/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParsingListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TagHandler;
import org.xml.sax.Attributes;

public class HolidayTagHandler
implements TagHandler,
ParsingListener {
    private IGanttProject project;

    public HolidayTagHandler(IGanttProject project) {
        this.project = project;
        project.getActiveCalendar().getPublicHolidays().clear();
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("date")) {
            this.loadHoliday(attrs);
        }
    }

    private void loadHoliday(Attributes atts) {
        try {
            String yearAsString = atts.getValue("year");
            if (yearAsString == null) {
                System.out.println("yearAsString==null");
            }
            String monthAsString = atts.getValue("month");
            String dateAsString = atts.getValue("date");
            int month = Integer.parseInt(monthAsString);
            int date = Integer.parseInt(dateAsString);
            if (yearAsString == null || yearAsString.equals("")) {
                this.project.getActiveCalendar().setPublicHoliDayType(month, date);
            } else {
                int year = Integer.parseInt(yearAsString);
                this.project.getActiveCalendar().setPublicHoliDayType(new GanttCalendar(year, month - 1, date).getTime());
            }
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR in parsing XML File year is not numeric: " + e.toString());
            return;
        }
    }

    @Override
    public void parsingStarted() {
    }

    @Override
    public void parsingFinished() {
    }
}

