/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.YesOrNoEnumDIY;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ColorValueParser;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParsingContext;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.TagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.shape.ShapePaint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class TaskTagHandler
implements TagHandler {
    private final ParsingContext myContext;
    private final TaskManager myManager;
    private final Stack myStack = new Stack();

    public TaskTagHandler(TaskManager mgr, ParsingContext context) {
        this.myManager = mgr;
        this.myContext = context;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("task")) {
            this.loadTask(attrs);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
        if (qName.equals("task")) {
            this.myStack.pop();
        }
    }

    private void loadTask(Attributes attrs) {
        String shape;
        String expand;
        String webLink_enc;
        String thirdConstraint;
        String third;
        String fixedStart;
        String color;
        String priority;
        String complete;
        String duration;
        String start;
        String project;
        String meeting;
        String taskName;
        String taskIdAsString = attrs.getValue("id");
        GanttTask task = null;
        if (taskIdAsString == null) {
            task = this.getManager().createTask();
        } else {
            int taskId;
            try {
                taskId = Integer.parseInt(taskIdAsString);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the value '" + taskIdAsString + "' of attribute 'id' of tag <task>", e);
            }
            task = this.getManager().createTask(taskId);
        }
        String keyTask = attrs.getValue("keyTask");
        if (keyTask != null && !"null".equalsIgnoreCase(keyTask)) {
            if (Boolean.valueOf(keyTask).booleanValue()) {
                task.setKeyTask(YesOrNoEnumDIY.yesEnum);
            } else {
                task.setKeyTask(YesOrNoEnumDIY.noEnum);
            }
        }
        if ((taskName = attrs.getValue("name")) != null) {
            task.setName(taskName);
        }
        if ((meeting = attrs.getValue("meeting")) != null) {
            task.setMilestone(meeting.equals("true"));
        }
        if ((project = attrs.getValue("project")) != null) {
            task.setProjectTask(true);
        }
        if ((start = attrs.getValue("start")) != null) {
            task.setStart(GanttCalendar.parseXMLDate(start));
        }
        if ((duration = attrs.getValue("duration")) != null) {
            try {
                int length = Integer.parseInt(duration);
                if (length == 0) {
                    length = 1;
                }
                task.setLength(length);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the value '" + duration + "' of attribute 'duration' of tag <task>", e);
            }
        }
        if ((complete = attrs.getValue("complete")) != null) {
            try {
                task.setCompletionPercentage(Float.parseFloat(complete));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the value '" + complete + "' of attribute 'complete' of tag <task>", e);
            }
        }
        if ((priority = attrs.getValue("priority")) != null) {
            try {
                task.setPriority(Integer.parseInt(priority));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the value '" + priority + "' of attribute 'priority' of tag <task>", e);
            }
        }
        if ((color = attrs.getValue("color")) != null) {
            task.setColor(ColorValueParser.parseString(color));
        }
        if ("true".equals(fixedStart = attrs.getValue("fixed-start"))) {
            this.myContext.addTaskWithLegacyFixedStart(task);
        }
        if ((third = attrs.getValue("thirdDate")) != null) {
            task.setThirdDate(GanttCalendar.parseXMLDate(third));
        }
        if ((thirdConstraint = attrs.getValue("thirdDate-constraint")) != null) {
            try {
                task.setThirdDateConstraint(Integer.parseInt(thirdConstraint));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the value '" + thirdConstraint + "' of attribute 'thirdDate-constraint' of tag <task>", e);
            }
        }
        String webLink = webLink_enc = attrs.getValue("webLink");
        if (webLink_enc != null) {
            try {
                webLink = URLDecoder.decode(webLink_enc, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (webLink != null) {
            task.setWebLink(webLink);
        }
        if ((expand = attrs.getValue("expand")) != null) {
            task.setExpand("true".equals(expand));
        }
        if ((shape = attrs.getValue("shape")) != null) {
            StringTokenizer st1 = new StringTokenizer(shape, ",");
            int[] array = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            String token = "";
            int count = 0;
            while (st1.hasMoreTokens()) {
                token = st1.nextToken();
                array[count] = new Integer(token);
                ++count;
            }
            task.setShape(new ShapePaint(4, 4, array, Color.white, task.getColor()));
        }
        this.getManager().registerTask(task);
        TaskContainmentHierarchyFacade taskHierarchy = this.getManager().getTaskHierarchy();
        this.myContext.setTaskID(task.getTaskID());
        Task lastTask = this.myStack.isEmpty() ? taskHierarchy.getRootTask() : (Task)this.myStack.peek();
        taskHierarchy.move(task, lastTask);
        this.myStack.push(task);
    }

    private TaskManager getManager() {
        return this.myManager;
    }
}

