/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.print;

import com.kingdee.bos.ctrl.print.extend.KDImagePrinter;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttExportSettings;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.ZoomInAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.ZoomOutAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Chart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DateOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.DefaultDateOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.print.GanttPrintable;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JDialog {
    private static final MediaSizeName DEFAULT_MEDIA_SIZE_NAME = MediaSizeName.ISO_A4;
    private static GanttLanguage language = GanttLanguage.getInstance();
    private int myPageWidth;
    private int myPageHeight;
    private GanttPrintable myPrintable = null;
    private JComboBox myComboScale = null;
    private PreviewContainer myPreviewContainer = null;
    private int myOrientation = 0;
    private PageFormat myPageFormat = null;
    private int myScale;
    private Chart myChart = null;
    private GanttExportSettings myExportSettings = null;
    private KDWorkButton myWholeProjectButton = null;
    private MediaSizeName myMediaSizeName;
    private JComboBox myComboMediaSize = null;
    private StatusBar statusBar;
    private DateOption myStart = new DefaultDateOption("generic.startDate"){

        @Override
        public void setValue(Date value) {
            super.setValue(value);
            this.commit();
            PrintPreview.this.onChangingDates();
            this.lock();
        }
    };
    private DateOption myFinish = new DefaultDateOption("generic.endDate"){

        @Override
        public void setValue(Date value) {
            super.setValue(value);
            this.commit();
            PrintPreview.this.onChangingDates();
            this.lock();
        }
    };

    private void onChangingDates() {
        this.myExportSettings.setStartDate(this.myStart.getValue());
        this.myExportSettings.setEndDate(this.myFinish.getValue());
        this.updateSourceImage(this.myChart.getChart(this.myExportSettings));
    }

    public PrintPreview(JFrame parent, Chart chart, String title, Date start, Date end, final GanttProject myProject) {
        super(parent, title, false);
        KDWorkButton bZoomIn;
        KDWorkButton bZoomOut;
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(910, (int)((double)screenDim.height * 0.75));
        this.setLocationRelativeTo(null);
        this.myChart = chart;
        if (start == null) {
            start = this.myChart.getStartDate();
        }
        if (end == null) {
            end = this.myChart.getEndDate();
        }
        this.myExportSettings = new GanttExportSettings();
        this.myPrintable = new GanttPrintable(this.myChart.getChart(this.myExportSettings), 1.5);
        KDToolBar tb = new KDToolBar();
        KDPanel tb2 = new KDPanel();
        TestGanttRolloverButton bPrint = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/print_16.gif")), GanttResourceUtil.getResource("Gantt_Print3"));
        ((AbstractButton)((Object)bPrint)).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.print(myProject);
            }
        });
        TestGanttRolloverButton bClose = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/exit_16.gif")), GanttResourceUtil.getResource("Gantt_Exit"));
        ((AbstractButton)((Object)bClose)).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.setVisible(false);
                PrintPreview.this.dispose();
            }
        });
        TestGanttRolloverButton bPortrait = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/portrait_16.gif")), GanttResourceUtil.getResource("Gantt_Vertical"));
        TestGanttRolloverButton bLandscape = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/landscape_16.gif")), GanttResourceUtil.getResource("Gantt_Horizontal"));
        ((AbstractButton)((Object)bPortrait)).addActionListener(new ActionListener((JButton)((Object)bLandscape), (JButton)((Object)bPortrait)){
            final /* synthetic */ JButton val$bLandscape;
            final /* synthetic */ JButton val$bPortrait;
            {
                this.val$bLandscape = jButton;
                this.val$bPortrait = jButton2;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.run(new Runnable(){

                    @Override
                    public void run() {
                        PrintPreview.this.changePageOrientation(1);
                        val$bLandscape.setEnabled(true);
                        val$bPortrait.setEnabled(false);
                    }
                });
            }
        });
        ((AbstractButton)((Object)bLandscape)).addActionListener(new ActionListener((JButton)((Object)bLandscape), (JButton)((Object)bPortrait)){
            final /* synthetic */ JButton val$bLandscape;
            final /* synthetic */ JButton val$bPortrait;
            {
                this.val$bLandscape = jButton;
                this.val$bPortrait = jButton2;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.run(new Runnable(){

                    @Override
                    public void run() {
                        PrintPreview.this.changePageOrientation(0);
                        val$bLandscape.setEnabled(false);
                        val$bPortrait.setEnabled(true);
                    }
                });
            }
        });
        ((AbstractButton)((Object)bLandscape)).setEnabled(false);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.myComboScale = new JComboBox<String>(scales);
        this.myComboScale.setSelectedIndex(2);
        this.myComboScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.run(new Runnable(){

                    @Override
                    public void run() {
                        PrintPreview.this.changeScale();
                    }
                });
            }
        });
        this.myComboScale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PrintPreview.this.run(new Runnable(){

                    @Override
                    public void run() {
                        PrintPreview.this.changeScale();
                    }
                });
            }
        });
        Dimension dim = this.myComboScale.getPreferredSize();
        dim.setSize(100.0, dim.getHeight());
        this.myComboScale.setEditable(true);
        boolean isDate = start != null && end != null;
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/calendar_16.gif"));
        this.myStart.lock();
        this.myFinish.lock();
        if (isDate) {
            this.myWholeProjectButton = new KDWorkButton(language.getText("wholeProject"), EASResource.getIcon((String)"imgTbtn_view"));
            this.myWholeProjectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintPreview.this.myStart.setValue(PrintPreview.this.myChart.getStartDate());
                    PrintPreview.this.myFinish.setValue(PrintPreview.this.myChart.getEndDate());
                }
            });
        }
        Vector<MediaSizeName> vMedia = new Vector<MediaSizeName>();
        vMedia.add(MediaSizeName.ISO_A0);
        vMedia.add(MediaSizeName.ISO_A1);
        vMedia.add(MediaSizeName.ISO_A2);
        vMedia.add(MediaSizeName.ISO_A3);
        vMedia.add(MediaSizeName.ISO_A4);
        vMedia.add(MediaSizeName.ISO_A5);
        vMedia.add(MediaSizeName.ISO_A6);
        if (vMedia != null) {
            this.myComboMediaSize = new JComboBox(vMedia);
            dim = this.myComboMediaSize.getPreferredSize();
            dim.setSize(dim.getWidth() + 20.0, dim.getHeight());
            this.myComboMediaSize.setMaximumSize(dim);
            this.myComboMediaSize.setPreferredSize(dim);
            this.myComboMediaSize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    PrintPreview.this.run(new Runnable(){

                        @Override
                        public void run() {
                            Object selectedItem = PrintPreview.this.myComboMediaSize.getSelectedItem();
                            if (selectedItem != null) {
                                PrintPreview.this.myMediaSizeName = (MediaSizeName)selectedItem;
                                MediaSize ms = MediaSize.getMediaSizeForName(PrintPreview.this.myMediaSizeName);
                                Paper p = new Paper();
                                float[] size = ms.getSize(25400);
                                p.setSize(size[0] * 72.0f, size[1] * 72.0f);
                                p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
                                PrintPreview.this.myPageFormat.setPaper(p);
                                PrintPreview.this.changePageOrientation(PrintPreview.this.myOrientation);
                                PrintPreview.this.statusBar.setText1(ms.getX(1000) + " x " + ms.getY(1000));
                                PrintPreview.this.myPreviewContainer.repaint();
                            }
                        }
                    });
                }
            });
        }
        ((JComponent)((Object)bPrint)).setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("printProject"))));
        ((JComponent)((Object)bPortrait)).setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("portrait"))));
        ((JComponent)((Object)bLandscape)).setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("landscape"))));
        ((JComponent)((Object)bClose)).setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("close"))));
        if (isDate) {
            this.myWholeProjectButton.setToolTipText(GanttProject.getToolTip(GanttProject.correctLabel(language.getText("displayWholeProject"))));
            GanttProject gp = myProject;
            final ZoomManager zoomManager = gp.getZoomManager();
            final ZoomOutAction zoomOut = new ZoomOutAction(zoomManager, gp.getOptions().getIconSize());
            final ZoomInAction zoomIn = new ZoomInAction(zoomManager, gp.getOptions().getIconSize());
            bZoomOut = new KDWorkButton(GanttResourceUtil.getResource("Gantt_Smaller"), (Icon)zoomOut.getValue("SmallIcon"));
            bZoomIn = new KDWorkButton(GanttResourceUtil.getResource("Gantt_Bigger"), (Icon)zoomIn.getValue("SmallIcon"));
            bZoomOut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PrintPreview.this.run(new Runnable(){

                        @Override
                        public void run() {
                            zoomOut.actionPerformed(null);
                            PrintPreview.this.updateSourceImage(PrintPreview.this.myChart.getChart(PrintPreview.this.myExportSettings));
                            bZoomOut.setEnabled(zoomManager.canZoomOut());
                            bZoomIn.setEnabled(zoomManager.canZoomIn());
                        }
                    });
                }
            });
            bZoomIn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PrintPreview.this.run(new Runnable(){

                        @Override
                        public void run() {
                            zoomIn.actionPerformed(null);
                            PrintPreview.this.updateSourceImage(PrintPreview.this.myChart.getChart(PrintPreview.this.myExportSettings));
                            bZoomOut.setEnabled(zoomManager.canZoomOut());
                            bZoomIn.setEnabled(zoomManager.canZoomIn());
                        }
                    });
                }
            });
        } else {
            bZoomOut = null;
            bZoomIn = null;
        }
        tb.setFloatable(false);
        tb.add((Component)new KDSeparator());
        tb.add((Component)((Object)bPrint));
        tb.add((Component)new KDSeparator());
        tb.add((Component)((Object)bPortrait));
        tb.add((Component)((Object)bLandscape));
        tb.add((Component)new KDSeparator());
        KDLabelContainer container = new KDLabelContainer();
        container.setBoundLabelText(language.getText("zoom"));
        container.setBoundLabelLength(80);
        container.setBoundLabelUnderline(true);
        container.setBoundEditor((JComponent)this.myComboScale);
        tb2.add((Component)container);
        KDPanel panel = new KDPanel();
        tb2.add((Component)panel);
        if (vMedia != null && !vMedia.isEmpty()) {
            container = new KDLabelContainer();
            container.setBoundLabelText(language.getText("choosePaperFormat"));
            container.setBoundLabelLength(80);
            container.setBoundLabelUnderline(true);
            container.setBoundEditor((JComponent)this.myComboMediaSize);
            tb2.add((Component)container);
            panel = new KDPanel();
            tb2.add((Component)panel);
        }
        if (isDate) {
            tb.add((Component)bZoomOut);
            tb.add((Component)bZoomIn);
            tb.add((Component)this.myWholeProjectButton);
            tb.add((Component)new KDSeparator());
            OptionsPageBuilder builder = new OptionsPageBuilder();
            builder.setOptionKeyPrefix("");
            tb2.add(builder.createStandaloneOptionPanel(this.myStart));
            panel = new KDPanel();
            tb2.add((Component)panel);
            URL iconArrow = this.getClass().getClassLoader().getResource("icons/fromto.gif");
            tb2.add(builder.createStandaloneOptionPanel(this.myFinish));
        }
        tb.add((Component)((Object)bClose));
        JPanel topPanel = new JPanel(new BorderLayout());
        tb2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        topPanel.add((Component)tb, "North");
        topPanel.add((Component)tb2, "South");
        this.getContentPane().add((Component)topPanel, "North");
        this.statusBar = new StatusBar();
        this.statusBar.setLabel0(language.getText("pageNumber"));
        this.statusBar.setLabel1(language.getText("paperSize"));
        this.getContentPane().add((Component)this.statusBar, "South");
        this.myPreviewContainer = new PreviewContainer();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        this.myPageFormat = new PageFormat();
        this.myPageFormat.setOrientation(this.myOrientation);
        this.myMediaSizeName = DEFAULT_MEDIA_SIZE_NAME;
        MediaSize ms = MediaSize.getMediaSizeForName(this.myMediaSizeName);
        Paper p = new Paper();
        float[] size = ms.getSize(25400);
        p.setSize(size[0] * 72.0f, size[1] * 72.0f);
        p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
        this.myPageFormat.setPaper(p);
        this.statusBar.setText1(ms.getX(1000) + " x " + ms.getY(1000));
        if (this.myPageFormat.getHeight() == 0.0 || this.myPageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.myPageWidth = (int)this.myPageFormat.getWidth();
        this.myPageHeight = (int)this.myPageFormat.getHeight();
        this.myScale = 50;
        int w = this.myPageWidth * this.myScale / 100;
        int h = this.myPageHeight * this.myScale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.myPageWidth, this.myPageHeight, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.myPageWidth, this.myPageHeight);
                if (this.myPrintable.print(g, this.myPageFormat, pageIndex) != 0) break;
                PagePreview pp = new PagePreview(w, h, img);
                this.myPreviewContainer.add(pp);
                ++pageIndex;
            }
            this.statusBar.setText0("" + pageIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
        JScrollPane ps = new JScrollPane(this.myPreviewContainer);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.myComboMediaSize.setSelectedItem(this.myMediaSizeName);
        this.myStart.setValue(start);
        this.myFinish.setValue(end);
    }

    private void changeScale() {
        String str = this.myComboScale.getSelectedItem().toString();
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        this.myScale = 0;
        try {
            this.myScale = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return;
        }
        int w = this.myPageWidth * this.myScale / 100;
        int h = this.myPageHeight * this.myScale / 100;
        Component[] comps = this.myPreviewContainer.getComponents();
        for (int k = 0; k < comps.length; ++k) {
            if (!(comps[k] instanceof PagePreview)) continue;
            PagePreview pp = (PagePreview)comps[k];
            pp.setScaledSize(w, h);
        }
        this.myPreviewContainer.doLayout();
        this.myPreviewContainer.getParent().getParent().validate();
    }

    private void run(Runnable runnable) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        runnable.run();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void changePageOrientation(int newOrientation) {
        this.myOrientation = newOrientation;
        this.myPageFormat.setOrientation(this.myOrientation);
        this.myPageWidth = (int)this.myPageFormat.getWidth();
        this.myPageHeight = (int)this.myPageFormat.getHeight();
        int w = this.myPageWidth * this.myScale / 100;
        int h = this.myPageHeight * this.myScale / 100;
        this.myPreviewContainer.removeAll();
        this.myPreviewContainer.repaint();
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.myPageWidth, this.myPageHeight, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.myPageWidth, this.myPageHeight);
                if (this.myPrintable.print(g, this.myPageFormat, pageIndex) != 0) break;
                PagePreview pp = new PagePreview(w, h, img);
                this.myPreviewContainer.add(pp);
                ++pageIndex;
            }
            this.statusBar.setText0("" + pageIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
        this.myPreviewContainer.doLayout();
        this.myPreviewContainer.getParent().getParent().validate();
        this.myPreviewContainer.validate();
    }

    private void print(GanttProject project) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        KDImagePrinter imageManager = new KDImagePrinter();
        imageManager.setParent((Component)project);
        imageManager.setData(new Image[]{this.myPrintable.image});
        imageManager.pageDialog();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void updateSourceImage(Image newSourceImage) {
        this.myPrintable = new GanttPrintable((BufferedImage)newSourceImage, 1.5);
        this.changePageOrientation(this.myOrientation);
    }

    private static Vector getAllMediaSizeNameAvailable() throws ClassNotFoundException {
        Class<?> c = Class.forName("javax.print.attribute.standard.MediaSizeName");
        Field[] fields = c.getFields();
        Vector<Object> res = new Vector<Object>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                res.add(field.get(null));
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    static class StatusBar
    extends JPanel {
        JLabel label0 = new JLabel();
        JLabel message0 = new JLabel();
        JLabel label1;
        JLabel message1;

        public StatusBar() {
            super(new BorderLayout());
            JPanel panel0 = new JPanel();
            panel0.add(this.label0);
            panel0.add(this.message0);
            this.add((Component)panel0, "West");
            this.label1 = new JLabel();
            this.message1 = new JLabel();
            JPanel panel1 = new JPanel();
            panel1.add(this.label1);
            panel1.add(this.message1);
            this.add((Component)panel1, "East");
        }

        public void setLabel0(String label) {
            this.label0.setText(label);
        }

        public void setText0(String text) {
            this.message0.setText(text);
        }

        public void setLabel1(String label) {
            this.label1.setText(label);
        }

        public void setText1(String text) {
            this.message1.setText(text);
        }
    }

    class PagePreview
    extends JPanel {
        protected int width;
        protected int height;
        protected Image sourceImage;
        protected Image image;

        public PagePreview(int w, int h, Image source) {
            this.width = w;
            this.height = h;
            this.sourceImage = source;
            this.image = this.sourceImage.getScaledInstance(this.width, this.height, 4);
            this.image.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.width = w;
            this.height = h;
            this.image = this.sourceImage.getScaledInstance(this.width, this.height, 4);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.width + ins.left + ins.right, this.height + ins.top + ins.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.image, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected final int H_GAP = 16;
        protected final int V_GAP = 10;

        PreviewContainer() {
        }

        @Override
        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(16, 10);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - 16) / (w + 16), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + 16) + 16;
            int hh = nRow * (h + 10) + 10;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + 16;
            int y = ins.top + 10;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - 16) / (w + 16), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + 16;
                }
                y += h + 10;
                x = ins.left + 16;
            }
        }
    }
}

