/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.CustomPropertyDefinition;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.CustomPropertyManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GanttDaysOff;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceView;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoManager;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HumanResourceManager
implements ResourceManager,
CustomPropertyManager {
    private List myViews = new ArrayList();
    private List resources = new ArrayList();
    private int nextFreeId = 0;
    private final Role myDefaultRole;
    private final Map customFields = new HashMap();
    private final List myListeners = new ArrayList();

    public HumanResourceManager(Role defaultRole) {
        this.myDefaultRole = defaultRole;
    }

    public HumanResource newHumanResource() {
        HumanResource result = new HumanResource(this);
        result.setRole(this.myDefaultRole);
        return result;
    }

    @Override
    public ProjectResource create(String name, int i) {
        HumanResource hr = new HumanResource(name, i, this);
        hr.setRole(this.myDefaultRole);
        this.add(hr);
        return hr;
    }

    @Override
    public void add(ProjectResource resource) {
        if (resource.getId() == -1) {
            resource.setId(this.nextFreeId);
        }
        if (resource.getId() >= this.nextFreeId) {
            this.nextFreeId = resource.getId() + 1;
        }
        this.resources.add(resource);
        this.fireResourceAdded(resource);
    }

    public void addCustomField(CustomPropertyDefinition definition) {
        this.customFields.put(definition.getName(), definition);
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            ((HumanResource)it.next()).addCustomField(definition.getName(), definition.getDefaultValue());
        }
    }

    public boolean checkCustomField(String title) {
        return this.customFields.containsKey(title);
    }

    public void removeCustomField(String title) {
        this.customFields.remove(title);
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            ((HumanResource)it.next()).removeCustomField(title);
        }
    }

    @Override
    public ProjectResource getById(int id) {
        ProjectResource pr = null;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (((ProjectResource)this.resources.get(i)).getId() != id) continue;
            pr = (ProjectResource)this.resources.get(i);
            break;
        }
        return pr;
    }

    @Override
    public List getResources() {
        return this.resources;
    }

    @Override
    public ProjectResource[] getResourcesArray() {
        return this.resources.toArray(new ProjectResource[this.resources.size()]);
    }

    @Override
    public void remove(ProjectResource resource) {
        this.fireResourcesRemoved(new ProjectResource[]{resource});
        this.resources.remove(resource);
    }

    @Override
    public void remove(ProjectResource resource, GPUndoManager myUndoManager) {
        final ProjectResource res = resource;
        myUndoManager.undoableEdit("Delete Human OK", new Runnable(){

            @Override
            public void run() {
                HumanResourceManager.this.fireResourcesRemoved(new ProjectResource[]{res});
                HumanResourceManager.this.resources.remove(res);
            }
        });
    }

    @Override
    public void save(OutputStream target) {
    }

    @Override
    public void clear() {
        this.fireCleanup();
        this.resources.clear();
    }

    @Override
    public void addView(ResourceView view) {
        this.myViews.add(view);
    }

    private void fireResourceAdded(ProjectResource resource) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resource);
        for (ResourceView nextView : this.myViews) {
            nextView.resourceAdded(e);
        }
    }

    void fireResourceChanged(ProjectResource resource) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resource);
        for (ResourceView nextView : this.myViews) {
            nextView.resourceChanged(e);
        }
    }

    private void fireResourcesRemoved(ProjectResource[] resources) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resources);
        for (int i = 0; i < this.myViews.size(); ++i) {
            ResourceView nextView = (ResourceView)this.myViews.get(i);
            nextView.resourcesRemoved(e);
        }
    }

    public void fireAssignmentsChanged(ProjectResource resource) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resource);
        for (ResourceView nextView : this.myViews) {
            nextView.resourceAssignmentsChanged(e);
        }
    }

    private void fireCleanup() {
        this.fireResourcesRemoved(this.resources.toArray(new ProjectResource[this.resources.size()]));
    }

    public void up(HumanResource hr) {
        int index = this.resources.indexOf(hr);
        if (index < 0) {
            try {
                throw new Exception("index<0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resources.remove(index);
        this.resources.add(index - 1, hr);
        this.fireResourceChanged(hr);
    }

    public void down(HumanResource hr) {
        int index = this.resources.indexOf(hr);
        if (index < 0) {
            try {
                throw new Exception("index<0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resources.remove(index);
        this.resources.add(index + 1, hr);
        this.fireResourceChanged(hr);
    }

    @Override
    public Map importData(ResourceManager resourceManager) {
        HashMap original2imported = new HashMap();
        if (!(resourceManager instanceof HumanResourceManager)) {
            throw new IllegalArgumentException("I expect resource manager to be HumanResourceManager");
        }
        HumanResourceManager hrManager = (HumanResourceManager)resourceManager;
        List resources = hrManager.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            HumanResource next = (HumanResource)resources.get(i);
            this.importData(next, original2imported);
        }
        return original2imported;
    }

    private void importData(HumanResource next, Map original2imported) {
        HumanResource imported = (HumanResource)this.create(next.getName(), this.nextFreeId);
        if (next.getDaysOff() != null) {
            for (int i = 0; i < next.getDaysOff().size(); ++i) {
                imported.addDaysOff((GanttDaysOff)((GanttDaysOff)next.getDaysOff().get(i)).clone());
            }
        }
        imported.setName(next.getName());
        imported.setDescription(next.getDescription());
        imported.setMail(next.getMail());
        imported.setPhone(next.getPhone());
        imported.setRole(next.getRole());
        original2imported.put(next, imported);
    }

    @Override
    public CustomPropertyManager getCustomPropertyManager() {
        return this;
    }

    @Override
    public List getDefinitions() {
        ArrayList result = new ArrayList(this.customFields.values());
        return result;
    }

    CustomPropertyDefinition getCustomPropertyDefinition(String nextName) {
        return (CustomPropertyDefinition)this.customFields.get(nextName);
    }

    static String getValueAsString(Object value) {
        String result = value != null ? (value instanceof GanttCalendar ? ((GanttCalendar)value).toXMLString() : String.valueOf(value)) : null;
        return result;
    }

    @Override
    public CustomPropertyDefinition createDefinition(String id, String typeAsString, String name, String defaultValueAsString) {
        return null;
    }
}

