/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.RoleImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.RoleManagerImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.RoleSet;
import java.util.ArrayList;

public class RoleSetImpl
implements RoleSet {
    private final String myName;
    private final ArrayList myRoles = new ArrayList();
    private boolean isEnabled;
    private final RoleManagerImpl myRoleManager;

    RoleSetImpl(String name, RoleManagerImpl roleManager) {
        this.myName = name;
        this.myRoleManager = roleManager;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Role[] getRoles() {
        return this.myRoles.toArray(new Role[0]);
    }

    @Override
    public Role createRole(String name, int persistentID) {
        RoleImpl result = new RoleImpl(persistentID, name, this);
        this.myRoles.add(result);
        this.myRoleManager.fireRolesChanged(this);
        return result;
    }

    @Override
    public void deleteRole(Role role) {
        this.myRoles.remove(role);
        this.myRoleManager.fireRolesChanged(this);
    }

    @Override
    public Role findRole(int roleID) {
        Role result = null;
        for (int i = 0; i < this.myRoles.size(); ++i) {
            Role next = (Role)this.myRoles.get(i);
            if (next.getID() != roleID) continue;
            result = next;
            break;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.myRoleManager.fireRolesChanged(this);
    }

    @Override
    public boolean isEmpty() {
        return this.myRoles.isEmpty();
    }

    @Override
    public void clear() {
        this.myRoles.clear();
    }

    void importData(RoleSet original) {
        Role[] originalRoles = original.getRoles();
        for (int i = 0; i < originalRoles.length; ++i) {
            Role nextRole = originalRoles[i];
            this.createRole(nextRole.getName(), nextRole.getID());
        }
    }
}

