/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.shape;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class ShapePaint
extends TexturePaint {
    protected int width;
    protected int height;
    protected int[] array;
    public Color foreground;
    public Color background;

    public ShapePaint(ShapePaint pattern) {
        this(pattern.width, pattern.height, pattern.array, pattern.foreground, pattern.background);
    }

    public ShapePaint(ShapePaint pattern, Color foreground, Color background) {
        this(pattern.width, pattern.height, pattern.array, foreground, background);
    }

    public ShapePaint(int width, int height, int[] array) {
        this(width, height, array, Color.black, Color.white);
    }

    public ShapePaint(int width, int height, int[] array, Color foreground, Color background) {
        super(ShapePaint.createTexture(width, height, array, foreground, background), new Rectangle(0, 0, width, height));
        this.width = width;
        this.height = height;
        this.array = array;
        this.foreground = foreground;
        this.background = background;
    }

    private static BufferedImage createTexture(int width, int height, int[] array, Color foreground, Color background) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, array[x + y * width] > 0 ? foreground.getRGB() : background.getRGB());
            }
        }
        return image;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShapePaint) {
            ShapePaint paint = (ShapePaint)obj;
            if (this.array.length != paint.array.length) {
                return false;
            }
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == paint.array[i]) continue;
                return false;
            }
            return paint.width == this.width && paint.height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString2() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.width);
        buffer.append("," + this.height);
        buffer.append("] {");
        for (int i = 0; i < this.array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("" + this.array[i]);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PatternPaint[");
        buffer.append("[width=" + this.width);
        buffer.append(",height=" + this.height);
        buffer.append(",array={");
        for (int i = 0; i < this.array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("" + this.array[i]);
        }
        buffer.append("},foreground=" + this.foreground);
        buffer.append(",background=" + this.background + "]");
        return buffer.toString();
    }

    public String getArray() {
        String result = "";
        if (this.array != null) {
            for (int i = 0; i < this.array.length; ++i) {
                result = result + this.array[i] + ",";
            }
        }
        return result.length() != 0 ? result.trim().substring(0, result.trim().length() - 1) : "";
    }

    public int[] getarray() {
        return this.array;
    }
}

