/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTreeTable;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttDialogCustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumsListener;
import java.util.ArrayList;
import java.util.List;

public class CustomColumnsManager {
    private GanttTreeTable ganttTreeTable = null;
    private List myListeners;

    public CustomColumnsManager(GanttTreeTable treetable) {
        this.ganttTreeTable = treetable;
        this.myListeners = new ArrayList();
    }

    public void setGanttTreeTable(GanttTreeTable treetable) {
        this.ganttTreeTable = treetable;
    }

    public void addNewCustomColumn(CustomColumn customColumn, IGanttProject project) {
        if (customColumn == null) {
            customColumn = new CustomColumn();
            GanttDialogCustomColumn d = new GanttDialogCustomColumn(project.getUIFacade(), customColumn, project);
            d.setVisible(true);
        }
        this.ganttTreeTable.addNewCustomColumn(customColumn);
        CustomColumEvent event = new CustomColumEvent(0, customColumn.getName());
        this.fireCustomColumnsChange(event);
    }

    public void deleteCustomColumn(String name) {
        this.ganttTreeTable.deleteCustomColumn(name);
        CustomColumEvent event = new CustomColumEvent(1, name);
        this.fireCustomColumnsChange(event);
    }

    public void changeCustomColumnName(String oldName, String newName) {
        this.ganttTreeTable.renameCustomcolumn(oldName, newName);
        this.ganttTreeTable.project.getTaskManager().getCustomColumnsStorage().renameCustomColumn(oldName, newName);
    }

    public void changeCustomColumnDefaultValue(String colName, Object newDefaultValue) throws CustomColumnsException {
        this.ganttTreeTable.project.getTaskManager().getCustomColumnsStorage().changeDefaultValue(colName, newDefaultValue);
    }

    public void addCustomColumnsListener(CustomColumsListener listener) {
        this.myListeners.add(listener);
    }

    private void fireCustomColumnsChange(CustomColumEvent event) {
        for (CustomColumsListener listener : this.myListeners) {
            listener.customColumsChange(event);
        }
    }
}

