/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.Role;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignmentCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignmentMutator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ResourceAssignmentCollectionImpl
implements ResourceAssignmentCollection {
    private final Map myAssignments = new HashMap();
    private final TaskImpl myTask;
    private ResourceManager myResourceManager;

    public ResourceAssignmentCollectionImpl(TaskImpl task, ResourceManager resourceManager) {
        this.myTask = task;
        this.myResourceManager = resourceManager;
    }

    private ResourceAssignmentCollectionImpl(ResourceAssignmentCollectionImpl collection) {
        this.myTask = collection.myTask;
        ResourceAssignment[] assignments = collection.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            ResourceAssignment next = assignments[i];
            ResourceAssignmentImpl copy = new ResourceAssignmentImpl(next.getResource());
            copy.setLoad(next.getLoad());
            copy.setCoordinator(next.isCoordinator());
            copy.setRoleForAssignment(next.getRoleForAssignment());
            this.addAssignment(copy);
        }
    }

    @Override
    public void clear() {
        ResourceAssignment[] assignments = this.getAssignments();
        for (int i = 0; i < assignments.length; ++i) {
            assignments[i].delete();
        }
    }

    @Override
    public ResourceAssignment[] getAssignments() {
        return this.myAssignments.values().toArray(new ResourceAssignment[this.myAssignments.size()]);
    }

    @Override
    public ResourceAssignment getAssignment(ProjectResource resource) {
        return (ResourceAssignment)this.myAssignments.get(resource);
    }

    @Override
    public ResourceAssignmentMutator createMutator() {
        return new ResourceAssignmentMutatorImpl();
    }

    ResourceAssignmentCollectionImpl copy() {
        return new ResourceAssignmentCollectionImpl(this);
    }

    @Override
    public ResourceAssignment addAssignment(ProjectResource resource) {
        return this.auxAddAssignment(resource);
    }

    @Override
    public void deleteAssignment(ProjectResource resource) {
        this.myAssignments.remove(resource);
    }

    private ResourceAssignment auxAddAssignment(ProjectResource resource) {
        ResourceAssignmentImpl result = new ResourceAssignmentImpl(resource);
        this.addAssignment(result);
        return result;
    }

    private void addAssignment(ResourceAssignment assignment) {
        this.myAssignments.put(assignment.getResource(), assignment);
    }

    public void removeAssignment(ProjectResource resource) {
        new ResourceAssignmentImpl(resource).delete();
    }

    private Task getTask() {
        return this.myTask;
    }

    public void importData(ResourceAssignmentCollection assignmentCollection) {
        if (this.myTask.isUnplugged()) {
            ResourceAssignment[] assignments = assignmentCollection.getAssignments();
            for (int i = 0; i < assignments.length; ++i) {
                ResourceAssignment next = assignments[i];
                this.addAssignment(next);
            }
        } else {
            ResourceAssignment[] assignments = assignmentCollection.getAssignments();
            for (int i = 0; i < assignments.length; ++i) {
                ResourceAssignment next = assignments[i];
                ProjectResource nextResource = next.getResource();
                ProjectResource nextImportedResource = this.myResourceManager.getById(nextResource.getId());
                if (nextImportedResource == null) continue;
                ResourceAssignmentImpl copy = new ResourceAssignmentImpl(nextImportedResource);
                copy.setLoad(next.getLoad());
                copy.setCoordinator(next.isCoordinator());
                copy.setRoleForAssignment(next.getRoleForAssignment());
                this.addAssignment(copy);
            }
        }
    }

    private static class MutationInfo
    implements Comparable {
        static final int ADD = 0;
        static final int DELETE = 1;
        private final ResourceAssignment myAssignment;
        private final int myOrder;
        private static int ourOrder;
        private int myOperation;
        private final ProjectResource myResource;

        public MutationInfo(ResourceAssignment assignment, int operation) {
            this.myAssignment = assignment;
            this.myOrder = ourOrder++;
            this.myOperation = operation;
            this.myResource = assignment.getResource();
        }

        public MutationInfo(ProjectResource resource, int operation) {
            this.myAssignment = null;
            this.myOrder = ourOrder++;
            this.myOperation = operation;
            this.myResource = resource;
        }

        public boolean equals(Object o) {
            boolean result = o instanceof MutationInfo;
            if (result) {
                result = this.myAssignment.getResource().equals(((MutationInfo)o).myAssignment.getResource());
            }
            return result;
        }

        public int compareTo(Object o) {
            if (!(o instanceof MutationInfo)) {
                throw new IllegalArgumentException();
            }
            return this.myOrder - ((MutationInfo)o).myOrder;
        }
    }

    private class ResourceAssignmentMutatorImpl
    implements ResourceAssignmentMutator {
        private Map myQueue = new HashMap();

        private ResourceAssignmentMutatorImpl() {
        }

        @Override
        public ResourceAssignment addAssignment(ProjectResource resource) {
            ResourceAssignmentStub result = new ResourceAssignmentStub(resource);
            this.myQueue.put(resource, new MutationInfo(result, 0));
            return result;
        }

        @Override
        public void deleteAssignment(ProjectResource resource) {
            MutationInfo info = (MutationInfo)this.myQueue.get(resource);
            if (info == null) {
                this.myQueue.put(resource, new MutationInfo(resource, 1));
            } else if (info.myOperation == 0) {
                this.myQueue.remove(resource);
            }
        }

        @Override
        public void commit() {
            ArrayList mutations = new ArrayList(this.myQueue.values());
            Collections.sort(mutations);
            block4: for (int i = 0; i < mutations.size(); ++i) {
                MutationInfo next = (MutationInfo)mutations.get(i);
                switch (next.myOperation) {
                    case 1: {
                        ResourceAssignmentCollectionImpl.this.myAssignments.remove(next.myResource);
                        continue block4;
                    }
                    case 0: {
                        ResourceAssignment result = ResourceAssignmentCollectionImpl.this.auxAddAssignment(next.myResource);
                        result.setLoad(next.myAssignment.getLoad());
                        result.setCoordinator(next.myAssignment.isCoordinator());
                        result.setRoleForAssignment(next.myAssignment.getRoleForAssignment());
                    }
                }
            }
        }
    }

    private class ResourceAssignmentStub
    implements ResourceAssignment {
        private final ProjectResource myResource;
        private float myLoad;
        private boolean myCoordinator;
        private Role myRoleForAssignment;

        public ResourceAssignmentStub(ProjectResource resource) {
            this.myResource = resource;
        }

        @Override
        public Task getTask() {
            return ResourceAssignmentCollectionImpl.this.getTask();
        }

        @Override
        public ProjectResource getResource() {
            return this.myResource;
        }

        @Override
        public float getLoad() {
            return this.myLoad;
        }

        @Override
        public void setLoad(float load) {
            this.myLoad = load;
        }

        @Override
        public void delete() {
        }

        public void deleteLocal() {
        }

        @Override
        public void setCoordinator(boolean responsible) {
            this.myCoordinator = responsible;
        }

        @Override
        public boolean isCoordinator() {
            return this.myCoordinator;
        }

        @Override
        public Role getRoleForAssignment() {
            return this.myRoleForAssignment;
        }

        @Override
        public void setRoleForAssignment(Role role) {
            this.myRoleForAssignment = role;
        }

        public String toString() {
            return this.getResource().getName() + " -> " + this.getTask().getName();
        }
    }

    private class ResourceAssignmentImpl
    implements ResourceAssignment {
        private ResourceAssignment myAssignmentToResource;

        public ResourceAssignmentImpl(ProjectResource resource) {
            this.myAssignmentToResource = resource.createAssignment(this);
        }

        @Override
        public Task getTask() {
            return ResourceAssignmentCollectionImpl.this.getTask();
        }

        @Override
        public ProjectResource getResource() {
            return this.myAssignmentToResource.getResource();
        }

        @Override
        public float getLoad() {
            return this.myAssignmentToResource.getLoad();
        }

        @Override
        public void setLoad(float load) {
            this.myAssignmentToResource.setLoad(load);
        }

        @Override
        public void delete() {
            ResourceAssignmentCollectionImpl.this.deleteAssignment(this.getResource());
            this.myAssignmentToResource.delete();
        }

        @Override
        public void setCoordinator(boolean responsible) {
            this.myAssignmentToResource.setCoordinator(responsible);
        }

        @Override
        public boolean isCoordinator() {
            return this.myAssignmentToResource.isCoordinator();
        }

        @Override
        public Role getRoleForAssignment() {
            return this.myAssignmentToResource.getRoleForAssignment();
        }

        @Override
        public void setRoleForAssignment(Role role) {
            this.myAssignmentToResource.setRoleForAssignment(role);
        }

        public String toString() {
            return this.getResource().getName() + " -> " + this.getTask().getName();
        }
    }
}

