/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskActivity;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import java.util.Date;

class TaskActivityImpl
implements TaskActivity {
    private final Date myEndDate;
    private final Date myStartDate;
    private final TaskLength myDuration;
    private float myIntensity;
    private final TaskImpl myTask;

    TaskActivityImpl(TaskImpl task, Date startDate, Date endDate) {
        this(task, startDate, endDate, 1.0f);
    }

    TaskActivityImpl(TaskImpl task, Date startDate, Date endDate, float intensity) {
        this.myStartDate = startDate;
        this.myEndDate = endDate;
        this.myDuration = task.getManager().createLength(task.getDuration().getTimeUnit(), startDate, endDate);
        this.myIntensity = intensity;
        this.myTask = task;
    }

    @Override
    public Date getStart() {
        return this.myStartDate;
    }

    @Override
    public Date getEnd() {
        return this.myEndDate;
    }

    @Override
    public TaskLength getDuration() {
        return this.myDuration;
    }

    @Override
    public float getIntensity() {
        return this.myIntensity;
    }

    public String toString() {
        return this.myTask.toString() + "[" + this.getStart() + ", " + this.getEnd() + "]";
    }

    @Override
    public Task getTask() {
        return this.myTask;
    }

    @Override
    public boolean isFirst() {
        return this == this.getTask().getActivities()[0];
    }

    @Override
    public boolean isLast() {
        TaskActivity[] all = this.getTask().getActivities();
        return this == all[all.length - 1];
    }
}

