/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTaskRelationship;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.YesOrNoEnumDIY;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.AlwaysWorkingTimeCalendarImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendarActivity;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.shape.ShapePaint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsValues;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignmentCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignmentCollectionImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskActivity;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskActivityImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskInfo;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManagerImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskMutator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.AlgorithmCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencySlice;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencySliceAsDependant;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencySliceAsDependee;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencySliceImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.hierarchy.TaskHierarchyItem;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TaskImpl
implements Task {
    public GanttProject project;
    private int myID;
    private final TaskManagerImpl myManager;
    private String myName;
    private String myWebLink = new String("http://");
    private boolean isMilestone;
    boolean isProjectTask;
    private int myPriority;
    private GanttCalendar myStart;
    private GanttCalendar myEnd;
    private GanttCalendar myThird;
    private int myThirdDateConstraint;
    private float myCompletionPercentage;
    private TaskLength myLength;
    private List myActivities = new ArrayList();
    private Object userObject = null;
    private boolean bExpand;
    private ResourceAssignmentCollectionImpl myAssignments;
    private TaskDependencySlice myDependencySlice;
    private TaskDependencySlice myDependencySliceAsDependant;
    private TaskDependencySlice myDependencySliceAsDependee;
    private boolean myEventsEnabled;
    private final TaskHierarchyItem myTaskHierarchyItem;
    private ShapePaint myShape;
    private Color myColor;
    private String myNotes;
    private MutatorImpl myMutator;
    private final CustomColumnsValues customValues;
    private boolean critical;
    public static final int NONE = 0;
    public static final int EARLIESTBEGIN = 1;
    private Exception myException;
    private TaskInfo myTaskInfo;
    private static final GPCalendar RESTLESS_CALENDAR = new AlwaysWorkingTimeCalendarImpl();
    private String personName;
    private String personID;
    private String partName;
    private String partID;
    private BigDecimal planCost;
    private YesOrNoEnumDIY keyTask;
    private String quality;
    private String safe;
    private String description;

    protected TaskImpl(TaskManager taskManager, int taskID, GanttProject myProject) {
        this.myManager = (TaskManagerImpl)taskManager;
        this.project = myProject;
        if (taskID == -1) {
            this.myID = this.myManager.getMaxID();
            this.myManager.increaseMaxID();
        } else {
            if (this.myManager.getTask(taskID) != null) {
                throw new IllegalArgumentException("There is a task with ID=" + taskID + " already");
            }
            this.myID = taskID;
        }
        this.myAssignments = new ResourceAssignmentCollectionImpl(this, this.myManager.getConfig().getResourceManager());
        this.myDependencySlice = new TaskDependencySliceImpl(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependant = new TaskDependencySliceAsDependant(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependee = new TaskDependencySliceAsDependee(this, this.myManager.getDependencyCollection());
        this.myPriority = 1;
        this.myTaskHierarchyItem = this.myManager.getHierarchyManager().createItem(this);
        this.myNotes = "";
        this.bExpand = true;
        this.myColor = null;
        this.customValues = new CustomColumnsValues(this.project);
    }

    protected TaskImpl(TaskImpl copy, boolean isUnplugged) {
        this.myManager = copy.myManager;
        this.myTaskHierarchyItem = !isUnplugged ? this.myManager.getHierarchyManager().createItem(this) : null;
        this.myAssignments = new ResourceAssignmentCollectionImpl(this, this.myManager.getConfig().getResourceManager());
        this.myAssignments.importData(copy.getAssignmentCollection());
        this.myID = copy.myID;
        this.myName = copy.myName;
        this.myWebLink = copy.myWebLink;
        this.isMilestone = copy.isMilestone;
        this.isProjectTask = copy.isProjectTask;
        this.myPriority = copy.myPriority;
        this.myStart = copy.myStart;
        this.myEnd = copy.myEnd;
        this.myThird = copy.myThird;
        this.myThirdDateConstraint = copy.myThirdDateConstraint;
        this.myCompletionPercentage = copy.myCompletionPercentage;
        this.myLength = copy.myLength;
        this.myShape = copy.myShape;
        this.myColor = copy.myColor;
        this.myNotes = copy.myNotes;
        this.bExpand = copy.bExpand;
        this.partID = copy.partID;
        this.partName = copy.partName;
        this.personID = copy.personID;
        this.personName = copy.personName;
        this.description = copy.description;
        this.planCost = copy.planCost;
        this.safe = copy.safe;
        this.quality = copy.quality;
        this.myDependencySlice = new TaskDependencySliceImpl(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependant = new TaskDependencySliceAsDependant(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependee = new TaskDependencySliceAsDependee(this, this.myManager.getDependencyCollection());
        this.customValues = (CustomColumnsValues)copy.getCustomValues().clone();
        this.recalculateActivities();
    }

    @Override
    public Task unpluggedClone() {
        TaskImpl result = new TaskImpl(this, true){

            @Override
            public boolean isSupertask() {
                return false;
            }
        };
        return result;
    }

    @Override
    public TaskMutator createMutator() {
        if (this.myMutator != null) {
            return this.myMutator;
        }
        this.myMutator = new MutatorImpl(this.project);
        this.myException = new Exception();
        return this.myMutator;
    }

    @Override
    public TaskMutator createMutatorFixingDuration() {
        if (this.myMutator != null) {
            return this.myMutator;
        }
        this.myMutator = new MutatorImpl(this.project){

            @Override
            public void setStart(GanttCalendar start) {
                super.setStart(start);
                TaskImpl.this.myEnd = null;
            }
        };
        this.myException = new Exception();
        return this.myMutator;
    }

    @Override
    public int getTaskID() {
        return this.myID;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getWebLink() {
        return this.myWebLink;
    }

    @Override
    public boolean isMilestone() {
        return this.isMilestone;
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    @Override
    public GanttCalendar getStart() {
        if (this.myMutator != null && this.myMutator.myIsolationLevel == 0) {
            return this.myMutator.getStart();
        }
        return this.myStart;
    }

    @Override
    public GanttCalendar getEnd() {
        GanttCalendar result = null;
        if (this.myMutator != null && this.myMutator.myIsolationLevel == 0) {
            result = this.myMutator.getEnd();
        }
        if (result == null) {
            if (this.myEnd == null) {
                this.myEnd = this.calculateEnd();
            }
            result = this.myEnd;
        }
        if (result.toString().equals("07-10-1")) {
            System.out.println();
        }
        return result;
    }

    GanttCalendar calculateEnd() {
        GanttCalendar result = this.getStart().Clone();
        Date newEnd = this.shiftDate(result.getTime(), this.getDuration().getTimeUnit(), this.getDuration().getLength());
        result.setTime(newEnd);
        return result;
    }

    @Override
    public GanttCalendar getThird() {
        if (this.myMutator != null && this.myMutator.myIsolationLevel == 0) {
            return this.myMutator.getThird();
        }
        return this.myThird;
    }

    @Override
    public int getThirdDateConstraint() {
        return this.myThirdDateConstraint;
    }

    @Override
    public TaskActivity[] getActivities() {
        List activities;
        List list = activities = this.myMutator == null ? null : this.myMutator.getActivities();
        if (activities == null) {
            activities = this.myActivities;
        }
        return activities.toArray(new TaskActivity[activities.size()]);
    }

    @Override
    public TaskLength getDuration() {
        return this.myMutator != null && this.myMutator.myIsolationLevel == 0 ? this.myMutator.getDuration() : this.myLength;
    }

    @Override
    public float getCompletionPercentage() {
        return this.myMutator != null && this.myMutator.myIsolationLevel == 0 ? this.myMutator.getCompletionPercentage() : this.myCompletionPercentage;
    }

    @Override
    public boolean getExpand() {
        return this.bExpand;
    }

    @Override
    public ShapePaint getShape() {
        return this.myShape;
    }

    @Override
    public Color getColor() {
        Color result = this.myColor;
        if (result == null) {
            result = this.isMilestone() || this.getNestedTasks().length > 0 ? Color.BLACK : this.myManager.getConfig().getDefaultColor();
        }
        return result;
    }

    @Override
    public String getNotes() {
        return this.myNotes;
    }

    @Override
    public GanttTaskRelationship[] getPredecessors() {
        return new GanttTaskRelationship[0];
    }

    @Override
    public GanttTaskRelationship[] getSuccessors() {
        return new GanttTaskRelationship[0];
    }

    @Override
    public ResourceAssignment[] getAssignments() {
        return this.myAssignments.getAssignments();
    }

    @Override
    public ResourceAssignmentCollection getAssignmentCollection() {
        return this.myAssignments;
    }

    @Override
    public Task getSupertask() {
        TaskHierarchyItem container = this.myTaskHierarchyItem.getContainerItem();
        return container.getTask();
    }

    @Override
    public Task[] getNestedTasks() {
        TaskHierarchyItem[] nestedItems = this.myTaskHierarchyItem.getNestedItems();
        Task[] result = new Task[nestedItems.length];
        for (int i = 0; i < nestedItems.length; ++i) {
            result[i] = nestedItems[i].getTask();
        }
        return result;
    }

    @Override
    public void move(Task targetSupertask) {
        TaskImpl supertaskImpl = (TaskImpl)targetSupertask;
        TaskHierarchyItem targetItem = supertaskImpl.myTaskHierarchyItem;
        this.myTaskHierarchyItem.delete();
        targetItem.addNestedItem(this.myTaskHierarchyItem);
        this.myManager.onTaskMoved(this);
    }

    @Override
    public void delete() {
        this.getDependencies().clear();
        this.getAssignmentCollection().clear();
    }

    @Override
    public TaskDependencySlice getDependencies() {
        return this.myDependencySlice;
    }

    @Override
    public TaskDependencySlice getDependenciesAsDependant() {
        return this.myDependencySliceAsDependant;
    }

    @Override
    public TaskDependencySlice getDependenciesAsDependee() {
        return this.myDependencySliceAsDependee;
    }

    @Override
    public TaskManager getManager() {
        return this.myManager;
    }

    protected void setTaskIDHack(int taskID) {
        this.myID = taskID;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    public void setWebLink(String webLink) {
        this.myWebLink = webLink;
    }

    @Override
    public void setMilestone(boolean milestone) {
        this.isMilestone = milestone;
    }

    @Override
    public void setPriority(int priority) {
        this.myPriority = priority;
    }

    @Override
    public void setStart(GanttCalendar start) {
        if (start == null) {
            return;
        }
        this.myStart = start;
    }

    private void adjustNestedTasks() {
        try {
            if (this.myManager == null) {
                throw new Exception("myManager = null");
            }
            AlgorithmCollection algorithmCollection = this.myManager.getAlgorithmCollection();
            if (algorithmCollection != null) {
                algorithmCollection.getAdjustTaskBoundsAlgorithm().adjustNestedTasks(this, this.project);
            }
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSupertask() {
        return this.myManager.getTaskHierarchy().hasNestedTasks(this);
    }

    @Override
    public void setEnd(GanttCalendar end) {
        this.myEnd = end;
        this.recalculateActivities();
    }

    @Override
    public void setThirdDate(GanttCalendar third) {
        GanttCalendar oldThird = this.myThird == null ? null : this.myThird.Clone();
        this.myThird = third;
    }

    @Override
    public void setThirdDateConstraint(int thirdDateConstraint) {
        this.myThirdDateConstraint = thirdDateConstraint;
    }

    @Override
    public void shift(TaskLength shift) {
        float unitCount = shift.getLength(this.myLength.getTimeUnit());
        if (unitCount != 0.0f) {
            Task resultTask = this.shift(unitCount);
            GanttCalendar oldStart = this.myStart;
            GanttCalendar oldEnd = this.myEnd;
            this.myStart = resultTask.getStart();
            this.myLength = resultTask.getDuration();
            this.myEnd = resultTask.getEnd();
            if (this.areEventsEnabled()) {
                this.myManager.fireTaskScheduleChanged(this, oldStart, oldEnd);
            }
            this.recalculateActivities();
        }
    }

    public Task shift(float unitCount) {
        Task clone = this.unpluggedClone();
        if (unitCount > 0.0f) {
            TaskLength length = this.myManager.createLength(this.myLength.getTimeUnit(), unitCount);
            Date shiftedDate = this.shiftDate(this.myStart.getTime(), length.getTimeUnit(), length.getLength(), RESTLESS_CALENDAR);
            clone.setStart(new GanttCalendar(shiftedDate));
            clone.setDuration(this.myLength);
        } else {
            Date newStart = this.shiftDate(clone.getStart().getTime(), clone.getDuration().getTimeUnit(), (long)unitCount);
            clone.setStart(new GanttCalendar(newStart));
            clone.setDuration(this.myLength);
        }
        return clone;
    }

    @Override
    public void setDuration(TaskLength length) {
        if (length.getLength() <= 0L) {
            try {
                throw new Exception("length.getLength() <=");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.project, (Throwable)e);
                return;
            }
        }
        this.myLength = length;
        this.myEnd = null;
    }

    private Date shiftDate(Date input, TimeUnit timeUnit, long length) {
        return this.shiftDate(input, timeUnit, length, this.myManager.getConfig().getCalendar());
    }

    private Date shiftDate(Date input, TimeUnit timeUnit, long length, GPCalendar calendar) {
        Date result;
        List activities = calendar.getActivities(input, timeUnit, length);
        if (activities.isEmpty()) {
            return input;
        }
        if (length >= 0L) {
            GPCalendarActivity lastActivity = (GPCalendarActivity)activities.get(activities.size() - 1);
            result = lastActivity.getEnd();
        } else {
            GPCalendarActivity firstActivity = (GPCalendarActivity)activities.get(0);
            result = firstActivity.getStart();
        }
        return result;
    }

    @Override
    public TaskLength translateDuration(TaskLength duration) {
        return this.myManager.createLength(this.myLength.getTimeUnit(), this.translateDurationValue(duration));
    }

    private float translateDurationValue(TaskLength duration) {
        if (this.myLength.getTimeUnit().equals(duration.getTimeUnit())) {
            return duration.getValue();
        }
        if (this.myLength.getTimeUnit().isConstructedFrom(duration.getTimeUnit())) {
            return duration.getValue() / (float)this.myLength.getTimeUnit().getAtomCount(duration.getTimeUnit());
        }
        if (duration.getTimeUnit().isConstructedFrom(this.myLength.getTimeUnit())) {
            return duration.getValue() * (float)duration.getTimeUnit().getAtomCount(this.myLength.getTimeUnit());
        }
        throw new RuntimeException("Can't transalte duration=" + duration + " into units=" + this.myLength.getTimeUnit());
    }

    private void recalculateActivities() {
        if (this.myLength == null || this.myManager == null) {
            return;
        }
        this.recalculateActivities(this.myActivities, this.myStart.getTime(), this.getEnd().getTime());
    }

    private void recalculateActivities(List output, Date startDate, Date endDate) {
        GPCalendar calendar = this.myManager.getConfig().getCalendar();
        List activities = calendar.getActivities(startDate, endDate);
        output.clear();
        for (int i = 0; i < activities.size(); ++i) {
            GPCalendarActivity nextCalendarActivity = (GPCalendarActivity)activities.get(i);
            TaskActivityImpl nextTaskActivity = new TaskActivityImpl(this, nextCalendarActivity.getStart(), nextCalendarActivity.getEnd());
            output.add(nextTaskActivity);
        }
    }

    @Override
    public void setCompletionPercentage(float percentage) {
        float oldPercentage = this.myCompletionPercentage;
        this.myCompletionPercentage = percentage;
    }

    @Override
    public void setShape(ShapePaint shape) {
        this.myShape = shape;
    }

    @Override
    public void setColor(Color color) {
        this.myColor = color;
    }

    @Override
    public void setNotes(String notes) {
        this.myNotes = notes;
    }

    @Override
    public void setExpand(boolean expand) {
        this.bExpand = expand;
    }

    @Override
    public void addNotes(String notes) {
        this.myNotes = this.myNotes + notes;
    }

    protected void enableEvents(boolean enabled) {
        this.myEventsEnabled = enabled;
    }

    protected boolean areEventsEnabled() {
        return this.myEventsEnabled;
    }

    public boolean shapeDefined() {
        return this.myShape != null;
    }

    public boolean colorDefined() {
        return this.myColor != null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isUnplugged() {
        return this.myTaskHierarchyItem == null;
    }

    @Override
    public CustomColumnsValues getCustomValues() {
        return this.customValues;
    }

    @Override
    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    @Override
    public boolean isCritical() {
        return this.critical;
    }

    @Override
    public void applyThirdDateConstraint() {
        TaskLength length = this.getDuration();
        if (this.getThird() != null) {
            switch (this.getThirdDateConstraint()) {
                case 1: {
                    if (!this.getThird().after(this.getStart())) break;
                    int difference = this.getThird().diff(this.getStart());
                    GanttCalendar _start = this.getStart().newAdd(difference);
                    GanttCalendar _end = this.getEnd().newAdd(difference);
                    this.setEnd(_end);
                    this.setStart(_start);
                    this.setDuration(length);
                }
            }
        }
    }

    @Override
    public TaskInfo getTaskInfo() {
        return this.myTaskInfo;
    }

    @Override
    public void setTaskInfo(TaskInfo taskInfo) {
        this.myTaskInfo = taskInfo;
    }

    @Override
    public boolean isProjectTask() {
        return this.isProjectTask;
    }

    @Override
    public void setProjectTask(boolean projectTask) {
        this.isProjectTask = projectTask;
    }

    @Override
    public TaskMutator getMutator() {
        return this.myMutator;
    }

    public void setKeyTask(YesOrNoEnumDIY keyTask) {
        this.keyTask = keyTask;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private class MutatorImpl
    implements TaskMutator {
        private EventSender myPropertiesEventSender;
        private EventSender myProgressEventSender;
        private FieldChange myCompletionPercentageChange;
        private FieldChange myStartChange;
        private FieldChange myEndChange;
        private FieldChange myThirdChange;
        private DurationChange myDurationChange;
        private List myActivities;
        private final List myCommands;
        private int myIsolationLevel;
        GanttProject project;
        private Task myUnpluggedClone;
        private TaskInfo myTaskInfo;

        MutatorImpl(GanttProject myProject) {
            this.myPropertiesEventSender = new PropertiesEventSender();
            this.myProgressEventSender = new ProgressEventSender();
            this.myCommands = new ArrayList();
            this.project = myProject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            try {
                GanttCalendar end;
                if (this.myUnpluggedClone == null) {
                    this.myUnpluggedClone = TaskImpl.this.unpluggedClone();
                }
                boolean fireChanges = false;
                if (this.myStartChange != null) {
                    GanttCalendar start = this.getStart();
                    TaskImpl.this.setStart(start);
                }
                if (this.myDurationChange != null) {
                    TaskLength duration = this.getDuration();
                    TaskImpl.this.setDuration(duration);
                    this.myEndChange = null;
                }
                if (this.myCompletionPercentageChange != null) {
                    float newValue = this.getCompletionPercentage();
                    TaskImpl.this.setCompletionPercentage(newValue);
                }
                if (this.myEndChange != null && (end = this.getEnd()).getTime().compareTo(TaskImpl.this.getStart().getTime()) > 0) {
                    if (this.myUnpluggedClone.getDuration() != null) {
                        this.myUnpluggedClone.setStart(this.getStart().Clone());
                        this.myUnpluggedClone.setEnd(this.getEnd().Clone());
                        long length = this.myUnpluggedClone.getDuration().getLength();
                        if (length <= 3652L) {
                            TaskImpl.this.setEnd(end);
                        }
                    } else {
                        TaskImpl.this.setEnd(end);
                    }
                }
                if (this.myThirdChange != null) {
                    GanttCalendar third = this.getThird();
                    TaskImpl.this.setThirdDate(third);
                }
                for (int i = 0; i < this.myCommands.size(); ++i) {
                    Runnable next = (Runnable)this.myCommands.get(i);
                    next.run();
                }
                this.myCommands.clear();
                this.myPropertiesEventSender.fireEvent();
                this.myProgressEventSender.fireEvent();
            }
            finally {
                TaskImpl.this.myMutator = null;
            }
            if (this.myStartChange != null && TaskImpl.this.isSupertask()) {
                TaskImpl.this.adjustNestedTasks();
            }
            if ((this.myStartChange != null || this.myEndChange != null || this.myDurationChange != null) && TaskImpl.this.areEventsEnabled()) {
                GanttCalendar oldStart = (GanttCalendar)(this.myStartChange == null ? TaskImpl.this.getStart() : this.myStartChange.myOldValue);
                GanttCalendar oldEnd = (GanttCalendar)(this.myEndChange == null ? TaskImpl.this.getEnd() : this.myEndChange.myOldValue);
                TaskImpl.this.myManager.fireTaskScheduleChanged(TaskImpl.this, oldStart, oldEnd);
                if (this.project != null) {
                    this.project.recalculateCriticalPath();
                }
            }
        }

        public GanttCalendar getThird() {
            return this.myThirdChange == null ? TaskImpl.this.myThird : (GanttCalendar)this.myThirdChange.myFieldValue;
        }

        public List getActivities() {
            if (this.myActivities == null && this.myStartChange != null || this.myDurationChange != null) {
                this.myActivities = new ArrayList();
                TaskImpl.this.recalculateActivities(this.myActivities, this.getStart().getTime(), TaskImpl.this.getEnd().getTime());
            }
            return this.myActivities;
        }

        @Override
        public void setName(final String name) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setName(name);
                }
            });
        }

        @Override
        public void setProjectTask(final boolean projectTask) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setProjectTask(projectTask);
                }
            });
        }

        @Override
        public void setMilestone(final boolean milestone) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setMilestone(milestone);
                }
            });
        }

        @Override
        public void setPriority(final int priority) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setPriority(priority);
                }
            });
        }

        @Override
        public void setStart(GanttCalendar start) {
            if (start == null) {
                try {
                    throw new Exception("start = null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            GanttCalendar currentStart = this.getStart();
            if (start != null && currentStart != null && start.equals(currentStart)) {
                return;
            }
            if (this.myStartChange == null) {
                this.myStartChange = new FieldChange();
                this.myStartChange.myEventSender = this.myPropertiesEventSender;
            }
            this.myStartChange.setOldValue(TaskImpl.this.myStart);
            this.myStartChange.setValue(start);
            this.myActivities = null;
        }

        @Override
        public void setEnd(GanttCalendar end) {
            if (this.myEndChange == null) {
                this.myEndChange = new FieldChange();
                this.myEndChange.myEventSender = this.myPropertiesEventSender;
            }
            this.myEndChange.setOldValue(TaskImpl.this.myEnd);
            this.myEndChange.setValue(end);
            this.myActivities = null;
        }

        @Override
        public void setThird(GanttCalendar third, final int thirdDateConstraint) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setThirdDateConstraint(thirdDateConstraint);
                }
            });
            if (this.myThirdChange == null) {
                this.myThirdChange = new FieldChange();
                this.myThirdChange.myEventSender = this.myPropertiesEventSender;
            }
            this.myThirdChange.setValue(third);
            this.myActivities = null;
        }

        @Override
        public void setDuration(TaskLength length) {
            if (this.myDurationChange == null) {
                this.myDurationChange = new DurationChange();
                this.myDurationChange.myEventSender = this.myPropertiesEventSender;
                this.myDurationChange.setValue(length);
            } else {
                TaskLength currentLength = (TaskLength)this.myDurationChange.myFieldValue;
                if (currentLength.getLength() - length.getLength() == 0L) {
                    return;
                }
            }
            TaskLength prevLength = (TaskLength)this.myDurationChange.myFieldValue;
            Date prevEnd = null;
            this.myDurationChange.setValue(length);
            Date shifted = prevEnd == null ? TaskImpl.this.shiftDate(this.getStart().getTime(), length.getTimeUnit(), length.getLength()) : TaskImpl.this.shiftDate(prevEnd, length.getTimeUnit(), length.getLength() - prevLength.getLength());
            GanttCalendar newEnd = new GanttCalendar(shifted);
            this.setEnd(newEnd);
            this.myActivities = null;
        }

        @Override
        public void setExpand(final boolean expand) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setExpand(expand);
                }
            });
        }

        @Override
        public void setCritical(final boolean critical) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setCritical(critical);
                }
            });
        }

        @Override
        public void setShape(final ShapePaint shape) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setShape(shape);
                }
            });
        }

        @Override
        public void setColor(final Color color) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setColor(color);
                }
            });
        }

        @Override
        public void setNotes(final String notes) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setNotes(notes);
                }
            });
        }

        @Override
        public void addNotes(final String notes) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.addNotes(notes);
                }
            });
        }

        @Override
        public float getCompletionPercentage() {
            return this.myCompletionPercentageChange == null ? TaskImpl.this.myCompletionPercentage : ((Float)this.myCompletionPercentageChange.myFieldValue).floatValue();
        }

        public GanttCalendar getStart() {
            return this.myStartChange == null ? TaskImpl.this.myStart : (GanttCalendar)this.myStartChange.myFieldValue;
        }

        public GanttCalendar getEnd() {
            return this.myEndChange == null ? null : (GanttCalendar)this.myEndChange.myFieldValue;
        }

        @Override
        public TaskLength getDuration() {
            return this.myDurationChange == null ? TaskImpl.this.myLength : (TaskLength)this.myDurationChange.myFieldValue;
        }

        @Override
        public void shift(float unitCount) {
            Task result = this.getPrecomputedShift(unitCount);
            if (result == null) {
                result = TaskImpl.this.shift(unitCount);
                this.cachePrecomputedShift(result, unitCount);
            }
            this.setStart(result.getStart());
            this.setDuration(result.getDuration());
            this.setEnd(result.getEnd());
        }

        @Override
        public void shift(TaskLength shift) {
            TaskImpl.this.shift(shift);
        }

        @Override
        public void setIsolationLevel(int level) {
            this.myIsolationLevel = level;
        }

        private void cachePrecomputedShift(Task result, float unitCount) {
        }

        private Task getPrecomputedShift(float unitCount) {
            return null;
        }

        public TaskInfo getTaskInfo() {
            return this.myTaskInfo;
        }

        @Override
        public void setTaskInfo(TaskInfo taskInfo) {
            this.myTaskInfo = taskInfo;
        }

        public void setKeyTask(final YesOrNoEnumDIY b) {
            this.myCommands.add(new Runnable(){

                @Override
                public void run() {
                    TaskImpl.this.setKeyTask(b);
                }
            });
        }

        @Override
        public void setCompletionPercentage(float percentage) {
            if (this.myCompletionPercentageChange == null) {
                this.myCompletionPercentageChange = new FieldChange();
                this.myCompletionPercentageChange.myEventSender = this.myProgressEventSender;
            }
            this.myCompletionPercentageChange.setValue(new Float(percentage));
        }
    }

    private static class DurationChange
    extends FieldChange {
        private int myMinLength = 0;
        private List myDates;

        private DurationChange() {
        }

        Date getCachedDate(int length) {
            if (this.myDates == null) {
                return null;
            }
            int index = length - this.myMinLength;
            if (index < 0 || index >= this.myDates.size()) {
                return null;
            }
            return (Date)this.myDates.get(index);
        }

        void cacheDate(Date date, int length) {
            int index;
            if (this.myDates == null) {
                this.myDates = new ArrayList();
            }
            for (index = length - this.myMinLength; index <= -1; ++index) {
                this.myDates.add(0, null);
            }
            while (index > this.myDates.size()) {
                this.myDates.add(null);
            }
            if (index == -1) {
                this.myDates.add(0, date);
            } else if (index == this.myDates.size()) {
                this.myDates.add(date);
            } else {
                this.myDates.set(index, date);
            }
        }
    }

    private static class FieldChange {
        String myFieldName;
        Object myFieldValue;
        Object myOldValue;
        EventSender myEventSender;

        private FieldChange() {
        }

        void setValue(Object newValue) {
            this.myFieldValue = newValue;
            this.myEventSender.enable();
        }

        public void setOldValue(Object oldValue) {
            this.myOldValue = oldValue;
        }
    }

    private class PropertiesEventSender
    implements EventSender {
        private boolean myEnabled;

        private PropertiesEventSender() {
        }

        @Override
        public void fireEvent() {
            if (this.myEnabled) {
                TaskImpl.this.myManager.fireTaskPropertiesChanged(TaskImpl.this);
            }
            this.myEnabled = false;
        }

        @Override
        public void enable() {
            this.myEnabled = true;
        }
    }

    private class ProgressEventSender
    implements EventSender {
        private boolean myEnabled;

        private ProgressEventSender() {
        }

        @Override
        public void fireEvent() {
            if (this.myEnabled) {
                TaskImpl.this.myManager.fireTaskProgressChanged(TaskImpl.this);
            }
            this.myEnabled = false;
        }

        @Override
        public void enable() {
            this.myEnabled = true;
        }
    }

    private static interface EventSender {
        public void enable();

        public void fireEvent();
    }
}

