/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.AlwaysWorkingTimeCalendarImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendarActivity;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsStorage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskDocumentOrderComparator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLengthImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManagerConfig;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.AdjustTaskBoundsAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.AlgorithmCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.CriticalPathAlgorithmImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.FindPossibleDependeesAlgorithmImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.ProjectBoundsAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.RecalculateTaskCompletionPercentageAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.EventDispatcher;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyCollectionImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.ConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishFinishConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.StartFinishConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.StartStartConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskDependencyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskHierarchyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskPropertyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskScheduleEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.hierarchy.TaskHierarchyManagerImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.DateFrameable;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;

public class TaskManagerImpl
implements TaskManager {
    private final TaskHierarchyManagerImpl myHierarchyManager;
    private final TaskDependencyCollectionImpl myDependencyCollection;
    private final AlgorithmCollection myAlgorithmCollection;
    private final List myListeners = new ArrayList();
    private int myMaxID = 0;
    private Task myRoot;
    private final TaskManagerConfig myConfig;
    private final TaskContainmentHierarchyFacade.Factory myFacadeFactory;
    private TaskContainmentHierarchyFacade myTaskContainment;
    private final TaskMap myTaskMap = new TaskMap(this);
    private GanttProject project;
    private CustomColumnsStorage customColumnsStorage;
    private static final GPCalendar RESTLESS_CALENDAR = new AlwaysWorkingTimeCalendarImpl();

    TaskManagerImpl(TaskContainmentHierarchyFacade.Factory containmentFacadeFactory, TaskManagerConfig config, GanttProject myProject) {
        this.myConfig = config;
        this.project = myProject;
        this.customColumnsStorage = new CustomColumnsStorage();
        this.myHierarchyManager = new TaskHierarchyManagerImpl();
        EventDispatcher dispatcher = new EventDispatcher(){

            @Override
            public void fireDependencyAdded(TaskDependency dep) {
                TaskManagerImpl.this.fireDependencyAdded(dep);
            }

            @Override
            public void fireDependencyRemoved(TaskDependency dep) {
                TaskManagerImpl.this.fireDependencyRemoved(dep);
            }
        };
        this.myDependencyCollection = new TaskDependencyCollectionImpl(containmentFacadeFactory, dispatcher){
            private TaskContainmentHierarchyFacade myTaskHierarchy;

            @Override
            protected TaskContainmentHierarchyFacade getTaskHierarchy() {
                if (this.myTaskHierarchy == null) {
                    this.myTaskHierarchy = TaskManagerImpl.this.getTaskHierarchy();
                }
                return this.myTaskHierarchy;
            }
        };
        this.myFacadeFactory = containmentFacadeFactory == null ? new FacadeFactoryImpl() : containmentFacadeFactory;
        Date today = GregorianCalendar.getInstance().getTime();
        this.myRoot = new GanttTask(null, new GanttCalendar(today), 1L, this, -1, this.project);
        this.myRoot.setStart(new GanttCalendar(GregorianCalendar.getInstance().getTime()));
        this.myRoot.setDuration(this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), 1.0f));
        this.myRoot.setExpand(true);
        FindPossibleDependeesAlgorithmImpl alg1 = new FindPossibleDependeesAlgorithmImpl(){

            @Override
            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        AdjustTaskBoundsAlgorithm alg3 = new AdjustTaskBoundsAlgorithm(){

            @Override
            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        RecalculateTaskScheduleAlgorithm alg2 = new RecalculateTaskScheduleAlgorithm(alg3, myProject){

            @Override
            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        RecalculateTaskCompletionPercentageAlgorithm alg4 = new RecalculateTaskCompletionPercentageAlgorithm(){

            @Override
            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return TaskManagerImpl.this.getTaskHierarchy();
            }
        };
        ProjectBoundsAlgorithm alg5 = new ProjectBoundsAlgorithm();
        this.myAlgorithmCollection = new AlgorithmCollection(alg1, alg2, alg3, alg4, alg5);
    }

    @Override
    public GanttTask getTask(int taskId) {
        return (GanttTask)this.myTaskMap.getTask(taskId);
    }

    @Override
    public Task getRootTask() {
        if (this.myRoot == null) {
            // empty if block
        }
        return this.myRoot;
    }

    @Override
    public Task[] getTasks() {
        return this.myTaskMap.getTasks();
    }

    @Override
    public void clear() {
        this.myTaskMap.clear();
        this.setMaxID(-1);
        this.myDependencyCollection.clear();
        Date today = GregorianCalendar.getInstance().getTime();
        this.myRoot = new GanttTask(null, new GanttCalendar(today), 1L, this, -1, this.project);
        this.myRoot.setStart(new GanttCalendar(GregorianCalendar.getInstance().getTime()));
        this.myRoot.setDuration(this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), 1.0f));
        this.myRoot.setExpand(true);
    }

    @Override
    public void deleteTask(Task tasktoRemove) {
        this.myTaskMap.removeTask(tasktoRemove);
    }

    @Override
    public GanttTask createTask() {
        GanttTask result = this.createTask(-1);
        return result;
    }

    @Override
    public GanttTask createTask(int taskID) {
        GanttCalendar calendar = null;
        calendar = new GanttCalendar(this.project.getStandDate());
        GanttTask result = new GanttTask("", calendar, 1L, this, taskID, this.project);
        if (result.getTaskID() >= this.getMaxID()) {
            this.setMaxID(result.getTaskID() + 1);
        }
        this.fireTaskAdded(result);
        return result;
    }

    @Override
    public void registerTask(Task task) {
        int taskID = task.getTaskID();
        if (this.myTaskMap.getTask(taskID) == null) {
            this.myTaskMap.addTask(task);
            if (this.getMaxID() < taskID) {
                this.setMaxID(taskID + 1);
            }
        } else {
            throw new RuntimeException("There is a task that already has the ID " + taskID);
        }
    }

    boolean isRegistered(TaskImpl task) {
        return this.myTaskMap.getTask(task.getTaskID()) != null;
    }

    public void setTask(Task task) {
        int taskID = task.getTaskID();
        this.myTaskMap.addTask(task);
        if (taskID > this.getMaxID()) {
            this.setMaxID(taskID);
        }
    }

    @Override
    public int getTaskCount() {
        return this.myTaskMap.size();
    }

    @Override
    public TaskLength getProjectLength() {
        if (this.myTaskMap.isEmpty()) {
            return this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), 0.0f);
        }
        ProjectBoundsAlgorithm.Result result = this.getAlgorithmCollection().getProjectBoundsAlgorithm().getBounds(Arrays.asList(this.myTaskMap.getTasks()));
        return this.createLength(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), result.lowerBound, result.upperBound);
    }

    @Override
    public Date getProjectStart() {
        if (this.myTaskMap.isEmpty()) {
            return this.myRoot.getStart().getTime();
        }
        ProjectBoundsAlgorithm.Result result = this.getAlgorithmCollection().getProjectBoundsAlgorithm().getBounds(Arrays.asList(this.myTaskMap.getTasks()));
        return result.lowerBound;
    }

    @Override
    public Date getProjectEnd() {
        if (this.myTaskMap.isEmpty()) {
            return this.myRoot.getStart().getTime();
        }
        ProjectBoundsAlgorithm.Result result = this.getAlgorithmCollection().getProjectBoundsAlgorithm().getBounds(Arrays.asList(this.myTaskMap.getTasks()));
        return result.upperBound;
    }

    @Override
    public TaskLength createLength(TimeUnit unit, float length) {
        return new TaskLengthImpl(unit, length);
    }

    @Override
    public TaskLength createLength(long count) {
        return new TaskLengthImpl(this.getConfig().getTimeUnitStack().getDefaultTimeUnit(), count);
    }

    @Override
    public TaskLength createLength(TimeUnit timeUnit, Date startDate, Date endDate) {
        int unitCount;
        int sign = 1;
        if (endDate.before(startDate)) {
            sign = -1;
            Date temp = endDate;
            endDate = startDate;
            startDate = temp;
        }
        if (timeUnit instanceof DateFrameable) {
            TimeUnit df = timeUnit;
            unitCount = 0;
            while (startDate.before(endDate)) {
                startDate = df.adjustRight(startDate);
                ++unitCount;
            }
        } else {
            throw new IllegalArgumentException("Time unit=" + timeUnit + " is not date frameable");
        }
        TaskLengthImpl result = new TaskLengthImpl(timeUnit, unitCount * sign);
        return result;
    }

    @Override
    public TaskDependencyCollection getDependencyCollection() {
        return this.myDependencyCollection;
    }

    @Override
    public AlgorithmCollection getAlgorithmCollection() {
        return this.myAlgorithmCollection;
    }

    public TaskHierarchyManagerImpl getHierarchyManager() {
        return this.myHierarchyManager;
    }

    @Override
    public TaskDependencyConstraint createConstraint(int constraintID) {
        ConstraintImpl result;
        switch (constraintID) {
            case 2: {
                result = new FinishStartConstraintImpl();
                break;
            }
            case 3: {
                result = new FinishFinishConstraintImpl();
                break;
            }
            case 4: {
                result = new StartFinishConstraintImpl();
                break;
            }
            case 1: {
                result = new StartStartConstraintImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constraint ID=" + constraintID);
            }
        }
        return result;
    }

    public int getMaxID() {
        return this.myMaxID;
    }

    public void setMaxID(int id) {
        this.myMaxID = id;
    }

    void increaseMaxID() {
        ++this.myMaxID;
    }

    @Override
    public void addTaskListener(TaskListener listener) {
    }

    @Override
    public GPCalendar getCalendar() {
        return this.getConfig().getCalendar();
    }

    public void fireTaskProgressChanged(Task changedTask) {
        TaskPropertyEvent e = new TaskPropertyEvent(changedTask);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.taskProgressChanged(e);
        }
    }

    void fireTaskScheduleChanged(Task changedTask, GanttCalendar oldStartDate, GanttCalendar oldFinishDate) {
        TaskScheduleEvent e = new TaskScheduleEvent(changedTask, oldStartDate, oldFinishDate, changedTask.getStart(), changedTask.getEnd());
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.taskScheduleChanged(e);
        }
    }

    private void fireDependencyAdded(TaskDependency newDependency) {
        TaskDependencyEvent e = new TaskDependencyEvent(this.getDependencyCollection(), newDependency);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.dependencyAdded(e);
        }
    }

    private void fireDependencyRemoved(TaskDependency dep) {
        TaskDependencyEvent e = new TaskDependencyEvent(this.getDependencyCollection(), dep);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.dependencyRemoved(e);
        }
    }

    private void fireTaskAdded(Task task) {
        TaskHierarchyEvent e = new TaskHierarchyEvent(this, task, null, this.getTaskHierarchy().getContainer(task));
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.taskAdded(e);
        }
    }

    private void fireTaskRemoved(Task task, Task oldSupertask) {
        TaskHierarchyEvent e = new TaskHierarchyEvent(this, task, oldSupertask, null);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.taskRemoved(e);
        }
    }

    void fireTaskPropertiesChanged(Task task) {
        TaskPropertyEvent e = new TaskPropertyEvent(task);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            TaskListener next = (TaskListener)this.myListeners.get(i);
            next.taskPropertiesChanged(e);
        }
    }

    public TaskManagerConfig getConfig() {
        return this.myConfig;
    }

    @Override
    public TaskContainmentHierarchyFacade getTaskHierarchy() {
        return this.myFacadeFactory.createFacede();
    }

    @Override
    public TaskManager emptyClone() {
        return new TaskManagerImpl(null, this.myConfig, this.project);
    }

    @Override
    public Map importData(TaskManager taskManager) {
        Task importRoot = taskManager.getRootTask();
        HashMap original2imported = new HashMap();
        this.importData(importRoot, this.getRootTask(), original2imported);
        TaskDependency[] deps = taskManager.getDependencyCollection().getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            Task nextDependant = deps[i].getDependant();
            Task nextDependee = deps[i].getDependee();
            Task importedDependant = (Task)original2imported.get(nextDependant);
            Task importedDependee = (Task)original2imported.get(nextDependee);
            try {
                TaskDependency dependency = this.getDependencyCollection().createDependency(importedDependant, importedDependee, new FinishStartConstraintImpl());
                dependency.setConstraint(deps[i].getConstraint());
                dependency.setDifference(deps[i].getDifference());
                dependency.setHardness(deps[i].getHardness());
                continue;
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
        }
        return original2imported;
    }

    private void importData(Task importRoot, Task root, Map original2imported) {
        Task[] nested = importRoot.getManager().getTaskHierarchy().getNestedTasks(importRoot);
        for (int i = nested.length - 1; i >= 0; --i) {
            GanttTask nextImported = this.createTask();
            this.registerTask(nextImported);
            nextImported.setName(nested[i].getName());
            nextImported.setStart(nested[i].getStart().Clone());
            nextImported.setDuration(nested[i].getDuration());
            nextImported.setMilestone(nested[i].isMilestone());
            nextImported.setColor(nested[i].getColor());
            nextImported.setShape(nested[i].getShape());
            nextImported.setCompletionPercentage(nested[i].getCompletionPercentage());
            nextImported.setNotes(nested[i].getNotes());
            nextImported.setTaskInfo(nested[i].getTaskInfo());
            nextImported.setExpand(nested[i].getExpand());
            if (nested[i].getThird() != null) {
                nextImported.setThirdDate(nested[i].getThird().Clone());
                nextImported.setThirdDateConstraint(nested[i].getThirdDateConstraint());
            }
            this.customColumnsStorage.processNewTask(nextImported);
            original2imported.put(nested[i], nextImported);
            this.getTaskHierarchy().move(nextImported, root);
            this.importData(nested[i], nextImported, original2imported);
        }
    }

    public Date findClosestWorkingTime(Date time) {
        return this.getCalendar().findClosestWorkingTime(time);
    }

    @Override
    public void processCriticalPath(TaskNode root) {
        try {
            this.myAlgorithmCollection.getRecalculateTaskScheduleAlgorithm().run();
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
        }
        CriticalPathAlgorithmImpl criticAlgo = new CriticalPathAlgorithmImpl(root, this.getCalendar());
        Task[] tasks = criticAlgo.getCriticalTasks();
        this.resetCriticalPath(root);
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i].setCritical(true);
        }
    }

    private void resetCriticalPath(TaskNode root) {
        Enumeration<TreeNode> en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            TreeNode next = en.nextElement();
            if (!(next instanceof TaskNode)) continue;
            Task t = (Task)((TaskNode)next).getUserObject();
            t.setCritical(false);
        }
    }

    @Override
    public void importAssignments(TaskManager importedTaskManager, ResourceManager hrManager, Map original2importedTask, Map original2importedResource) {
        Task[] tasks = importedTaskManager.getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            ResourceAssignment[] assignments = tasks[i].getAssignments();
            for (int j = 0; j < assignments.length; ++j) {
                GanttTask task = this.getTask(((Task)original2importedTask.get(tasks[i])).getTaskID());
                ResourceAssignment assignment = task.getAssignmentCollection().addAssignment((HumanResource)original2importedResource.get(assignments[j].getResource()));
                assignment.setLoad(assignments[j].getLoad());
                assignment.setCoordinator(assignments[j].isCoordinator());
            }
        }
    }

    void onTaskMoved(TaskImpl task) {
        if (!this.isRegistered(task)) {
            this.registerTask(task);
        }
        this.myTaskMap.setDirty();
    }

    @Override
    public Date shift(Date original, TaskLength duration) {
        Date result;
        long atomDuration;
        GPCalendar calendar = RESTLESS_CALENDAR;
        TimeUnit atomUnit = this.getConfig().getTimeUnitStack().getDefaultTimeUnit();
        List activities = calendar.getActivities(original, atomUnit, atomDuration = (long)duration.getLength(atomUnit));
        if (activities.isEmpty()) {
            return original;
        }
        if (atomDuration >= 0L) {
            GPCalendarActivity lastActivity = (GPCalendarActivity)activities.get(activities.size() - 1);
            result = lastActivity.getEnd();
        } else {
            GPCalendarActivity firstActivity = (GPCalendarActivity)activities.get(0);
            result = firstActivity.getStart();
        }
        return result;
    }

    @Override
    public CustomColumnsStorage getCustomColumnsStorage() {
        return this.customColumnsStorage;
    }

    private class FacadeFactoryImpl
    implements TaskContainmentHierarchyFacade.Factory {
        private FacadeFactoryImpl() {
        }

        @Override
        public TaskContainmentHierarchyFacade createFacede() {
            return new FacadeImpl();
        }
    }

    private final class FacadeImpl
    implements TaskContainmentHierarchyFacade {
        private List myPathBuffer = new ArrayList();

        private FacadeImpl() {
        }

        @Override
        public Task[] getNestedTasks(Task container) {
            return container.getNestedTasks();
        }

        @Override
        public boolean hasNestedTasks(Task container) {
            return TaskManagerImpl.this.myRoot == null ? false : TaskManagerImpl.this.myRoot.isMilestone();
        }

        @Override
        public Task getRootTask() {
            return TaskManagerImpl.this.getRootTask();
        }

        @Override
        public Task getContainer(Task nestedTask) {
            return nestedTask.getSupertask();
        }

        @Override
        public boolean areUnrelated(Task first, Task second) {
            this.myPathBuffer.clear();
            Task container = this.getContainer(first);
            while (container != null) {
                this.myPathBuffer.add(container);
                container = this.getContainer(container);
            }
            if (this.myPathBuffer.contains(second)) {
                return false;
            }
            this.myPathBuffer.clear();
            container = this.getContainer(second);
            while (container != null) {
                this.myPathBuffer.add(container);
                container = this.getContainer(container);
            }
            return !this.myPathBuffer.contains(first);
        }

        @Override
        public void move(Task whatMove, Task whereMove) {
            whatMove.move(whereMove);
        }

        @Override
        public int getDepth(Task task) {
            int depth = 0;
            while (task != TaskManagerImpl.this.myRoot) {
                task = task.getSupertask();
                ++depth;
            }
            return depth;
        }

        @Override
        public int compareDocumentOrder(Task task1, Task task2) {
            if (task1 == task2) {
                return 0;
            }
            ArrayList<Task> buffer1 = new ArrayList<Task>();
            Task container = task1;
            while (container != null) {
                buffer1.add(0, container);
                container = this.getContainer(container);
            }
            ArrayList<Task> buffer2 = new ArrayList<Task>();
            Task container2 = task2;
            while (container2 != null) {
                buffer2.add(0, container2);
                container2 = this.getContainer(container2);
            }
            if (buffer1.get(0) != this.getRootTask() && buffer2.get(0) == this.getRootTask()) {
                return -1;
            }
            if (buffer1.get(0) == this.getRootTask() && buffer2.get(0) != this.getRootTask()) {
                return 1;
            }
            boolean result = false;
            int i = 0;
            Task commonRoot = null;
            while (i != buffer1.size()) {
                Task root2;
                if (i == buffer2.size()) {
                    return 1;
                }
                Task root1 = (Task)buffer1.get(i);
                if (root1 != (root2 = (Task)buffer2.get(i))) {
                    if (commonRoot == null) {
                        try {
                            throw new Exception("Failure comparing task=" + task1 + " and task=" + task2 + "\n. Path1=" + buffer1 + "\nPath2=" + buffer2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (commonRoot != null) {
                        Task[] nestedTasks = commonRoot.getNestedTasks();
                        if (nestedTasks != null) {
                            for (int j = 0; j < nestedTasks.length; ++j) {
                                if (nestedTasks[j] == root1) {
                                    return -1;
                                }
                                if (nestedTasks[j] != root2) continue;
                                return 1;
                            }
                        }
                        throw new IllegalStateException("We should not be here");
                    }
                }
                ++i;
                commonRoot = root1;
            }
            return -1;
        }

        @Override
        public boolean contains(Task task) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TaskMap {
        private final Map myId2task = new HashMap();
        private TaskDocumentOrderComparator myComparator;
        private boolean isModified = true;
        private Task[] myArray;
        private final TaskManagerImpl myManager;

        TaskMap(TaskManagerImpl taskManager) {
            this.myComparator = new TaskDocumentOrderComparator(taskManager);
            this.myManager = taskManager;
        }

        void addTask(Task task) {
            this.myId2task.put(new Integer(task.getTaskID()), task);
            this.isModified = true;
        }

        Task getTask(int id) {
            return (Task)this.myId2task.get(new Integer(id));
        }

        public Task[] getTasks() {
            if (this.isModified) {
                this.myArray = this.myId2task.values().toArray(new Task[this.myId2task.size()]);
                Arrays.sort(this.myArray, this.myComparator);
                this.isModified = false;
            }
            return this.myArray;
        }

        public void clear() {
            this.myId2task.clear();
            this.isModified = true;
        }

        public void removeTask(Task task) {
            this.myId2task.remove(new Integer(task.getTaskID()));
            Task[] nestedTasks = this.myManager.getTaskHierarchy().getNestedTasks(task);
            for (int i = 0; i < nestedTasks.length; ++i) {
                this.removeTask(nestedTasks[i]);
            }
            this.isModified = true;
        }

        public int size() {
            return this.myId2task.size();
        }

        public boolean isEmpty() {
            return this.myId2task.isEmpty();
        }

        void setDirty() {
            this.isModified = true;
        }
    }
}

