/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TaskSelectionManager {
    private final List selectedTasks = new ArrayList();
    private final List myListeners = new ArrayList();

    public void addTask(Task task) {
        if (!this.selectedTasks.contains(task)) {
            this.selectedTasks.add(task);
            this.fireSelectionChanged();
        }
    }

    public void removeTask(Task task) {
        if (this.selectedTasks.contains(task)) {
            this.selectedTasks.remove(task);
            this.fireSelectionChanged();
        }
    }

    public boolean isTaskSelected(Task task) {
        return this.selectedTasks.contains(task);
    }

    public List getSelectedTasks() {
        return Collections.unmodifiableList(this.selectedTasks);
    }

    public Date getEarliestStart() {
        Date res = null;
        for (Task task : this.selectedTasks) {
            Date d = task.getStart().getTime();
            if (res == null) {
                res = d;
                continue;
            }
            if (!d.before(res)) continue;
            res = d;
        }
        return res;
    }

    public Date getLatestEnd() {
        Date res = null;
        for (Task task : this.selectedTasks) {
            Date d = task.getEnd().getTime();
            if (res == null) {
                res = d;
                continue;
            }
            if (!d.after(res)) continue;
            res = d;
        }
        return res;
    }

    public void clear() {
        this.selectedTasks.clear();
        this.fireSelectionChanged();
    }

    public void addSelectionListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeSelectionListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private void fireSelectionChanged() {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            Listener next = (Listener)this.myListeners.get(i);
            next.selectionChanged(Collections.unmodifiableList(this.selectedTasks));
        }
    }

    public static interface Listener {
        public void selectionChanged(List var1);
    }
}

