/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.CriticalPathAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class CriticalPathAlgorithmImpl
implements CriticalPathAlgorithm {
    TaskNode root = null;
    private GPCalendar calendar = null;

    public CriticalPathAlgorithmImpl(TaskNode root, GPCalendar cal) {
        this.root = root;
        this.calendar = cal;
    }

    private List getLastTasks() {
        ArrayList<Object> res = new ArrayList<Object>();
        Enumeration<TreeNode> en = this.root.preorderEnumeration();
        Calendar end = null;
        while (en.hasMoreElements()) {
            TaskNode tn;
            TreeNode next = en.nextElement();
            if (!(next instanceof TaskNode) || (tn = (TaskNode)next).isRoot()) continue;
            GanttCalendar tnEnd = tn.getEnd();
            if (end == null || end.before(tnEnd)) {
                res.clear();
                end = tnEnd.Clone();
                res.add(tn.getUserObject());
                continue;
            }
            if (((GanttCalendar)end).compareTo(tnEnd) != 0) continue;
            res.add(tn.getUserObject());
        }
        return res;
    }

    @Override
    public Task[] getCriticalTasks() {
        List lastTasks = this.getLastTasks();
        ArrayList<Task> res = new ArrayList<Task>(lastTasks);
        for (Task t : lastTasks) {
            res.add(t);
            this.checkCriticalTasks(t, res);
        }
        Task[] r = new Task[res.size()];
        res.toArray(r);
        return r;
    }

    private void checkCriticalTasks(Task successor, List criticalTasksList) {
        TaskDependency[] rel = successor.getDependenciesAsDependant().toArray();
        for (int i = 0; i < rel.length; ++i) {
            Task t = rel[i].getDependee();
            if (t.getEnd().compareTo(successor.getStart()) != 0 && !CriticalPathAlgorithmImpl.isIntervalNonWorking(t.getEnd(), successor.getStart(), this.calendar)) continue;
            criticalTasksList.add(t);
            this.checkCriticalTasks(t, criticalTasksList);
        }
    }

    private static boolean isIntervalNonWorking(GanttCalendar d1, GanttCalendar d2, GPCalendar cal) {
        while (d1.before(d2) && cal.getWeekDayType(d1.getDayWeek()) != GPCalendar.DayType.WORKING) {
            d1.add(1);
        }
        return d1.equals(d2);
    }
}

