/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import java.math.BigDecimal;

public abstract class RecalculateTaskCompletionPercentageAlgorithm {
    public void run(Task task) {
        TaskContainmentHierarchyFacade facade = this.createContainmentFacade();
        this.recalculateSupertaskCompletionPercentageBottomUp(task, facade);
    }

    private void recalculateSupertaskCompletionPercentageBottomUp(Task task, TaskContainmentHierarchyFacade facade) {
        while (task != null) {
            this.recalculateSupertaskCompletionPercentage(task, facade);
            task = facade.getContainer(task);
        }
    }

    private void recalculateSupertaskCompletionPercentage(Task task, TaskContainmentHierarchyFacade facade) {
        Task[] nestedTasks = facade.getNestedTasks(task);
        if (nestedTasks.length > 0) {
            BigDecimal completedDays = new BigDecimal("0");
            BigDecimal plannedDays = new BigDecimal("0");
            for (int i = 0; i < nestedTasks.length; ++i) {
                Task next = nestedTasks[i];
                long nextDuration = next.getDuration().getLength();
                completedDays = completedDays.add(new BigDecimal((float)nextDuration * next.getCompletionPercentage()));
                plannedDays = plannedDays.add(new BigDecimal(nextDuration));
            }
            float completionPercentage = completedDays.divide(plannedDays, 2, 4).floatValue();
            task.setCompletionPercentage(completionPercentage);
        }
    }

    protected abstract TaskContainmentHierarchyFacade createContainmentFacade();
}

