/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.hierarchy;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import java.util.ArrayList;

public class TaskHierarchyItem {
    private Task myTask;
    private TaskHierarchyItem myContainerItem;
    private TaskHierarchyItem myFirstNestedItem;
    private TaskHierarchyItem myNextSiblingItem;
    private static final TaskHierarchyItem[] EMPTY_ARRAY = new TaskHierarchyItem[0];

    public TaskHierarchyItem(Task myTask, TaskHierarchyItem containerItem) {
        this.myTask = myTask;
        this.myContainerItem = containerItem;
        if (this.myContainerItem != null) {
            this.myContainerItem.addNestedItem(this);
        }
    }

    public Task getTask() {
        return this.myTask;
    }

    public TaskHierarchyItem getContainerItem() {
        return this.myContainerItem;
    }

    public TaskHierarchyItem[] getNestedItems() {
        TaskHierarchyItem[] result;
        if (this.myFirstNestedItem == null) {
            result = EMPTY_ARRAY;
        } else {
            ArrayList<TaskHierarchyItem> tempList = new ArrayList<TaskHierarchyItem>();
            TaskHierarchyItem nested = this.myFirstNestedItem;
            while (nested != null) {
                tempList.add(nested);
                nested = nested.myNextSiblingItem;
            }
            result = tempList.toArray(EMPTY_ARRAY);
        }
        return result;
    }

    public void addNestedItem(TaskHierarchyItem nested) {
        nested.myNextSiblingItem = this.myFirstNestedItem;
        nested.myContainerItem = this;
        this.myFirstNestedItem = nested;
    }

    public void delete() {
        if (this.myContainerItem != null) {
            TaskHierarchyItem previousSibling = this.myContainerItem.myFirstNestedItem;
            if (this == previousSibling) {
                this.myContainerItem.myFirstNestedItem = this.myNextSiblingItem;
            } else {
                while (previousSibling.myNextSiblingItem != this) {
                    previousSibling = previousSibling.myNextSiblingItem;
                }
                previousSibling.myNextSiblingItem = this.myNextSiblingItem;
            }
            this.myContainerItem = null;
        }
        this.myNextSiblingItem = null;
    }
}

