/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.DateFrameable;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitDateFrameableImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitFunctionOfDate;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitGraph;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitText;
import java.util.Date;

public class TimeUnitFunctionOfDateImpl
extends TimeUnitDateFrameableImpl
implements TimeUnitFunctionOfDate {
    private final DateFrameable myDirectFrameable;

    public TimeUnitFunctionOfDateImpl(String name, TimeUnitGraph graph, TimeUnit directAtomUnit, DateFrameable framer) {
        super(name, graph, directAtomUnit, framer);
        if (!(directAtomUnit instanceof DateFrameable)) {
            throw new IllegalArgumentException("Only date frameable time units may be used as atoms for functions of date");
        }
        this.myDirectFrameable = directAtomUnit;
    }

    @Override
    public TimeUnit createTimeUnit(Date date) {
        return new ParameterizedTimeUnitImpl(date);
    }

    @Override
    public int getAtomCount(TimeUnit atomUnit) {
        throw new UnsupportedOperationException("This time unit is function of date. Use method createTimeUnit() to create a parameterized instance.");
    }

    private class ParameterizedTimeUnitImpl
    implements TimeUnit,
    DateFrameable {
        private final Date myBaseDate;
        private final Date myRightDate;
        private final Date myLeftDate;
        private int myAtomCount = -1;
        private TextFormatter myTextFormatter;

        public ParameterizedTimeUnitImpl(Date myBaseDate) {
            this.myBaseDate = myBaseDate;
            this.myRightDate = TimeUnitFunctionOfDateImpl.this.adjustRight(myBaseDate);
            this.myLeftDate = TimeUnitFunctionOfDateImpl.this.adjustLeft(myBaseDate);
        }

        @Override
        public String getName() {
            return TimeUnitFunctionOfDateImpl.this.getName();
        }

        @Override
        public boolean isConstructedFrom(TimeUnit unit) {
            return TimeUnitFunctionOfDateImpl.this.isConstructedFrom(unit);
        }

        @Override
        public int getAtomCount(TimeUnit atomUnit) {
            if (atomUnit == TimeUnitFunctionOfDateImpl.this || atomUnit == this) {
                return 1;
            }
            int directAtomCount = this.getDirectAtomCount();
            return directAtomCount * this.getDirectAtomUnit().getAtomCount(atomUnit);
        }

        private int getDirectAtomCount() {
            if (this.myAtomCount == -1) {
                this.myAtomCount = 0;
                Date leftDate = TimeUnitFunctionOfDateImpl.this.myDirectFrameable.jumpLeft(this.myRightDate);
                while (leftDate.compareTo(this.myLeftDate) >= 0) {
                    leftDate = TimeUnitFunctionOfDateImpl.this.myDirectFrameable.jumpLeft(leftDate);
                    ++this.myAtomCount;
                }
            }
            return this.myAtomCount;
        }

        @Override
        public TimeUnit getDirectAtomUnit() {
            return TimeUnitFunctionOfDateImpl.this.getDirectAtomUnit();
        }

        @Override
        public Date adjustRight(Date baseDate) {
            return TimeUnitFunctionOfDateImpl.this.adjustRight(baseDate);
        }

        @Override
        public Date adjustLeft(Date baseDate) {
            return TimeUnitFunctionOfDateImpl.this.adjustLeft(baseDate);
        }

        @Override
        public Date jumpLeft(Date baseDate) {
            return TimeUnitFunctionOfDateImpl.this.jumpLeft(baseDate);
        }

        @Override
        public void setTextFormatter(TextFormatter formatter) {
            TimeUnitFunctionOfDateImpl.this.setTextFormatter(formatter);
        }

        @Override
        public TimeUnitText format(Date baseDate) {
            TextFormatter formatter = TimeUnitFunctionOfDateImpl.this.getTextFormatter();
            return formatter == null ? new TimeUnitText("") : formatter.format(this, baseDate);
        }

        public boolean equals(Object o) {
            return TimeUnitFunctionOfDateImpl.this.equals(o);
        }
    }
}

