/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitGraph;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitText;
import java.util.Date;

public class TimeUnitImpl
implements TimeUnit {
    private final String myName;
    private final TimeUnitGraph myGraph;
    private final TimeUnit myDirectAtomUnit;
    private TextFormatter myTextFormatter;

    public TimeUnitImpl(String name, TimeUnitGraph graph, TimeUnit directAtomUnit) {
        this.myName = name;
        this.myGraph = graph;
        this.myDirectAtomUnit = directAtomUnit;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isConstructedFrom(TimeUnit atomUnit) {
        return this.myGraph.getComposition(this, atomUnit) != null;
    }

    @Override
    public int getAtomCount(TimeUnit atomUnit) {
        TimeUnitGraph.Composition composition = this.myGraph.getComposition(this, atomUnit);
        if (composition == null) {
            throw new RuntimeException("Failed to find a composition of time unit=" + this + " from time unit=" + atomUnit);
        }
        return composition.getAtomCount();
    }

    @Override
    public TimeUnit getDirectAtomUnit() {
        return this.myDirectAtomUnit;
    }

    public String toString() {
        return this.getName() + " hash=" + this.hashCode();
    }

    @Override
    public void setTextFormatter(TextFormatter formatter) {
        this.myTextFormatter = formatter;
    }

    @Override
    public TimeUnitText format(Date baseDate) {
        return this.myTextFormatter == null ? new TimeUnitText("") : this.myTextFormatter.format(this, baseDate);
    }

    protected TextFormatter getTextFormatter() {
        return this.myTextFormatter;
    }

    @Override
    public Date adjustRight(Date baseDate) {
        throw new UnsupportedOperationException("Time unit=" + this + " doesnt support this operation");
    }

    @Override
    public Date adjustLeft(Date baseDate) {
        throw new UnsupportedOperationException("Time unit=" + this + " doesnt support this operation");
    }

    @Override
    public Date jumpLeft(Date baseDate) {
        throw new UnsupportedOperationException("Time unit=" + this + " doesnt support this operation");
    }
}

