/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeFrame;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitGraph;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitPair;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.DayTextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.FramerImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.MonthTextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.TimeFrameImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.WeekFramerImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.WeekTextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.YearTextFormatter;
import java.util.Date;

public class GPTimeUnitStack
implements TimeUnitStack {
    private TimeUnitGraph ourGraph = new TimeUnitGraph();
    public TimeUnit DAY;
    public TimeUnit WEEK;
    public TimeUnit MONTH;
    public TimeUnit QUARTER;
    public TimeUnit YEAR = null;
    private TimeUnitPair[] myPairs;
    private TimeUnit MONTH_FROM_WEEKS;
    public TimeUnit DAY_AS_BOTTOM_UNIT;
    public TimeUnit WEEK_AS_BOTTOM_UNIT;
    public TimeUnit MONTH_AS_BOTTOM_UNIT;

    public GPTimeUnitStack(GanttLanguage i18n) {
        TimeUnit atom = this.ourGraph.createAtomTimeUnit("atom");
        this.DAY = this.ourGraph.createDateFrameableTimeUnit("day", atom, 1, new FramerImpl(5));
        this.DAY.setTextFormatter(new DayTextFormatter());
        this.DAY_AS_BOTTOM_UNIT = this.ourGraph.createDateFrameableTimeUnit("week", this.DAY, 1, new FramerImpl(7));
        this.DAY_AS_BOTTOM_UNIT.setTextFormatter(new DayTextFormatter(DayTextFormatter.format_EEEE));
        this.WEEK = this.ourGraph.createDateFrameableTimeUnit("week", this.DAY, 7, new WeekFramerImpl());
        this.WEEK.setTextFormatter(new WeekTextFormatter(WeekTextFormatter.format_yyyyMMdd));
        this.WEEK_AS_BOTTOM_UNIT = this.ourGraph.createDateFrameableTimeUnit("week", this.DAY, 7, new WeekFramerImpl());
        this.WEEK_AS_BOTTOM_UNIT.setTextFormatter(new WeekTextFormatter("{0}"));
        this.MONTH = this.ourGraph.createTimeUnitFunctionOfDate("month", this.DAY, new FramerImpl(2));
        this.MONTH.setTextFormatter(new MonthTextFormatter());
        this.MONTH_AS_BOTTOM_UNIT = this.ourGraph.createDateFrameableTimeUnit("month", this.DAY, 30, new FramerImpl(2));
        this.MONTH_AS_BOTTOM_UNIT.setTextFormatter(new MonthTextFormatter());
        this.YEAR = this.ourGraph.createTimeUnitFunctionOfDate("year", this.DAY, new FramerImpl(1));
        this.YEAR.setTextFormatter(new YearTextFormatter());
        this.myPairs = new TimeUnitPair[]{new MyTimeUnitPair(this.WEEK, this.DAY_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.MONTH, this.DAY), new MyTimeUnitPair(this.MONTH, this.DAY), new MyTimeUnitPair(this.MONTH, this.WEEK), new MyTimeUnitPair(this.MONTH, this.WEEK), new MyTimeUnitPair(this.MONTH, this.WEEK), new MyTimeUnitPair(this.MONTH, this.WEEK), new MyTimeUnitPair(this.MONTH, this.WEEK), new MyTimeUnitPair(this.YEAR, this.MONTH_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.YEAR, this.MONTH_AS_BOTTOM_UNIT), new MyTimeUnitPair(this.YEAR, this.MONTH_AS_BOTTOM_UNIT)};
    }

    @Override
    public TimeFrame createTimeFrame(Date baseDate, TimeUnit topUnit, TimeUnit bottomUnit) {
        return new TimeFrameImpl(baseDate, topUnit, bottomUnit);
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public TimeUnit getDefaultTimeUnit() {
        return this.DAY;
    }

    @Override
    public TimeUnitPair[] getTimeUnitPairs() {
        return this.myPairs;
    }

    @Override
    public TimeUnit getWeekDayTimeUnit() {
        return this.DAY_AS_BOTTOM_UNIT;
    }

    private class MyTimeUnitPair
    extends TimeUnitPair {
        MyTimeUnitPair(TimeUnit topUnit, TimeUnit bottomUnit) {
            super(topUnit, bottomUnit, GPTimeUnitStack.this);
        }
    }
}

