/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitText;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.CachingTextFormatter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MonthTextFormatter
extends CachingTextFormatter
implements TextFormatter {
    private SimpleDateFormat myLongFormat;
    private SimpleDateFormat myMediumFormat;
    private SimpleDateFormat myShortFormat;

    public MonthTextFormatter() {
        this.initFormats();
    }

    @Override
    protected TimeUnitText createTimeUnitText(Date adjustedLeft) {
        String longText = MessageFormat.format("{0}", this.myLongFormat.format(adjustedLeft));
        String mediumText = MessageFormat.format("{0}", this.myMediumFormat.format(adjustedLeft));
        String shortText = MessageFormat.format("{0}", this.myShortFormat.format(adjustedLeft));
        if (shortText.length() == 3) {
            shortText = shortText.substring(0, 2);
        }
        TimeUnitText result = new TimeUnitText(longText, mediumText, shortText);
        return result;
    }

    private void initFormats() {
        this.myLongFormat = GanttLanguage.getInstance().createDateFormat("yyyy MM");
        this.myMediumFormat = GanttLanguage.getInstance().createDateFormat("MM");
        this.myShortFormat = GanttLanguage.getInstance().createDateFormat("MM");
    }

    @Override
    public void languageChanged(GanttLanguage.Event event) {
        super.languageChanged(event);
        this.initFormats();
    }
}

