/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TextFormatter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitText;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.CachingTextFormatter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class WeekTextFormatter
extends CachingTextFormatter
implements TextFormatter {
    private Calendar myCalendar;
    SimpleDateFormat weekFormat_yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat weekFormat_MMdd = new SimpleDateFormat("MM-dd");
    SimpleDateFormat weekFormat_dd = new SimpleDateFormat("dd");
    public static int format_yyyyMMdd = 1;
    private int disFormat = -1;

    WeekTextFormatter(String formatString) {
        this.myCalendar = (Calendar)Calendar.getInstance().clone();
    }

    public WeekTextFormatter(int myDisFormat) {
        this.disFormat = myDisFormat;
    }

    @Override
    protected TimeUnitText createTimeUnitText(Date startDate) {
        String shortText = "";
        String middleText = "";
        String longText = "";
        if (this.myCalendar == null) {
            this.myCalendar = (Calendar)Calendar.getInstance().clone();
        }
        this.myCalendar.setTime(startDate);
        this.myCalendar.setMinimalDaysInFirstWeek(7);
        if (this.disFormat == -1) {
            Integer weekNo = new Integer(this.myCalendar.get(3));
            shortText = MessageFormat.format("{0}", weekNo);
            middleText = MessageFormat.format(GanttLanguage.getInstance().getText("week") + " {0}", weekNo);
        } else if (this.disFormat == format_yyyyMMdd) {
            shortText = this.weekFormat_dd.format(startDate);
            middleText = this.weekFormat_MMdd.format(startDate);
            longText = this.weekFormat_yyyyMMdd.format(startDate);
        }
        return new TimeUnitText(longText, middleText, shortText);
    }

    @Override
    public void languageChanged(GanttLanguage.Event event) {
        super.languageChanged(event);
        this.myCalendar = (Calendar)Calendar.getInstance().clone();
    }
}

