/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParserFactory;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.UndoableEditImpl;
import java.io.IOException;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class UndoManagerImpl
implements GPUndoManager {
    private UndoableEditSupport myUndoEventDispatcher;
    private UndoManager mySwingUndoManager;
    private DocumentManager myDocumentManager;
    private ParserFactory myParserFactory;
    private IGanttProject myProject;
    private UndoableEditImpl swingEditImpl;

    public UndoManagerImpl(IGanttProject project, ParserFactory parserFactory, DocumentManager documentManager) {
        this.myProject = project;
        this.myParserFactory = parserFactory;
        this.myDocumentManager = documentManager;
        this.mySwingUndoManager = new UndoManager();
        this.myUndoEventDispatcher = new UndoableEditSupport();
    }

    @Override
    public void undoableEdit(String localizedName, Runnable editImpl) {
        try {
            this.swingEditImpl = new UndoableEditImpl(localizedName, editImpl, this);
            this.mySwingUndoManager.addEdit(this.swingEditImpl);
            this.fireUndoableEditHappened(this.swingEditImpl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fireUndoableEditHappened(UndoableEditImpl swingEditImpl) {
        this.myUndoEventDispatcher.postEdit(swingEditImpl);
    }

    private void fireUndoOrRedoHappened() {
        UndoableEditListener[] listeners = this.myUndoEventDispatcher.getUndoableEditListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((GPUndoListener)listeners[i]).undoOrRedoHappened();
        }
    }

    DocumentManager getDocumentManager() {
        return this.myDocumentManager;
    }

    protected ParserFactory getParserFactory() {
        return this.myParserFactory;
    }

    IGanttProject getProject() {
        return this.myProject;
    }

    @Override
    public boolean canUndo() {
        return this.mySwingUndoManager.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.mySwingUndoManager.canRedo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.mySwingUndoManager.undo();
        this.fireUndoOrRedoHappened();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.mySwingUndoManager.redo();
        this.fireUndoOrRedoHappened();
    }

    @Override
    public String getUndoPresentationName() {
        return this.mySwingUndoManager.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return this.mySwingUndoManager.getRedoPresentationName();
    }

    @Override
    public void addUndoableEditListener(GPUndoListener listener) {
        this.myUndoEventDispatcher.addUndoableEditListener(listener);
    }

    @Override
    public void removeUndoableEditListener(GPUndoListener listener) {
        this.myUndoEventDispatcher.removeUndoableEditListener(listener);
    }

    @Override
    public void die() {
        if (this.swingEditImpl != null) {
            this.swingEditImpl.die();
        }
        if (this.mySwingUndoManager != null) {
            this.mySwingUndoManager.discardAllEdits();
        }
    }
}

