/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.Document;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.UndoManagerImpl;
import java.io.File;
import java.io.IOException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

class UndoableEditImpl
extends AbstractUndoableEdit {
    private String myPresentationName;
    private Runnable myEditImpl;
    private Document myDocumentBefore;
    private Document myDocumentAfter;
    private UndoManagerImpl myManager;

    UndoableEditImpl(String localizedName, Runnable editImpl, UndoManagerImpl manager) throws IOException {
        this.myManager = manager;
        this.myPresentationName = localizedName;
        this.myEditImpl = editImpl;
        this.myDocumentBefore = this.saveFile();
        editImpl.run();
        this.myDocumentAfter = this.saveFile();
    }

    private Document saveFile() throws IOException {
        File tempFile = this.createTemporaryFile();
        tempFile.deleteOnExit();
        Document doc = this.myManager.getDocumentManager().getDocument(tempFile.getAbsolutePath());
        doc.write();
        return doc;
    }

    @Override
    public boolean canUndo() {
        return this.myDocumentBefore.canRead();
    }

    @Override
    public boolean canRedo() {
        return this.myDocumentAfter.canRead();
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            this.restoreDocument(this.myDocumentAfter);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CannotRedoException();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            this.restoreDocument(this.myDocumentBefore);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CannotRedoException();
        }
    }

    private void restoreDocument(Document document) throws IOException {
        Document projectDocument = this.myManager.getProject().getDocument();
        this.myManager.getProject().close();
        document.read();
        this.myManager.getProject().setDocument(projectDocument);
    }

    @Override
    public String getPresentationName() {
        return this.myPresentationName;
    }

    File createTemporaryFile() throws IOException {
        return File.createTempFile("_GanttProject_qSave", ".gan");
    }
}

