/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;

public final class Duration
implements Comparable {
    private double m_duration;
    private TimeUnit m_units;
    private static final Duration[] ZERO_DURATIONS = new Duration[]{new Duration(0, TimeUnit.MINUTES), new Duration(0, TimeUnit.HOURS), new Duration(0, TimeUnit.DAYS), new Duration(0, TimeUnit.WEEKS), new Duration(0, TimeUnit.MONTHS), new Duration(0, TimeUnit.YEARS), new Duration(0, TimeUnit.PERCENT), new Duration(0, TimeUnit.ELAPSED_MINUTES), new Duration(0, TimeUnit.ELAPSED_HOURS), new Duration(0, TimeUnit.ELAPSED_DAYS), new Duration(0, TimeUnit.ELAPSED_WEEKS), new Duration(0, TimeUnit.ELAPSED_MONTHS), new Duration(0, TimeUnit.ELAPSED_YEARS), new Duration(0, TimeUnit.ELAPSED_PERCENT)};

    private Duration(double duration, TimeUnit type) {
        this.m_duration = duration;
        this.m_units = type;
    }

    private Duration(int duration, TimeUnit type) {
        this.m_duration = duration;
        this.m_units = type;
    }

    public double getDuration() {
        return this.m_duration;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public Duration convertUnits(TimeUnit type, ProjectHeader defaults) {
        return Duration.convertUnits(this.m_duration, this.m_units, type, defaults);
    }

    public static Duration convertUnits(double duration, TimeUnit fromUnits, TimeUnit toUnits, ProjectHeader defaults) {
        return Duration.convertUnits(duration, fromUnits, toUnits, defaults.getMinutesPerDay().doubleValue(), defaults.getMinutesPerWeek().doubleValue());
    }

    public static Duration convertUnits(double duration, TimeUnit fromUnits, TimeUnit toUnits, double minutesPerDay, double minutesPerWeek) {
        switch (fromUnits.getValue()) {
            case 5: {
                duration *= minutesPerWeek * 52.0;
                break;
            }
            case 12: {
                duration *= 524160.0;
                break;
            }
            case 4: {
                duration *= minutesPerWeek * 4.0;
                break;
            }
            case 11: {
                duration *= 40320.0;
                break;
            }
            case 3: {
                duration *= minutesPerWeek;
                break;
            }
            case 10: {
                duration *= 10080.0;
                break;
            }
            case 2: {
                duration *= minutesPerDay;
                break;
            }
            case 9: {
                duration *= 1440.0;
                break;
            }
            case 1: 
            case 8: {
                duration *= 60.0;
            }
        }
        if (toUnits != TimeUnit.MINUTES && toUnits != TimeUnit.ELAPSED_MINUTES) {
            switch (toUnits.getValue()) {
                case 1: 
                case 8: {
                    duration /= 60.0;
                    break;
                }
                case 2: {
                    duration /= minutesPerDay;
                    break;
                }
                case 9: {
                    duration /= 1440.0;
                    break;
                }
                case 3: {
                    duration /= minutesPerWeek;
                    break;
                }
                case 10: {
                    duration /= 10080.0;
                    break;
                }
                case 4: {
                    duration /= minutesPerWeek * 4.0;
                    break;
                }
                case 11: {
                    duration /= 40320.0;
                    break;
                }
                case 5: {
                    duration /= minutesPerWeek * 52.0;
                    break;
                }
                case 12: {
                    duration /= 524160.0;
                }
            }
        }
        return Duration.getInstance(duration, toUnits);
    }

    public static Duration getInstance(double duration, TimeUnit type) {
        Duration result = duration == 0.0 ? ZERO_DURATIONS[type.getValue()] : new Duration(duration, type);
        return result;
    }

    public static Duration getInstance(int duration, TimeUnit type) {
        Duration result = duration == 0 ? ZERO_DURATIONS[type.getValue()] : new Duration(duration, type);
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Duration rhs = (Duration)o;
        return this.m_duration == rhs.m_duration && this.m_units == rhs.m_units;
    }

    public int hashCode() {
        return this.m_units.getValue() + (int)this.m_duration;
    }

    public int compareTo(Object o) {
        Duration rhs = (Duration)o;
        if (this.m_units != rhs.m_units) {
            rhs = Duration.convertUnits(rhs.m_duration, rhs.m_units, this.m_units, 480.0, 2400.0);
        }
        return this.m_duration < rhs.m_duration ? -1 : (this.m_duration == rhs.m_duration ? 0 : 1);
    }

    public String toString() {
        return this.m_duration + this.m_units.toString();
    }
}

