/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.FieldContainer;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.FilterCriteria;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Filter {
    private Integer m_id;
    private String m_name;
    private boolean m_showRelatedSummaryRows;
    private List m_criteria = new LinkedList();
    private boolean m_promptTextSet;

    public void setID(Integer id) {
        this.m_id = id;
    }

    public Integer getID() {
        return this.m_id;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setShowRelatedSummaryRows(boolean showRelatedSummaryRows) {
        this.m_showRelatedSummaryRows = showRelatedSummaryRows;
    }

    public boolean getShowRelatedSummaryRows() {
        return this.m_showRelatedSummaryRows;
    }

    public void addCriteria(FilterCriteria criteria) {
        this.m_criteria.add(criteria);
        if (criteria.getPromptTextSet()) {
            this.m_promptTextSet = true;
        }
    }

    public List getCriteria() {
        return this.m_criteria;
    }

    public boolean isTaskFilter() {
        boolean result = true;
        if (!this.m_criteria.isEmpty()) {
            result = ((FilterCriteria)this.m_criteria.get(0)).getField() instanceof TaskField;
        }
        return result;
    }

    public boolean isResourceFilter() {
        boolean result = true;
        if (!this.m_criteria.isEmpty()) {
            result = ((FilterCriteria)this.m_criteria.get(0)).getField() instanceof ResourceField;
        }
        return result;
    }

    public boolean evaluate(FieldContainer container) {
        boolean result = true;
        if (!this.m_criteria.isEmpty()) {
            boolean logicalAnd = true;
            for (FilterCriteria criteria : this.m_criteria) {
                boolean criteriaResult = criteria.evaluate(container);
                result = logicalAnd ? result && criteriaResult : result || criteriaResult;
                logicalAnd = criteria.getLogicalAnd();
            }
        }
        return result;
    }

    public boolean getPromptTextSet() {
        return this.m_promptTextSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Filter id=");
        sb.append(this.m_id);
        sb.append(" name=");
        sb.append(this.m_name);
        sb.append(" showRelatedSummaryRows=");
        sb.append(this.m_showRelatedSummaryRows);
        sb.append(" criteria=[");
        Iterator iter = this.m_criteria.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

