/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.FieldContainer;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.FieldType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TestOperator;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.DateUtility;
import java.util.Date;

public abstract class GenericCriteria {
    private ProjectFile m_projectFile;
    private FieldType m_field;
    private TestOperator m_operator;
    private Object[] m_definedValues = new Object[2];
    private Object[] m_workingValues = new Object[2];
    private boolean m_symbolicValues;

    public GenericCriteria(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
    }

    public void setField(FieldType field) {
        this.m_field = field;
    }

    public FieldType getField() {
        return this.m_field;
    }

    public TestOperator getOperator() {
        return this.m_operator;
    }

    public void setOperator(TestOperator operator) {
        this.m_operator = operator;
    }

    public void setValue(int index, Object value) {
        this.m_definedValues[index] = value;
        if (value instanceof FieldType) {
            this.m_symbolicValues = true;
        } else if (value instanceof Duration && ((Duration)value).getUnits() != TimeUnit.HOURS) {
            value = ((Duration)value).convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectHeader());
        }
        this.m_workingValues[index] = value;
    }

    public Object getValue(int index) {
        return this.m_definedValues[index];
    }

    protected boolean evaluateCriteria(FieldContainer container) {
        Object lhs = container.getCurrentValue(this.m_field);
        switch (this.m_field.getDataType().getType()) {
            case 2: {
                if (lhs == null) break;
                lhs = DateUtility.getDayStartDate((Date)lhs);
                break;
            }
            case 6: {
                if (lhs == null) break;
                Duration dur = (Duration)lhs;
                lhs = dur.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectHeader());
                break;
            }
            case 1: {
                lhs = lhs == null ? "" : lhs;
            }
        }
        Object[] rhs = this.m_symbolicValues ? this.processSymbolicValues(this.m_workingValues, container) : this.m_workingValues;
        return this.m_operator.evaluate(lhs, rhs);
    }

    private Object[] processSymbolicValues(Object[] oldValues, FieldContainer container) {
        Object[] newValues = new Object[2];
        for (int loop = 0; loop < oldValues.length; ++loop) {
            Object value = oldValues[loop];
            if (value == null) continue;
            if (value instanceof FieldType) {
                FieldType type = (FieldType)value;
                value = container.getCachedValue(type);
                switch (type.getDataType().getType()) {
                    case 2: {
                        if (value == null) break;
                        value = DateUtility.getDayStartDate((Date)value);
                        break;
                    }
                    case 6: {
                        if (value == null || ((Duration)value).getUnits() == TimeUnit.HOURS) break;
                        value = ((Duration)value).convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectHeader());
                        break;
                    }
                    case 1: {
                        value = value == null ? "" : value;
                    }
                }
            }
            newValues[loop] = value;
        }
        return newValues;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[GenericCriteria");
        sb.append(" field=");
        sb.append(this.m_field);
        sb.append(" operator=");
        sb.append(this.m_operator);
        sb.append(" value=[");
        sb.append(this.m_definedValues[0]);
        sb.append(",");
        sb.append(this.m_definedValues[1]);
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

