/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.junit;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPXJException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.junit.FileUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.junit.MPXJTestCase;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.NumberUtility;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class BasicTest
extends MPXJTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite1() throws Exception {
        File out = null;
        boolean success = true;
        try {
            File in = new File(this.m_basedir + "/sample.mpx");
            ProjectFile mpx = new MPXReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpx, out, false);
            success = FileUtility.equals(in, out);
            BasicTest.assertTrue((String)"Files are not identical", (boolean)success);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite2() throws Exception {
        File out = null;
        boolean success = true;
        try {
            File in = new File(this.m_basedir + "/sample1.xml");
            ProjectFile xml = new MSPDIReader().read(in);
            out = File.createTempFile("junit", ".xml");
            new MSPDIWriter().write(xml, out);
            success = FileUtility.equals(in, out);
            BasicTest.assertTrue((String)"Files are not identical", (boolean)success);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite3() throws Exception {
        File out = null;
        boolean success = true;
        try {
            File in = new File(this.m_basedir + "/sample1.mpx");
            ProjectFile mpx = new MPXReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpx, out, false);
            success = FileUtility.equals(in, out);
            BasicTest.assertTrue((String)"Files are not identical", (boolean)success);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite4() throws Exception {
        File out = null;
        boolean success = true;
        try {
            MPXReader reader = new MPXReader();
            MPXWriter writer = new MPXWriter();
            File in = new File(this.m_basedir + "/sample.mpx");
            ProjectFile mpx = reader.read(in);
            out = File.createTempFile("junit", ".mpx");
            writer.setLocale(Locale.GERMAN);
            writer.write(mpx, out);
            reader.setLocale(Locale.GERMAN);
            mpx = reader.read(out);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite5() throws Exception {
        File out = null;
        boolean success = true;
        try {
            MPXReader reader = new MPXReader();
            MPXWriter writer = new MPXWriter();
            Locale swedish = new Locale("sv");
            File in = new File(this.m_basedir + "/sample.mpx");
            ProjectFile mpx = reader.read(in);
            out = File.createTempFile("junit", ".mpx");
            writer.setLocale(swedish);
            writer.write(mpx, out);
            mpx = new ProjectFile();
            reader.setLocale(swedish);
            mpx = reader.read(out);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite6() throws Exception {
        File out = null;
        boolean success = true;
        try {
            MPXReader reader = new MPXReader();
            MPXWriter writer = new MPXWriter();
            Locale portuguese = new Locale("pt");
            File in = new File(this.m_basedir + "/sample.mpx");
            ProjectFile mpx = reader.read(in);
            out = File.createTempFile("junit", ".mpx");
            writer.setLocale(portuguese);
            writer.write(mpx, out);
            mpx = new ProjectFile();
            reader.setLocale(portuguese);
            mpx = reader.read(out);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite7() throws Exception {
        File out = null;
        boolean success = true;
        try {
            MPXReader reader = new MPXReader();
            MPXWriter writer = new MPXWriter();
            Locale french = new Locale("fr");
            File in = new File(this.m_basedir + "/sample.mpx");
            ProjectFile mpx = reader.read(in);
            out = File.createTempFile("junit", ".mpx");
            writer.setLocale(french);
            writer.write(mpx, out);
            reader.setLocale(french);
            mpx = reader.read(out);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite8() throws Exception {
        File out = null;
        boolean success = true;
        try {
            MPXReader reader = new MPXReader();
            MPXWriter writer = new MPXWriter();
            Locale italian = new Locale("it");
            File in = new File(this.m_basedir + "/sample.mpx");
            ProjectFile mpx = reader.read(in);
            out = File.createTempFile("junit", ".mpx");
            writer.setLocale(italian);
            writer.write(mpx, out);
            reader.setLocale(italian);
            mpx = reader.read(out);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite9() throws Exception {
        File out = null;
        boolean success = true;
        try {
            File in = new File(this.m_basedir + "/empty.mpp");
            ProjectFile mpx = new MPPReader().read(in);
            mpx.getProjectHeader().setCurrentDate(new SimpleDateFormat("dd/MM/yyyy").parse("01/03/2006"));
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpx, out, false);
            success = FileUtility.equals(new File(this.m_basedir + "/empty.mpx"), out);
            BasicTest.assertTrue((String)"Files are not identical", (boolean)success);
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    public void testRead1() throws Exception {
        File in = new File(this.m_basedir + "/sample.de.mpx");
        MPXReader reader = new MPXReader();
        reader.setLocale(Locale.GERMAN);
        reader.read(in);
    }

    public void testAutomaticGeneration() throws Exception {
        ProjectFile file = new ProjectFile();
        file.setAutoWBS(true);
        file.setAutoOutlineLevel(true);
        file.setAutoOutlineNumber(true);
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        file.setAutoResourceID(true);
        file.setAutoResourceUniqueID(true);
        Resource resource1 = file.addResource();
        resource1.setName("R1");
        BasicTest.assertEquals((int)1, (int)resource1.getUniqueID());
        BasicTest.assertEquals((int)1, (int)resource1.getID());
        Resource resource2 = file.addResource();
        resource2.setName("R2");
        BasicTest.assertEquals((int)2, (int)resource2.getUniqueID());
        BasicTest.assertEquals((int)2, (int)resource2.getID());
        Task task1 = file.addTask();
        task1.setName("1.0");
        BasicTest.assertEquals((String)"1.0", (String)task1.getWBS());
        BasicTest.assertEquals((int)1, (int)task1.getOutlineLevel());
        BasicTest.assertEquals((String)"1.0", (String)task1.getOutlineNumber());
        BasicTest.assertEquals((int)1, (int)task1.getID());
        BasicTest.assertEquals((int)1, (int)task1.getUniqueID());
        BasicTest.assertEquals((boolean)false, (boolean)task1.getSummary());
        task1 = file.addTask();
        task1.setName("2.0");
        BasicTest.assertEquals((String)"2.0", (String)task1.getWBS());
        BasicTest.assertEquals((int)1, (int)task1.getOutlineLevel());
        BasicTest.assertEquals((String)"2.0", (String)task1.getOutlineNumber());
        BasicTest.assertEquals((int)2, (int)task1.getID());
        BasicTest.assertEquals((int)2, (int)task1.getUniqueID());
        BasicTest.assertEquals((boolean)false, (boolean)task1.getSummary());
        task1 = file.addTask();
        task1.setName("3.0");
        BasicTest.assertEquals((String)"3.0", (String)task1.getWBS());
        BasicTest.assertEquals((int)1, (int)task1.getOutlineLevel());
        BasicTest.assertEquals((String)"3.0", (String)task1.getOutlineNumber());
        BasicTest.assertEquals((int)3, (int)task1.getID());
        BasicTest.assertEquals((int)3, (int)task1.getUniqueID());
        BasicTest.assertEquals((boolean)false, (boolean)task1.getSummary());
        Task task2 = task1.addTask();
        task2.setName("3.1");
        BasicTest.assertEquals((String)"3.1", (String)task2.getWBS());
        BasicTest.assertEquals((int)2, (int)task2.getOutlineLevel());
        BasicTest.assertEquals((String)"3.1", (String)task2.getOutlineNumber());
        BasicTest.assertEquals((int)4, (int)task2.getID());
        BasicTest.assertEquals((int)4, (int)task2.getUniqueID());
        BasicTest.assertEquals((boolean)true, (boolean)task1.getSummary());
        BasicTest.assertEquals((boolean)false, (boolean)task2.getSummary());
        task2 = task1.addTask();
        task2.setName("3.2");
        BasicTest.assertEquals((String)"3.2", (String)task2.getWBS());
        BasicTest.assertEquals((int)2, (int)task2.getOutlineLevel());
        BasicTest.assertEquals((String)"3.2", (String)task2.getOutlineNumber());
        BasicTest.assertEquals((int)5, (int)task2.getID());
        BasicTest.assertEquals((int)5, (int)task2.getUniqueID());
        BasicTest.assertEquals((boolean)true, (boolean)task1.getSummary());
        BasicTest.assertEquals((boolean)false, (boolean)task2.getSummary());
        Task task3 = task2.addTask();
        task3.setName("3.2.1");
        BasicTest.assertEquals((String)"3.2.1", (String)task3.getWBS());
        BasicTest.assertEquals((int)3, (int)task3.getOutlineLevel());
        BasicTest.assertEquals((String)"3.2.1", (String)task3.getOutlineNumber());
        BasicTest.assertEquals((int)6, (int)task3.getID());
        BasicTest.assertEquals((int)6, (int)task3.getUniqueID());
        BasicTest.assertEquals((boolean)true, (boolean)task1.getSummary());
        BasicTest.assertEquals((boolean)true, (boolean)task2.getSummary());
        BasicTest.assertEquals((boolean)false, (boolean)task3.getSummary());
        task3 = task2.addTask();
        task3.setName("3.2.2");
        BasicTest.assertEquals((String)"3.2.2", (String)task3.getWBS());
        BasicTest.assertEquals((int)3, (int)task3.getOutlineLevel());
        BasicTest.assertEquals((String)"3.2.2", (String)task3.getOutlineNumber());
        BasicTest.assertEquals((int)7, (int)task3.getID());
        BasicTest.assertEquals((int)7, (int)task3.getUniqueID());
        BasicTest.assertEquals((boolean)true, (boolean)task1.getSummary());
        BasicTest.assertEquals((boolean)true, (boolean)task2.getSummary());
        BasicTest.assertEquals((boolean)false, (boolean)task3.getSummary());
    }

    public void testStructure() throws Exception {
        ProjectFile file = new ProjectFile();
        file.setAutoWBS(true);
        file.setAutoOutlineLevel(true);
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        Task task1 = file.addTask();
        BasicTest.assertNull((Object)task1.getParentTask());
        Task task2 = task1.addTask();
        BasicTest.assertEquals((Object)task2.getParentTask(), (Object)task1);
        task1.addTask();
        List children = task1.getChildTasks();
        BasicTest.assertEquals((int)children.size(), (int)2);
        List toplevel = file.getChildTasks();
        BasicTest.assertEquals((int)toplevel.size(), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion1() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample98.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
            this.commonTests(mpp);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion2() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
            this.commonTests(mpp);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion3() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample.xml");
            ProjectFile xml = new MSPDIReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(xml, out);
            this.commonTests(xml);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    private void commonTests(ProjectFile file) {
        Task task = file.getTaskByUniqueID(new Integer(2));
        List assignments = task.getResourceAssignments();
        BasicTest.assertEquals((int)2, (int)assignments.size());
        block4: for (ResourceAssignment assignment : assignments) {
            switch (NumberUtility.getInt(assignment.getResourceID())) {
                case 1: {
                    BasicTest.assertEquals((int)200, (int)((int)assignment.getRemainingWork().getDuration()));
                    BasicTest.assertEquals((Object)TimeUnit.HOURS, (Object)assignment.getRemainingWork().getUnits());
                    continue block4;
                }
                case 2: {
                    BasicTest.assertEquals((int)300, (int)((int)assignment.getRemainingWork().getDuration()));
                    BasicTest.assertEquals((Object)TimeUnit.HOURS, (Object)assignment.getRemainingWork().getUnits());
                    continue block4;
                }
            }
            BasicTest.assertTrue((String)"Unexpected resource", (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion4() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
            ProjectFile mpx = new MPXReader().read(out);
            out.delete();
            out = File.createTempFile("junit", ".xml");
            new MSPDIWriter().write(mpx, out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    public void testRelationList() throws Exception {
        File in = new File(this.m_basedir + "/sample.mpx");
        ProjectFile mpx = new MPXReader().read(in);
        List tasks = mpx.getAllTasks();
        for (Task task : tasks) {
            List rels = task.getPredecessors();
            if (rels == null) continue;
            for (Relation rel : rels) {
                mpx.getTaskByUniqueID(rel.getTaskUniqueID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskNotes() throws Exception {
        File out = null;
        try {
            String notes1 = "Notes, containing a comma. Done.";
            String notes2 = "Notes \"containing embedded quotes\" Done.";
            String notes3 = "Notes, \"containing embedded quotes, and comma's too.\" Done.";
            String notes4 = "\"Notes containing embedded quotes as first and last chars. Done.\"";
            String notes5 = "Normal unquoted notes. Done.";
            ProjectFile file1 = new ProjectFile();
            file1.setAutoWBS(true);
            file1.setAutoOutlineLevel(true);
            file1.setAutoTaskID(true);
            file1.setAutoTaskUniqueID(true);
            Task task1 = file1.addTask();
            task1.setName("Test Task 1");
            task1.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
            task1.setStart(new Date());
            task1.setNotes(notes1);
            Task task2 = file1.addTask();
            task2.setName("Test Task 2");
            task2.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
            task2.setStart(new Date());
            task2.setNotes(notes2);
            Task task3 = file1.addTask();
            task3.setName("Test Task 3");
            task3.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
            task3.setStart(new Date());
            task3.setNotes(notes3);
            Task task4 = file1.addTask();
            task4.setName("Test Task 4");
            task4.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
            task4.setStart(new Date());
            task4.setNotes(notes4);
            Task task5 = file1.addTask();
            task5.setName("Test Task 5");
            task5.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
            task5.setStart(new Date());
            task5.setNotes(notes5);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(file1, out);
            ProjectFile file2 = new MPXReader().read(out);
            Task task1a = file2.getTaskByUniqueID(task1.getUniqueID());
            String notes = task1a.getNotes();
            BasicTest.assertEquals((String)notes1, (String)notes);
            Task task2a = file2.getTaskByUniqueID(task2.getUniqueID());
            notes = task2a.getNotes();
            BasicTest.assertEquals((String)notes2, (String)notes);
            Task task3a = file2.getTaskByUniqueID(task3.getUniqueID());
            notes = task3a.getNotes();
            BasicTest.assertEquals((String)notes3, (String)notes);
            Task task4a = file2.getTaskByUniqueID(task4.getUniqueID());
            notes = task4a.getNotes();
            BasicTest.assertEquals((String)notes4, (String)notes);
            Task task5a = file2.getTaskByUniqueID(task5.getUniqueID());
            notes = task5a.getNotes();
            BasicTest.assertEquals((String)notes5, (String)notes);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceNotes() throws Exception {
        File out = null;
        try {
            String notes1 = "Notes, containing a comma. Done.";
            String notes2 = "Notes \"containing embedded quotes\" Done.";
            String notes3 = "Notes, \"containing embedded quotes, and comma's too.\" Done.";
            String notes4 = "\"Notes containing embedded quotes as first and last chars. Done.\"";
            String notes5 = "Normal unquoted notes. Done.";
            ProjectFile file1 = new ProjectFile();
            file1.setAutoWBS(true);
            file1.setAutoOutlineLevel(true);
            file1.setAutoResourceID(true);
            file1.setAutoResourceUniqueID(true);
            Resource resource1 = file1.addResource();
            resource1.setName("Test Resource 1");
            resource1.setNotes(notes1);
            Resource resource2 = file1.addResource();
            resource2.setName("Test Resource 2");
            resource2.setNotes(notes2);
            Resource resource3 = file1.addResource();
            resource3.setName("Test Resource 3");
            resource3.setNotes(notes3);
            Resource resource4 = file1.addResource();
            resource4.setName("Test Resource 4");
            resource4.setNotes(notes4);
            Resource resource5 = file1.addResource();
            resource5.setName("Test Resource 5");
            resource5.setNotes(notes5);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(file1, out);
            ProjectFile file2 = new MPXReader().read(out);
            Resource resource1a = file2.getResourceByUniqueID(resource1.getUniqueID());
            String notes = resource1a.getNotes();
            BasicTest.assertEquals((String)notes1, (String)notes);
            Resource resource2a = file2.getResourceByUniqueID(resource2.getUniqueID());
            notes = resource2a.getNotes();
            BasicTest.assertEquals((String)notes2, (String)notes);
            Resource resource3a = file2.getResourceByUniqueID(resource3.getUniqueID());
            notes = resource3a.getNotes();
            BasicTest.assertEquals((String)notes3, (String)notes);
            Resource resource4a = file2.getResourceByUniqueID(resource4.getUniqueID());
            notes = resource4a.getNotes();
            BasicTest.assertEquals((String)notes4, (String)notes);
            Resource resource5a = file2.getResourceByUniqueID(resource5.getUniqueID());
            notes = resource5a.getNotes();
            BasicTest.assertEquals((String)notes5, (String)notes);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug1() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug1.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug2() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug2.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug3() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug3.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            List tasks = mpp.getAllTasks();
            for (Task task : tasks) {
                BasicTest.assertEquals((String)"Outline levels do not match", (int)task.getOutlineLevel(), (int)this.calculateOutlineLevel(task));
            }
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug4() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug4.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    private int calculateOutlineLevel(Task task) {
        int level = 0;
        while (task != null) {
            task = task.getParentTask();
            ++level;
        }
        return level;
    }

    public void testBaseCalendarGetDate() throws Exception {
        ProjectFile file = new ProjectFile();
        ProjectCalendar cal = file.addDefaultBaseCalendar();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Date startDate = df.parse("09/10/2003");
        Duration duration = Duration.getInstance(1, TimeUnit.DAYS);
        Date endDate = cal.getDate(startDate, duration);
        BasicTest.assertEquals((long)df.parse("10/10/2003").getTime(), (long)endDate.getTime());
        duration = Duration.getInstance(7, TimeUnit.DAYS);
        endDate = cal.getDate(startDate, duration);
        BasicTest.assertEquals((long)df.parse("18/10/2003").getTime(), (long)endDate.getTime());
        duration = Duration.getInstance(1, TimeUnit.WEEKS);
        endDate = cal.getDate(startDate, duration);
        BasicTest.assertEquals((long)df.parse("16/10/2003").getTime(), (long)endDate.getTime());
        duration = Duration.getInstance(-1, TimeUnit.DAYS);
        endDate = cal.getDate(startDate, duration);
        BasicTest.assertEquals((long)df.parse("08/10/2003").getTime(), (long)endDate.getTime());
    }

    public void testMPP8Flags1() throws Exception {
        File in = new File(this.m_basedir + "/mpp8flags1.mpp");
        ProjectFile mpp = new MPPReader().read(in);
        List tasks = mpp.getAllTasks();
        BasicTest.assertTrue((String)"Not enough tasks", (tasks.size() > 0 ? 1 : 0) != 0);
        BasicTest.assertTrue((String)"Not an even number of tasks", (tasks.size() % 2 == 0 ? 1 : 0) != 0);
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag1());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag2());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag3());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag4());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag5());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag6());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag7());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag8());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag9());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag10());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag11());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag12());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag13());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag14());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag15());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag16());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag17());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag18());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag19());
            task = (Task)iter.next();
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag1());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag2());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag3());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag4());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag5());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag6());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag7());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag8());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag9());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag10());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag11());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag12());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag13());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag14());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag15());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag16());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag17());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag18());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag19());
        }
    }

    public void testMPP8Flags2() throws Exception {
        File in = new File(this.m_basedir + "/mpp8flags2.mpp");
        ProjectFile mpp = new MPPReader().read(in);
        List tasks = mpp.getAllTasks();
        Iterator iter = tasks.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getName().startsWith("Parent")) continue;
            boolean[] flags = this.getFlagArray(task);
            BasicTest.assertTrue((String)("Incorrect flag set in task " + task.getName()), (boolean)this.testSingleFlagTrue(flags, index));
            if (++index != 20) continue;
            index = 0;
        }
    }

    public void testMPP9Flags1() throws Exception {
        File in = new File(this.m_basedir + "/mpp9flags1.mpp");
        ProjectFile mpp = new MPPReader().read(in);
        List tasks = mpp.getAllTasks();
        BasicTest.assertTrue((String)"Not enough tasks", (tasks.size() > 0 ? 1 : 0) != 0);
        BasicTest.assertTrue((String)"Not an even number of tasks", (tasks.size() % 2 == 0 ? 1 : 0) != 0);
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag1());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag2());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag3());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag4());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag5());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag6());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag7());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag8());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag9());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag10());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag11());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag12());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag13());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag14());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag15());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag16());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag17());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag18());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag19());
            BasicTest.assertFalse((String)task.getName(), (boolean)task.getFlag20());
            task = (Task)iter.next();
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag1());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag2());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag3());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag4());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag5());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag6());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag7());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag8());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag9());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag10());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag11());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag12());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag13());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag14());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag15());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag16());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag17());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag18());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag19());
            BasicTest.assertTrue((String)task.getName(), (boolean)task.getFlag20());
        }
    }

    public void testMPP9Flags2() throws Exception {
        File in = new File(this.m_basedir + "/mpp8flags2.mpp");
        ProjectFile mpp = new MPPReader().read(in);
        List tasks = mpp.getAllTasks();
        Iterator iter = tasks.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getName().startsWith("Parent")) continue;
            boolean[] flags = this.getFlagArray(task);
            BasicTest.assertTrue((String)("Incorrect flag set in task " + task.getName()), (boolean)this.testSingleFlagTrue(flags, index));
            if (++index != 20) continue;
            index = 0;
        }
    }

    private boolean[] getFlagArray(Task task) {
        boolean[] flags = new boolean[]{task.getFlag1(), task.getFlag2(), task.getFlag3(), task.getFlag4(), task.getFlag5(), task.getFlag6(), task.getFlag7(), task.getFlag8(), task.getFlag9(), task.getFlag10(), task.getFlag11(), task.getFlag12(), task.getFlag13(), task.getFlag14(), task.getFlag15(), task.getFlag16(), task.getFlag17(), task.getFlag18(), task.getFlag19(), task.getFlag20()};
        return flags;
    }

    private boolean testSingleFlagTrue(boolean[] flags, int index) {
        boolean result = true;
        for (int loop = 0; loop < flags.length; ++loop) {
            if (!flags[loop] || loop == index) continue;
            result = false;
            break;
        }
        return result;
    }

    public void testViews() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/sample98.mpp");
        List views = mpp.getViews();
        BasicTest.assertEquals((String)"Incorrect number of views", (int)1, (int)views.size());
        mpp = new MPPReader().read(this.m_basedir + "/sample.mpp");
        views = mpp.getViews();
        BasicTest.assertEquals((String)"Incorrect number of views", (int)3, (int)views.size());
    }

    public void testTables() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/sample98.mpp");
        List tables = mpp.getTables();
        BasicTest.assertEquals((String)"Incorrect number of tables", (int)1, (int)tables.size());
        mpp = new MPPReader().read(this.m_basedir + "/sample.mpp");
        tables = mpp.getTables();
        BasicTest.assertEquals((String)"Incorrect number of tables", (int)2, (int)tables.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskCalendars() throws Exception {
        File out = null;
        try {
            ProjectCalendar cal;
            File in = new File(this.m_basedir + "/sample1.mpp");
            ProjectFile mpp = new MPPReader().read(in);
            for (Task task : mpp.getAllTasks()) {
                cal = task.getCalendar();
                if (cal == null) continue;
                BasicTest.assertEquals((String)task.getName(), (String)cal.getName());
            }
            out = File.createTempFile("junit", ".xml");
            new MSPDIWriter().write(mpp, out);
            ProjectFile mspdi = new MSPDIReader().read(out.getCanonicalPath());
            for (Task task : mspdi.getAllTasks()) {
                cal = task.getCalendar();
                if (cal == null) continue;
                BasicTest.assertEquals((String)task.getName(), (String)cal.getName());
            }
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMSPDIAliases() throws Exception {
        File out = null;
        boolean success = true;
        try {
            MSPDIReader reader = new MSPDIReader();
            MSPDIWriter writer = new MSPDIWriter();
            File in = new File(this.m_basedir + "/alias.xml");
            ProjectFile xml = reader.read(in);
            this.validateAliases(xml);
            out = File.createTempFile("junit", ".xml");
            writer.write(xml, out);
            xml = reader.read(out);
            this.validateAliases(xml);
            success = true;
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    public void testMPP9Aliases() throws Exception {
        File in = new File(this.m_basedir + "/alias.mpp");
        ProjectFile mpp = new MPPReader().read(in);
        this.validateAliases(mpp);
    }

    private void validateAliases(ProjectFile mpx) {
        BasicTest.assertEquals((String)"Text1t", (String)mpx.getTaskFieldAlias(TaskField.TEXT1));
        BasicTest.assertEquals((String)"Text2t", (String)mpx.getTaskFieldAlias(TaskField.TEXT2));
        BasicTest.assertEquals((String)"Text3t", (String)mpx.getTaskFieldAlias(TaskField.TEXT3));
        BasicTest.assertEquals((String)"Text4t", (String)mpx.getTaskFieldAlias(TaskField.TEXT4));
        BasicTest.assertEquals((String)"Text5t", (String)mpx.getTaskFieldAlias(TaskField.TEXT5));
        BasicTest.assertEquals((String)"Text6t", (String)mpx.getTaskFieldAlias(TaskField.TEXT6));
        BasicTest.assertEquals((String)"Text7t", (String)mpx.getTaskFieldAlias(TaskField.TEXT7));
        BasicTest.assertEquals((String)"Text8t", (String)mpx.getTaskFieldAlias(TaskField.TEXT8));
        BasicTest.assertEquals((String)"Text9t", (String)mpx.getTaskFieldAlias(TaskField.TEXT9));
        BasicTest.assertEquals((String)"Text10t", (String)mpx.getTaskFieldAlias(TaskField.TEXT10));
        BasicTest.assertEquals((String)"Text11t", (String)mpx.getTaskFieldAlias(TaskField.TEXT11));
        BasicTest.assertEquals((String)"Text12t", (String)mpx.getTaskFieldAlias(TaskField.TEXT12));
        BasicTest.assertEquals((String)"Text13t", (String)mpx.getTaskFieldAlias(TaskField.TEXT13));
        BasicTest.assertEquals((String)"Text14t", (String)mpx.getTaskFieldAlias(TaskField.TEXT14));
        BasicTest.assertEquals((String)"Text15t", (String)mpx.getTaskFieldAlias(TaskField.TEXT15));
        BasicTest.assertEquals((String)"Text16t", (String)mpx.getTaskFieldAlias(TaskField.TEXT16));
        BasicTest.assertEquals((String)"Text17t", (String)mpx.getTaskFieldAlias(TaskField.TEXT17));
        BasicTest.assertEquals((String)"Text18t", (String)mpx.getTaskFieldAlias(TaskField.TEXT18));
        BasicTest.assertEquals((String)"Text19t", (String)mpx.getTaskFieldAlias(TaskField.TEXT19));
        BasicTest.assertEquals((String)"Text20t", (String)mpx.getTaskFieldAlias(TaskField.TEXT20));
        BasicTest.assertEquals((String)"Text21t", (String)mpx.getTaskFieldAlias(TaskField.TEXT21));
        BasicTest.assertEquals((String)"Text22t", (String)mpx.getTaskFieldAlias(TaskField.TEXT22));
        BasicTest.assertEquals((String)"Text23t", (String)mpx.getTaskFieldAlias(TaskField.TEXT23));
        BasicTest.assertEquals((String)"Text24t", (String)mpx.getTaskFieldAlias(TaskField.TEXT24));
        BasicTest.assertEquals((String)"Text25t", (String)mpx.getTaskFieldAlias(TaskField.TEXT25));
        BasicTest.assertEquals((String)"Text26t", (String)mpx.getTaskFieldAlias(TaskField.TEXT26));
        BasicTest.assertEquals((String)"Text27t", (String)mpx.getTaskFieldAlias(TaskField.TEXT27));
        BasicTest.assertEquals((String)"Text28t", (String)mpx.getTaskFieldAlias(TaskField.TEXT28));
        BasicTest.assertEquals((String)"Text29t", (String)mpx.getTaskFieldAlias(TaskField.TEXT29));
        BasicTest.assertEquals((String)"Text30t", (String)mpx.getTaskFieldAlias(TaskField.TEXT30));
        BasicTest.assertEquals((String)"Start1t", (String)mpx.getTaskFieldAlias(TaskField.START1));
        BasicTest.assertEquals((String)"Start2t", (String)mpx.getTaskFieldAlias(TaskField.START2));
        BasicTest.assertEquals((String)"Start3t", (String)mpx.getTaskFieldAlias(TaskField.START3));
        BasicTest.assertEquals((String)"Start4t", (String)mpx.getTaskFieldAlias(TaskField.START4));
        BasicTest.assertEquals((String)"Start5t", (String)mpx.getTaskFieldAlias(TaskField.START5));
        BasicTest.assertEquals((String)"Start6t", (String)mpx.getTaskFieldAlias(TaskField.START6));
        BasicTest.assertEquals((String)"Start7t", (String)mpx.getTaskFieldAlias(TaskField.START7));
        BasicTest.assertEquals((String)"Start8t", (String)mpx.getTaskFieldAlias(TaskField.START8));
        BasicTest.assertEquals((String)"Start9t", (String)mpx.getTaskFieldAlias(TaskField.START9));
        BasicTest.assertEquals((String)"Start10t", (String)mpx.getTaskFieldAlias(TaskField.START10));
        BasicTest.assertEquals((String)"Finish1t", (String)mpx.getTaskFieldAlias(TaskField.FINISH1));
        BasicTest.assertEquals((String)"Finish2t", (String)mpx.getTaskFieldAlias(TaskField.FINISH2));
        BasicTest.assertEquals((String)"Finish3t", (String)mpx.getTaskFieldAlias(TaskField.FINISH3));
        BasicTest.assertEquals((String)"Finish4t", (String)mpx.getTaskFieldAlias(TaskField.FINISH4));
        BasicTest.assertEquals((String)"Finish5t", (String)mpx.getTaskFieldAlias(TaskField.FINISH5));
        BasicTest.assertEquals((String)"Finish6t", (String)mpx.getTaskFieldAlias(TaskField.FINISH6));
        BasicTest.assertEquals((String)"Finish7t", (String)mpx.getTaskFieldAlias(TaskField.FINISH7));
        BasicTest.assertEquals((String)"Finish8t", (String)mpx.getTaskFieldAlias(TaskField.FINISH8));
        BasicTest.assertEquals((String)"Finish9t", (String)mpx.getTaskFieldAlias(TaskField.FINISH9));
        BasicTest.assertEquals((String)"Finish10t", (String)mpx.getTaskFieldAlias(TaskField.FINISH10));
        BasicTest.assertEquals((String)"Cost1t", (String)mpx.getTaskFieldAlias(TaskField.COST1));
        BasicTest.assertEquals((String)"Cost2t", (String)mpx.getTaskFieldAlias(TaskField.COST2));
        BasicTest.assertEquals((String)"Cost3t", (String)mpx.getTaskFieldAlias(TaskField.COST3));
        BasicTest.assertEquals((String)"Cost4t", (String)mpx.getTaskFieldAlias(TaskField.COST4));
        BasicTest.assertEquals((String)"Cost5t", (String)mpx.getTaskFieldAlias(TaskField.COST5));
        BasicTest.assertEquals((String)"Cost6t", (String)mpx.getTaskFieldAlias(TaskField.COST6));
        BasicTest.assertEquals((String)"Cost7t", (String)mpx.getTaskFieldAlias(TaskField.COST7));
        BasicTest.assertEquals((String)"Cost8t", (String)mpx.getTaskFieldAlias(TaskField.COST8));
        BasicTest.assertEquals((String)"Cost9t", (String)mpx.getTaskFieldAlias(TaskField.COST9));
        BasicTest.assertEquals((String)"Cost10t", (String)mpx.getTaskFieldAlias(TaskField.COST10));
        BasicTest.assertEquals((String)"Date1t", (String)mpx.getTaskFieldAlias(TaskField.DATE1));
        BasicTest.assertEquals((String)"Date2t", (String)mpx.getTaskFieldAlias(TaskField.DATE2));
        BasicTest.assertEquals((String)"Date3t", (String)mpx.getTaskFieldAlias(TaskField.DATE3));
        BasicTest.assertEquals((String)"Date4t", (String)mpx.getTaskFieldAlias(TaskField.DATE4));
        BasicTest.assertEquals((String)"Date5t", (String)mpx.getTaskFieldAlias(TaskField.DATE5));
        BasicTest.assertEquals((String)"Date6t", (String)mpx.getTaskFieldAlias(TaskField.DATE6));
        BasicTest.assertEquals((String)"Date7t", (String)mpx.getTaskFieldAlias(TaskField.DATE7));
        BasicTest.assertEquals((String)"Date8t", (String)mpx.getTaskFieldAlias(TaskField.DATE8));
        BasicTest.assertEquals((String)"Date9t", (String)mpx.getTaskFieldAlias(TaskField.DATE9));
        BasicTest.assertEquals((String)"Date10t", (String)mpx.getTaskFieldAlias(TaskField.DATE10));
        BasicTest.assertEquals((String)"Flag1t", (String)mpx.getTaskFieldAlias(TaskField.FLAG1));
        BasicTest.assertEquals((String)"Flag2t", (String)mpx.getTaskFieldAlias(TaskField.FLAG2));
        BasicTest.assertEquals((String)"Flag3t", (String)mpx.getTaskFieldAlias(TaskField.FLAG3));
        BasicTest.assertEquals((String)"Flag4t", (String)mpx.getTaskFieldAlias(TaskField.FLAG4));
        BasicTest.assertEquals((String)"Flag5t", (String)mpx.getTaskFieldAlias(TaskField.FLAG5));
        BasicTest.assertEquals((String)"Flag6t", (String)mpx.getTaskFieldAlias(TaskField.FLAG6));
        BasicTest.assertEquals((String)"Flag7t", (String)mpx.getTaskFieldAlias(TaskField.FLAG7));
        BasicTest.assertEquals((String)"Flag8t", (String)mpx.getTaskFieldAlias(TaskField.FLAG8));
        BasicTest.assertEquals((String)"Flag9t", (String)mpx.getTaskFieldAlias(TaskField.FLAG9));
        BasicTest.assertEquals((String)"Flag10t", (String)mpx.getTaskFieldAlias(TaskField.FLAG10));
        BasicTest.assertEquals((String)"Flag11t", (String)mpx.getTaskFieldAlias(TaskField.FLAG11));
        BasicTest.assertEquals((String)"Flag12t", (String)mpx.getTaskFieldAlias(TaskField.FLAG12));
        BasicTest.assertEquals((String)"Flag13t", (String)mpx.getTaskFieldAlias(TaskField.FLAG13));
        BasicTest.assertEquals((String)"Flag14t", (String)mpx.getTaskFieldAlias(TaskField.FLAG14));
        BasicTest.assertEquals((String)"Flag15t", (String)mpx.getTaskFieldAlias(TaskField.FLAG15));
        BasicTest.assertEquals((String)"Flag16t", (String)mpx.getTaskFieldAlias(TaskField.FLAG16));
        BasicTest.assertEquals((String)"Flag17t", (String)mpx.getTaskFieldAlias(TaskField.FLAG17));
        BasicTest.assertEquals((String)"Flag18t", (String)mpx.getTaskFieldAlias(TaskField.FLAG18));
        BasicTest.assertEquals((String)"Flag19t", (String)mpx.getTaskFieldAlias(TaskField.FLAG19));
        BasicTest.assertEquals((String)"Flag20t", (String)mpx.getTaskFieldAlias(TaskField.FLAG20));
        BasicTest.assertEquals((String)"Number1t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER1));
        BasicTest.assertEquals((String)"Number2t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER2));
        BasicTest.assertEquals((String)"Number3t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER3));
        BasicTest.assertEquals((String)"Number4t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER4));
        BasicTest.assertEquals((String)"Number5t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER5));
        BasicTest.assertEquals((String)"Number6t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER6));
        BasicTest.assertEquals((String)"Number7t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER7));
        BasicTest.assertEquals((String)"Number8t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER8));
        BasicTest.assertEquals((String)"Number9t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER9));
        BasicTest.assertEquals((String)"Number10t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER10));
        BasicTest.assertEquals((String)"Number11t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER11));
        BasicTest.assertEquals((String)"Number12t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER12));
        BasicTest.assertEquals((String)"Number13t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER13));
        BasicTest.assertEquals((String)"Number14t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER14));
        BasicTest.assertEquals((String)"Number15t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER15));
        BasicTest.assertEquals((String)"Number16t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER16));
        BasicTest.assertEquals((String)"Number17t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER17));
        BasicTest.assertEquals((String)"Number18t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER18));
        BasicTest.assertEquals((String)"Number19t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER19));
        BasicTest.assertEquals((String)"Number20t", (String)mpx.getTaskFieldAlias(TaskField.NUMBER20));
        BasicTest.assertEquals((String)"Duration1t", (String)mpx.getTaskFieldAlias(TaskField.DURATION1));
        BasicTest.assertEquals((String)"Duration2t", (String)mpx.getTaskFieldAlias(TaskField.DURATION2));
        BasicTest.assertEquals((String)"Duration3t", (String)mpx.getTaskFieldAlias(TaskField.DURATION3));
        BasicTest.assertEquals((String)"Duration4t", (String)mpx.getTaskFieldAlias(TaskField.DURATION4));
        BasicTest.assertEquals((String)"Duration5t", (String)mpx.getTaskFieldAlias(TaskField.DURATION5));
        BasicTest.assertEquals((String)"Duration6t", (String)mpx.getTaskFieldAlias(TaskField.DURATION6));
        BasicTest.assertEquals((String)"Duration7t", (String)mpx.getTaskFieldAlias(TaskField.DURATION7));
        BasicTest.assertEquals((String)"Duration8t", (String)mpx.getTaskFieldAlias(TaskField.DURATION8));
        BasicTest.assertEquals((String)"Duration9t", (String)mpx.getTaskFieldAlias(TaskField.DURATION9));
        BasicTest.assertEquals((String)"Duration10t", (String)mpx.getTaskFieldAlias(TaskField.DURATION10));
        BasicTest.assertEquals((String)"Outline Code1t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE1));
        BasicTest.assertEquals((String)"Outline Code2t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE2));
        BasicTest.assertEquals((String)"Outline Code3t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE3));
        BasicTest.assertEquals((String)"Outline Code4t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE4));
        BasicTest.assertEquals((String)"Outline Code5t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE5));
        BasicTest.assertEquals((String)"Outline Code6t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE6));
        BasicTest.assertEquals((String)"Outline Code7t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE7));
        BasicTest.assertEquals((String)"Outline Code8t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE8));
        BasicTest.assertEquals((String)"Outline Code9t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE9));
        BasicTest.assertEquals((String)"Outline Code10t", (String)mpx.getTaskFieldAlias(TaskField.OUTLINE_CODE10));
        BasicTest.assertEquals((String)"Text1r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT1));
        BasicTest.assertEquals((String)"Text2r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT2));
        BasicTest.assertEquals((String)"Text3r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT3));
        BasicTest.assertEquals((String)"Text4r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT4));
        BasicTest.assertEquals((String)"Text5r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT5));
        BasicTest.assertEquals((String)"Text6r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT6));
        BasicTest.assertEquals((String)"Text7r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT7));
        BasicTest.assertEquals((String)"Text8r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT8));
        BasicTest.assertEquals((String)"Text9r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT9));
        BasicTest.assertEquals((String)"Text10r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT10));
        BasicTest.assertEquals((String)"Text11r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT11));
        BasicTest.assertEquals((String)"Text12r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT12));
        BasicTest.assertEquals((String)"Text13r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT13));
        BasicTest.assertEquals((String)"Text14r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT14));
        BasicTest.assertEquals((String)"Text15r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT15));
        BasicTest.assertEquals((String)"Text16r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT16));
        BasicTest.assertEquals((String)"Text17r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT17));
        BasicTest.assertEquals((String)"Text18r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT18));
        BasicTest.assertEquals((String)"Text19r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT19));
        BasicTest.assertEquals((String)"Text20r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT20));
        BasicTest.assertEquals((String)"Text21r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT21));
        BasicTest.assertEquals((String)"Text22r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT22));
        BasicTest.assertEquals((String)"Text23r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT23));
        BasicTest.assertEquals((String)"Text24r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT24));
        BasicTest.assertEquals((String)"Text25r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT25));
        BasicTest.assertEquals((String)"Text26r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT26));
        BasicTest.assertEquals((String)"Text27r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT27));
        BasicTest.assertEquals((String)"Text28r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT28));
        BasicTest.assertEquals((String)"Text29r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT29));
        BasicTest.assertEquals((String)"Text30r", (String)mpx.getResourceFieldAlias(ResourceField.TEXT30));
        BasicTest.assertEquals((String)"Start1r", (String)mpx.getResourceFieldAlias(ResourceField.START1));
        BasicTest.assertEquals((String)"Start2r", (String)mpx.getResourceFieldAlias(ResourceField.START2));
        BasicTest.assertEquals((String)"Start3r", (String)mpx.getResourceFieldAlias(ResourceField.START3));
        BasicTest.assertEquals((String)"Start4r", (String)mpx.getResourceFieldAlias(ResourceField.START4));
        BasicTest.assertEquals((String)"Start5r", (String)mpx.getResourceFieldAlias(ResourceField.START5));
        BasicTest.assertEquals((String)"Start6r", (String)mpx.getResourceFieldAlias(ResourceField.START6));
        BasicTest.assertEquals((String)"Start7r", (String)mpx.getResourceFieldAlias(ResourceField.START7));
        BasicTest.assertEquals((String)"Start8r", (String)mpx.getResourceFieldAlias(ResourceField.START8));
        BasicTest.assertEquals((String)"Start9r", (String)mpx.getResourceFieldAlias(ResourceField.START9));
        BasicTest.assertEquals((String)"Start10r", (String)mpx.getResourceFieldAlias(ResourceField.START10));
        BasicTest.assertEquals((String)"Finish1r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH1));
        BasicTest.assertEquals((String)"Finish2r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH2));
        BasicTest.assertEquals((String)"Finish3r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH3));
        BasicTest.assertEquals((String)"Finish4r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH4));
        BasicTest.assertEquals((String)"Finish5r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH5));
        BasicTest.assertEquals((String)"Finish6r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH6));
        BasicTest.assertEquals((String)"Finish7r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH7));
        BasicTest.assertEquals((String)"Finish8r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH8));
        BasicTest.assertEquals((String)"Finish9r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH9));
        BasicTest.assertEquals((String)"Finish10r", (String)mpx.getResourceFieldAlias(ResourceField.FINISH10));
        BasicTest.assertEquals((String)"Cost1r", (String)mpx.getResourceFieldAlias(ResourceField.COST1));
        BasicTest.assertEquals((String)"Cost2r", (String)mpx.getResourceFieldAlias(ResourceField.COST2));
        BasicTest.assertEquals((String)"Cost3r", (String)mpx.getResourceFieldAlias(ResourceField.COST3));
        BasicTest.assertEquals((String)"Cost4r", (String)mpx.getResourceFieldAlias(ResourceField.COST4));
        BasicTest.assertEquals((String)"Cost5r", (String)mpx.getResourceFieldAlias(ResourceField.COST5));
        BasicTest.assertEquals((String)"Cost6r", (String)mpx.getResourceFieldAlias(ResourceField.COST6));
        BasicTest.assertEquals((String)"Cost7r", (String)mpx.getResourceFieldAlias(ResourceField.COST7));
        BasicTest.assertEquals((String)"Cost8r", (String)mpx.getResourceFieldAlias(ResourceField.COST8));
        BasicTest.assertEquals((String)"Cost9r", (String)mpx.getResourceFieldAlias(ResourceField.COST9));
        BasicTest.assertEquals((String)"Cost10r", (String)mpx.getResourceFieldAlias(ResourceField.COST10));
        BasicTest.assertEquals((String)"Date1r", (String)mpx.getResourceFieldAlias(ResourceField.DATE1));
        BasicTest.assertEquals((String)"Date2r", (String)mpx.getResourceFieldAlias(ResourceField.DATE2));
        BasicTest.assertEquals((String)"Date3r", (String)mpx.getResourceFieldAlias(ResourceField.DATE3));
        BasicTest.assertEquals((String)"Date4r", (String)mpx.getResourceFieldAlias(ResourceField.DATE4));
        BasicTest.assertEquals((String)"Date5r", (String)mpx.getResourceFieldAlias(ResourceField.DATE5));
        BasicTest.assertEquals((String)"Date6r", (String)mpx.getResourceFieldAlias(ResourceField.DATE6));
        BasicTest.assertEquals((String)"Date7r", (String)mpx.getResourceFieldAlias(ResourceField.DATE7));
        BasicTest.assertEquals((String)"Date8r", (String)mpx.getResourceFieldAlias(ResourceField.DATE8));
        BasicTest.assertEquals((String)"Date9r", (String)mpx.getResourceFieldAlias(ResourceField.DATE9));
        BasicTest.assertEquals((String)"Date10r", (String)mpx.getResourceFieldAlias(ResourceField.DATE10));
        BasicTest.assertEquals((String)"Flag1r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG1));
        BasicTest.assertEquals((String)"Flag2r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG2));
        BasicTest.assertEquals((String)"Flag3r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG3));
        BasicTest.assertEquals((String)"Flag4r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG4));
        BasicTest.assertEquals((String)"Flag5r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG5));
        BasicTest.assertEquals((String)"Flag6r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG6));
        BasicTest.assertEquals((String)"Flag7r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG7));
        BasicTest.assertEquals((String)"Flag8r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG8));
        BasicTest.assertEquals((String)"Flag9r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG9));
        BasicTest.assertEquals((String)"Flag10r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG10));
        BasicTest.assertEquals((String)"Flag11r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG11));
        BasicTest.assertEquals((String)"Flag12r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG12));
        BasicTest.assertEquals((String)"Flag13r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG13));
        BasicTest.assertEquals((String)"Flag14r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG14));
        BasicTest.assertEquals((String)"Flag15r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG15));
        BasicTest.assertEquals((String)"Flag16r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG16));
        BasicTest.assertEquals((String)"Flag17r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG17));
        BasicTest.assertEquals((String)"Flag18r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG18));
        BasicTest.assertEquals((String)"Flag19r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG19));
        BasicTest.assertEquals((String)"Flag20r", (String)mpx.getResourceFieldAlias(ResourceField.FLAG20));
        BasicTest.assertEquals((String)"Number1r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER1));
        BasicTest.assertEquals((String)"Number2r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER2));
        BasicTest.assertEquals((String)"Number3r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER3));
        BasicTest.assertEquals((String)"Number4r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER4));
        BasicTest.assertEquals((String)"Number5r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER5));
        BasicTest.assertEquals((String)"Number6r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER6));
        BasicTest.assertEquals((String)"Number7r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER7));
        BasicTest.assertEquals((String)"Number8r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER8));
        BasicTest.assertEquals((String)"Number9r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER9));
        BasicTest.assertEquals((String)"Number10r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER10));
        BasicTest.assertEquals((String)"Number11r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER11));
        BasicTest.assertEquals((String)"Number12r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER12));
        BasicTest.assertEquals((String)"Number13r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER13));
        BasicTest.assertEquals((String)"Number14r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER14));
        BasicTest.assertEquals((String)"Number15r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER15));
        BasicTest.assertEquals((String)"Number16r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER16));
        BasicTest.assertEquals((String)"Number17r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER17));
        BasicTest.assertEquals((String)"Number18r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER18));
        BasicTest.assertEquals((String)"Number19r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER19));
        BasicTest.assertEquals((String)"Number20r", (String)mpx.getResourceFieldAlias(ResourceField.NUMBER20));
        BasicTest.assertEquals((String)"Duration1r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION1));
        BasicTest.assertEquals((String)"Duration2r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION2));
        BasicTest.assertEquals((String)"Duration3r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION3));
        BasicTest.assertEquals((String)"Duration4r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION4));
        BasicTest.assertEquals((String)"Duration5r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION5));
        BasicTest.assertEquals((String)"Duration6r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION6));
        BasicTest.assertEquals((String)"Duration7r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION7));
        BasicTest.assertEquals((String)"Duration8r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION8));
        BasicTest.assertEquals((String)"Duration9r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION9));
        BasicTest.assertEquals((String)"Duration10r", (String)mpx.getResourceFieldAlias(ResourceField.DURATION10));
        BasicTest.assertEquals((String)"Outline Code1r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE1));
        BasicTest.assertEquals((String)"Outline Code2r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE2));
        BasicTest.assertEquals((String)"Outline Code3r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE3));
        BasicTest.assertEquals((String)"Outline Code4r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE4));
        BasicTest.assertEquals((String)"Outline Code5r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE5));
        BasicTest.assertEquals((String)"Outline Code6r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE6));
        BasicTest.assertEquals((String)"Outline Code7r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE7));
        BasicTest.assertEquals((String)"Outline Code8r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE8));
        BasicTest.assertEquals((String)"Outline Code9r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE9));
        BasicTest.assertEquals((String)"Outline Code10r", (String)mpx.getResourceFieldAlias(ResourceField.OUTLINE_CODE10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedLineBreaks() throws Exception {
        File out = null;
        boolean success = false;
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            ProjectFile file = new ProjectFile();
            file.setAutoTaskID(true);
            file.setAutoTaskUniqueID(true);
            file.setAutoResourceID(true);
            file.setAutoResourceUniqueID(true);
            file.setAutoOutlineLevel(true);
            file.setAutoOutlineNumber(true);
            file.setAutoWBS(true);
            file.setAutoCalendarUniqueID(true);
            file.addDefaultBaseCalendar();
            ProjectHeader header = file.getProjectHeader();
            header.setComments("Project Header Comments: Some\rExample\nText\r\nWith\n\rBreaks");
            header.setStartDate(df.parse("01/01/2003"));
            Resource resource1 = file.addResource();
            resource1.setName("Resource1: Some\rExample\nText\r\nWith\n\rBreaks");
            resource1.setNotes("Resource1 Notes: Some\rExample\nText\r\nWith\n\rBreaks");
            Task task1 = file.addTask();
            task1.setName("Task1: Some\rExample\nText\r\nWith\n\rBreaks");
            task1.setNotes("Task1 Notes: Some\rExample\nText\r\nWith\n\rBreaks");
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(file, out);
            file = new MPXReader().read(out);
            BasicTest.assertEquals((int)1, (int)file.getAllTasks().size());
            BasicTest.assertEquals((int)1, (int)file.getAllResources().size());
            header = file.getProjectHeader();
            BasicTest.assertEquals((String)"Project Header Comments: Some\nExample\nText\nWith\nBreaks", (String)header.getComments());
            task1 = file.getTaskByUniqueID(new Integer(1));
            BasicTest.assertEquals((String)"Task1: Some\nExample\nText\nWith\nBreaks", (String)task1.getName());
            BasicTest.assertEquals((String)"Task1 Notes: Some\nExample\nText\nWith\nBreaks", (String)task1.getNotes());
            resource1 = file.getResourceByUniqueID(new Integer(1));
            BasicTest.assertEquals((String)"Resource1: Some\nExample\nText\nWith\nBreaks", (String)resource1.getName());
            BasicTest.assertEquals((String)"Resource1 Notes: Some\nExample\nText\nWith\nBreaks", (String)resource1.getNotes());
            success = true;
        }
        finally {
            if (success && out != null) {
                out.delete();
            }
        }
    }

    public void testPasswordProtection() throws Exception {
        File in;
        try {
            in = new File(this.m_basedir + "/readpassword9.mpp");
            new MPPReader().read(in);
            BasicTest.assertTrue((boolean)false);
        }
        catch (MPXJException ex) {
            BasicTest.assertEquals((String)MPXJException.PASSWORD_PROTECTED, (String)ex.getMessage());
        }
        in = new File(this.m_basedir + "/writepassword9.mpp");
        new MPPReader().read(in);
        try {
            in = new File(this.m_basedir + "/bothpassword9.mpp");
            new MPPReader().read(in);
            BasicTest.assertTrue((boolean)false);
        }
        catch (MPXJException ex) {
            BasicTest.assertEquals((String)MPXJException.PASSWORD_PROTECTED, (String)ex.getMessage());
        }
    }

    public void testMspdiExtendedAttributes() throws Exception {
        MSPDIReader reader = new MSPDIReader();
        MSPDIWriter writer = new MSPDIWriter();
        ProjectFile xml = reader.read(this.m_basedir + "/mspextattr.xml");
        this.commonMspdiExtendedAttributeTests(xml);
        File out = File.createTempFile("junit", ".xml");
        writer.write(xml, out);
        xml = reader.read(out);
        this.commonMspdiExtendedAttributeTests(xml);
        out.delete();
    }

    private void commonMspdiExtendedAttributeTests(ProjectFile xml) {
        List tasks = xml.getAllTasks();
        BasicTest.assertEquals((int)2, (int)tasks.size());
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Task task = (Task)tasks.get(1);
        BasicTest.assertEquals((String)"Task Text One", (String)task.getText1());
        BasicTest.assertEquals((String)"01/01/2004", (String)df.format(task.getStart1()));
        BasicTest.assertEquals((String)"31/12/2004", (String)df.format(task.getFinish1()));
        BasicTest.assertEquals((double)99.95, (double)task.getCost1().doubleValue(), (double)0.0);
        BasicTest.assertEquals((String)"18/07/2004", (String)df.format(task.getDate1()));
        BasicTest.assertTrue((boolean)task.getFlag1());
        BasicTest.assertEquals((double)55.56, (double)task.getNumber1().doubleValue(), (double)0.0);
        BasicTest.assertEquals((double)13.0, (double)task.getDuration1().getDuration(), (double)0.0);
        BasicTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getDuration1().getUnits());
        List resources = xml.getAllResources();
        BasicTest.assertEquals((int)2, (int)resources.size());
        Resource resource = (Resource)resources.get(1);
        BasicTest.assertEquals((String)"Resource Text One", (String)resource.getText1());
        BasicTest.assertEquals((String)"01/01/2003", (String)df.format(resource.getStart1()));
        BasicTest.assertEquals((String)"31/12/2003", (String)df.format(resource.getFinish1()));
        BasicTest.assertEquals((double)29.99, (double)resource.getCost1().doubleValue(), (double)0.0);
        BasicTest.assertEquals((String)"18/07/2003", (String)df.format(resource.getDate1()));
        BasicTest.assertTrue((boolean)resource.getFlag1());
        BasicTest.assertEquals((double)5.99, (double)resource.getNumber1().doubleValue(), (double)0.0);
        BasicTest.assertEquals((double)22.0, (double)resource.getDuration1().getDuration(), (double)0.0);
        BasicTest.assertEquals((Object)TimeUnit.DAYS, (Object)resource.getDuration1().getUnits());
    }

    public void testProjectHeader() throws Exception {
        block2: {
            File out = null;
            try {
                MPXReader reader = new MPXReader();
                MPXWriter writer = new MPXWriter();
                ProjectFile mpx = reader.read(this.m_basedir + "/headertest.mpx");
                this.testHeaderFields(mpx);
                out = File.createTempFile("junit", ".mpx");
                writer.write(mpx, out);
                mpx = reader.read(out);
                this.testHeaderFields(mpx);
                out.delete();
                out = null;
                mpx = new MPPReader().read(this.m_basedir + "/headertest8.mpp");
                this.testHeaderFields(mpx);
                mpx = new MPPReader().read(this.m_basedir + "/headertest9.mpp");
                this.testHeaderFields(mpx);
                mpx = new MSPDIReader().read(this.m_basedir + "/headertest.xml");
                this.testHeaderFields(mpx);
                out = File.createTempFile("junit", ".xml");
                new MSPDIWriter().write(mpx, out);
                mpx = new MSPDIReader().read(out);
                this.testHeaderFields(mpx);
                out.delete();
                out = null;
            }
            catch (Exception ex) {
                if (out == null) break block2;
                out.delete();
            }
        }
    }

    private void testHeaderFields(ProjectFile file) {
        ProjectHeader header = file.getProjectHeader();
        BasicTest.assertEquals((String)"Project Title Text", (String)header.getProjectTitle());
        BasicTest.assertEquals((String)"Author Text", (String)header.getAuthor());
        BasicTest.assertEquals((String)"Comments Text", (String)header.getComments());
        BasicTest.assertEquals((String)"Company Text", (String)header.getCompany());
        BasicTest.assertEquals((String)"Keywords Text", (String)header.getKeywords());
        BasicTest.assertEquals((String)"Manager Text", (String)header.getManager());
        BasicTest.assertEquals((String)"Subject Text", (String)header.getSubject());
    }

    public void testWBS() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/sample98.mpp");
        Task task = mpp.getTaskByUniqueID(new Integer(2));
        BasicTest.assertEquals((String)"Second Task", (String)task.getName());
        BasicTest.assertEquals((String)"1.1", (String)task.getWBS());
        mpp = new MPPReader().read(this.m_basedir + "/sample.mpp");
        task = mpp.getTaskByUniqueID(new Integer(2));
        BasicTest.assertEquals((String)"Second Task", (String)task.getName());
        BasicTest.assertEquals((String)"1.1", (String)task.getWBS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPriority() throws Exception {
        ProjectFile mpx = new MPXReader().read(this.m_basedir + "/mpxpriority.mpx");
        this.validatePriority(mpx);
        ProjectFile mpp8 = new MPPReader().read(this.m_basedir + "/mpp8priority.mpp");
        this.validatePriority(mpp8);
        ProjectFile mpp9 = new MPPReader().read(this.m_basedir + "/mpp9priority.mpp");
        this.validatePriority(mpp9);
        ProjectFile xml = new MSPDIReader().read(this.m_basedir + "/mspdipriority.xml");
        this.validatePriority(xml);
        File out = null;
        boolean success = false;
        try {
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpx, out);
            ProjectFile mpx2 = new MPXReader().read(out);
            this.validatePriority(mpx2);
            success = true;
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
        out = null;
        success = false;
        try {
            out = File.createTempFile("junit", ".xml");
            new MSPDIWriter().write(mpx, out);
            ProjectFile xml3 = new MSPDIReader().read(out);
            this.validatePriority(xml3);
            success = true;
        }
        finally {
            if (out != null && success) {
                out.delete();
            }
        }
    }

    private void validatePriority(ProjectFile file) {
        BasicTest.assertEquals((int)1000, (int)file.getTaskByUniqueID(new Integer(1)).getPriority().getValue());
        BasicTest.assertEquals((int)900, (int)file.getTaskByUniqueID(new Integer(2)).getPriority().getValue());
        BasicTest.assertEquals((int)800, (int)file.getTaskByUniqueID(new Integer(3)).getPriority().getValue());
        BasicTest.assertEquals((int)700, (int)file.getTaskByUniqueID(new Integer(4)).getPriority().getValue());
        BasicTest.assertEquals((int)600, (int)file.getTaskByUniqueID(new Integer(5)).getPriority().getValue());
        BasicTest.assertEquals((int)500, (int)file.getTaskByUniqueID(new Integer(6)).getPriority().getValue());
        BasicTest.assertEquals((int)400, (int)file.getTaskByUniqueID(new Integer(7)).getPriority().getValue());
        BasicTest.assertEquals((int)300, (int)file.getTaskByUniqueID(new Integer(8)).getPriority().getValue());
        BasicTest.assertEquals((int)200, (int)file.getTaskByUniqueID(new Integer(9)).getPriority().getValue());
        BasicTest.assertEquals((int)100, (int)file.getTaskByUniqueID(new Integer(10)).getPriority().getValue());
    }

    public void testCalendars() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/caltest98.mpp");
        this.validateResourceCalendars(mpp);
        ProjectFile mpx = new MPXReader().read(this.m_basedir + "/caltest98.mpx");
        this.validateResourceCalendars(mpx);
        ProjectFile mpp9 = new MPPReader().read(this.m_basedir + "/caltest.mpp");
        this.validateResourceCalendars(mpp9);
        this.validateTaskCalendars(mpp9);
        ProjectFile xml = new MSPDIReader().read(this.m_basedir + "/caltest.xml");
        this.validateResourceCalendars(xml);
        this.validateTaskCalendars(xml);
    }

    private void validateResourceCalendars(ProjectFile mpx) {
        Resource resource = mpx.getResourceByUniqueID(new Integer(1));
        ProjectCalendar calendar = resource.getResourceCalendar();
        BasicTest.assertEquals((String)"Resource One", (String)calendar.getName());
        BasicTest.assertFalse((boolean)calendar.isBaseCalendar());
        BasicTest.assertEquals((String)"Standard", (String)calendar.getBaseCalendar().getName());
        BasicTest.assertTrue((boolean)calendar.getCalendarExceptions().isEmpty());
        resource = mpx.getResourceByUniqueID(new Integer(2));
        calendar = resource.getResourceCalendar();
        BasicTest.assertEquals((String)"Resource Two", (String)calendar.getName());
        BasicTest.assertFalse((boolean)calendar.isBaseCalendar());
        BasicTest.assertEquals((String)"Base Calendar", (String)calendar.getBaseCalendar().getName());
        BasicTest.assertTrue((boolean)calendar.getCalendarExceptions().isEmpty());
        resource = mpx.getResourceByUniqueID(new Integer(3));
        calendar = resource.getResourceCalendar();
        BasicTest.assertEquals((String)"Resource Three", (String)calendar.getName());
        BasicTest.assertFalse((boolean)calendar.isBaseCalendar());
        BasicTest.assertEquals((String)"Base Calendar", (String)calendar.getBaseCalendar().getName());
        BasicTest.assertFalse((boolean)calendar.getCalendarExceptions().isEmpty());
    }

    private void validateTaskCalendars(ProjectFile mpx) {
        Task task = mpx.getTaskByUniqueID(new Integer(2));
        ProjectCalendar calendar = task.getCalendar();
        BasicTest.assertNull((Object)calendar);
        task = mpx.getTaskByUniqueID(new Integer(3));
        calendar = task.getCalendar();
        BasicTest.assertEquals((String)"Standard", (String)calendar.getName());
        BasicTest.assertTrue((boolean)calendar.isBaseCalendar());
        task = mpx.getTaskByUniqueID(new Integer(4));
        calendar = task.getCalendar();
        BasicTest.assertEquals((String)"Base Calendar", (String)calendar.getName());
        BasicTest.assertTrue((boolean)calendar.isBaseCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoval() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/remove.mpp");
        BasicTest.assertEquals((int)9, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)8, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)6, (int)mpp.getAllResourceAssignments().size());
        Task task = mpp.getTaskByUniqueID(new Integer(1));
        BasicTest.assertEquals((String)"Task One", (String)task.getName());
        task.remove();
        BasicTest.assertEquals((int)8, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)8, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)6, (int)mpp.getAllResourceAssignments().size());
        Resource resource = mpp.getResourceByUniqueID(new Integer(1));
        BasicTest.assertEquals((String)"Resource One", (String)resource.getName());
        resource.remove();
        BasicTest.assertEquals((int)8, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)7, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)6, (int)mpp.getAllResourceAssignments().size());
        task = mpp.getTaskByUniqueID(new Integer(2));
        BasicTest.assertEquals((String)"Task Two", (String)task.getName());
        task.remove();
        BasicTest.assertEquals((int)7, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)7, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)5, (int)mpp.getAllResourceAssignments().size());
        resource = mpp.getResourceByUniqueID(new Integer(3));
        BasicTest.assertEquals((String)"Resource Three", (String)resource.getName());
        resource.remove();
        BasicTest.assertEquals((int)7, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)6, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)4, (int)mpp.getAllResourceAssignments().size());
        task = mpp.getTaskByUniqueID(new Integer(5));
        BasicTest.assertEquals((String)"Task Five", (String)task.getName());
        List assignments = task.getResourceAssignments();
        BasicTest.assertEquals((int)2, (int)assignments.size());
        ResourceAssignment assignment = (ResourceAssignment)assignments.get(0);
        resource = assignment.getResource();
        BasicTest.assertEquals((String)"Resource Six", (String)resource.getName());
        assignments = resource.getTaskAssignments();
        BasicTest.assertEquals((int)1, (int)assignments.size());
        assignment.remove();
        assignments = task.getResourceAssignments();
        BasicTest.assertEquals((int)1, (int)assignments.size());
        assignments = resource.getTaskAssignments();
        BasicTest.assertEquals((int)0, (int)assignments.size());
        BasicTest.assertEquals((int)7, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)6, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)3, (int)mpp.getAllResourceAssignments().size());
        task = mpp.getTaskByUniqueID(new Integer(8));
        BasicTest.assertEquals((String)"Task Eight", (String)task.getName());
        task.remove();
        BasicTest.assertEquals((int)5, (int)mpp.getAllTasks().size());
        BasicTest.assertEquals((int)6, (int)mpp.getAllResources().size());
        BasicTest.assertEquals((int)3, (int)mpp.getAllResourceAssignments().size());
        mpp.synchronizeTaskIDs();
        mpp.synchronizeResourceIDs();
        File out = null;
        try {
            out = File.createTempFile("junit", ".mpx");
            new MPXWriter().write(mpp, out);
            ProjectFile mpx = new MPXReader().read(out);
            BasicTest.assertEquals((int)5, (int)mpx.getAllTasks().size());
            BasicTest.assertEquals((int)6, (int)mpx.getAllResources().size());
            BasicTest.assertEquals((int)3, (int)mpx.getAllResourceAssignments().size());
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    public void testProjectCalendarExceptions() throws Exception {
    }
}

