/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mpd;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPXJException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpd.MPD9DatabaseReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public final class MPDDatabaseReader {
    private Integer m_projectID;
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_preserveNoteFormatting;

    public ProjectFile read() throws MPXJException {
        MPD9DatabaseReader reader = new MPD9DatabaseReader();
        reader.setProjectID(this.m_projectID);
        reader.setPreserveNoteFormatting(this.m_preserveNoteFormatting);
        reader.setDataSource(this.m_dataSource);
        reader.setConnection(this.m_connection);
        ProjectFile project = reader.read();
        return project;
    }

    public void setProjectID(int projectID) {
        this.m_projectID = new Integer(projectID);
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    public ProjectFile read(String accessDatabaseFileName) throws MPXJException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + accessDatabaseFileName;
            this.m_connection = DriverManager.getConnection(url);
            this.m_projectID = new Integer(1);
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (ClassNotFoundException ex) {
            throw new MPXJException("Failed to load JDBC driver", ex);
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

