/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.FieldType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Filter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.FilterCriteria;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPTaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TestOperator;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.FixedData;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.Var2Data;
import java.io.IOException;

public abstract class FilterReader {
    protected abstract Integer getVarDataType();

    public void process(ProjectFile file, FixedData fixedData, Var2Data varData) throws IOException {
        boolean lastLogicalAnd = true;
        int filterCount = fixedData.getItemCount();
        for (int filterLoop = 0; filterLoop < filterCount; ++filterLoop) {
            byte[] filterFixedData = fixedData.getByteArrayValue(filterLoop);
            if (filterFixedData == null || filterFixedData.length < 4) continue;
            Filter filter = new Filter();
            filter.setID(new Integer(MPPUtility.getInt(filterFixedData, 0)));
            filter.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(filterFixedData, 4)));
            byte[] filterVarData = varData.getByteArray(filter.getID(), this.getVarDataType());
            if (filterVarData == null) continue;
            int varDataOffset = MPPUtility.getInt(filterVarData, 16);
            filter.setShowRelatedSummaryRows(MPPUtility.getByte(filterVarData, 4) != 0);
            int offset = 180;
            block9: while (offset + 240 <= varDataOffset) {
                String prompt;
                Object value;
                int startOffset = offset;
                FilterCriteria criteria = new FilterCriteria(file);
                filter.addCriteria(criteria);
                int operatorValue = MPPUtility.getInt(filterVarData, offset);
                criteria.setOperator(TestOperator.getInstance(operatorValue - 999));
                int fieldType = MPPUtility.getShort(filterVarData, offset + 120);
                int entityType = MPPUtility.getByte(filterVarData, offset + 123);
                FieldType type = null;
                switch (entityType) {
                    case 11: {
                        type = MPPTaskField.getInstance(fieldType);
                        break;
                    }
                    case 12: {
                        type = MPPResourceField.getInstance(fieldType);
                    }
                }
                criteria.setField(type);
                if (MPPUtility.getByte(filterVarData, offset + 224) == 0) {
                    value = this.getValue(file, type, filterVarData, offset, varDataOffset);
                    criteria.setValue(0, value);
                } else {
                    prompt = this.getPrompt(filterVarData, offset, varDataOffset);
                    criteria.setPromptText(0, prompt);
                }
                if (criteria.getOperator() == TestOperator.IS_WITHIN || criteria.getOperator() == TestOperator.IS_NOT_WITHIN) {
                    if (MPPUtility.getByte(filterVarData, offset + 224 + 80) == 0) {
                        value = this.getValue(file, type, filterVarData, offset + 80, varDataOffset);
                        criteria.setValue(1, value);
                    } else {
                        prompt = this.getPrompt(filterVarData, offset + 80, varDataOffset);
                        criteria.setPromptText(1, prompt);
                    }
                    offset += 320;
                } else {
                    offset += 240;
                }
                if (offset + 80 > varDataOffset) continue;
                int logicalOperator = MPPUtility.getShort(filterVarData, offset);
                switch (logicalOperator) {
                    case 25: 
                    case 27: {
                        criteria.setLogicalAnd(true);
                        lastLogicalAnd = true;
                        offset += 80;
                        continue block9;
                    }
                    case 26: 
                    case 28: {
                        criteria.setLogicalAnd(false);
                        lastLogicalAnd = false;
                        offset += 80;
                        continue block9;
                    }
                }
                criteria.setLogicalAnd(lastLogicalAnd);
            }
            file.addFilter(filter);
        }
    }

    private Object getValue(ProjectFile file, FieldType type, byte[] filterVarData, int offset, int varDataOffset) {
        boolean valueFlag;
        Object value = null;
        boolean bl = valueFlag = MPPUtility.getInt(filterVarData, offset + 160) == 1;
        if (!valueFlag) {
            int field = MPPUtility.getShort(filterVarData, offset + 200);
            value = type instanceof TaskField ? MPPTaskField.getInstance(field) : MPPResourceField.getInstance(field);
        } else {
            switch (type.getDataType().getType()) {
                case 6: {
                    value = MPPUtility.getAdjustedDuration(file, MPPUtility.getInt(filterVarData, offset + 192), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(filterVarData, offset + 192)));
                    break;
                }
                case 5: {
                    value = new Double(MPPUtility.getDouble(filterVarData, offset + 192));
                    break;
                }
                case 8: {
                    value = new Double(MPPUtility.getInt(filterVarData, offset + 192));
                    break;
                }
                case 3: {
                    value = new Double(MPPUtility.getDouble(filterVarData, offset + 192) / 100.0);
                    break;
                }
                case 1: {
                    int textOffset = MPPUtility.getShort(filterVarData, offset + 228);
                    value = MPPUtility.getUnicodeString(filterVarData, varDataOffset + textOffset);
                    break;
                }
                case 4: {
                    int intValue = MPPUtility.getShort(filterVarData, offset + 192);
                    value = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 2: {
                    value = MPPUtility.getTimestamp(filterVarData, offset + 192);
                }
            }
        }
        return value;
    }

    private String getPrompt(byte[] filterVarData, int offset, int varDataOffset) {
        int textOffset = MPPUtility.getShort(filterVarData, offset + 232);
        String value = MPPUtility.getUnicodeString(filterVarData, varDataOffset + textOffset);
        return value;
    }
}

