/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.FieldType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Group;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.GroupClause;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPTaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.ColorType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.FixedData;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.FontBase;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.FontStyle;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.Var2Data;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public abstract class GroupReader {
    protected abstract Integer getVarDataType();

    public void process(ProjectFile file, FixedData fixedData, Var2Data varData, Map fontBases) throws IOException {
        int groupCount = fixedData.getItemCount();
        for (int groupLoop = 0; groupLoop < groupCount; ++groupLoop) {
            Integer groupID;
            byte[] groupVarData;
            byte[] groupFixedData = fixedData.getByteArrayValue(groupLoop);
            if (groupFixedData == null || groupFixedData.length < 4 || (groupVarData = varData.getByteArray(groupID = new Integer(MPPUtility.getInt(groupFixedData, 0)), this.getVarDataType())) == null) continue;
            String groupName = MPPUtility.getUnicodeString(groupFixedData, 4);
            Integer groupUniqueID = new Integer(MPPUtility.getInt(groupVarData, 0));
            boolean showSummaryTasks = MPPUtility.getShort(groupVarData, 4) != 0;
            Group group = new Group(groupID, groupName, showSummaryTasks);
            file.addGroup(group);
            int clauseCount = MPPUtility.getShort(groupVarData, 6);
            int offset = 8;
            for (int clauseIndex = 0; clauseIndex < clauseCount && offset + 47 <= groupVarData.length; ++clauseIndex) {
                GroupClause clause = new GroupClause();
                group.addGroupClause(clause);
                int fieldType = MPPUtility.getShort(groupVarData, offset);
                int entityType = MPPUtility.getByte(groupVarData, offset + 3);
                FieldType type = null;
                switch (entityType) {
                    case 11: {
                        type = MPPTaskField.getInstance(fieldType);
                        break;
                    }
                    case 12: {
                        type = MPPResourceField.getInstance(fieldType);
                    }
                }
                clause.setField(type);
                boolean ascending = MPPUtility.getByte(groupVarData, offset + 4) != 0;
                clause.setAscending(ascending);
                int fontIndex = MPPUtility.getByte(groupVarData, offset + 8);
                FontBase fontBase = (FontBase)fontBases.get(new Integer(fontIndex));
                int style = MPPUtility.getByte(groupVarData, offset + 9);
                boolean bold = (style & 1) != 0;
                boolean italic = (style & 2) != 0;
                boolean underline = (style & 4) != 0;
                int fontColorIndex = MPPUtility.getByte(groupVarData, offset + 10);
                ColorType fontColor = ColorType.getInstance(fontColorIndex);
                FontStyle fontStyle = new FontStyle(fontBase, italic, bold, underline, fontColor);
                clause.setFont(fontStyle);
                int colorIndex = MPPUtility.getByte(groupVarData, offset + 12);
                ColorType color = ColorType.getInstance(colorIndex);
                clause.setCellBackgroundColor(color);
                int patternIndex = MPPUtility.getByte(groupVarData, offset + 13);
                clause.setPattern(patternIndex);
                int groupOn = MPPUtility.getShort(groupVarData, offset + 14);
                clause.setGroupOn(groupOn);
                Comparable<Date> startAt = null;
                Number groupInterval = null;
                if (type != null && type.getDataType() != null) {
                    switch (type.getDataType().getType()) {
                        case 3: 
                        case 5: 
                        case 6: {
                            startAt = new Double(MPPUtility.getDouble(groupVarData, offset + 24));
                            groupInterval = new Double(MPPUtility.getDouble(groupVarData, offset + 40));
                            break;
                        }
                        case 8: {
                            startAt = new Integer(MPPUtility.getInt(groupVarData, offset + 24));
                            groupInterval = new Integer(MPPUtility.getInt(groupVarData, offset + 40));
                            break;
                        }
                        case 4: {
                            startAt = MPPUtility.getShort(groupVarData, offset + 24) == 1 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 2: {
                            startAt = MPPUtility.getTimestamp(groupVarData, offset + 24);
                            groupInterval = new Integer(MPPUtility.getInt(groupVarData, offset + 40));
                        }
                    }
                }
                clause.setStartAt(startAt);
                clause.setGroupInterval(groupInterval);
                offset += 48;
            }
        }
    }
}

