/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPXJException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.CompObj;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPP12Reader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPP8Reader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPP9Reader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPVariantReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.reader.AbstractProjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class MPPReader
extends AbstractProjectReader {
    private boolean m_preserveNoteFormatting;
    private static final Map FILE_CLASS_MAP = new HashMap();

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            ProjectFile projectFile = new ProjectFile();
            POIFSFileSystem fs = new POIFSFileSystem(is);
            DirectoryNode root = fs.getRoot();
            CompObj compObj = new CompObj((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            String format = compObj.getFileFormat();
            Class readerClass = (Class)FILE_CLASS_MAP.get(format);
            if (readerClass == null) {
                throw new MPXJException("Invalid file format: " + format);
            }
            MPPVariantReader reader = (MPPVariantReader)readerClass.newInstance();
            reader.process(this, projectFile, (DirectoryEntry)root);
            projectFile.setAutoOutlineNumber(true);
            projectFile.updateStructure();
            projectFile.setAutoOutlineNumber(false);
            List tasks = projectFile.getAllTasks();
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Task task;
                task.setSummary((task = (Task)iter.next()).getChildTasks().size() != 0);
            }
            projectFile.updateUniqueCounters();
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (InstantiationException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public boolean getPreserveNoteFormatting() {
        return this.m_preserveNoteFormatting;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    static {
        FILE_CLASS_MAP.put("MSProject.MPP9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT12", MPP12Reader.class);
    }
}

