/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPXJException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Rate;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ScheduleFrom;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.Props;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryEntry;

public final class ProjectHeaderReader {
    public void process(ProjectFile file, Props props, DirectoryEntry rootDir) throws MPXJException {
        ProjectHeader ph = file.getProjectHeader();
        ph.setScheduleFrom(ScheduleFrom.getInstance(1 - props.getShort(Props.SCHEDULE_FROM)));
        ph.setCalendarName(props.getUnicodeString(Props.DEFAULT_CALENDAR_NAME));
        ph.setDefaultStartTime(props.getTime(Props.START_TIME));
        ph.setDefaultEndTime(props.getTime(Props.END_TIME));
        ph.setStatusDate(props.getTimestamp(Props.STATUS_DATE));
        ph.setDefaultDurationUnits(MPPUtility.getDurationTimeUnits(props.getShort(Props.DURATION_UNITS)));
        ph.setMinutesPerDay(new Integer(props.getInt(Props.MINUTES_PER_DAY)));
        ph.setMinutesPerWeek(new Integer(props.getInt(Props.MINUTES_PER_WEEK)));
        ph.setDefaultOvertimeRate(new Rate(props.getDouble(Props.OVERTIME_RATE), TimeUnit.HOURS));
        ph.setDefaultStandardRate(new Rate(props.getDouble(Props.STANDARD_RATE), TimeUnit.HOURS));
        ph.setDefaultWorkUnits(MPPUtility.getWorkTimeUnits(props.getShort(Props.WORK_UNITS)));
        ph.setSplitInProgressTasks(props.getBoolean(Props.SPLIT_TASKS));
        ph.setUpdatingTaskStatusUpdatesResourceStatus(props.getBoolean(Props.TASK_UPDATES_RESOURCE));
        ph.setCurrencyDigits(new Integer(props.getShort(Props.CURRENCY_DIGITS)));
        ph.setCurrencySymbol(props.getUnicodeString(Props.CURRENCY_SYMBOL));
        ph.setSymbolPosition(MPPUtility.getSymbolPosition(props.getShort(Props.CURRENCY_PLACEMENT)));
        SummaryInformation summary = new SummaryInformation(rootDir);
        ph.setProjectTitle(summary.getProjectTitle());
        ph.setSubject(summary.getSubject());
        ph.setAuthor(summary.getAuthor());
        ph.setKeywords(summary.getKeywords());
        ph.setComments(summary.getComments());
        ph.setCompany(summary.getCompany());
        ph.setManager(summary.getManager());
        ph.setCategory(summary.getCategory());
        ph.setRevision(summary.getRevision());
        ph.setDocumentSummaryInformation(summary.getDocumentSummaryInformation());
        ph.setCalculateMultipleCriticalPaths(props.getBoolean(Props.CALCULATE_MULTIPLE_CRITICAL_PATHS));
    }
}

