/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.AccrueType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ConstraintType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.DataType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.DateRange;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.FileCreationRecord;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Priority;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarHours;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Rate;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RecurringTask;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RelationType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.LocaleData;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.LocaleUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXConstants;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXTaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.ResourceModel;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.TaskModel;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.MPXJFormats;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.NumberUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.writer.AbstractProjectWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class MPXWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private OutputStreamWriter m_writer;
    private ResourceModel m_resourceModel;
    private TaskModel m_taskModel;
    private char m_delimiter;
    private Locale m_locale = Locale.ENGLISH;
    private StringBuffer m_buffer;
    private MPXJFormats m_formats;

    @Override
    public void write(ProjectFile projectFile, OutputStream out) throws IOException {
        this.write(projectFile, out, true);
    }

    public void write(ProjectFile projectFile, String fileName, boolean useLocaleDefaults) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        this.write(projectFile, fos, useLocaleDefaults);
        fos.flush();
        fos.close();
    }

    public void write(ProjectFile projectFile, File file, boolean useLocaleDefaults) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.write(projectFile, fos, useLocaleDefaults);
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ProjectFile projectFile, OutputStream out, boolean useLocaleDefaults) throws IOException {
        this.m_projectFile = projectFile;
        if (useLocaleDefaults) {
            LocaleUtility.setLocale(this.m_projectFile, this.m_locale);
        }
        this.m_delimiter = projectFile.getDelimiter();
        this.m_writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), projectFile.getFileCreationRecord().getCodePage().getCharset());
        this.m_buffer = new StringBuffer();
        this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
        try {
            this.write();
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_resourceModel = null;
            this.m_taskModel = null;
            this.m_buffer = null;
            this.m_locale = null;
            this.m_formats = null;
        }
    }

    private void write() throws IOException {
        this.writeFileCreationRecord(this.m_projectFile.getFileCreationRecord());
        this.writeProjectHeader(this.m_projectFile.getProjectHeader());
        if (!this.m_projectFile.getAllResources().isEmpty()) {
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_resourceModel.toString());
            Iterator iter = this.m_projectFile.getAllResources().iterator();
            while (iter.hasNext()) {
                this.writeResource((Resource)iter.next());
            }
        }
        if (!this.m_projectFile.getAllTasks().isEmpty()) {
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_taskModel.toString());
            this.writeTasks(this.m_projectFile.getChildTasks());
        }
        this.m_writer.flush();
    }

    private void writeFileCreationRecord(FileCreationRecord record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append("MPX");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getProgramName());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getFileVersion());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getCodePage());
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeProjectHeader(ProjectHeader record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(10);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCurrencySymbol()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getSymbolPosition()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCurrencyDigits()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(new Character(record.getThousandsSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(new Character(record.getDecimalSeparator())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(11);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(new Integer(record.getDefaultDurationUnits().getValue())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getDefaultDurationIsFixed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(new Integer(record.getDefaultWorkUnits().getValue())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberUtility.getDouble(record.getMinutesPerDay()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberUtility.getDouble(record.getMinutesPerWeek()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(record.getDefaultStandardRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(record.getDefaultOvertimeRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getUpdatingTaskStatusUpdatesResourceStatus() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getSplitInProgressTasks() ? "1" : "0");
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(12);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDateOrder()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getTimeFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.getIntegerTimeInMinutes(record.getDefaultStartTime())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(new Character(record.getDateSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(new Character(record.getTimeSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getAMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getPMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDateFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getBarTextDateFormat()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        Iterator iter = this.m_projectFile.getBaseCalendars().iterator();
        while (iter.hasNext()) {
            this.writeCalendar((ProjectCalendar)iter.next());
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(30);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getProjectTitle()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCompany()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getManager()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getCalendarName()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getFinishDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getScheduleFrom()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getCurrentDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getComments()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(record.getWork2())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getBaselineDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(record.getPercentageComplete())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getBaselineStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getBaselineFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getActualStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getActualFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getStartVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getFinishVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getSubject()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getAuthor()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getKeywords()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendar(ProjectCalendar record) throws IOException {
        this.m_buffer.setLength(0);
        if (record.getBaseCalendar() == null) {
            this.m_buffer.append(20);
            this.m_buffer.append(this.m_delimiter);
            if (record.getName() != null) {
                this.m_buffer.append(record.getName());
            }
        } else {
            this.m_buffer.append(55);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.getBaseCalendar().getName());
        }
        int[] days = record.getDays();
        for (int loop = 0; loop < days.length; ++loop) {
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(days[loop]);
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        ProjectCalendarHours[] hours = record.getHours();
        for (int loop = 0; loop < hours.length; ++loop) {
            if (hours[loop] == null) continue;
            this.writeCalendarHours(record, hours[loop]);
        }
        if (!record.getCalendarExceptions().isEmpty()) {
            ArrayList exceptions = new ArrayList(record.getCalendarExceptions());
            Collections.sort(exceptions);
            Iterator iter = exceptions.iterator();
            while (iter.hasNext()) {
                this.writeCalendarException(record, (ProjectCalendarException)iter.next());
            }
        }
    }

    private void writeCalendarHours(ProjectCalendar parentCalendar, ProjectCalendarHours record) throws IOException {
        DateRange range3;
        DateRange range2;
        this.m_buffer.setLength(0);
        int recordNumber = parentCalendar.isBaseCalendar() ? 25 : 56;
        DateRange range1 = record.getDateRange(0);
        if (range1 == null) {
            range1 = DateRange.EMPTY_RANGE;
        }
        if ((range2 = record.getDateRange(1)) == null) {
            range2 = DateRange.EMPTY_RANGE;
        }
        if ((range3 = record.getDateRange(2)) == null) {
            range3 = DateRange.EMPTY_RANGE;
        }
        this.m_buffer.append(recordNumber);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDay()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range1.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range1.getEndDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range2.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range2.getEndDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range3.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range3.getEndDate())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendarException(ProjectCalendar parentCalendar, ProjectCalendarException record) throws IOException {
        this.m_buffer.setLength(0);
        if (parentCalendar.isBaseCalendar()) {
            this.m_buffer.append(26);
        } else {
            this.m_buffer.append(57);
        }
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(record.getFromDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(record.getToDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getWorking() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getFromTime1())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getToTime1())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getFromTime2())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getToTime2())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getFromTime3())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getToTime3())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResource(Resource record) throws IOException {
        int mpxFieldType;
        this.m_buffer.setLength(0);
        int[] fields = this.m_resourceModel.getModel();
        this.m_buffer.append(50);
        for (int loop = 0; loop < fields.length && (mpxFieldType = fields[loop]) != -1; ++loop) {
            ResourceField resourceField = MPXResourceField.getMpxjField(mpxFieldType);
            Object value = record.getCachedValue(resourceField);
            value = this.formatType(resourceField.getDataType(), value);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(value));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String notes = record.getNotes();
        if (notes != null && notes.length() != 0) {
            this.writeNotes(51, notes);
        }
        if (record.getResourceCalendar() != null) {
            this.writeCalendar(record.getResourceCalendar());
        }
        this.m_projectFile.fireResourceWrittenEvent(record);
    }

    private void writeNotes(int recordNumber, String text) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(recordNumber);
        this.m_buffer.append(this.m_delimiter);
        if (text != null) {
            String note = this.stripLineBreaks(text, MPXConstants.EOL_PLACEHOLDER_STRING);
            boolean quote = note.indexOf(this.m_delimiter) != -1 || note.indexOf(34) != -1;
            int length = note.length();
            if (quote) {
                this.m_buffer.append('\"');
            }
            block3: for (int loop = 0; loop < length; ++loop) {
                char c = note.charAt(loop);
                switch (c) {
                    case '\"': {
                        this.m_buffer.append("\"\"");
                        continue block3;
                    }
                    default: {
                        this.m_buffer.append(c);
                    }
                }
            }
            if (quote) {
                this.m_buffer.append('\"');
            }
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTask(Task record) throws IOException {
        int field;
        this.m_buffer.setLength(0);
        int[] fields = this.m_taskModel.getModel();
        this.m_buffer.append(70);
        for (int loop = 0; loop < fields.length && (field = fields[loop]) != -1; ++loop) {
            TaskField taskField = MPXTaskField.getMpxjField(field);
            Object value = record.getCachedValue(taskField);
            value = this.formatType(taskField.getDataType(), value);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(value));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String notes = record.getNotes();
        if (notes != null && notes.length() != 0) {
            this.writeNotes(71, notes);
        }
        if (record.getRecurringTask() != null) {
            this.writeRecurringTask(record.getRecurringTask());
        }
        if (!record.getResourceAssignments().isEmpty()) {
            Iterator list = record.getResourceAssignments().iterator();
            while (list.hasNext()) {
                this.writeResourceAssignment((ResourceAssignment)list.next());
            }
        }
        this.m_projectFile.fireTaskWrittenEvent(record);
    }

    private void writeRecurringTask(RecurringTask record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(72);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getTaskUniqueID()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getFinishDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDuration()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDurationType()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getNumberOfOccurances()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getRecurranceType()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getNotSureIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getLengthRadioIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDailyBoxRadioIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getWeeklyBoxDayOfWeekIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMonthlyBoxRadioIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getYearlyBoxRadioIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDailyBoxComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getWeeklyBoxComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMonthlyBoxFirstLastComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMonthlyBoxDayComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMonthlyBoxBottomRadioFrequencyComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMonthlyBoxDayIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMonthlyBoxTopRadioFrequencyComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getYearlyBoxFirstLastComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getYearlyBoxDayComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getYearlyBoxMonthComboIndex()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getYearlyBoxDate())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResourceAssignment(ResourceAssignment record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(75);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getResourceID()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatUnits(record.getUnits())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getPlannedWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getOvertimeWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getPlannedCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getDelay())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getResourceUniqueID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        if (record.getWorkgroupAssignment() != null) {
            this.writeResourceAssignmentWorkgroupFields(record.getWorkgroupAssignment());
        }
    }

    private void writeResourceAssignmentWorkgroupFields(ResourceAssignmentWorkgroupFields record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(76);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMessageUniqueID()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getConfirmed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getResponsePending() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getUpdateStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getUpdateFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getScheduleID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTasks(List tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTask(task);
            this.writeTasks(task.getChildTasks());
        }
    }

    private Integer getIntegerTimeInMinutes(Date date) {
        Integer result = null;
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int time = cal.get(11) * 60;
            result = new Integer(time += cal.get(12));
        }
        return result;
    }

    private String escapeQuotes(String value) {
        StringBuffer sb = new StringBuffer();
        int length = value.length();
        sb.append('\"');
        for (int index = 0; index < length; ++index) {
            char c = value.charAt(index);
            sb.append(c);
            if (c != '\"') continue;
            sb.append('\"');
        }
        sb.append('\"');
        return sb.toString();
    }

    private String stripLineBreaks(String text, String replacement) {
        if (text.indexOf(13) != -1 || text.indexOf(10) != -1) {
            int index;
            StringBuffer sb = new StringBuffer(text);
            while ((index = sb.indexOf("\r\n")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\n\r")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\r")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            while ((index = sb.indexOf("\n")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            text = sb.toString();
        }
        return text;
    }

    private String format(Object o) {
        String result;
        if (o == null) {
            result = "";
        } else {
            result = o instanceof Boolean ? LocaleData.getString(this.m_locale, (Boolean)o == true ? "YES" : "NO") : (o instanceof Float || o instanceof Double ? this.m_formats.getDecimalFormat().format(((Number)o).doubleValue()) : o.toString());
            if ((result = this.stripLineBreaks(result, MPXConstants.EOL_PLACEHOLDER_STRING)).indexOf(34) != -1) {
                result = this.escapeQuotes(result);
            } else if (result.indexOf(this.m_delimiter) != -1) {
                result = '\"' + result + '\"';
            }
        }
        return result;
    }

    private void stripTrailingDelimiters(StringBuffer buffer) {
        int index;
        for (index = buffer.length() - 1; index > 0 && buffer.charAt(index) == this.m_delimiter; --index) {
        }
        buffer.setLength(index + 1);
    }

    private String formatTime(Date value) {
        return value == null ? null : this.m_formats.getTimeFormat().format(value);
    }

    private String formatCurrency(Number value) {
        return value == null ? null : this.m_formats.getCurrencyFormat().format(value);
    }

    private String formatUnits(Number value) {
        return value == null ? null : this.m_formats.getUnitsDecimalFormat().format(value.doubleValue() / 100.0);
    }

    private String formatDateTime(Date value) {
        return value == null ? null : this.m_formats.getDateTimeFormat().format(value);
    }

    private String formatDate(Date value) {
        return value == null ? null : this.m_formats.getDateFormat().format(value);
    }

    private String formatPercentage(Number value) {
        return value == null ? null : this.m_formats.getPercentageDecimalFormat().format(value) + "%";
    }

    private String formatAccrueType(AccrueType type) {
        return type == null ? null : LocaleData.getStringArray(this.m_locale, "ACCRUE_TYPES")[type.getType() - 1];
    }

    private String formatConstraintType(ConstraintType type) {
        return type == null ? null : LocaleData.getStringArray(this.m_locale, "CONSTRAINT_TYPES")[type.getType()];
    }

    private String formatDuration(Duration value) {
        return value == null ? null : this.m_formats.getDurationDecimalFormat().format(value.getDuration()) + this.formatTimeUnit(value.getUnits());
    }

    private String formatRate(Rate value) {
        String result = null;
        if (value != null) {
            StringBuffer buffer = new StringBuffer(this.m_formats.getCurrencyFormat().format(value.getAmount()));
            buffer.append("/");
            buffer.append(this.formatTimeUnit(value.getUnits()));
            result = buffer.toString();
        }
        return result;
    }

    private String formatPriority(Priority value) {
        String result = null;
        if (value != null) {
            String[] priorityTypes = LocaleData.getStringArray(this.m_locale, "PRIORITY_TYPES");
            int priority = value.getValue();
            if (priority < 100) {
                priority = 100;
            } else if (priority > 1000) {
                priority = 1000;
            }
            result = priorityTypes[(priority /= 100) - 1];
        }
        return result;
    }

    private String formatTaskType(TaskType value) {
        return LocaleData.getString(this.m_locale, value == TaskType.FIXED_DURATION ? "YES" : "NO");
    }

    private String formatRelationList(List value) {
        String result = null;
        if (value != null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = value.iterator();
            while (iter.hasNext()) {
                if (sb.length() != 0) {
                    sb.append(this.m_delimiter);
                }
                sb.append(this.formatRelation((Relation)iter.next()));
            }
            result = sb.toString();
        }
        return result;
    }

    private String formatRelation(Relation relation) {
        String result = null;
        if (relation != null) {
            StringBuffer sb = new StringBuffer(relation.getTaskID().toString());
            Duration duration = relation.getDuration();
            RelationType type = relation.getType();
            double durationValue = duration.getDuration();
            if (durationValue != 0.0 || type != RelationType.FINISH_START) {
                String[] typeNames = LocaleData.getStringArray(this.m_locale, "RELATION_TYPES");
                sb.append(typeNames[type.getType()]);
            }
            if (durationValue != 0.0) {
                if (durationValue > 0.0) {
                    sb.append('+');
                }
                sb.append(this.formatDuration(duration));
            }
            result = sb.toString();
        }
        return result;
    }

    private String formatTimeUnit(TimeUnit timeUnit) {
        int units = timeUnit.getValue();
        String[] unitNames = LocaleData.getStringArray(this.m_locale, "TIME_UNITS_ARRAY");
        String result = units < 0 || units >= unitNames.length ? "" : unitNames[units];
        return result;
    }

    private String formatDecimal(double value) {
        return this.m_formats.getDecimalFormat().format(value);
    }

    private Object formatType(DataType type, Object value) {
        switch (type.getType()) {
            case 2: {
                value = this.formatDateTime((Date)value);
                break;
            }
            case 3: {
                value = this.formatCurrency((Number)value);
                break;
            }
            case 7: {
                value = this.formatUnits((Number)value);
                break;
            }
            case 8: {
                value = this.formatPercentage((Number)value);
                break;
            }
            case 9: {
                value = this.formatAccrueType((AccrueType)value);
                break;
            }
            case 10: {
                value = this.formatConstraintType((ConstraintType)value);
                break;
            }
            case 6: {
                value = this.formatDuration((Duration)value);
                break;
            }
            case 11: {
                value = this.formatRate((Rate)value);
                break;
            }
            case 12: {
                value = this.formatPriority((Priority)value);
                break;
            }
            case 13: {
                value = this.formatRelationList((List)value);
                break;
            }
            case 14: {
                value = this.formatTaskType((TaskType)value);
            }
        }
        return value;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }
}

