/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.DateRange;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Day;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPTaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPXJException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarHours;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RelationType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ScheduleFrom;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.SubProject;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.DatatypeConverter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.Project;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.ProjectType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.reader.AbstractProjectReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.NumberUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MSPDIReader
extends AbstractProjectReader {
    private boolean m_compatibleInput = true;
    private ProjectFile m_projectFile;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(stream);
            if (this.m_compatibleInput) {
                this.removeEmptyElementNodes(doc, doc);
            }
            JAXBContext context = JAXBContext.newInstance((String)"com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (this.m_compatibleInput) {
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        return true;
                    }
                });
            }
            Project project = (Project)unmarshaller.unmarshal((Node)doc);
            HashMap calendarMap = new HashMap();
            this.readProjectHeader(project);
            this.readProjectExtendedAttributes(project);
            this.readCalendars(project, calendarMap);
            this.readResources(project, calendarMap);
            this.readTasks(project);
            this.readAssignments(project);
            this.m_projectFile.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void readProjectHeader(Project project) {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        header.setActualsInSync(project.isActualsInSync());
        header.setAdminProject(project.isAdminProject());
        header.setAuthor(project.getAuthor());
        header.setAutoAddNewResourcesAndTasks(project.isAutoAddNewResourcesAndTasks());
        header.setAutolink(project.isAutolink());
        header.setBaselineForEarnedValue(NumberUtility.getInteger(project.getBaselineForEarnedValue()));
        header.setCategory(project.getCategory());
        header.setCompany(project.getCompany());
        header.setCreationDate(DatatypeConverter.parseDate(project.getCreationDate()));
        header.setCriticalSlackLimit(NumberUtility.getInteger(project.getCriticalSlackLimit()));
        header.setCurrencyDigits(NumberUtility.getInteger(project.getCurrencyDigits()));
        header.setCurrencySymbol(project.getCurrencySymbol());
        header.setCurrentDate(DatatypeConverter.parseDate(project.getCurrentDate()));
        header.setDaysPerMonth(NumberUtility.getInteger(project.getDaysPerMonth()));
        header.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        header.setDefaultEndTime(DatatypeConverter.parseTime(project.getDefaultFinishTime()));
        header.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        header.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate()));
        header.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate()));
        header.setDefaultStartTime(DatatypeConverter.parseTime(project.getDefaultStartTime()));
        header.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        header.setDefaultTaskType(project.getDefaultTaskType());
        header.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        header.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        header.setEditableActualCosts(project.isEditableActualCosts());
        header.setExtendedCreationDate(DatatypeConverter.parseDate(project.getExtendedCreationDate()));
        header.setFinishDate(DatatypeConverter.parseDate(project.getFinishDate()));
        header.setFiscalYearStart(project.isFiscalYearStart());
        header.setFiscalYearStartMonth(NumberUtility.getInteger(project.getFYStartDate()));
        header.setHonorConstraints(project.isHonorConstraints());
        header.setInsertedProjectsLikeSummary(project.isInsertedProjectsLikeSummary());
        header.setLastSaved(DatatypeConverter.parseDate(project.getLastSaved()));
        header.setManager(project.getManager());
        header.setMicrosoftProjectServerURL(project.isMicrosoftProjectServerURL());
        header.setMinutesPerDay(NumberUtility.getInteger(project.getMinutesPerDay()));
        header.setMinutesPerWeek(NumberUtility.getInteger(project.getMinutesPerWeek()));
        header.setMoveCompletedEndsBack(project.isMoveCompletedEndsBack());
        header.setMoveCompletedEndsForward(project.isMoveCompletedEndsForward());
        header.setMoveRemainingStartsBack(project.isMoveRemainingStartsBack());
        header.setMoveRemainingStartsForward(project.isMoveRemainingStartsForward());
        header.setMultipleCriticalPaths(project.isMultipleCriticalPaths());
        header.setName(project.getName());
        header.setNewTasksEffortDriven(project.isNewTasksEffortDriven());
        header.setNewTasksEstimated(project.isNewTasksEstimated());
        header.setNewTaskStartIsProjectStart(NumberUtility.getInt(project.getNewTaskStartDate()) == 0);
        header.setProjectExternallyEdited(project.isProjectExternallyEdited());
        header.setProjectTitle(project.getTitle());
        header.setRemoveFileProperties(project.isRemoveFileProperties());
        header.setRevision(NumberUtility.getInteger(project.getRevision()));
        header.setScheduleFrom(project.isScheduleFromStart() ? ScheduleFrom.START : ScheduleFrom.FINISH);
        header.setSubject(project.getSubject());
        header.setSplitInProgressTasks(project.isSplitsInProgressTasks());
        header.setSpreadActualCost(project.isSpreadActualCost());
        header.setSpreadPercentComplete(project.isSpreadPercentComplete());
        header.setStartDate(DatatypeConverter.parseDate(project.getStartDate()));
        header.setStatusDate(DatatypeConverter.parseDate(project.getStatusDate()));
        header.setSymbolPosition(project.getCurrencySymbolPosition());
        header.setUniqueID(project.getUID());
        header.setUpdatingTaskStatusUpdatesResourceStatus(project.isTaskUpdatesResource());
        header.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
    }

    private void readCalendars(Project project, HashMap map) {
        ProjectType.CalendarsType calendars = project.getCalendars();
        if (calendars != null) {
            List calendar = calendars.getCalendar();
            Iterator iter = calendar.iterator();
            LinkedList baseCalendars = new LinkedList();
            while (iter.hasNext()) {
                this.readCalendar((ProjectType.CalendarsType.CalendarType)iter.next(), map, baseCalendars);
            }
            MSPDIReader.updateBaseCalendarNames(baseCalendars, map);
        }
    }

    private static void updateBaseCalendarNames(List baseCalendars, HashMap map) {
        for (Pair pair : baseCalendars) {
            ProjectCalendar cal = (ProjectCalendar)pair.getFirst();
            BigInteger baseCalendarID = (BigInteger)pair.getSecond();
            ProjectCalendar baseCal = (ProjectCalendar)map.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setBaseCalendar(baseCal);
        }
    }

    private void readCalendar(ProjectType.CalendarsType.CalendarType calendar, HashMap map, LinkedList baseCalendars) {
        ProjectType.CalendarsType.CalendarType.WeekDaysType days;
        ProjectCalendar bc = calendar.isIsBaseCalendar() ? this.m_projectFile.addBaseCalendar() : this.m_projectFile.addResourceCalendar();
        bc.setUniqueID(NumberUtility.getInteger(calendar.getUID()));
        bc.setName(calendar.getName());
        BigInteger baseCalendarID = calendar.getBaseCalendarUID();
        if (baseCalendarID != null) {
            baseCalendars.add(new Pair(bc, baseCalendarID));
        }
        if ((days = calendar.getWeekDays()) != null) {
            List day = days.getWeekDay();
            Iterator iter = day.iterator();
            while (iter.hasNext()) {
                this.readDay(bc, (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType)iter.next());
            }
        }
        map.put(calendar.getUID(), bc);
    }

    private void readDay(ProjectCalendar calendar, ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType day) {
        BigInteger dayType = day.getDayType();
        if (dayType != null) {
            if (dayType.intValue() == 0) {
                this.readExceptionDay(calendar, day);
            } else {
                this.readNormalDay(calendar, day);
            }
        }
    }

    private void readNormalDay(ProjectCalendar calendar, ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType weekDay) {
        int dayNumber = weekDay.getDayType().intValue();
        Day day = Day.getInstance(dayNumber);
        calendar.setWorkingDay(day, weekDay.isDayWorking());
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType times = weekDay.getWorkingTimes();
        if (times != null) {
            List time = times.getWorkingTime();
            for (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType period : time) {
                Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                Date endTime = DatatypeConverter.parseTime(period.getToTime());
                if (startTime == null || endTime == null) continue;
                hours.addDateRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar calendar, ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType day) {
        ProjectCalendarException exception = calendar.addCalendarException();
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.TimePeriodType timePeriod = day.getTimePeriod();
        exception.setFromDate(DatatypeConverter.parseDate(timePeriod.getFromDate()));
        exception.setToDate(DatatypeConverter.parseDate(timePeriod.getToDate()));
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType times = day.getWorkingTimes();
        if (times != null) {
            ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType period;
            List time = times.getWorkingTime();
            Iterator iter = time.iterator();
            if (iter.hasNext()) {
                period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                exception.setFromTime1(DatatypeConverter.parseTime(period.getFromTime()));
                exception.setToTime1(DatatypeConverter.parseTime(period.getToTime()));
            }
            if (iter.hasNext()) {
                period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                exception.setFromTime2(DatatypeConverter.parseTime(period.getFromTime()));
                exception.setToTime2(DatatypeConverter.parseTime(period.getToTime()));
            }
            if (iter.hasNext()) {
                period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                exception.setFromTime3(DatatypeConverter.parseTime(period.getFromTime()));
                exception.setToTime3(DatatypeConverter.parseTime(period.getToTime()));
            }
        }
    }

    private void readProjectExtendedAttributes(Project project) {
        ProjectType.ExtendedAttributesType attributes = project.getExtendedAttributes();
        if (attributes != null) {
            List attribute = attributes.getExtendedAttribute();
            Iterator iter = attribute.iterator();
            while (iter.hasNext()) {
                this.readFieldAlias((ProjectType.ExtendedAttributesType.ExtendedAttributeType)iter.next());
            }
        }
    }

    private void readFieldAlias(ProjectType.ExtendedAttributesType.ExtendedAttributeType attribute) {
        String alias = attribute.getAlias();
        if (alias != null && alias.length() != 0) {
            int id = Integer.parseInt(attribute.getFieldID());
            int base = id & 0xFFFF0000;
            int index = id & 0xFFFF;
            switch (base) {
                case 0xB400000: {
                    TaskField taskField = MPPTaskField.getInstance(index);
                    if (taskField == null) break;
                    this.m_projectFile.setTaskFieldAlias(taskField, attribute.getAlias());
                    break;
                }
                case 0xC400000: {
                    ResourceField resourceField = MPPResourceField.getInstance(index);
                    if (resourceField == null) break;
                    this.m_projectFile.setResourceFieldAlias(resourceField, attribute.getAlias());
                    break;
                }
            }
        }
    }

    private void readResources(Project project, HashMap calendarMap) {
        ProjectType.ResourcesType resources = project.getResources();
        if (resources != null) {
            List resource = resources.getResource();
            Iterator iter = resource.iterator();
            while (iter.hasNext()) {
                this.readResource((ProjectType.ResourcesType.ResourceType)iter.next(), calendarMap);
            }
        }
    }

    private void readResource(ProjectType.ResourcesType.ResourceType xml, HashMap calendarMap) {
        Resource mpx = this.m_projectFile.addResource();
        mpx.setAccrueAt(xml.getAccrueAt());
        mpx.setActveDirectoryGUID(xml.getActiveDirectoryGUID());
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWorkProtected()));
        mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWork()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setAvailableFrom(DatatypeConverter.parseDate(xml.getAvailableFrom()));
        mpx.setAvailableTo(DatatypeConverter.parseDate(xml.getAvailableTo()));
        mpx.setBCWS(DatatypeConverter.parseCurrency(xml.getBCWS()));
        mpx.setBCWP(DatatypeConverter.parseCurrency(xml.getBCWP()));
        mpx.setBookingType(xml.getBookingType());
        mpx.setCanLevel(xml.isCanLevel());
        mpx.setCode(xml.getCode());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCostPerUse(DatatypeConverter.parseCurrency(xml.getCostPerUse()));
        mpx.setCostVariance(DatatypeConverter.parseCurrency(xml.getCostVariance()));
        mpx.setCreationDate(DatatypeConverter.parseDate(xml.getCreationDate()));
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setEmailAddress(xml.getEmailAddress());
        mpx.setFinish(DatatypeConverter.parseDate(xml.getFinish()));
        mpx.setGroup(xml.getGroup());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberUtility.getInteger(xml.getID()));
        mpx.setInitials(xml.getInitials());
        mpx.setIsEnterprise(xml.isIsEnterprise());
        mpx.setIsGeneric(xml.isIsGeneric());
        mpx.setIsInactive(xml.isIsInactive());
        mpx.setIsNull(xml.isIsNull());
        mpx.setMaterialLabel(xml.getMaterialLabel());
        mpx.setMaxUnits(DatatypeConverter.parseUnits(xml.getMaxUnits()));
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNtAccount(xml.getNTAccount());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeRate(DatatypeConverter.parseRate(xml.getOvertimeRate()));
        mpx.setOvertimeRateFormat(DatatypeConverter.parseTimeUnit(xml.getOvertimeRateFormat()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getOvertimeWork()));
        mpx.setPeakUnits(DatatypeConverter.parseUnits(xml.getPeakUnits()));
        mpx.setPercentWorkComplete(xml.getPercentWorkComplete());
        mpx.setPhonetics(xml.getPhonetics());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingWork()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingOvertimeWork()));
        mpx.setStandardRate(DatatypeConverter.parseRate(xml.getStandardRate()));
        mpx.setStandardRateFormat(DatatypeConverter.parseTimeUnit(xml.getStandardRateFormat()));
        mpx.setStart(DatatypeConverter.parseDate(xml.getStart()));
        mpx.setSV(DatatypeConverter.parseCurrency(xml.getSV()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberUtility.getInteger(xml.getUID()));
        mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getWork()));
        mpx.setWorkGroup(xml.getWorkGroup());
        mpx.setWorkVariance(DatatypeConverter.parseDurationInMinutes(xml.getWorkVariance()));
        this.readResourceExtendedAttributes(xml, mpx);
        mpx.setResourceCalendar((ProjectCalendar)calendarMap.get(xml.getCalendarUID()));
        mpx.setOverAllocated(xml.isOverAllocated());
        this.m_projectFile.fireResourceReadEvent(mpx);
    }

    private void readResourceExtendedAttributes(ProjectType.ResourcesType.ResourceType xml, Resource mpx) {
        List extendedAttributes = xml.getExtendedAttribute();
        for (ProjectType.ResourcesType.ResourceType.ExtendedAttributeType attrib : extendedAttributes) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            ResourceField mpxFieldID = MPPResourceField.getInstance(xmlFieldID);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID);
        }
    }

    private void readTasks(Project project) {
        ProjectType.TasksType tasks = project.getTasks();
        if (tasks != null) {
            List task = tasks.getTask();
            Iterator iter = task.iterator();
            while (iter.hasNext()) {
                this.readTask((ProjectType.TasksType.TaskType)iter.next());
            }
            iter = task.iterator();
            while (iter.hasNext()) {
                this.readPredecessors((ProjectType.TasksType.TaskType)iter.next());
            }
        }
        this.m_projectFile.updateStructure();
    }

    private void readTask(ProjectType.TasksType.TaskType xml) {
        Task mpx = this.m_projectFile.addTask();
        mpx.setDurationFormat(DatatypeConverter.parseDurationTimeUnits(xml.getDurationFormat()));
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualDuration()));
        mpx.setActualFinish(DatatypeConverter.parseDate(xml.getActualFinish()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualOvertimeWorkProtected()));
        mpx.setActualStart(DatatypeConverter.parseDate(xml.getActualStart()));
        mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualWork()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setCalendar(this.getTaskCalendar(xml));
        mpx.setConstraintDate(DatatypeConverter.parseDate(xml.getConstraintDate()));
        mpx.setConstraintType(DatatypeConverter.parseConstraintType(xml.getConstraintType()));
        mpx.setContact(xml.getContact());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCreateDate(DatatypeConverter.parseDate(xml.getCreateDate()));
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setDeadline(DatatypeConverter.parseDate(xml.getDeadline()));
        mpx.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getDuration()));
        mpx.setEarlyFinish(DatatypeConverter.parseDate(xml.getEarlyFinish()));
        mpx.setEarlyStart(DatatypeConverter.parseDate(xml.getEarlyStart()));
        mpx.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(xml.getEarnedValueMethod()));
        mpx.setEffortDriven(xml.isEffortDriven());
        mpx.setEstimated(xml.isEstimated());
        mpx.setExternalTask(xml.isExternalTask());
        mpx.setProject(xml.getExternalTaskProject());
        mpx.setFinish(DatatypeConverter.parseDate(xml.getFinish()));
        mpx.setFinishVariance(DatatypeConverter.parseDurationInMinutes(xml.getFinishVariance()));
        mpx.setFixedCost(DatatypeConverter.parseCurrency(xml.getFixedCost()));
        mpx.setFixedCostAccrual(xml.getFixedCostAccrual());
        mpx.setFreeSlack(DatatypeConverter.parseDurationInMinutes(xml.getFreeSlack()));
        mpx.setHideBar(xml.isHideBar());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberUtility.getInteger(xml.getID()));
        mpx.setIgnoreResourceCalendar(xml.isIgnoreResourceCalendar());
        mpx.setLateFinish(DatatypeConverter.parseDate(xml.getLateFinish()));
        mpx.setLateStart(DatatypeConverter.parseDate(xml.getLateStart()));
        mpx.setLevelAssignments(xml.isLevelAssignments());
        mpx.setLevelingCanSplit(xml.isLevelingCanSplit());
        mpx.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(xml.getLevelingDelayFormat()));
        if (xml.getLevelingDelay() != null && mpx.getLevelingDelayFormat() != null) {
            mpx.setLevelingDelay(Duration.getInstance(xml.getLevelingDelay().doubleValue(), mpx.getLevelingDelayFormat()));
        }
        mpx.setMilestone(xml.isMilestone());
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNull(xml.isIsNull());
        mpx.setOutlineLevel(NumberUtility.getInteger(xml.getOutlineLevel()));
        mpx.setOutlineNumber(xml.getOutlineNumber());
        mpx.setOverAllocated(xml.isOverAllocated());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getOvertimeWork()));
        mpx.setPercentageComplete(xml.getPercentComplete());
        mpx.setPercentageWorkComplete(xml.getPercentWorkComplete());
        mpx.setPhysicalPercentComplete(NumberUtility.getInteger(xml.getPhysicalPercentComplete()));
        mpx.setPreleveledFinish(DatatypeConverter.parseDate(xml.getPreLeveledFinish()));
        mpx.setPreleveledStart(DatatypeConverter.parseDate(xml.getPreLeveledStart()));
        mpx.setPriority(DatatypeConverter.parsePriority(xml.getPriority()));
        mpx.setRecurring(xml.isRecurring());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRemainingDuration()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRemainingOvertimeWork()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRemainingWork()));
        mpx.setResume(DatatypeConverter.parseDate(xml.getResume()));
        mpx.setResumeValid(xml.isResumeValid());
        mpx.setRollup(xml.isRollup());
        mpx.setStart(DatatypeConverter.parseDate(xml.getStart()));
        mpx.setStartVariance(DatatypeConverter.parseDurationInMinutes(xml.getStartVariance()));
        mpx.setStop(DatatypeConverter.parseDate(xml.getStop()));
        mpx.setSubProject(xml.isIsSubproject() ? new SubProject() : null);
        mpx.setSubprojectName(xml.getSubprojectName());
        mpx.setSubprojectReadOnly(xml.isIsSubprojectReadOnly());
        mpx.setSummary(xml.isSummary());
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberUtility.getInteger(xml.getUID()));
        mpx.setWBS(xml.getWBS());
        mpx.setWBSLevel(xml.getWBSLevel());
        mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getWork()));
        mpx.setWorkVariance(Duration.getInstance(NumberUtility.getDouble(xml.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
        mpx.setTotalSlack(DatatypeConverter.parseDurationInMinutes(xml.getTotalSlack()));
        mpx.setCritical(xml.isCritical());
        this.readTaskExtendedAttributes(xml, mpx);
        this.m_projectFile.fireTaskReadEvent(mpx);
    }

    private void readTaskExtendedAttributes(ProjectType.TasksType.TaskType xml, Task mpx) {
        List extendedAttributes = xml.getExtendedAttribute();
        for (ProjectType.TasksType.TaskType.ExtendedAttributeType attrib : extendedAttributes) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            TaskField mpxFieldID = MPPTaskField.getInstance(xmlFieldID);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID);
        }
    }

    private ProjectCalendar getTaskCalendar(ProjectType.TasksType.TaskType task) {
        ProjectCalendar calendar = null;
        BigInteger calendarID = task.getCalendarUID();
        if (calendarID != null) {
            calendar = this.m_projectFile.getBaseCalendarByUniqueID(new Integer(calendarID.intValue()));
        }
        return calendar;
    }

    private void readPredecessors(ProjectType.TasksType.TaskType task) {
        Task currTask;
        Integer uid = task.getUID();
        if (uid != null && (currTask = this.m_projectFile.getTaskByUniqueID(uid)) != null) {
            List predecessors = task.getPredecessorLink();
            Iterator iter = predecessors.iterator();
            while (iter.hasNext()) {
                this.readPredecessor(currTask, (ProjectType.TasksType.TaskType.PredecessorLinkType)iter.next());
            }
        }
    }

    private void readPredecessor(Task currTask, ProjectType.TasksType.TaskType.PredecessorLinkType link) {
        Task prevTask;
        BigInteger uid = link.getPredecessorUID();
        if (uid != null && (prevTask = this.m_projectFile.getTaskByUniqueID(new Integer(uid.intValue()))) != null) {
            RelationType type = link.getType() != null ? RelationType.getInstance(link.getType().intValue()) : RelationType.FINISH_START;
            int lag = link.getLinkLag() != null ? link.getLinkLag().intValue() / 600 : 0;
            Relation rel = currTask.addPredecessor(prevTask);
            rel.setType(type);
            rel.setDuration(Duration.getInstance(lag, TimeUnit.HOURS));
        }
    }

    private void readAssignments(Project project) {
        ProjectType.AssignmentsType assignments = project.getAssignments();
        if (assignments != null) {
            List assignment = assignments.getAssignment();
            Iterator iter = assignment.iterator();
            while (iter.hasNext()) {
                this.readAssignment((ProjectType.AssignmentsType.AssignmentType)iter.next());
            }
        }
    }

    private void readAssignment(ProjectType.AssignmentsType.AssignmentType assignment) {
        BigInteger taskUID = assignment.getTaskUID();
        BigInteger resourceUID = assignment.getResourceUID();
        if (taskUID != null && resourceUID != null) {
            Task task = this.m_projectFile.getTaskByUniqueID(new Integer(taskUID.intValue()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(new Integer(resourceUID.intValue()));
            if (task != null && resource != null) {
                ResourceAssignment mpx = task.addResourceAssignment(resource);
                mpx.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
                mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
                mpx.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
                mpx.setDelay(DatatypeConverter.parseDurationInMinutes(assignment.getDelay()));
                mpx.setFinish(DatatypeConverter.parseDate(assignment.getFinish()));
                mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
                mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
                mpx.setStart(DatatypeConverter.parseDate(assignment.getStart()));
                mpx.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
                mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
                mpx.setWorkContour(assignment.getWorkContour());
            }
        }
    }

    private void removeEmptyElementNodes(Node parent, Node node) {
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            for (int loop = 0; loop < list.getLength(); ++loop) {
                this.removeEmptyElementNodes(node, list.item(loop));
            }
        } else if (node.getNodeType() == 1) {
            parent.removeChild(node);
        }
    }

    public void setMicrosoftProjectCompatibleInput(boolean flag) {
        this.m_compatibleInput = flag;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }
}

