/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.AccrueType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.DateRange;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Day;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ExtendedAttributeResourceFields;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ExtendedAttributeTaskFields;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPPTaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarHours;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RelationType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ScheduleFrom;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.DatatypeConverter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.ObjectFactory;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.Project;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.ProjectType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.NumberUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.writer.AbstractProjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public final class MSPDIWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private static final BigInteger BIGINTEGER_ZERO = BigInteger.valueOf(0L);
    private static final Integer NULL_RESOURCE_ID = new Integer(-65535);

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            JAXBContext context = JAXBContext.newInstance((String)"com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ObjectFactory factory = new ObjectFactory();
            Project project = factory.createProject();
            this.writeProjectHeader(project);
            this.writeProjectExtendedAttributes(factory, project);
            this.writeCalendars(factory, project);
            this.writeResources(factory, project);
            this.writeTasks(factory, project);
            this.writeAssignments(factory, project);
            DatatypeConverter.setParentFile(this.m_projectFile);
            marshaller.marshal((Object)project, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void writeProjectHeader(Project project) {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        project.setActualsInSync(header.getActualsInSync());
        project.setAdminProject(header.getAdminProject());
        project.setAuthor(header.getAuthor());
        project.setAutoAddNewResourcesAndTasks(header.getAutoAddNewResourcesAndTasks());
        project.setAutolink(header.getAutolink());
        project.setBaselineForEarnedValue(NumberUtility.getBigInteger(header.getBaselineForEarnedValue()));
        project.setCalendarUID(BigInteger.ONE);
        project.setCategory(header.getCategory());
        project.setCompany(header.getCompany());
        project.setCreationDate(DatatypeConverter.printDate(header.getCreationDate()));
        project.setCriticalSlackLimit(NumberUtility.getBigInteger(header.getCriticalSlackLimit()));
        project.setCurrencyDigits(BigInteger.valueOf(header.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(header.getCurrencySymbol());
        project.setCurrencySymbolPosition(header.getSymbolPosition());
        project.setCurrentDate(DatatypeConverter.printDate(header.getCurrentDate()));
        project.setDaysPerMonth(NumberUtility.getBigInteger(header.getDaysPerMonth()));
        project.setDefaultFinishTime(DatatypeConverter.printTime(header.getDefaultEndTime()));
        project.setDefaultFixedCostAccrual(header.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(header.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(header.getDefaultStandardRate()));
        project.setDefaultStartTime(DatatypeConverter.printTime(header.getDefaultStartTime()));
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(header.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(header.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(header.getDefaultDurationUnits()));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(header.getEarnedValueMethod()));
        project.setEditableActualCosts(header.getEditableActualCosts());
        project.setExtendedCreationDate(DatatypeConverter.printDate(header.getExtendedCreationDate()));
        project.setFinishDate(DatatypeConverter.printDate(header.getFinishDate()));
        project.setFiscalYearStart(header.getFiscalYearStart());
        project.setFYStartDate(NumberUtility.getBigInteger(header.getFiscalYearStartMonth()));
        project.setHonorConstraints(header.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(header.getInsertedProjectsLikeSummary());
        project.setLastSaved(DatatypeConverter.printDate(header.getLastSaved()));
        project.setManager(header.getManager());
        project.setMicrosoftProjectServerURL(header.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberUtility.getBigInteger(header.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberUtility.getBigInteger(header.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(header.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(header.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(header.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(header.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(header.getMultipleCriticalPaths());
        project.setName(header.getName());
        project.setNewTasksEffortDriven(header.getNewTasksEffortDriven());
        project.setNewTasksEstimated(header.getNewTasksEstimated());
        project.setNewTaskStartDate(header.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setProjectExternallyEdited(header.getProjectExternallyEdited());
        project.setRemoveFileProperties(header.getRemoveFileProperties());
        project.setRevision(NumberUtility.getBigInteger(header.getRevision()));
        project.setScheduleFromStart(header.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(header.getSplitInProgressTasks());
        project.setSpreadActualCost(header.getSpreadActualCost());
        project.setSpreadPercentComplete(header.getSpreadPercentComplete());
        project.setStartDate(DatatypeConverter.printDate(header.getStartDate()));
        project.setStatusDate(DatatypeConverter.printDate(header.getStatusDate()));
        project.setSubject(header.getSubject());
        project.setTaskUpdatesResource(header.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(header.getProjectTitle());
        project.setUID(header.getUniqueID());
        project.setWeekStartDay(DatatypeConverter.printDay(header.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(header.getDefaultWorkUnits()));
    }

    private void writeProjectExtendedAttributes(ObjectFactory factory, Project project) throws JAXBException {
        ProjectType.ExtendedAttributesType attributes = factory.createProjectTypeExtendedAttributesType();
        project.setExtendedAttributes(attributes);
        List list = attributes.getExtendedAttribute();
        this.writeTaskFieldAliases(factory, list);
        this.writeResourceFieldAliases(factory, list);
    }

    private void writeTaskFieldAliases(ObjectFactory factory, List list) throws JAXBException {
        Map fieldAliasMap = this.m_projectFile.getTaskFieldAliasMap();
        for (int loop = 0; loop < ExtendedAttributeTaskFields.getFIELD_ARRAY().length; ++loop) {
            TaskField key = ExtendedAttributeTaskFields.getFIELD_ARRAY()[loop];
            Integer fieldID = new Integer(MPPTaskField.getID(key) | 0xB400000);
            String name = key.getName();
            String alias = (String)fieldAliasMap.get(key);
            ProjectType.ExtendedAttributesType.ExtendedAttributeType attribute = factory.createProjectTypeExtendedAttributesTypeExtendedAttributeType();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeResourceFieldAliases(ObjectFactory factory, List list) throws JAXBException {
        Map fieldAliasMap = this.m_projectFile.getResourceFieldAliasMap();
        for (int loop = 0; loop < ExtendedAttributeResourceFields.getFIELD_ARRAY().length; ++loop) {
            ResourceField key = ExtendedAttributeResourceFields.getFIELD_ARRAY()[loop];
            Integer fieldID = new Integer(MPPResourceField.getID(key) | 0xC400000);
            String name = key.getName();
            String alias = (String)fieldAliasMap.get(key);
            ProjectType.ExtendedAttributesType.ExtendedAttributeType attribute = factory.createProjectTypeExtendedAttributesTypeExtendedAttributeType();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeCalendars(ObjectFactory factory, Project project) throws JAXBException {
        ProjectCalendar cal;
        LinkedList<ProjectCalendar> calendarList = new LinkedList<ProjectCalendar>(this.m_projectFile.getBaseCalendars());
        Iterator iter = this.m_projectFile.getAllResources().iterator();
        while (iter.hasNext()) {
            cal = ((Resource)iter.next()).getResourceCalendar();
            if (cal == null) continue;
            calendarList.add(cal);
        }
        ProjectType.CalendarsType calendars = factory.createProjectTypeCalendarsType();
        project.setCalendars(calendars);
        List calendar = calendars.getCalendar();
        iter = calendarList.iterator();
        factory.createProjectTypeCalendarsTypeCalendarType();
        while (iter.hasNext()) {
            cal = (ProjectCalendar)iter.next();
            calendar.add(this.writeCalendar(factory, cal));
        }
    }

    private ProjectType.CalendarsType.CalendarType writeCalendar(ObjectFactory factory, ProjectCalendar bc) throws JAXBException {
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType time;
        List timesList;
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType times;
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType day;
        ProjectCalendar base;
        ProjectType.CalendarsType.CalendarType calendar = factory.createProjectTypeCalendarsTypeCalendarType();
        calendar.setUID(NumberUtility.getBigInteger(bc.getUniqueID()));
        calendar.setIsBaseCalendar(bc.isBaseCalendar());
        if (!bc.isBaseCalendar() && (base = bc.getBaseCalendar()) != null) {
            calendar.setBaseCalendarUID(NumberUtility.getBigInteger(base.getUniqueID()));
        }
        calendar.setName(bc.getName());
        ProjectType.CalendarsType.CalendarType.WeekDaysType days = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysType();
        calendar.setWeekDays(days);
        List dayList = days.getWeekDay();
        for (int loop = 1; loop < 8; ++loop) {
            int workingFlag = bc.getWorkingDay(Day.getInstance(loop));
            if (workingFlag == 2) continue;
            day = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayType();
            dayList.add(day);
            day.setDayType(BigInteger.valueOf(loop));
            day.setDayWorking(workingFlag == 1);
            if (workingFlag != 1) continue;
            times = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesType();
            day.setWorkingTimes(times);
            timesList = times.getWorkingTime();
            ProjectCalendarHours bch = bc.getCalendarHours(Day.getInstance(loop));
            if (bch == null) continue;
            Iterator rangeIter = bch.iterator();
            while (rangeIter.hasNext()) {
                DateRange range = (DateRange)rangeIter.next();
                if (range == null) continue;
                time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStartDate()));
                time.setToTime(DatatypeConverter.printTime(range.getEndDate()));
            }
        }
        ArrayList exceptions = new ArrayList(bc.getCalendarExceptions());
        Collections.sort(exceptions);
        for (ProjectCalendarException exception : exceptions) {
            boolean working = exception.getWorking();
            day = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayType();
            dayList.add(day);
            day.setDayType(BIGINTEGER_ZERO);
            day.setDayWorking(working);
            ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.TimePeriodType period = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeTimePeriodType();
            day.setTimePeriod(period);
            period.setFromDate(DatatypeConverter.printDate(exception.getFromDate()));
            period.setToDate(DatatypeConverter.printDate(exception.getToDate()));
            if (!working) continue;
            times = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesType();
            day.setWorkingTimes(times);
            timesList = times.getWorkingTime();
            time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
            timesList.add(time);
            time.setFromTime(DatatypeConverter.printTime(exception.getFromTime1()));
            time.setToTime(DatatypeConverter.printTime(exception.getToTime1()));
            time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
            timesList.add(time);
            time.setFromTime(DatatypeConverter.printTime(exception.getFromTime2()));
            time.setToTime(DatatypeConverter.printTime(exception.getToTime2()));
            time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
            timesList.add(time);
            time.setFromTime(DatatypeConverter.printTime(exception.getFromTime3()));
            time.setToTime(DatatypeConverter.printTime(exception.getToTime3()));
        }
        return calendar;
    }

    private void writeResources(ObjectFactory factory, Project project) throws JAXBException {
        ProjectType.ResourcesType resources = factory.createProjectTypeResourcesType();
        project.setResources(resources);
        List list = resources.getResource();
        Iterator iter = this.m_projectFile.getAllResources().iterator();
        while (iter.hasNext()) {
            list.add(this.writeResource(factory, (Resource)iter.next()));
        }
    }

    private ProjectType.ResourcesType.ResourceType writeResource(ObjectFactory factory, Resource mpx) throws JAXBException {
        ProjectType.ResourcesType.ResourceType xml = factory.createProjectTypeResourcesTypeResourceType();
        ProjectCalendar cal = mpx.getResourceCalendar();
        if (cal != null) {
            xml.setCalendarUID(NumberUtility.getBigInteger(cal.getUniqueID()));
        }
        xml.setAccrueAt(mpx.getAccrueAt());
        xml.setActiveDirectoryGUID(mpx.getActiveDirectoryGUID());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setAvailableFrom(DatatypeConverter.printDate(mpx.getAvailableFrom()));
        xml.setAvailableTo(DatatypeConverter.printDate(mpx.getAvailableTo()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBookingType(mpx.getBookingType());
        xml.setCanLevel(mpx.getCanLevel());
        xml.setCode(mpx.getCode());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCostPerUse(DatatypeConverter.printCurrency(mpx.getCostPerUse()));
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setCreationDate(DatatypeConverter.printDate(mpx.getCreationDate()));
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setEmailAddress(mpx.getEmailAddress());
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setGroup(mpx.getGroup());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberUtility.getBigInteger(mpx.getID()));
        xml.setInitials(mpx.getInitials());
        xml.setIsEnterprise(mpx.getEnterprise());
        xml.setIsGeneric(mpx.getGeneric());
        xml.setIsInactive(mpx.getInactive());
        xml.setIsNull(mpx.getNull());
        xml.setMaterialLabel(mpx.getMaterialLabel());
        xml.setMaxUnits(DatatypeConverter.printUnits(mpx.getMaxUnits()));
        xml.setName(mpx.getName());
        xml.setNotes(mpx.getNotes());
        xml.setNTAccount(mpx.getNtAccount());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeRate(DatatypeConverter.printRate(mpx.getOvertimeRate()));
        xml.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(mpx.getOvertimeRateFormat()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPeakUnits(DatatypeConverter.printUnits(mpx.getPeakUnits()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentWorkComplete()));
        xml.setPhonetics(mpx.getPhonetics());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setStandardRate(DatatypeConverter.printRate(mpx.getStandardRate()));
        xml.setStandardRateFormat(DatatypeConverter.printTimeUnit(mpx.getStandardRateFormat()));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setType(mpx.getType());
        xml.setUID(mpx.getUniqueID());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkGroup(mpx.getWorkGroup());
        xml.setWorkVariance(new BigDecimal(DatatypeConverter.printDurationInMinutes(mpx.getWorkVariance()) * 1000.0));
        this.writeResourceExtendedAttributes(factory, xml, mpx);
        return xml;
    }

    private void writeResourceExtendedAttributes(ObjectFactory factory, ProjectType.ResourcesType.ResourceType xml, Resource mpx) throws JAXBException {
        List extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeResourceFields.getFIELD_ARRAY().length; ++loop) {
            ResourceField mpxFieldID = ExtendedAttributeResourceFields.getFIELD_ARRAY()[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (value == null) continue;
            Integer xmlFieldID = new Integer(MPPResourceField.getID(mpxFieldID) | 0xC400000);
            ProjectType.ResourcesType.ResourceType.ExtendedAttributeType attrib = factory.createProjectTypeResourcesTypeResourceTypeExtendedAttributeType();
            extendedAttributes.add(attrib);
            attrib.setUID(BigInteger.valueOf(loop + 1));
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private void writeTasks(ObjectFactory factory, Project project) throws JAXBException {
        ProjectType.TasksType tasks = factory.createProjectTypeTasksType();
        project.setTasks(tasks);
        List list = tasks.getTask();
        Iterator iter = this.m_projectFile.getAllTasks().iterator();
        while (iter.hasNext()) {
            list.add(this.writeTask(factory, (Task)iter.next()));
        }
    }

    private ProjectType.TasksType.TaskType writeTask(ObjectFactory factory, Task mpx) throws JAXBException {
        ProjectType.TasksType.TaskType xml = factory.createProjectTypeTasksTypeTaskType();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualDuration(DatatypeConverter.printDuration(this, mpx.getActualDuration()));
        xml.setActualFinish(DatatypeConverter.printDate(mpx.getActualFinish()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualStart(DatatypeConverter.printDate(mpx.getActualStart()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setCalendarUID(this.getTaskCalendarID(mpx));
        xml.setConstraintDate(DatatypeConverter.printDate(mpx.getConstraintDate()));
        xml.setConstraintType(DatatypeConverter.printConstraintType(mpx.getConstraintType()));
        xml.setContact(mpx.getContact());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCreateDate(DatatypeConverter.printDate(mpx.getCreateDate()));
        xml.setCritical(mpx.getCritical());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDeadline(DatatypeConverter.printDate(mpx.getDeadline()));
        xml.setDuration(DatatypeConverter.printDuration(this, mpx.getDuration()));
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDurationFormat()));
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDuration()));
        xml.setEarlyFinish(DatatypeConverter.printDate(mpx.getEarlyFinish()));
        xml.setEarlyStart(DatatypeConverter.printDate(mpx.getEarlyStart()));
        xml.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(mpx.getEarnedValueMethod()));
        xml.setEffortDriven(mpx.getEffortDriven());
        xml.setEstimated(mpx.getEstimated());
        xml.setExternalTask(mpx.getExternalTask());
        xml.setExternalTaskProject(mpx.getProject());
        Date finishDate = mpx.getFinish();
        if (finishDate != null) {
            xml.setFinish(DatatypeConverter.printDate(finishDate));
        }
        xml.setFinishVariance(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getFinishVariance()) * 1000L));
        xml.setFixedCost(DatatypeConverter.printCurrency(mpx.getFixedCost()));
        AccrueType fixedCostAccrual = mpx.getFixedCostAccrual();
        if (fixedCostAccrual == null) {
            fixedCostAccrual = AccrueType.PRORATED;
        }
        xml.setFixedCostAccrual(fixedCostAccrual);
        xml.setFreeSlack(BIGINTEGER_ZERO);
        xml.setHideBar(mpx.getHideBar());
        xml.setIsNull(mpx.getNull());
        xml.setIsSubproject(mpx.getSubProject() != null);
        xml.setIsSubprojectReadOnly(mpx.getSubprojectReadOnly());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberUtility.getBigInteger(mpx.getID()));
        xml.setIgnoreResourceCalendar(mpx.getIgnoreResourceCalendar());
        xml.setLateFinish(DatatypeConverter.printDate(mpx.getLateFinish()));
        xml.setLateStart(DatatypeConverter.printDate(mpx.getLateStart()));
        xml.setLevelAssignments(mpx.getLevelAssignments());
        xml.setLevelingCanSplit(mpx.getLevelingCanSplit());
        if (mpx.getLevelingDelay() != null) {
            xml.setLevelingDelay(BigInteger.valueOf((long)mpx.getLevelingDelay().getDuration()));
            xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelayFormat()));
        }
        xml.setMilestone(mpx.getMilestone());
        xml.setName(mpx.getName());
        xml.setNotes(mpx.getNotes());
        xml.setOutlineLevel(NumberUtility.getBigInteger(mpx.getOutlineLevel()));
        xml.setOutlineNumber(mpx.getOutlineNumber());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentComplete(NumberUtility.getBigInteger(mpx.getPercentageComplete()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentageWorkComplete()));
        xml.setPhysicalPercentComplete(NumberUtility.getBigInteger(mpx.getPhysicalPercentComplete()));
        xml.setPriority(DatatypeConverter.printPriority(mpx.getPriority()));
        xml.setRecurring(mpx.getRecurring());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        if (mpx.getRemainingDuration() == null) {
            Duration duration = mpx.getDuration();
            if (duration != null) {
                double amount = duration.getDuration();
                amount -= amount * NumberUtility.getDouble(mpx.getPercentageComplete()) / 100.0;
                xml.setRemainingDuration(DatatypeConverter.printDuration(this, Duration.getInstance(amount, duration.getUnits())));
            }
        } else {
            xml.setRemainingDuration(DatatypeConverter.printDuration(this, mpx.getRemainingDuration()));
        }
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResume(DatatypeConverter.printDate(mpx.getResume()));
        xml.setResumeValid(mpx.getResumeValid());
        xml.setRollup(mpx.getRollup());
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setStartVariance(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getStartVariance()) * 1000L));
        xml.setStop(DatatypeConverter.printDate(mpx.getStop()));
        xml.setSubprojectName(mpx.getSubprojectName());
        xml.setSummary(mpx.getSummary());
        xml.setTotalSlack(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getTotalSlack()) * 1000L));
        xml.setType(mpx.getType());
        xml.setUID(mpx.getUniqueID());
        xml.setWBS(mpx.getWBS());
        xml.setWBSLevel(mpx.getWBSLevel());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkVariance(new BigDecimal(DatatypeConverter.printDurationInMinutes(mpx.getWorkVariance()) * 1000.0));
        this.writePredecessors(factory, xml, mpx);
        this.writeTaskExtendedAttributes(factory, xml, mpx);
        return xml;
    }

    private void writeTaskExtendedAttributes(ObjectFactory factory, ProjectType.TasksType.TaskType xml, Task mpx) throws JAXBException {
        List extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeTaskFields.getFIELD_ARRAY().length; ++loop) {
            TaskField mpxFieldID = ExtendedAttributeTaskFields.getFIELD_ARRAY()[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (value == null) continue;
            Integer xmlFieldID = new Integer(MPPTaskField.getID(mpxFieldID) | 0xB400000);
            ProjectType.TasksType.TaskType.ExtendedAttributeType attrib = factory.createProjectTypeTasksTypeTaskTypeExtendedAttributeType();
            extendedAttributes.add(attrib);
            attrib.setUID(BigInteger.valueOf(loop + 1));
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private BigInteger printExtendedAttributeDurationFormat(Object value) {
        BigInteger result = null;
        if (value instanceof Duration) {
            result = DatatypeConverter.printDurationTimeUnits(((Duration)value).getUnits());
        }
        return result;
    }

    private BigInteger getTaskCalendarID(Task mpx) {
        BigInteger result = null;
        ProjectCalendar cal = mpx.getCalendar();
        result = cal != null ? NumberUtility.getBigInteger(cal.getUniqueID()) : BigInteger.valueOf(-1L);
        return result;
    }

    private void writePredecessors(ObjectFactory factory, ProjectType.TasksType.TaskType xml, Task mpx) throws JAXBException {
        Integer taskID;
        TreeSet<Integer> set = new TreeSet<Integer>();
        List list = xml.getPredecessorLink();
        List predecessors = mpx.getUniqueIDPredecessors();
        if (predecessors != null) {
            for (Relation rel : predecessors) {
                taskID = rel.getTaskID();
                set.add(taskID);
                list.add(this.writePredecessor(factory, taskID, rel.getType(), rel.getDuration()));
            }
        }
        if ((predecessors = mpx.getPredecessors()) != null) {
            for (Relation rel : predecessors) {
                Task task = this.m_projectFile.getTaskByID(rel.getTaskID());
                if (task == null || set.contains(taskID = task.getUniqueID())) continue;
                list.add(this.writePredecessor(factory, taskID, rel.getType(), rel.getDuration()));
            }
        }
    }

    private ProjectType.TasksType.TaskType.PredecessorLinkType writePredecessor(ObjectFactory factory, Integer taskID, RelationType type, Duration lag) throws JAXBException {
        ProjectType.TasksType.TaskType.PredecessorLinkType link = factory.createProjectTypeTasksTypeTaskTypePredecessorLinkType();
        link.setPredecessorUID(NumberUtility.getBigInteger(taskID));
        link.setType(BigInteger.valueOf(type.getType()));
        if (lag != null && lag.getDuration() != 0.0) {
            link.setLinkLag(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(lag) * 10L));
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(lag.getUnits()));
        }
        return link;
    }

    private void writeAssignments(ObjectFactory factory, Project project) throws JAXBException {
        int uid = 0;
        ProjectType.AssignmentsType assignments = factory.createProjectTypeAssignmentsType();
        project.setAssignments(assignments);
        List list = assignments.getAssignment();
        Iterator iter = this.m_projectFile.getAllResourceAssignments().iterator();
        while (iter.hasNext()) {
            list.add(this.writeAssignment(factory, (ResourceAssignment)iter.next(), uid));
            ++uid;
        }
        for (Task task : this.m_projectFile.getAllTasks()) {
            double percentComplete = NumberUtility.getDouble(task.getPercentageComplete());
            if (percentComplete == 0.0 || !task.getResourceAssignments().isEmpty()) continue;
            ResourceAssignment dummy = this.m_projectFile.newResourceAssignment(task);
            Duration duration = task.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            double durationValue = duration.getDuration();
            TimeUnit durationUnits = duration.getUnits();
            double actualWork = durationValue * percentComplete / 100.0;
            double remainingWork = durationValue - actualWork;
            dummy.setResourceUniqueID(NULL_RESOURCE_ID);
            dummy.setWork(duration);
            dummy.setActualWork(Duration.getInstance(actualWork, durationUnits));
            dummy.setRemainingWork(Duration.getInstance(remainingWork, durationUnits));
            list.add(this.writeAssignment(factory, dummy, uid));
            ++uid;
        }
    }

    private ProjectType.AssignmentsType.AssignmentType writeAssignment(ObjectFactory factory, ResourceAssignment mpx, int uid) throws JAXBException {
        ProjectType.AssignmentsType.AssignmentType xml = factory.createProjectTypeAssignmentsTypeAssignmentType();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setDelay(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getDelay()) * 1000L));
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResourceUID(BigInteger.valueOf(NumberUtility.getInt(mpx.getResourceUniqueID())));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setTaskUID(NumberUtility.getBigInteger(mpx.getTask().getUniqueID()));
        xml.setUID(BigInteger.valueOf(uid));
        xml.setUnits(DatatypeConverter.printUnits(mpx.getUnits()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkContour(mpx.getWorkContour());
        return xml;
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }
}

