/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime.GrammarInfo;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime.UnmarshallableObject;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime.UnmarshallingContext;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime.UnmarshallingEventHandler;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime.ValidatableObject;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.schema.impl.runtime.XMLSerializable;
import com.sun.msv.grammar.Grammar;
import com.sun.xml.bind.GrammarImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

public class GrammarInfoImpl
implements GrammarInfo {
    private final Map rootTagMap;
    private final Class objectFactoryClass;
    private final Map defaultImplementationMap;
    private final ClassLoader classLoader;

    public GrammarInfoImpl(Map _rootTagMap, Map _defaultImplementationMap, Class _objectFactoryClass) {
        this.rootTagMap = _rootTagMap;
        this.defaultImplementationMap = _defaultImplementationMap;
        this.objectFactoryClass = _objectFactoryClass;
        this.classLoader = this.objectFactoryClass.getClassLoader();
    }

    private final Class lookupRootMap(String nsUri, String localName) {
        QName qn = new QName(nsUri, localName);
        if (this.rootTagMap.containsKey(qn)) {
            return (Class)this.rootTagMap.get(qn);
        }
        qn = new QName(nsUri, "*");
        if (this.rootTagMap.containsKey(qn)) {
            return (Class)this.rootTagMap.get(qn);
        }
        qn = new QName("*", "*");
        return (Class)this.rootTagMap.get(qn);
    }

    @Override
    public final Class getRootElement(String namespaceUri, String localName) {
        Class intfCls = this.lookupRootMap(namespaceUri, localName);
        if (intfCls == null) {
            return null;
        }
        return this.getDefaultImplementation(intfCls);
    }

    @Override
    public final UnmarshallingEventHandler createUnmarshaller(String namespaceUri, String localName, UnmarshallingContext context) {
        Class impl = this.getRootElement(namespaceUri, localName);
        if (impl == null) {
            return null;
        }
        try {
            return ((UnmarshallableObject)impl.newInstance()).createUnmarshaller(context);
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.toString());
        }
    }

    @Override
    public final String[] getProbePoints() {
        ArrayList<String> r = new ArrayList<String>();
        for (QName qn : this.rootTagMap.keySet()) {
            r.add(qn.getNamespaceURI());
            r.add(qn.getLocalPart());
        }
        return r.toArray(new String[r.size()]);
    }

    @Override
    public final boolean recognize(String nsUri, String localName) {
        return this.lookupRootMap(nsUri, localName) != null;
    }

    @Override
    public final Class getDefaultImplementation(Class javaContentInterface) {
        try {
            return Class.forName((String)this.defaultImplementationMap.get(javaContentInterface), true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
    }

    @Override
    public final Grammar getGrammar() throws JAXBException {
        ObjectInputStream ois = null;
        try {
            InputStream is = this.objectFactoryClass.getResourceAsStream("bgm.ser");
            if (is == null) {
                String name = this.objectFactoryClass.getName();
                int idx = name.lastIndexOf(46);
                name = '/' + name.substring(0, idx + 1).replace('.', '/') + "bgm.ser";
                throw new JAXBException("unable to locate " + name + ". Check if this file is in the classpath.");
            }
            ois = new ObjectInputStream(is);
            GrammarImpl g = (GrammarImpl)ois.readObject();
            ois.close();
            g.connect(new Grammar[]{g});
            GrammarImpl grammarImpl = g;
            return grammarImpl;
        }
        catch (Exception e) {
            throw new JAXBException("unable to extract the schema information", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                    ois = null;
                }
                catch (IOException e) {
                    throw new JAXBException("unable to extract the schema information", (Throwable)e);
                }
            }
        }
    }

    @Override
    public XMLSerializable castToXMLSerializable(Object o) {
        if (o instanceof XMLSerializable) {
            return (XMLSerializable)o;
        }
        return null;
    }

    @Override
    public ValidatableObject castToValidatableObject(Object o) {
        if (o instanceof ValidatableObject) {
            return (ValidatableObject)o;
        }
        return null;
    }
}

