/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.planner;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.ConstraintType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.DateRange;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.MPXJException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarHours;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RelationType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Allocation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Allocations;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Calendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Calendars;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Constraint;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Day;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.DayType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.DayTypes;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Days;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.DefaultWeek;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Interval;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.ObjectFactory;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.OverriddenDayType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.OverriddenDayTypes;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Predecessor;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Predecessors;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Project;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Resources;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema.Tasks;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.DateUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.Sequence;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.writer.AbstractProjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public final class PlannerWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private Project m_plannerProject;
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private static Map RELATIONSHIP_TYPES = new HashMap();

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            JAXBContext context = JAXBContext.newInstance((String)"com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.schema");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
            this.m_factory = new ObjectFactory();
            this.m_plannerProject = this.m_factory.createProject();
            this.writeProjectHeader();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            marshaller.marshal((Object)this.m_plannerProject, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_plannerProject = null;
        }
    }

    private void writeProjectHeader() {
        ProjectHeader mpxjHeader = this.m_projectFile.getProjectHeader();
        this.m_plannerProject.setCompany(mpxjHeader.getCompany());
        this.m_plannerProject.setManager(mpxjHeader.getManager());
        this.m_plannerProject.setName(this.getString(mpxjHeader.getName()));
        this.m_plannerProject.setProjectStart(this.getDateTime(mpxjHeader.getStartDate()));
        this.m_plannerProject.setMrprojectVersion("2");
    }

    private void writeCalendars() throws JAXBException {
        Calendars calendars = this.m_factory.createCalendars();
        this.m_plannerProject.setCalendars(calendars);
        this.writeDayTypes(calendars);
        List calendar = calendars.getCalendar();
        for (ProjectCalendar mpxjCalendar : this.m_projectFile.getBaseCalendars()) {
            Calendar plannerCalendar = this.m_factory.createCalendar();
            calendar.add(plannerCalendar);
            this.writeCalendar(mpxjCalendar, plannerCalendar);
        }
    }

    private void writeDayTypes(Calendars calendars) throws JAXBException {
        DayTypes dayTypes = this.m_factory.createDayTypes();
        calendars.setDayTypes(dayTypes);
        List typeList = dayTypes.getDayType();
        DayType dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("0");
        dayType.setName("Working");
        dayType.setDescription("A default working day");
        dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("1");
        dayType.setName("Nonworking");
        dayType.setDescription("A default non working day");
        dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("2");
        dayType.setName("Use base");
        dayType.setDescription("Use day from base calendar");
    }

    private void writeCalendar(ProjectCalendar mpxjCalendar, Calendar plannerCalendar) throws JAXBException {
        plannerCalendar.setId(this.getIntegerString(mpxjCalendar.getUniqueID()));
        plannerCalendar.setName(this.getString(mpxjCalendar.getName()));
        DefaultWeek dw = this.m_factory.createDefaultWeek();
        plannerCalendar.setDefaultWeek(dw);
        dw.setMon(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.MONDAY));
        dw.setTue(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.TUESDAY));
        dw.setWed(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.WEDNESDAY));
        dw.setThu(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.THURSDAY));
        dw.setFri(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.FRIDAY));
        dw.setSat(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.SATURDAY));
        dw.setSun(this.getWorkingDayString(mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.SUNDAY));
        OverriddenDayTypes odt = this.m_factory.createOverriddenDayTypes();
        plannerCalendar.setOverriddenDayTypes(odt);
        List typeList = odt.getOverriddenDayType();
        Sequence uniqueID = new Sequence(0);
        for (int dayLoop = 1; dayLoop < 8; ++dayLoop) {
            com.kingdee.eas.mm.project.client.net.sf.mpxj.Day day = com.kingdee.eas.mm.project.client.net.sf.mpxj.Day.getInstance(dayLoop);
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            this.processWorkingHours(mpxjCalendar, uniqueID, day, typeList);
            break;
        }
        Days plannerDays = this.m_factory.createDays();
        plannerCalendar.setDays(plannerDays);
        List dayList = plannerDays.getDay();
        this.processExceptionDays(mpxjCalendar, dayList);
        List calendarList = plannerCalendar.getCalendar();
        for (ProjectCalendar mpxjDerivedCalendar : mpxjCalendar.getDerivedCalendars()) {
            Calendar plannerDerivedCalendar = this.m_factory.createCalendar();
            calendarList.add(plannerDerivedCalendar);
            this.writeCalendar(mpxjDerivedCalendar, plannerDerivedCalendar);
        }
    }

    private void processWorkingHours(ProjectCalendar mpxjCalendar, Sequence uniqueID, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day day, List typeList) throws JAXBException {
        ProjectCalendarHours mpxjHours;
        if (this.isWorkingDay(mpxjCalendar, day) && (mpxjHours = mpxjCalendar.getCalendarHours(day)) != null) {
            OverriddenDayType odt = this.m_factory.createOverriddenDayType();
            typeList.add(odt);
            odt.setId(this.getIntegerString(uniqueID.next()));
            List intervalList = odt.getInterval();
            Iterator iter = mpxjHours.iterator();
            while (iter.hasNext()) {
                DateRange mpxjRange = (DateRange)iter.next();
                Interval interval = this.m_factory.createInterval();
                intervalList.add(interval);
                interval.setStart(this.getTimeString(mpxjRange.getStartDate()));
                interval.setEnd(this.getTimeString(mpxjRange.getEndDate()));
            }
        }
    }

    private void processExceptionDays(ProjectCalendar mpxjCalendar, List dayList) throws JAXBException {
        for (ProjectCalendarException mpxjCalendarException : mpxjCalendar.getCalendarExceptions()) {
            Date rangeStartDay = mpxjCalendarException.getFromDate();
            Date rangeEndDay = mpxjCalendarException.getToDate();
            if (DateUtility.getDayStartDate(rangeStartDay).getTime() == DateUtility.getDayEndDate(rangeEndDay).getTime()) {
                Day day = this.m_factory.createDay();
                dayList.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(mpxjCalendarException.getFromDate()));
                day.setId(mpxjCalendarException.getWorking() ? "0" : "1");
                continue;
            }
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(rangeStartDay);
            while (cal.getTime().getTime() < rangeEndDay.getTime()) {
                Day day = this.m_factory.createDay();
                dayList.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(cal.getTime()));
                day.setId(mpxjCalendarException.getWorking() ? "0" : "1");
                cal.add(6, 1);
            }
        }
    }

    private void writeResources() throws JAXBException {
        Resources resources = this.m_factory.createResources();
        this.m_plannerProject.setResources(resources);
        List resourceList = resources.getResource();
        for (com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource mpxjResource : this.m_projectFile.getAllResources()) {
            Resource plannerResource = this.m_factory.createResource();
            resourceList.add(plannerResource);
            this.writeResource(mpxjResource, plannerResource);
        }
    }

    private void writeResource(com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource mpxjResource, Resource plannerResource) {
        ProjectCalendar resourceCalendar = mpxjResource.getResourceCalendar();
        if (resourceCalendar != null) {
            plannerResource.setCalendar(this.getIntegerString(resourceCalendar.getUniqueID()));
        }
        plannerResource.setEmail(mpxjResource.getEmailAddress());
        plannerResource.setId(this.getIntegerString(mpxjResource.getUniqueID()));
        plannerResource.setName(mpxjResource.getName());
        plannerResource.setNote(mpxjResource.getNotes());
        plannerResource.setShortName(mpxjResource.getInitials());
        plannerResource.setType(mpxjResource.getType() == ResourceType.MATERIAL ? "2" : "1");
        plannerResource.setUnits("0");
    }

    private void writeTasks() throws JAXBException {
        Tasks tasks = this.m_factory.createTasks();
        this.m_plannerProject.setTasks(tasks);
        List taskList = tasks.getTask();
        Iterator iter = this.m_projectFile.getChildTasks().iterator();
        while (iter.hasNext()) {
            this.writeTask((com.kingdee.eas.mm.project.client.net.sf.mpxj.Task)iter.next(), taskList);
        }
    }

    private void writeTask(com.kingdee.eas.mm.project.client.net.sf.mpxj.Task mpxjTask, List taskList) throws JAXBException {
        Task plannerTask = this.m_factory.createTask();
        taskList.add(plannerTask);
        plannerTask.setEnd(this.getDateTimeString(mpxjTask.getFinish()));
        plannerTask.setId(this.getIntegerString(mpxjTask.getUniqueID()));
        plannerTask.setName(this.getString(mpxjTask.getName()));
        plannerTask.setNote(mpxjTask.getNotes());
        plannerTask.setPercentComplete(this.getIntegerString(mpxjTask.getPercentageWorkComplete()));
        plannerTask.setPriority(this.getIntegerString(mpxjTask.getPriority().getValue() * 10));
        plannerTask.setScheduling(this.getScheduling(mpxjTask.getType()));
        plannerTask.setStart(this.getDateTimeString(DateUtility.getDayStartDate(mpxjTask.getStart())));
        if (mpxjTask.getMilestone()) {
            plannerTask.setType("milestone");
        } else {
            plannerTask.setType("normal");
        }
        plannerTask.setWork(this.getDurationString(mpxjTask.getWork()));
        plannerTask.setWorkStart(this.getDateTimeString(mpxjTask.getStart()));
        ConstraintType mpxjConstraintType = mpxjTask.getConstraintType();
        if (mpxjConstraintType != ConstraintType.AS_SOON_AS_POSSIBLE) {
            Constraint plannerConstraint = this.m_factory.createConstraint();
            plannerTask.setConstraint(plannerConstraint);
            if (mpxjConstraintType == ConstraintType.START_NO_EARLIER_THAN) {
                plannerConstraint.setType("start-no-earlier-than");
            } else if (mpxjConstraintType == ConstraintType.MUST_START_ON) {
                plannerConstraint.setType("must-start-on");
            }
            plannerConstraint.setTime(this.getDateTimeString(mpxjTask.getConstraintDate()));
        }
        this.writePredecessors(mpxjTask, plannerTask);
        List childTaskList = plannerTask.getTask();
        Iterator iter = mpxjTask.getChildTasks().iterator();
        while (iter.hasNext()) {
            this.writeTask((com.kingdee.eas.mm.project.client.net.sf.mpxj.Task)iter.next(), childTaskList);
        }
    }

    private void writePredecessors(com.kingdee.eas.mm.project.client.net.sf.mpxj.Task mpxjTask, Task plannerTask) throws JAXBException {
        Integer taskID;
        TreeSet<Integer> set = new TreeSet<Integer>();
        Predecessors plannerPredecessors = this.m_factory.createPredecessors();
        plannerTask.setPredecessors(plannerPredecessors);
        List predecessorList = plannerPredecessors.getPredecessor();
        int id = 0;
        List predecessors = mpxjTask.getUniqueIDPredecessors();
        if (predecessors != null) {
            for (Relation rel : predecessors) {
                taskID = rel.getTaskUniqueID();
                set.add(taskID);
                Predecessor plannerPredecessor = this.m_factory.createPredecessor();
                plannerPredecessor.setId(this.getIntegerString(++id));
                plannerPredecessor.setPredecessorId(this.getIntegerString(taskID));
                plannerPredecessor.setLag(this.getDurationString(rel.getDuration()));
                plannerPredecessor.setType((String)RELATIONSHIP_TYPES.get(rel.getType()));
                predecessorList.add(plannerPredecessor);
            }
        }
        if ((predecessors = mpxjTask.getPredecessors()) != null) {
            for (Relation rel : predecessors) {
                com.kingdee.eas.mm.project.client.net.sf.mpxj.Task task = this.m_projectFile.getTaskByID(rel.getTaskID());
                if (task == null || set.contains(taskID = task.getUniqueID())) continue;
                Predecessor plannerPredecessor = this.m_factory.createPredecessor();
                plannerPredecessor.setId(this.getIntegerString(++id));
                plannerPredecessor.setPredecessorId(this.getIntegerString(taskID));
                plannerPredecessor.setLag(this.getDurationString(rel.getDuration()));
                plannerPredecessor.setType((String)RELATIONSHIP_TYPES.get(rel.getType()));
                predecessorList.add(plannerPredecessor);
            }
        }
    }

    private void writeAssignments() throws JAXBException {
        Allocations allocations = this.m_factory.createAllocations();
        this.m_plannerProject.setAllocations(allocations);
        List allocationList = allocations.getAllocation();
        for (ResourceAssignment mpxjAssignment : this.m_projectFile.getAllResourceAssignments()) {
            Allocation plannerAllocation = this.m_factory.createAllocation();
            allocationList.add(plannerAllocation);
            plannerAllocation.setTaskId(this.getIntegerString(mpxjAssignment.getTask().getUniqueID()));
            plannerAllocation.setResourceId(this.getIntegerString(mpxjAssignment.getResourceUniqueID()));
            plannerAllocation.setUnits(this.getIntegerString(mpxjAssignment.getUnits()));
        }
    }

    private String getDateTime(Date value) {
        StringBuffer result = new StringBuffer(16);
        if (value != null) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(value);
            result.append(this.m_fourDigitFormat.format(cal.get(1)));
            result.append(this.m_twoDigitFormat.format(cal.get(2) + 1));
            result.append(this.m_twoDigitFormat.format(cal.get(5)));
            result.append("T");
            result.append(this.m_twoDigitFormat.format(cal.get(11)));
            result.append(this.m_twoDigitFormat.format(cal.get(12)));
            result.append(this.m_twoDigitFormat.format(cal.get(13)));
            result.append("Z");
        }
        return result.toString();
    }

    private Date getDate(String value) throws MPXJException {
        try {
            Number year = this.m_fourDigitFormat.parse(value.substring(0, 4));
            Number month = this.m_twoDigitFormat.parse(value.substring(4, 6));
            Number day = this.m_twoDigitFormat.parse(value.substring(6, 8));
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.set(1, year.intValue());
            cal.set(2, month.intValue() - 1);
            cal.set(5, day.intValue());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse date " + value, ex);
        }
    }

    private Date getTime(String value) throws MPXJException {
        try {
            Number hours = this.m_twoDigitFormat.parse(value.substring(0, 2));
            Number minutes = this.m_twoDigitFormat.parse(value.substring(2, 4));
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.set(11, hours.intValue());
            cal.set(12, minutes.intValue());
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse time " + value, ex);
        }
    }

    private String getIntegerString(Number value) {
        return value == null ? null : Integer.toString(value.intValue());
    }

    private String getIntegerString(int value) {
        return Integer.toString(value);
    }

    private boolean isWorkingDay(ProjectCalendar mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day day) {
        boolean result = false;
        switch (mpxjCalendar.getWorkingDay(day)) {
            case 1: {
                result = true;
                break;
            }
            case 0: {
                result = false;
                break;
            }
            case 2: {
                result = this.isWorkingDay(mpxjCalendar.getBaseCalendar(), day);
            }
        }
        return result;
    }

    private String getWorkingDayString(ProjectCalendar mpxjCalendar, com.kingdee.eas.mm.project.client.net.sf.mpxj.Day day) {
        String result = null;
        switch (mpxjCalendar.getWorkingDay(day)) {
            case 1: {
                result = "0";
                break;
            }
            case 0: {
                result = "1";
                break;
            }
            case 2: {
                result = "2";
            }
        }
        return result;
    }

    private String getTimeString(Date value) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(value);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        StringBuffer sb = new StringBuffer(4);
        sb.append(this.m_twoDigitFormat.format(hours));
        sb.append(this.m_twoDigitFormat.format(minutes));
        return sb.toString();
    }

    private String getDateString(Date value) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(value);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        StringBuffer sb = new StringBuffer(8);
        sb.append(this.m_fourDigitFormat.format(year));
        sb.append(this.m_twoDigitFormat.format(month));
        sb.append(this.m_twoDigitFormat.format(day));
        return sb.toString();
    }

    private String getDateTimeString(Date value) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(value);
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.m_fourDigitFormat.format(cal.get(1)));
        sb.append(this.m_twoDigitFormat.format(cal.get(2) + 1));
        sb.append(this.m_twoDigitFormat.format(cal.get(5)));
        sb.append('T');
        sb.append(this.m_twoDigitFormat.format(cal.get(11)));
        sb.append(this.m_twoDigitFormat.format(cal.get(12)));
        sb.append(this.m_twoDigitFormat.format(cal.get(13)));
        sb.append('Z');
        return sb.toString();
    }

    private String getDurationString(Duration value) {
        String result = null;
        if (value != null) {
            double seconds = 0.0;
            switch (value.getUnits().getValue()) {
                case 0: 
                case 7: {
                    seconds = value.getDuration() * 60.0;
                    break;
                }
                case 1: 
                case 8: {
                    seconds = value.getDuration() * 28800.0;
                    break;
                }
                case 2: 
                case 9: {
                    double minutesPerDay = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    seconds = value.getDuration() * (minutesPerDay * 60.0);
                    break;
                }
                case 3: 
                case 10: {
                    double minutesPerWeek = this.m_projectFile.getProjectHeader().getMinutesPerWeek().doubleValue();
                    seconds = value.getDuration() * (minutesPerWeek * 60.0);
                    break;
                }
                case 4: 
                case 11: {
                    double minutesPerDay = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double daysPerMonth = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    seconds = value.getDuration() * (daysPerMonth * minutesPerDay * 60.0);
                    break;
                }
                case 5: 
                case 12: {
                    double minutesPerDay = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double daysPerMonth = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    seconds = value.getDuration() * (12.0 * daysPerMonth * minutesPerDay * 60.0);
                    break;
                }
            }
            result = Long.toString((long)seconds);
        }
        return result;
    }

    private String getScheduling(TaskType value) {
        String result = "fixed-work";
        if (value != null && value == TaskType.FIXED_DURATION) {
            result = "fixed-duration";
        }
        return result;
    }

    private String getString(String value) {
        return value == null ? "" : value;
    }

    static {
        RELATIONSHIP_TYPES.put(RelationType.FINISH_FINISH, "FF");
        RELATIONSHIP_TYPES.put(RelationType.FINISH_START, "FS");
        RELATIONSHIP_TYPES.put(RelationType.START_FINISH, "SF");
        RELATIONSHIP_TYPES.put(RelationType.START_START, "SS");
    }
}

