/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.sample;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.PlannerReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.planner.PlannerWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.reader.ProjectReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.writer.ProjectWriter;
import java.util.HashMap;
import java.util.Map;

public final class MpxjConvert {
    private static final Map READER_MAP = new HashMap();
    private static final Map WRITER_MAP;

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MpxjConvert <input file name> <output file name>");
            } else {
                MpxjConvert convert = new MpxjConvert();
                convert.process(args[0], args[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void process(String inputFile, String outputFile) throws Exception {
        System.out.println("Reading input file started.");
        long start = System.currentTimeMillis();
        ProjectReader reader = this.getReaderObject(inputFile);
        ProjectFile projectFile = reader.read(inputFile);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Reading input file completed in " + elapsed + "ms.");
        System.out.println("Writing output file started.");
        start = System.currentTimeMillis();
        ProjectWriter writer = this.getWriterObject(outputFile);
        writer.write(projectFile, outputFile);
        elapsed = System.currentTimeMillis() - start;
        System.out.println("Writing output completed in " + elapsed + "ms.");
    }

    private ProjectReader getReaderObject(String name) throws Exception {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new Exception("Filename has no extension: " + name);
        }
        String extension = name.substring(index + 1).toUpperCase();
        Class fileClass = (Class)READER_MAP.get(extension);
        if (fileClass == null) {
            throw new Exception("Cannot read files of type: " + name);
        }
        ProjectReader file = (ProjectReader)fileClass.newInstance();
        return file;
    }

    private ProjectWriter getWriterObject(String name) throws Exception {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new Exception("Filename has no extension: " + name);
        }
        String extension = name.substring(index + 1).toUpperCase();
        Class fileClass = (Class)WRITER_MAP.get(extension);
        if (fileClass == null) {
            throw new Exception("Cannot write files of type: " + name);
        }
        ProjectWriter file = (ProjectWriter)fileClass.newInstance();
        return file;
    }

    static {
        READER_MAP.put("MPP", MPPReader.class);
        READER_MAP.put("MPT", MPPReader.class);
        READER_MAP.put("MPX", MPXReader.class);
        READER_MAP.put("XML", MSPDIReader.class);
        READER_MAP.put("PLANNER", PlannerReader.class);
        WRITER_MAP = new HashMap();
        WRITER_MAP.put("MPX", MPXWriter.class);
        WRITER_MAP.put("XML", MSPDIWriter.class);
        WRITER_MAP.put("PLANNER", PlannerWriter.class);
    }
}

