/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.sample;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RelationType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Resource;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.NumberUtility;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.writer.AbstractProjectWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.writer.ProjectWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class MpxjCreate {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxCreate <output file name>");
            } else {
                MpxjCreate.create(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static ProjectWriter getWriter(String filename) {
        String suffix = filename.length() < 4 ? ".MPX" : filename.substring(filename.length() - 4).toUpperCase();
        AbstractProjectWriter result = suffix.toUpperCase(Locale.ENGLISH).equals(".XML") ? new MSPDIWriter() : new MPXWriter();
        return result;
    }

    private static void create(String filename) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        ProjectFile file = new ProjectFile();
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        file.setAutoResourceID(true);
        file.setAutoResourceUniqueID(true);
        file.setAutoOutlineLevel(true);
        file.setAutoOutlineNumber(true);
        file.setAutoWBS(true);
        file.setAutoCalendarUniqueID(true);
        ProjectCalendar calendar = file.addDefaultBaseCalendar();
        ProjectCalendarException exception = calendar.addCalendarException();
        exception.setFromDate(df.parse("13/03/2006"));
        exception.setToDate(df.parse("13/03/2006"));
        exception.setWorking(false);
        ProjectHeader header = file.getProjectHeader();
        header.setStartDate(df.parse("01/01/2003"));
        Resource resource1 = file.addResource();
        resource1.setName("Resource1");
        Resource resource2 = file.addResource();
        resource2.setName("Resource2");
        resource2.setMaxUnits(new Double(50.0));
        Task task1 = file.addTask();
        task1.setName("Summary Task");
        Task task2 = task1.addTask();
        task2.setName("First Sub Task");
        task2.setDuration(Duration.getInstance(10.5, TimeUnit.DAYS));
        task2.setStart(df.parse("01/01/2003"));
        task2.setPercentageComplete(NumberUtility.getDouble(50.0));
        task2.setActualStart(df.parse("01/01/2003"));
        Task task3 = task1.addTask();
        task3.setName("Second Sub Task");
        task3.setStart(df.parse("11/01/2003"));
        task3.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
        Relation rel1 = task3.addPredecessor(task2);
        rel1.setType(RelationType.FINISH_START);
        Task milestone1 = task1.addTask();
        milestone1.setName("Milestone");
        milestone1.setStart(df.parse("21/01/2003"));
        milestone1.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
        Relation rel2 = milestone1.addPredecessor(task3);
        rel2.setType(RelationType.FINISH_START);
        Task task4 = file.addTask();
        task4.setName("Last Task");
        task4.setDuration(Duration.getInstance(8, TimeUnit.DAYS));
        task4.setStart(df.parse("01/01/2003"));
        task4.setPercentageComplete(NumberUtility.getDouble(70.0));
        task4.setActualStart(df.parse("01/01/2003"));
        ResourceAssignment assignment1 = task2.addResourceAssignment(resource1);
        ResourceAssignment assignment2 = task3.addResourceAssignment(resource2);
        assignment1.setWork(Duration.getInstance(80, TimeUnit.HOURS));
        assignment1.setActualWork(Duration.getInstance(40, TimeUnit.HOURS));
        assignment1.setRemainingWork(Duration.getInstance(40, TimeUnit.HOURS));
        assignment2.setRemainingWork(Duration.getInstance(80, TimeUnit.HOURS));
        assignment1.setStart(df.parse("01/01/2003"));
        assignment2.setStart(df.parse("11/01/2003"));
        ProjectWriter writer = MpxjCreate.getWriter(filename);
        writer.write(file, filename);
    }
}

