/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.net.sf.mpxj.utility;

import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import java.util.Calendar;
import java.util.Date;

public final class DateUtility {
    private DateUtility() {
    }

    public static Date getDayStartDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            date = cal.getTime();
        }
        return date;
    }

    public static Date getDayEndDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(14, 999);
            cal.set(13, 59);
            cal.set(12, 59);
            cal.set(11, 23);
            date = cal.getTime();
        }
        return date;
    }

    public static Date getCanonicalTime(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(6, 1);
            cal.set(1, 1);
            date = cal.getTime();
        }
        return date;
    }

    public static int compare(Date startDate, Date endDate, Date targetDate) {
        return DateUtility.compare(startDate, endDate, targetDate.getTime());
    }

    public static int compare(Date startDate, Date endDate, long targetDate) {
        int result = 0;
        if (targetDate < startDate.getTime()) {
            result = -1;
        } else if (targetDate > endDate.getTime()) {
            result = 1;
        }
        return result;
    }

    public static Duration getVariance(Task task, Date date1, Date date2, TimeUnit format) {
        Duration variance = null;
        if (date1 != null & date2 != null) {
            ProjectCalendar calendar = task.getCalendar();
            if (calendar == null) {
                ProjectFile file = task.getParentFile();
                calendar = file.getBaseCalendar(file.getProjectHeader().getCalendarName());
            }
            if (calendar != null) {
                variance = calendar.getWork(date1, date2, format);
            }
        }
        if (variance == null) {
            variance = Duration.getInstance(0, format);
        }
        return variance;
    }
}

