/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.IProductLine;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.report.client.AbstractItemGoodRateReportUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;

public class ItemGoodRateReportUI
extends AbstractItemGoodRateReportUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemGoodRateReportUI.class);

    public ItemGoodRateReportUI() throws Exception {
        this.isReport = true;
        this.registerParam();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.startDateFrom.setTimeEnabled(true);
        this.startDateTo.setTimeEnabled(true);
        this.endDateFrom.setTimeEnabled(true);
        this.endDateTo.setTimeEnabled(true);
        this.setBizMaterialF7(this.prmtmaterialNumFrom, false, null);
        this.setBizMaterialF7(this.prmtmaterialNumTo, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtmaterialNumFrom, this.prmtmaterialNumTo, this.prmtproductLine, this.prmtWorkshop});
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"ItemGoodRateReportView");
        this.prmtstorageOrgUnit.setRequired(true);
        this.prmtstorageOrgUnit.setEnabledMultiSelection(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "ItemGoodRateReportView";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource", (String)strKey);
    }

    public boolean verify() {
        boolean result = super.verify();
        if (result) {
            if (this.startDateTo.getValue() != null && this.startDateFrom.getValue() != null && ((Date)this.startDateTo.getValue()).getTime() < ((Date)this.startDateFrom.getValue()).getTime()) {
                MsgBox.showInfo((String)ItemGoodRateReportUI.getResource("filterStartDate"));
                return false;
            }
            if (this.endDateTo.getValue() != null && this.endDateFrom.getValue() != null && ((Date)this.endDateTo.getValue()).getTime() < ((Date)this.endDateFrom.getValue()).getTime()) {
                MsgBox.showInfo((String)ItemGoodRateReportUI.getResource("fiterEndDate"));
                return false;
            }
            if (this.kDTextRateFrom.getNumberValue() != null && this.kDTextRateTo.getNumberValue() != null && this.kDTextRateFrom.getNumberValue().floatValue() > this.kDTextRateTo.getNumberValue().floatValue()) {
                MsgBox.showInfo((String)ItemGoodRateReportUI.getResource("GoodRate"));
                return false;
            }
        }
        return result;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            CoreBaseCollection items;
            String numbers = this.transformNumberArray(this.prmtWorkshop);
            if (numbers != null) {
                IAdminOrgUnit admin = AdminOrgUnitFactory.getRemoteInstance();
                items = admin.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtWorkshop.setValue((Object)items.toArray());
            }
            if ((numbers = this.transformNumberArray(this.prmtproductLine)) != null) {
                IProductLine prodLine = ProductLineFactory.getRemoteInstance();
                items = prodLine.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.prmtproductLine.setValue((Object)items.toArray());
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    private String transformNumberArray(KDBizPromptBox control) {
        String ids = control.getText();
        if (ids == null || ids != null && ids.length() == 0) {
            return null;
        }
        return ids.replaceAll(" ", "").replaceAll(";", "','");
    }

    private void registerParam() {
        this.isReport = true;
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement storageEelement = new SingleFilterElement("storageOrgUnit", (Component)this.prmtstorageOrgUnit);
        storageEelement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ItemGoodRateReportUI.getResource("STORAGEORG_ISNULL")));
        storageEelement.setDefaultValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"ItemGoodRateReportView"));
        elements.add((FilterElement)storageEelement);
        elements.add((FilterElement)new SingleFilterElement("workshopNumber", (Component)this.prmtWorkshop));
        elements.add((FilterElement)new SingleFilterElement("productionLine", (Component)this.prmtproductLine));
        elements.add((FilterElement)new SingleFilterElement("PrmtproductFrom", (Component)this.PrmtproductFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtproductTo", (Component)this.prmtproductTo));
        elements.add((FilterElement)new SingleFilterElement("prmtmaterialNumFrom", (Component)this.prmtmaterialNumFrom));
        elements.add((FilterElement)new SingleFilterElement("prmtmaterialNumTo", (Component)this.prmtmaterialNumTo));
        this.kDTextRateFrom.setMinimumValue((Comparable)new BigDecimal(0));
        this.kDTextRateFrom.setMaximumValue((Comparable)new BigDecimal(1));
        SingleFilterElement rateFrom = new SingleFilterElement("TextRateFrom", (Component)this.kDTextRateFrom);
        this.kDTextRateTo.setMinimumValue((Comparable)new BigDecimal(0));
        this.kDTextRateTo.setMaximumValue((Comparable)new BigDecimal(1));
        SingleFilterElement rateTo = new SingleFilterElement("TextRateTo", (Component)this.kDTextRateTo);
        elements.add((FilterElement)rateFrom);
        elements.add((FilterElement)rateTo);
        SingleFilterElement startDateF = new SingleFilterElement("startDateFrom", (Component)this.startDateFrom);
        startDateF.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"39_ItemGoodRateReportUI")));
        SingleFilterElement startDateT = new SingleFilterElement("startDateTo", (Component)this.startDateTo);
        startDateT.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"40_ItemGoodRateReportUI")));
        SingleFilterElement endDateF = new SingleFilterElement("endDateFrom", (Component)this.endDateFrom);
        endDateF.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"41_ItemGoodRateReportUI")));
        SingleFilterElement endDateT = new SingleFilterElement("endDateTo", (Component)this.endDateTo);
        endDateT.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"42_ItemGoodRateReportUI")));
        startDateF.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        startDateT.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        endDateF.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        endDateT.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        elements.add((FilterElement)startDateF);
        elements.add((FilterElement)startDateT);
        elements.add((FilterElement)endDateF);
        elements.add((FilterElement)endDateT);
        SingleFilterElement release = new SingleFilterElement("kDCheckBoxrelease", (Component)this.kDCheckBoxrelease);
        release.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)release);
        SingleFilterElement close = new SingleFilterElement("kDCheckBoxclose", (Component)this.kDCheckBoxclose);
        close.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)close);
        SingleFilterElement complete = new SingleFilterElement("kDCheckBoxcomplete", (Component)this.kDCheckBoxcomplete);
        complete.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)complete);
        SingleFilterElement common = new SingleFilterElement("kDCheckBoxCommon", (Component)this.kDCheckBoxCommon);
        common.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)common);
        SingleFilterElement rework = new SingleFilterElement("kDCheckBoxRework", (Component)this.kDCheckBoxRework);
        rework.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)rework);
        SingleFilterElement repair = new SingleFilterElement("kDCheckBoxRepair", (Component)this.kDCheckBoxRepair);
        repair.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)repair);
        SingleFilterElement other = new SingleFilterElement("kDCheckBoxOther", (Component)this.kDCheckBoxOther);
        other.setDefaultValue((Object)new Boolean(true));
        elements.add((FilterElement)other);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement(null, null);
        this.getFilterManager().setMainOrgElement((FilterElement)storageEelement, this.getPropertyOfMainBizOrg());
    }

    class SingleComPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleComPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                object = this.prmt.getValue();
            }
            cp.setObject(this.getId(), object);
        }
    }
}

