/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.report.IReportServer;
import com.kingdee.eas.base.report.ReportRowObject;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.tableutils.resize.KDTAutoResizeManager;
import com.kingdee.eas.mm.report.IPlannerWorkPlatformFacade;
import com.kingdee.eas.mm.report.PlannerWorkPlatformFacadeFactory;
import com.kingdee.eas.mm.report.client.AbstractMRPResultContrastUI;
import com.kingdee.eas.mm.report.client.MRPPlanVersionSetUI;
import com.kingdee.eas.mm.report.client.PlanerPluginClassName;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MRPResultContrastUI
extends AbstractMRPResultContrastUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(MRPResultContrastUI.class);
    private RptParams filter = null;
    private Map originTables = null;
    private Map contrastTables = null;
    private Map coStatTables = null;
    private String displayUnit = null;
    private BigDecimal convsRate = new BigDecimal("1");
    private int baseQtyPrc = 0;
    private int prodQtyPrc = 0;
    protected boolean isMTS11 = false;
    private PlanVersionSetInfo contrastPlanVersion = null;
    private boolean isContrastSimulant = false;
    private String contrastPlanDate = null;
    private IReportServer reportServer = null;
    private boolean isViewOriginResult = true;
    private PlanerPluginClassName plugin = null;
    private IPlannerWorkPlatformFacade reportFacade = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isContrastConfirmed()) {
            this.initData();
            this.initKDTable();
            this.setTitleFields();
        } else {
            SysUtil.abort();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setSingleDispTableVisible();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.pnlDispInday.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
        this.pnlDIspInWeek.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
        this.pnlDispInMonth.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
        this.pnlCoDispInday.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
        this.pnlCoDispInWeek.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
        this.pnlCoDispInMonth.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
    }

    private void initData() throws Exception {
        this.filter = (RptParams)((RptParams)this.getUIContext().get("filter")).clone();
        this.originTables = (Map)this.getUIContext().get("statTables");
        this.displayUnit = (String)this.getUIContext().get("displayUnit");
        this.isMTS11 = (Boolean)this.getUIContext().get("isMTS11");
        this.convsRate = (BigDecimal)this.getUIContext().get("convsRate");
        this.baseQtyPrc = (Integer)this.getUIContext().get("baseQtyPrc");
        this.prodQtyPrc = (Integer)this.getUIContext().get("prodQtyPrc");
        this.reportFacade = PlannerWorkPlatformFacadeFactory.getRemoteInstance();
        this.coStatTables = this.reportFacade.prepareContrastData(this.originTables, this.contrastTables);
        this.actionViewOriginResult.setEnabled(true);
        this.actionViewContrastResult.setEnabled(true);
        this.actionContrast.setEnabled(true);
        this.actionViewBill.setEnabled(true);
        this.menuView.setMnemonic(86);
    }

    private void setTitleFields() {
        KDPanel title = (KDPanel)this.getUIContext().get("title");
        String storageOrgUnit = ((KDLabel)title.getComponent(0)).getText();
        this.txtStorageOrgUnit.setText(this.getText(storageOrgUnit.split(this.getResource("COLON"))[1]));
        String materialNumber = ((KDLabel)title.getComponent(3)).getText();
        this.txtMaterialNumber.setText(this.getText(materialNumber.split(this.getResource("COLON"))[1]));
        String materialName = ((KDLabel)title.getComponent(4)).getText();
        this.txtMaterialName.setText(this.getText(materialName.split(this.getResource("COLON"))[1]));
        String materialModel = ((KDLabel)title.getComponent(5)).getText();
        this.txtMaterialModel.setText(this.getText(materialModel.split(this.getResource("COLON"))[1]));
        String unitName = ((KDLabel)title.getComponent(7)).getText();
        this.txtUnit.setText(this.getText(unitName.split(this.getResource("COLON"))[1]));
        String oriPlanVersion = ((PlanVersionSetInfo)this.getUIContext().get("planVersion")).getNumber();
        String isSimulantResult = ((KDLabel)title.getComponent(12)).getText();
        oriPlanVersion = this.getResource("YES").equals(this.getText(isSimulantResult.split(this.getResource("COLON"))[1]).trim()) ? oriPlanVersion + " - " + this.getResource("SIMULANT_LABEL") : oriPlanVersion + " - " + this.getResource("FORMAL_LABEL");
        this.contPlanVersion1.getBoundLabel().setForeground(Color.BLUE);
        this.txtPlanVersion1.setText(oriPlanVersion);
        this.contPlanDate1.getBoundLabel().setForeground(Color.BLUE);
        String oriPlanDate = ((KDLabel)title.getComponent(10)).getText();
        this.txtPlanDate1.setText(this.getText(oriPlanDate.split(this.getResource("COLON"))[1]));
        String contrastPvNumber = this.contrastPlanVersion.getNumber();
        contrastPvNumber = this.isContrastSimulant ? contrastPvNumber + " - " + this.getResource("SIMULANT_LABEL") : contrastPvNumber + " - " + this.getResource("FORMAL_LABEL");
        this.txtPlanVersion2.setText(contrastPvNumber);
        this.txtPlanDate2.setText(this.contrastPlanDate);
        if (this.contrastPlanDate == null || "".equals(this.contrastPlanDate)) {
            this.setIsShowTextOnly(false);
            this.setMessageText(contrastPvNumber + this.getResource("PLANVERSION_NOT_CALCULATED"));
            this.setNextMessageText("");
            this.setShowMessagePolicy(0);
            this.showMessage();
        }
    }

    private String getText(String text) {
        String str = text;
        if (str != null) {
            str = text.trim();
        }
        return str;
    }

    private boolean isContrastConfirmed() throws Exception {
        MRPPlanVersionSetUI uiObj;
        boolean isConfirmed = false;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(MRPPlanVersionSetUI.class.getName(), this.getUIContext(), null, OprtState.VIEW, 95);
        window.show();
        if (window.close() && (isConfirmed = (uiObj = (MRPPlanVersionSetUI)window.getUIObject()).isConfirmed())) {
            this.contrastTables = (Map)uiObj.getUIContext().get("contarstTables");
            this.contrastPlanVersion = (PlanVersionSetInfo)uiObj.getUIContext().get("contrastPlanVersion");
            this.isContrastSimulant = (Boolean)uiObj.getUIContext().get("isContrastSimulant");
            this.contrastPlanDate = (String)uiObj.getUIContext().get("planDate");
        }
        return isConfirmed;
    }

    public boolean destroyWindow() {
        try {
            if (this.reportServer == null) {
                this.reportServer = this.getReportServer();
            }
            if (this.contrastTables != null) {
                if (this.contrastTables.get("tblDispInDay") != null) {
                    this.reportServer.dropTempTable(null, null, (String)this.contrastTables.get("tblDispInDay"));
                }
                if (this.contrastTables.get("tblDispInWeek") != null) {
                    this.reportServer.dropTempTable(null, null, (String)this.contrastTables.get("tblDispInWeek"));
                }
                if (this.contrastTables.get("tblDispInMonth") != null) {
                    this.reportServer.dropTempTable(null, null, (String)this.contrastTables.get("tblDispInMonth"));
                }
                if (this.contrastTables.get("tblDispInPeriods") != null) {
                    this.reportServer.dropTempTable(null, null, (String)this.contrastTables.get("tblDispInPeriods"));
                }
                if (this.contrastTables.get("mainTable") != null) {
                    this.reportServer.dropTempTable(null, null, (String)this.contrastTables.get("mainTable"));
                }
                if (this.coStatTables != null && this.coStatTables.get("coDayStatTable") != null) {
                    this.reportFacade.dropTable((String)this.coStatTables.get("coDayStatTable"));
                }
                if (this.coStatTables != null && this.coStatTables.get("coWeekStatTable") != null) {
                    this.reportFacade.dropTable((String)this.coStatTables.get("coWeekStatTable"));
                }
                if (this.coStatTables != null && this.coStatTables.get("coMonthStatTable") != null) {
                    this.reportFacade.dropTable((String)this.coStatTables.get("coMonthStatTable"));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return super.destroyWindow();
    }

    @Override
    public void actionViewOriginResult_actionPerformed(ActionEvent e) throws Exception {
        this.setSingleDispTableVisible();
        this.isViewOriginResult = true;
        this.tblDispInDay.refresh();
        this.tblDispInWeek.refresh();
        this.tblDispInMonth.refresh();
        this.tblPeriodDetail.removeRows();
    }

    @Override
    public void actionViewContrastResult_actionPerformed(ActionEvent e) throws Exception {
        this.setSingleDispTableVisible();
        this.isViewOriginResult = false;
        this.tblDispInDay.setRefresh(true);
        this.tblDispInDay.refresh();
        this.tblDispInWeek.refresh();
        this.tblDispInMonth.refresh();
        this.tblPeriodDetail.removeRows();
    }

    @Override
    public void actionContrast_actionPerformed(ActionEvent e) throws Exception {
        this.setCoDispTableVisible();
        this.tblPeriodDetail.removeRows();
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.showEditUI();
    }

    private void setCoDispTableVisible() {
        this.kDTabbedPane1.remove((Component)this.pnlDispInday);
        this.kDTabbedPane1.remove((Component)this.pnlDIspInWeek);
        this.kDTabbedPane1.remove((Component)this.pnlDispInMonth);
        this.kDTabbedPane1.add((Component)this.pnlCoDispInday, (Object)this.resHelper.getString("pnlCoDispInday.constraints"));
        this.kDTabbedPane1.add((Component)this.pnlCoDispInWeek, (Object)this.resHelper.getString("pnlCoDispInWeek.constraints"));
        this.kDTabbedPane1.add((Component)this.pnlCoDispInMonth, (Object)this.resHelper.getString("pnlCoDispInMonth.constraints"));
    }

    private void setSingleDispTableVisible() {
        this.kDTabbedPane1.add((Component)this.pnlDispInday, (Object)this.resHelper.getString("pnlDispInday.constraints"));
        this.kDTabbedPane1.add((Component)this.pnlDIspInWeek, (Object)this.resHelper.getString("pnlDIspInWeek.constraints"));
        this.kDTabbedPane1.add((Component)this.pnlDispInMonth, (Object)this.resHelper.getString("pnlDispInMonth.constraints"));
        this.kDTabbedPane1.remove((Component)this.pnlCoDispInday);
        this.kDTabbedPane1.remove((Component)this.pnlCoDispInWeek);
        this.kDTabbedPane1.remove((Component)this.pnlCoDispInMonth);
    }

    private IReportServer getReportServer() throws BOSException {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.eas.mm.report.app.PlanerWorkPlatformReport", IReportServer.class);
        return server;
    }

    private void initKDTable() {
        this.setKDTableDataRequestMode(this.tblDispInDay);
        this.setKDTableDataRequestMode(this.tblDispInWeek);
        this.setKDTableDataRequestMode(this.tblDispInMonth);
        this.setKDTableDataRequestMode(this.tblCoDispInday);
        this.setKDTableDataRequestMode(this.tblCoDispInWeek);
        this.setKDTableDataRequestMode(this.tblCoDispInMonth);
        KDTAutoResizeManager.register((KDTable[])new KDTable[]{this.tblDispInDay, this.tblDispInWeek, this.tblDispInMonth, this.tblCoDispInday, this.tblCoDispInWeek, this.tblCoDispInMonth, this.tblPeriodDetail});
        this.tblPeriodDetail.checkParsed();
        this.tblPeriodDetail.getStyleAttributes().setLocked(true);
        this.tblPeriodDetail.getSelectManager().setSelectMode(2);
        this.setTableFontColor(this.tblCoDispInday);
        this.setTableFontColor(this.tblCoDispInWeek);
        this.setTableFontColor(this.tblCoDispInMonth);
        this.tblDispInDay.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MRPResultContrastUI.this.setDetailByStatData(e);
                }
                catch (Exception e1) {
                    MRPResultContrastUI.this.handleException(e1);
                }
            }
        });
        this.tblDispInWeek.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MRPResultContrastUI.this.setDetailByStatData(e);
                }
                catch (Exception e1) {
                    MRPResultContrastUI.this.handleException(e1);
                }
            }
        });
        this.tblDispInMonth.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MRPResultContrastUI.this.setDetailByStatData(e);
                }
                catch (Exception e1) {
                    MRPResultContrastUI.this.handleException(e1);
                }
            }
        });
        this.tblCoDispInday.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MRPResultContrastUI.this.setDetailByCoStatData(e);
                }
                catch (Exception e1) {
                    MRPResultContrastUI.this.handleException(e1);
                }
            }
        });
        this.tblCoDispInWeek.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MRPResultContrastUI.this.setDetailByCoStatData(e);
                }
                catch (Exception e1) {
                    MRPResultContrastUI.this.handleException(e1);
                }
            }
        });
        this.tblCoDispInMonth.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MRPResultContrastUI.this.setDetailByCoStatData(e);
                }
                catch (Exception e1) {
                    MRPResultContrastUI.this.handleException(e1);
                }
            }
        });
        this.tblPeriodDetail.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                MRPResultContrastUI.this.periodDetailCliked(e);
            }
        });
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        KDTable table = (KDTable)e.getSource();
        try {
            if (this.reportServer == null) {
                this.reportServer = this.getReportServer();
            }
            if (table.equals(this.tblDispInDay)) {
                this.insertDayStatData(from, len);
            } else if (table.equals(this.tblDispInWeek)) {
                this.insertWeekStatData(from, len);
            } else if (table.equals(this.tblDispInMonth)) {
                this.insertMonthStatData(from, len);
            } else if (table.equals(this.tblCoDispInday)) {
                this.insertCoDayStatData(from, len);
            } else if (table.equals(this.tblCoDispInWeek)) {
                this.insertCoWeekStatData(from, len);
            } else if (table.equals(this.tblCoDispInMonth)) {
                this.insertCoMonthStatData(from, len);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void setKDTableDataRequestMode(KDTable table) {
        table.checkParsed();
        table.getDataRequestManager().setDataRequestMode(1);
        table.getStyleAttributes().setLocked(true);
        table.getSelectManager().setSelectMode(2);
        table.removeKDTDataRequestListener((KDTDataRequestListener)this);
        table.addKDTDataRequestListener((KDTDataRequestListener)this);
    }

    private void setTableFontColor(KDTable table) {
        table.checkParsed();
        table.getHeadRow(0).getCell(1).getStyleAttributes().setFontColor(Color.BLUE);
        table.getHeadRow(0).getCell(3).getStyleAttributes().setFontColor(Color.BLUE);
        table.getHeadRow(0).getCell(5).getStyleAttributes().setFontColor(Color.BLUE);
        table.getHeadRow(0).getCell(7).getStyleAttributes().setFontColor(Color.BLUE);
        table.getColumn(1).getStyleAttributes().setFontColor(Color.BLUE);
        table.getColumn(3).getStyleAttributes().setFontColor(Color.BLUE);
        table.getColumn(5).getStyleAttributes().setFontColor(Color.BLUE);
        table.getColumn(7).getStyleAttributes().setFontColor(Color.BLUE);
    }

    private void insertDayStatData(int from, int length) throws Exception {
        this.filter.setString("statType", "day");
        String table = null;
        table = this.isViewOriginResult ? (String)this.originTables.get("tblDispInDay") : (String)this.contrastTables.get("tblDispInDay");
        IRowSet rs = this.reportServer.getDataForOnePage(null, this.filter, table, from, length);
        this.insertStatTableData(this.tblDispInDay, rs);
    }

    private void insertWeekStatData(int from, int length) throws Exception {
        this.filter.setString("statType", "week");
        String table = null;
        table = this.isViewOriginResult ? (String)this.originTables.get("tblDispInWeek") : (String)this.contrastTables.get("tblDispInWeek");
        IRowSet rs = this.reportServer.getDataForOnePage(null, this.filter, table, from, length);
        this.insertStatTableData(this.tblDispInWeek, rs);
    }

    private void insertMonthStatData(int from, int length) throws Exception {
        this.filter.setString("statType", "month");
        String table = null;
        table = this.isViewOriginResult ? (String)this.originTables.get("tblDispInMonth") : (String)this.contrastTables.get("tblDispInMonth");
        IRowSet rs = this.reportServer.getDataForOnePage(null, this.filter, table, from, length);
        this.insertStatTableData(this.tblDispInMonth, rs);
    }

    private void insertCoDayStatData(int from, int length) throws Exception {
        String table = (String)this.coStatTables.get("coDayStatTable");
        IRowSet rs = this.reportFacade.getContrastData(table, from, length);
        this.insertCoStatTableData(this.tblCoDispInday, rs);
    }

    private void insertCoWeekStatData(int from, int length) throws Exception {
        String table = (String)this.coStatTables.get("coWeekStatTable");
        IRowSet rs = this.reportFacade.getContrastData(table, from, length);
        this.insertCoStatTableData(this.tblCoDispInWeek, rs);
    }

    private void insertCoMonthStatData(int from, int length) throws Exception {
        String table = (String)this.coStatTables.get("coMonthStatTable");
        IRowSet rs = this.reportFacade.getContrastData(table, from, length);
        this.insertCoStatTableData(this.tblCoDispInMonth, rs);
    }

    private void insertStatTableData(KDTable table, IRowSet rs) throws Exception {
        int index = 0;
        int dataRowIndex = 1;
        ReportRowObject reportRowObject = null;
        String period = null;
        while (rs.next()) {
            IRow row = null;
            period = rs.getString("FPeriodDispName");
            if (rs.getInt("FMrpItemType") == 1) {
                if (this.isMTS11) {
                    ++dataRowIndex;
                    continue;
                }
                row = table.addRow();
                period = this.getResource("STOCK");
            } else {
                row = table.addRow();
            }
            if (this.isViewOriginResult) {
                Appearance app = new Appearance();
                app.foreColor = Color.BLUE;
                app.ApplyRowAppearnce(row);
            }
            index = row.getRowIndex();
            row.getCell("FPeriod").setValue((Object)period);
            row.getCell("FSR").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FSR").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FSR")));
            row.getCell("FPab").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FPab").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FPab")));
            row.getCell("FIndependent").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FIndependent").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FIndependent")));
            row.getCell("FDependent").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FDependent").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FDependent")));
            reportRowObject = new ReportRowObject();
            reportRowObject.setRowindex(index);
            reportRowObject.setRs(rs);
            reportRowObject.setDataRowIndex(dataRowIndex);
            row.setUserObject((Object)reportRowObject);
            ++dataRowIndex;
        }
    }

    private void insertCoStatTableData(KDTable table, IRowSet rs) throws Exception {
        int index = 0;
        int dataRowIndex = 1;
        ReportRowObject reportRowObject = null;
        String period = null;
        while (rs.next()) {
            IRow row = null;
            period = rs.getString("FPeriodDispName");
            if (rs.getInt("FMrpItemType") == 1) {
                if (this.isMTS11) {
                    ++dataRowIndex;
                    continue;
                }
                row = table.addRow();
                period = this.getResource("STOCK");
            } else {
                row = table.addRow();
            }
            index = row.getRowIndex();
            row.getCell("FPeriod").setValue((Object)period);
            row.getCell("FSR1").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FSR1").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FSR1")));
            row.getCell("FPab1").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FPab1").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FPab1")));
            row.getCell("FIndependent1").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FIndependent1").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FIndependent1")));
            row.getCell("FDependent1").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FDependent1").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FDependent1")));
            row.getCell("FSR2").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FSR2").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FSR2")));
            row.getCell("FPab2").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FPab2").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FPab2")));
            row.getCell("FIndependent2").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FIndependent2").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FIndependent2")));
            row.getCell("FDependent2").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FDependent2").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FDependent2")));
            reportRowObject = new ReportRowObject();
            reportRowObject.setRowindex(index);
            reportRowObject.setRs(rs);
            reportRowObject.setDataRowIndex(dataRowIndex);
            row.setUserObject((Object)reportRowObject);
            ++dataRowIndex;
        }
    }

    private void setDetailByStatData(KDTSelectEvent e) throws Exception {
        int rowIndex = e.getSelectBlock().getTop();
        if (rowIndex == -1) {
            return;
        }
        KDTable table = (KDTable)e.getSource();
        ReportRowObject userObj = (ReportRowObject)table.getRow(rowIndex).getUserObject();
        IRowSet rowSet = userObj.getRs();
        rowSet.absolute(userObj.getDataRowIndex());
        String periodDispName = rowSet.getString("FPeriodDispName");
        int mrpItemType = rowSet.getInt("FMrpItemType");
        RptParams detailFilter = new RptParams();
        detailFilter.setString("mrpItemType", String.valueOf(mrpItemType));
        if (table.equals(this.tblDispInDay)) {
            detailFilter.setString("statType", "day");
        } else if (table.equals(this.tblDispInWeek)) {
            detailFilter.setString("statType", "week");
        } else if (table.equals(this.tblDispInMonth)) {
            detailFilter.setString("statType", "month");
        }
        detailFilter.setString("periodDispName", periodDispName);
        if (this.isViewOriginResult) {
            detailFilter.setString("mainTable", (String)this.originTables.get("mainTable"));
        } else {
            detailFilter.setString("mainTable", (String)this.contrastTables.get("mainTable"));
        }
        if (this.reportServer == null) {
            this.reportServer = this.getReportServer();
        }
        HashMap result = this.reportServer.getData("", detailFilter);
        IRowSet rs = (IRowSet)result.get("reportdata");
        this.tblPeriodDetail.removeRows();
        IRow row = null;
        int index = 0;
        ReportRowObject reportRowObject = null;
        while (rs.next()) {
            row = this.tblPeriodDetail.addRow();
            if (this.isViewOriginResult) {
                Appearance app = new Appearance();
                app.foreColor = Color.BLUE;
                app.ApplyRowAppearnce(row);
            }
            index = row.getRowIndex();
            row.getCell("FBillDate").setValue((Object)rs.getString("FBilldate"));
            row.getCell("FMRP").setValue((Object)rs.getString("FMRP"));
            row.getCell("FBillnum").setValue((Object)rs.getString("FBillnum"));
            if (rs.getString("Fexception") != null && rs.getString("Fexception").equals("0")) {
                row.getCell("Fexception").setValue(null);
            } else {
                row.getCell("Fexception").setValue((Object)rs.getString("Fexception"));
            }
            row.getCell("FAmount").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FAmount").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FAmount")));
            row.getCell("FPab").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FPab").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FPab")));
            row.getCell("FOrg").setValue((Object)rs.getString("FOrg"));
            row.getCell("FReDate").setValue((Object)rs.getString("FReDate"));
            row.getCell("Fproject").setValue((Object)rs.getString("Fproject"));
            row.getCell("FTrackNumber").setValue((Object)rs.getString("FTrackNumber"));
            reportRowObject = new ReportRowObject();
            reportRowObject.setRowindex(index);
            reportRowObject.setRs(rs);
            reportRowObject.setDataRowIndex(index + 1);
            row.setUserObject((Object)reportRowObject);
        }
    }

    private void setDetailByCoStatData(KDTSelectEvent e) throws Exception {
        int rowIndex = e.getSelectBlock().getTop();
        if (rowIndex == -1) {
            return;
        }
        KDTable table = (KDTable)e.getSource();
        ReportRowObject userObj = (ReportRowObject)table.getRow(rowIndex).getUserObject();
        IRowSet rowSet = userObj.getRs();
        rowSet.absolute(userObj.getDataRowIndex());
        String periodDispName = rowSet.getString("FPeriodDispName");
        int mrpItemType = rowSet.getInt("FMrpItemType");
        RptParams detailFilter = new RptParams();
        detailFilter.setString("mrpItemType", String.valueOf(mrpItemType));
        String statType = null;
        if (table.equals(this.tblCoDispInday)) {
            statType = "day";
        } else if (table.equals(this.tblCoDispInWeek)) {
            statType = "week";
        } else if (table.equals(this.tblCoDispInMonth)) {
            statType = "month";
        }
        if (this.reportFacade == null) {
            this.reportFacade = PlannerWorkPlatformFacadeFactory.getRemoteInstance();
        }
        IRowSet rs = this.reportFacade.getContrastDetail((String)this.originTables.get("mainTable"), (String)this.contrastTables.get("mainTable"), mrpItemType, periodDispName, statType);
        this.tblPeriodDetail.removeRows();
        IRow row = null;
        int index = 0;
        ReportRowObject reportRowObject = null;
        while (rs.next()) {
            row = this.tblPeriodDetail.addRow();
            if (rs.getString("FPlanVersion").equals("1")) {
                Appearance app = new Appearance();
                app.foreColor = Color.BLUE;
                app.ApplyRowAppearnce(row);
            }
            index = row.getRowIndex();
            row.getCell("FBillDate").setValue((Object)rs.getString("FBilldate"));
            row.getCell("FMRP").setValue((Object)rs.getString("FMRP"));
            row.getCell("FBillnum").setValue((Object)rs.getString("FBillnum"));
            if (rs.getString("Fexception") != null && rs.getString("Fexception").equals("0")) {
                row.getCell("Fexception").setValue(null);
            } else {
                row.getCell("Fexception").setValue((Object)rs.getString("Fexception"));
            }
            row.getCell("FAmount").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FAmount").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FAmount")));
            row.getCell("FPab").getStyleAttributes().setNumberFormat(this.getCellgetFormatPattern());
            row.getCell("FPab").setValue((Object)this.getQtyByUnit(rs.getBigDecimal("FPab")));
            row.getCell("FOrg").setValue((Object)rs.getString("FOrg"));
            row.getCell("FReDate").setValue((Object)rs.getString("FReDate"));
            row.getCell("Fproject").setValue((Object)rs.getString("Fproject"));
            row.getCell("FTrackNumber").setValue((Object)rs.getString("FTrackNumber"));
            reportRowObject = new ReportRowObject();
            reportRowObject.setRowindex(index);
            reportRowObject.setRs(rs);
            reportRowObject.setDataRowIndex(index + 1);
            row.setUserObject((Object)reportRowObject);
        }
    }

    private void periodDetailCliked(KDTMouseEvent e) {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.showEditUI();
        }
    }

    private void showEditUI() {
        try {
            ArrayList selectRows = this.getSelectRows();
            if (this.plugin == null) {
                this.plugin = new PlanerPluginClassName();
            }
            this.plugin.showOrder(selectRows, this.filter);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private ArrayList getSelectRows() throws SQLException {
        ArrayList<HashMap> listData = new ArrayList<HashMap>();
        KDTable table = this.tblPeriodDetail;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                listData.add(this.getOneRowData(j));
            }
        }
        return listData;
    }

    private HashMap getOneRowData(int row) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IRowSet rslocal = null;
        ReportRowObject userObj = (ReportRowObject)this.tblPeriodDetail.getRow(row).getUserObject();
        rslocal = userObj.getRs();
        if (rslocal != null) {
            rslocal.absolute(userObj.getDataRowIndex());
            ResultSetMetaData meta = rslocal.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                map.put(meta.getColumnName(i).toUpperCase(), rslocal.getObject(meta.getColumnName(i)));
            }
        }
        return map;
    }

    private BigDecimal getQtyByUnit(BigDecimal qtyMeasuredByBaseUnit) {
        BigDecimal qty = qtyMeasuredByBaseUnit;
        if ("productionUnit".equals(this.displayUnit) && qtyMeasuredByBaseUnit != null) {
            qty = qtyMeasuredByBaseUnit.divide(this.convsRate, this.prodQtyPrc, 4);
        }
        return qty;
    }

    private String getCellgetFormatPattern() {
        String formatPattern = SCMClientUtils.getFormatPattern((int)this.baseQtyPrc);
        if ("productionUnit".equals(this.displayUnit)) {
            formatPattern = SCMClientUtils.getFormatPattern((int)this.prodQtyPrc);
        }
        return formatPattern;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.PlannerResource", (String)key);
    }
}

