/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.ITableTreeController;
import com.kingdee.eas.mm.common.client.TableTreeHelper;
import com.kingdee.eas.mm.common.client.TableTreeNode;
import com.kingdee.eas.mm.mo.ScrapTypeEnum;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.report.IMTOOrderTraceFacade;
import com.kingdee.eas.mm.report.MTOOrderTraceFacade;
import com.kingdee.eas.mm.report.MTOOrderTraceFacadeFactory;
import com.kingdee.eas.mm.report.PlannerWorkPlatformFacade;
import com.kingdee.eas.mm.report.client.AbstractMTOBillTraceUI;
import com.kingdee.eas.mm.report.client.ITreeController;
import com.kingdee.eas.mm.report.client.MTOBillTraceFilterUI;
import com.kingdee.eas.mm.report.client.MTOBillTraceTreeUI;
import com.kingdee.eas.mm.report.client.TableHeaderInfo;
import com.kingdee.eas.mm.sfc.ReportTypeEnum;
import com.kingdee.eas.mm.sfc.WPTransferTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MTOBillTraceUI
extends AbstractMTOBillTraceUI
implements ITableTreeController,
ITreeController {
    private static final Logger logger = CoreUIObject.getLogger(MTOBillTraceUI.class);
    public static final String REPORT_RESOURCE = "com.kingdee.eas.mm.report.ReportResource";
    private MTOBillTraceTreeUI aMTOBillTraceTreeUI;
    private TableTreeHelper tableTreeHelper;
    private CommonQueryDialog commonQueryDialog;
    FilterInfo filterInfo;
    private Map tableHeader = new HashMap();
    private List saleOrdersSaved = new ArrayList();
    private List saleBillTypes = new ArrayList();
    private List manufactureBillTypes = new ArrayList();
    private List productionBillTypes = new ArrayList();
    private List requestBillTypes = new ArrayList();
    private boolean pnlSaleHasShowed = false;
    private boolean pnlManufactureHasShowed = false;
    private boolean pnlProductionHasShowed = false;
    private boolean pnlRequestHasShowed = false;
    private boolean pnlSaleRefreshed = false;
    private boolean pnlManufactureRefreshed = false;
    private boolean pnlProductionRefreshed = false;
    private boolean pnlRequestRefreshed = false;
    private List currentBills = new ArrayList();
    private KDTable currentTable = new KDTable();
    private TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
    private SaleOrderInfo saleOrderInfo = null;
    boolean isQueryByTrackNumber = false;
    boolean isShowHeader = true;
    private OrgUnitCollection authorizedMainOrgs = null;
    private int COLUMN_TREENODE = 0;
    private int COLUMN_TREENODE_WIDTH = 200;

    public MTOBillTraceUI() throws Exception {
        this.initTableHeader();
        this.initBillList();
    }

    public void onLoad() throws Exception {
        this.removeRequestDataListener();
        MTOOrderTraceFacade facade = new MTOOrderTraceFacade();
        IObjectPK pk = LogUtil.beginLog(null, (String)"onLoad", (BOSObjectType)facade.getType(), null, (String)EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource.LOG_VIEW"), (String)"mm_MTOBillTrace_view");
        LogUtil.afterLog(null, (IObjectPK)pk);
        super.onLoad();
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 715, 605));
        this.pnlSale.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 705, 575));
        this.pnlManufacture.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 705, 575));
        this.pnlProduction.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 705, 575));
        this.pnlRequest.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 705, 575));
        this.toolBar.remove((Component)this.btnAddNew);
        this.toolBar.remove((Component)this.btnView);
        this.toolBar.remove((Component)this.btnEdit);
        this.toolBar.remove((Component)this.btnRemove);
        this.toolBar.remove((Component)this.btnLocate);
        this.menuBar.remove((Component)this.menuEdit);
        this.menuFile.remove((JMenuItem)this.menuItemAddNew);
        this.menuView.remove((JMenuItem)this.menuItemView);
        this.menuView.remove((JMenuItem)this.menuItemLocate);
        this.buildTreeUI();
        this.currentBills = this.saleBillTypes;
        this.currentTable = this.tblMain;
        this.pnlSaleHasShowed = true;
        this.tableTreeHelper = new TableTreeHelper((CoreUI)this, this.tblMain, (ITableTreeController)this);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        this.parseFilter(ev.getFilter());
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.aMTOBillTraceTreeUI == null) {
            return;
        }
        this.kDTabbedPane1.setSelectedComponent((Component)this.pnlSale);
        this.currentTable = this.tblMain;
        this.pnlManufactureRefreshed = true;
        this.pnlProductionRefreshed = true;
        this.pnlRequestRefreshed = true;
        this.aMTOBillTraceTreeUI.setFilterInfo(this.filterInfo);
        this.aMTOBillTraceTreeUI.initTree();
        this.treePanel.repaint();
        this.currentTable.refresh();
        this.insertRow(this.currentTable, null, 0);
        this.tblMain.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.kDTable1.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.kDTable2.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.kDTable3.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!(this.pnlSaleHasShowed || this.pnlManufactureHasShowed || this.pnlProductionHasShowed || this.pnlRequestHasShowed)) {
            super.actionQuery_actionPerformed(e);
        } else {
            super.actionQuery_actionPerformed(e);
            this.kDTabbedPane1.setSelectedComponent((Component)this.pnlSale);
            this.currentTable = this.tblMain;
            this.pnlManufactureRefreshed = true;
            this.pnlProductionRefreshed = true;
            this.pnlRequestRefreshed = true;
            this.aMTOBillTraceTreeUI.setFilterInfo(this.filterInfo);
            this.aMTOBillTraceTreeUI.initTree();
            this.treePanel.repaint();
            this.currentTable.refresh();
            this.insertRow(this.currentTable, null, 0);
        }
        this.tblMain.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.kDTable1.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.kDTable2.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.kDTable3.getColumn(this.COLUMN_TREENODE).setWidth(this.COLUMN_TREENODE_WIDTH);
        this.actionRefresh_actionPerformed(e);
    }

    public void parseFilter(FilterInfo filterInfo) {
        FilterItemCollection filters = filterInfo.getFilterItems();
        this.filterInfo = filterInfo;
        this.initBillList();
        String propertyName = "";
        Object compareValue = new Object();
        for (int i = 0; i < filters.size(); ++i) {
            propertyName = filters.get(i).getPropertyName();
            compareValue = filters.get(i).getCompareValue();
            if ("btTrackNumber".equals(propertyName)) {
                this.isQueryByTrackNumber = "true".equals(compareValue);
            }
            if (propertyName.endsWith("InSale") && "false".equals(compareValue)) {
                this.saleBillTypes.remove(propertyName);
            }
            if (propertyName.endsWith("InManu") && "false".equals(compareValue)) {
                this.manufactureBillTypes.remove(propertyName);
            }
            if (propertyName.endsWith("InProd") && "false".equals(compareValue)) {
                this.productionBillTypes.remove(propertyName);
            }
            if (!propertyName.endsWith("InReq") || !"false".equals(compareValue)) continue;
            this.requestBillTypes.remove(propertyName);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected ISCMFilter getFilterUI() throws Exception {
        return new MTOBillTraceFilterUI();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(540);
        this.commonQueryDialog.setHeight(440);
        try {
            ISCMFilter iFilter = this.getFilterUI();
            iFilter.setIsSupportMultiOrgs(true);
            iFilter.setContextObject((Object)this.getUIContext());
            iFilter.setAuthorizedMainOrgs(this.getDefaultMainBizOrg());
            this.commonQueryDialog.addUserPanel((KDPanel)iFilter);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setUiObject(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.commonQueryDialog;
    }

    protected OrgUnitCollection getDefaultMainBizOrg() {
        if (this.authorizedMainOrgs == null) {
            this.authorizedMainOrgs = new OrgUnitCollection();
            try {
                OrgUnitInfo[] mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermissionItem());
                if (mainOrgs != null && mainOrgs.length > 0) {
                    mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
                    for (int i = 0; i < mainOrgs.length; ++i) {
                        this.authorizedMainOrgs.add(mainOrgs[i]);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.authorizedMainOrgs;
    }

    protected String getViewPermissionItem() {
        return "mm_MTOBillTrace_Query";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable2.getStyleAttributes().setLocked(true);
        this.kDTable3.getStyleAttributes().setLocked(true);
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.kDTable2.getSelectManager().setSelectMode(2);
        this.kDTable3.getSelectManager().setSelectMode(2);
    }

    public void buildTreeUI() {
        try {
            this.aMTOBillTraceTreeUI = new MTOBillTraceTreeUI(this.filterInfo, this);
            this.aMTOBillTraceTreeUI.initLayout();
            this.aMTOBillTraceTreeUI.onLoad();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.treePanel.add((Component)((Object)this.aMTOBillTraceTreeUI), (Object)"Center");
        this.treePanel.repaint();
    }

    public void removeRequestDataListener() {
        DataSetWrapperFactory dataSetFactory = this.tblMain.getDataRequestManager().getDataSetFactory();
        EventListener[] listener = dataSetFactory.getRequestRowSetListeners();
        for (int i = 0; i < listener.length; ++i) {
            dataSetFactory.removeRequestRowSetListener((RequestRowSetListener)listener[i]);
        }
    }

    protected void initListener() {
        ChangeListener panelChangedlistener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MTOBillTraceUI.this.kDTabbedPane1.getSelectedComponent() == MTOBillTraceUI.this.pnlSale) {
                    MTOBillTraceUI.this.currentBills = MTOBillTraceUI.this.saleBillTypes;
                    MTOBillTraceUI.this.currentTable = MTOBillTraceUI.this.tblMain;
                    if (!MTOBillTraceUI.this.pnlSaleHasShowed) {
                        MTOBillTraceUI.this.pnlSaleHasShowed = true;
                    }
                    if (MTOBillTraceUI.this.pnlSaleRefreshed) {
                        MTOBillTraceUI.this.currentTable.refresh();
                        if ("bySaleOrder".equals(MTOBillTraceUI.this.trackNumberInfo.getString("queryMode")) && MTOBillTraceUI.this.isShowHeader) {
                            MTOBillTraceUI.this.insertHeader(null, -1);
                        } else {
                            MTOBillTraceUI.this.insertRow(MTOBillTraceUI.this.currentTable, null, 0);
                        }
                        MTOBillTraceUI.this.pnlSaleRefreshed = false;
                    }
                } else if (MTOBillTraceUI.this.kDTabbedPane1.getSelectedComponent() == MTOBillTraceUI.this.pnlManufacture) {
                    MTOBillTraceUI.this.currentBills = MTOBillTraceUI.this.manufactureBillTypes;
                    MTOBillTraceUI.this.currentTable = MTOBillTraceUI.this.kDTable1;
                    if (!MTOBillTraceUI.this.pnlManufactureHasShowed) {
                        MTOBillTraceUI.this.tableTreeHelper.addTable(MTOBillTraceUI.this.kDTable1);
                        MTOBillTraceUI.this.pnlManufactureHasShowed = true;
                    }
                    if (MTOBillTraceUI.this.pnlManufactureRefreshed) {
                        MTOBillTraceUI.this.currentTable.refresh();
                        MTOBillTraceUI.this.insertRow(MTOBillTraceUI.this.currentTable, null, 0);
                        MTOBillTraceUI.this.pnlManufactureRefreshed = false;
                    }
                } else if (MTOBillTraceUI.this.kDTabbedPane1.getSelectedComponent() == MTOBillTraceUI.this.pnlProduction) {
                    MTOBillTraceUI.this.currentBills = MTOBillTraceUI.this.productionBillTypes;
                    MTOBillTraceUI.this.currentTable = MTOBillTraceUI.this.kDTable2;
                    if (!MTOBillTraceUI.this.pnlProductionHasShowed) {
                        MTOBillTraceUI.this.tableTreeHelper.addTable(MTOBillTraceUI.this.kDTable2);
                        MTOBillTraceUI.this.pnlProductionHasShowed = true;
                    }
                    if (MTOBillTraceUI.this.pnlProductionRefreshed) {
                        MTOBillTraceUI.this.currentTable.refresh();
                        MTOBillTraceUI.this.insertRow(MTOBillTraceUI.this.currentTable, null, 0);
                        MTOBillTraceUI.this.pnlProductionRefreshed = false;
                    }
                } else if (MTOBillTraceUI.this.kDTabbedPane1.getSelectedComponent() == MTOBillTraceUI.this.pnlRequest) {
                    MTOBillTraceUI.this.currentBills = MTOBillTraceUI.this.requestBillTypes;
                    MTOBillTraceUI.this.currentTable = MTOBillTraceUI.this.kDTable3;
                    if (!MTOBillTraceUI.this.pnlRequestHasShowed) {
                        MTOBillTraceUI.this.tableTreeHelper.addTable(MTOBillTraceUI.this.kDTable3);
                        MTOBillTraceUI.this.pnlRequestHasShowed = true;
                    }
                    if (MTOBillTraceUI.this.pnlRequestRefreshed) {
                        MTOBillTraceUI.this.currentTable.refresh();
                        MTOBillTraceUI.this.insertRow(MTOBillTraceUI.this.currentTable, null, 0);
                        MTOBillTraceUI.this.pnlRequestRefreshed = false;
                    }
                }
            }
        };
        this.kDTabbedPane1.addChangeListener(panelChangedlistener);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public String getTreeColumn() {
        return "tree";
    }

    public void insertRow(KDTable table, TableTreeNode treeNode, int rowIndex) {
        block18: {
            if (treeNode == null) {
                TableTreeNode node = new TableTreeNode();
                List header = (List)this.tableHeader.get(this.currentBills.get(0));
                String rsKey = "";
                node.setId("0");
                node.setLeaf(false);
                node.setFirst(true);
                node.setLast(true);
                node.setLevel(1);
                node.setHasExpanded(false);
                node.setHasChild(true);
                node.setIconEmpty(false);
                rsKey = ((TableHeaderInfo)header.get(0)).getRsKey();
                node.setName(EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
                node.setUserObject(this.currentBills.get(0));
                IRow row = this.currentTable.addRow();
                row.getStyleAttributes().setBackground(this.tblMain.getHead().getRow(0).getStyle().getBackground());
                row.getCell(0).setValue((Object)node);
                node.setExpanded(true);
                node.setHasExpanded(true);
                for (int i = 1; i < header.size(); ++i) {
                    rsKey = ((TableHeaderInfo)header.get(i)).getRsKey();
                    row.getCell(i).setValue((Object)EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
                }
                if ("saleOrderInSale".equals(this.currentBills.get(0))) {
                    if (this.isQueryByTrackNumber && this.isShowHeader) {
                        this.insertHeader(null, rowIndex);
                    }
                    this.insertSaleOrder(node, rowIndex);
                } else {
                    try {
                        boolean flag = this.aMTOBillTraceTreeUI.isSelectedTreeNode();
                        if (flag) {
                            IRowSet set = this.getTreeInterface().getBills((String)node.getUserObject(), "", this.trackNumberInfo, this.saleOrderInfo);
                            this.insertData(node, set, rowIndex);
                            break block18;
                        }
                        JdbcRowSet set = new JdbcRowSet();
                        this.insertData(node, (IRowSet)set, rowIndex);
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                        SysUtil.abort();
                    }
                }
            } else if (treeNode.isDataLevel() && !treeNode.isLeaf()) {
                treeNode.setHasChild(true);
                treeNode.setLeaf(false);
                this.insertHeader(treeNode, rowIndex);
            } else {
                try {
                    TrackNumberInfo trackNumber = new TrackNumberInfo();
                    trackNumber.setId(this.trackNumberInfo.getId());
                    trackNumber.setNumber(this.trackNumberInfo.getNumber());
                    SaleOrderInfo saleOrder = null;
                    String sourceBillID = "";
                    if (treeNode.getLevel() > 1) {
                        if ("saleOrderInSale".equals(this.currentBills.get(0))) {
                            saleOrder = (SaleOrderInfo)treeNode.getParent().getUserObject();
                            trackNumber.setString("queryMode", "bySaleOrder");
                        } else {
                            sourceBillID = (String)treeNode.getParent().getUserObject();
                        }
                    } else if ("saleOrderInSale".equals(this.currentBills.get(0))) {
                        trackNumber.setString("queryMode", "bySaleOrder");
                    }
                    IRowSet set = this.getTreeInterface().getBills((String)treeNode.getUserObject(), sourceBillID, trackNumber, saleOrder);
                    this.insertData(treeNode, set, rowIndex);
                }
                catch (Exception e) {
                    this.handUIException(e);
                    SysUtil.abort();
                }
            }
        }
    }

    public void insertHeader(TableTreeNode treeNode, int rowIndex) {
        String billType = "";
        String rsKey = "";
        for (int i = 1; i < this.currentBills.size(); ++i) {
            IRow row = this.currentTable.addRow(++rowIndex);
            row.getStyleAttributes().setBackground(this.tblMain.getHead().getRow(0).getStyle().getBackground());
            billType = (String)this.currentBills.get(i);
            List header = (List)this.tableHeader.get(billType);
            TableTreeNode node = new TableTreeNode();
            node.setId(String.valueOf(i));
            node.setLeaf(false);
            node.setFirst(i == 1);
            node.setLast(i == this.currentBills.size() - 1);
            node.setLevel(null != treeNode ? treeNode.getLevel() + 1 : 1);
            node.setDataLevel(false);
            node.setHasExpanded(false);
            node.setHasChild(true);
            node.setIconEmpty(false);
            rsKey = ((TableHeaderInfo)header.get(0)).getRsKey();
            node.setName(EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
            node.setParent(treeNode);
            node.setUserObject((Object)billType);
            row.getCell(0).setValue((Object)node);
            for (int j = 1; j < header.size(); ++j) {
                rsKey = ((TableHeaderInfo)header.get(j)).getRsKey();
                row.getCell(j).setValue((Object)EASResource.getString((String)REPORT_RESOURCE, (String)rsKey));
            }
        }
    }

    public void insertData(TableTreeNode treeNode, IRowSet set, int rowIndex) throws Exception {
        String billType = (String)treeNode.getUserObject();
        int i = 0;
        while (set.next()) {
            IRow row = this.currentTable.addRow(++rowIndex);
            TableTreeNode node = new TableTreeNode();
            node.setId(String.valueOf(i));
            if (!billType.equals(this.currentBills.get(0))) {
                node.setLeaf(true);
            } else {
                node.setHasChild(true);
            }
            node.setFirst(i == 0);
            node.setLast(i == set.size() - 1);
            node.setLevel(treeNode.getLevel() + 1);
            node.setDataLevel(true);
            node.setHasExpanded(false);
            node.setIconEmpty(false);
            node.setName(set.getString("FNUMBER"));
            node.setUserObject((Object)set.getString("ID"));
            node.setParent(treeNode);
            row.getCell(0).setValue((Object)node);
            List tableHeaderExpand = (List)this.tableHeader.get(billType);
            String fieldName = "";
            for (int j = 1; j < tableHeaderExpand.size(); ++j) {
                fieldName = ((TableHeaderInfo)tableHeaderExpand.get(j)).getFieldName();
                if ("BASESTATUS".equals(fieldName)) {
                    row.getCell(j).setValue((Object)BillBaseStatusEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("ENTRYBASESTATUS".equals(fieldName)) {
                    row.getCell(j).setValue((Object)EntryBaseStatusEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("SCRAPTYPE".equals(fieldName)) {
                    row.getCell(j).setValue((Object)ScrapTypeEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("REPORTTYPE".equals(fieldName)) {
                    row.getCell(j).setValue((Object)ReportTypeEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("TRANSFERTYPE".equals(fieldName)) {
                    row.getCell(j).setValue((Object)WPTransferTypeEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("ORDERTYPE".equals(fieldName)) {
                    row.getCell(j).setValue((Object)PlannedOrderTypeEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("DOSINGTYPE".equals(fieldName)) {
                    row.getCell(j).setValue((Object)DosingTypeEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("OUTPUTTYPE".equals(fieldName)) {
                    row.getCell(j).setValue((Object)MaterialProductEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if ("MATERIALATTR".equals(fieldName)) {
                    row.getCell(j).setValue((Object)MaterialAttributeEnum.getEnum((int)set.getInt(fieldName)));
                    continue;
                }
                if (fieldName.indexOf("DATE") != -1) {
                    row.getCell(j).setValue((Object)this.convertDate(set.getString(fieldName)));
                    continue;
                }
                if (fieldName.indexOf("QTY") != -1) {
                    row.getCell(j).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    if (new BigDecimal("0.0").compareTo(set.getBigDecimal(fieldName)) == 0) {
                        row.getCell(j).setValue(null);
                        continue;
                    }
                    row.getCell(j).setValue((Object)set.getBigDecimal(fieldName).setScale(set.getInt("QtyPrecision")));
                    continue;
                }
                row.getCell(j).setValue((Object)set.getString(fieldName));
            }
            ++i;
        }
        if (i == 0) {
            treeNode.setHasChild(false);
        }
    }

    public void insertSaleOrder(TableTreeNode treeNode, int rowIndex) {
        Iterator iterSaleOrder = this.saleOrdersSaved.iterator();
        int i = 0;
        while (iterSaleOrder.hasNext()) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)iterSaleOrder.next();
            IRow row = this.currentTable.addRow(++rowIndex);
            TableTreeNode node = new TableTreeNode();
            node.setId(String.valueOf(i));
            node.setFirst(i == 0);
            node.setLast(i == this.saleOrdersSaved.size() - 1);
            node.setLevel(treeNode.getLevel() + 1);
            node.setDataLevel(true);
            node.setHasExpanded(false);
            node.setHasChild(false);
            node.setIconEmpty(false);
            node.setName(saleOrderInfo.getNumber());
            node.setParent(treeNode);
            node.setUserObject((Object)saleOrderInfo);
            SaleOrderEntryInfo saleOrderEntryInfo = saleOrderInfo.getEntries().get(0);
            row.getCell(0).setValue((Object)node);
            row.getCell(1).setValue((Object)saleOrderInfo.getNumber());
            row.getCell(2).setValue((Object)saleOrderInfo.getSaleOrgUnit().getName());
            row.getCell(3).setValue((Object)saleOrderEntryInfo.getMaterial().getNumber());
            row.getCell(4).setValue((Object)saleOrderEntryInfo.getMaterial().getName());
            row.getCell(5).setValue((Object)saleOrderEntryInfo.getMaterial().getModel());
            row.getCell(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell(6).setValue((Object)saleOrderEntryInfo.getQty());
            row.getCell(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell(7).setValue((Object)saleOrderEntryInfo.getTotalIssueQty());
            row.getCell(8).setValue((Object)saleOrderEntryInfo.getUnit().getName());
            row.getCell(9).setValue((Object)this.convertDate(saleOrderEntryInfo.getSendDate().toString()));
            row.getCell(10).setValue((Object)saleOrderEntryInfo.getTrackNumber().getNumber());
            row.getCell(11).setValue((Object)saleOrderEntryInfo.getBaseStatus());
            row.getCell(12).setValue((Object)saleOrderInfo.getBizType().getName());
            row.getCell(13).setValue((Object)saleOrderInfo.getOrderCustomer().getNumber());
            row.getCell(14).setValue((Object)this.convertDate(saleOrderInfo.getCreateTime().toString()));
            row.getCell(15).setValue((Object)saleOrderInfo.getStorageOrgUnit().getName());
            row.getCell(16).setValue((Object)new Integer(saleOrderEntryInfo.getSeq()));
            ++i;
        }
        if (i == 0) {
            treeNode.setHasChild(false);
        }
    }

    @Override
    public void selectSaleOrder(SaleOrderInfo saleOrderInfo, Map trackNumbers) {
        this.setTableNeedRefresh();
        this.trackNumberInfo = (TrackNumberInfo)trackNumbers.get(saleOrderInfo);
        this.trackNumberInfo.setString("queryMode", "bySaleOrder");
        this.isShowHeader = false;
        if (null == saleOrderInfo.getId()) {
            this.saleOrderInfo = null;
            this.currentTable.refresh();
            this.isShowHeader = true;
            if ("saleOrderInSale".equals(this.currentBills.get(0))) {
                this.insertHeader(null, -1);
            } else {
                this.insertRow(this.currentTable, null, 0);
            }
        } else {
            this.saleOrderInfo = saleOrderInfo;
            ArrayList<SaleOrderInfo> tempSaleOrder = new ArrayList<SaleOrderInfo>();
            tempSaleOrder.add(this.saleOrderInfo);
            this.saleOrdersSaved = tempSaleOrder;
            this.currentTable.refresh();
            this.insertRow(this.currentTable, null, 0);
        }
    }

    @Override
    public void selectTrackNumber(TrackNumberInfo trackNumberInfo, Map saleOrders) {
        this.setTableNeedRefresh();
        this.trackNumberInfo = trackNumberInfo;
        this.isShowHeader = true;
        this.saleOrdersSaved = (List)saleOrders.get(trackNumberInfo.getNumber());
        if (this.isQueryByTrackNumber) {
            this.trackNumberInfo.setString("queryMode", "byTrackNumber");
        } else {
            this.trackNumberInfo.setString("queryMode", "byTrackNumberWithSaleOrder");
            StringBuffer saleOrder = new StringBuffer("(");
            for (int i = 0; i < this.saleOrdersSaved.size() - 1; ++i) {
                saleOrder.append("'").append(((SaleOrderInfo)this.saleOrdersSaved.get(i)).getNumber()).append("'").append(",");
            }
            saleOrder.append("'");
            saleOrder.append(((SaleOrderInfo)this.saleOrdersSaved.get(this.saleOrdersSaved.size() - 1)).getNumber());
            saleOrder.append("')");
            this.trackNumberInfo.setString("saleOrder", saleOrder.toString());
        }
        this.currentTable.refresh();
        this.insertRow(this.currentTable, null, 0);
    }

    private void setTableNeedRefresh() {
        this.pnlSaleRefreshed = true;
        this.pnlManufactureRefreshed = true;
        this.pnlProductionRefreshed = true;
        this.pnlRequestRefreshed = true;
        if (this.currentTable == this.tblMain) {
            this.pnlSaleRefreshed = false;
        } else if (this.currentTable == this.kDTable1) {
            this.pnlManufactureRefreshed = false;
        } else if (this.currentTable == this.kDTable2) {
            this.pnlProductionRefreshed = false;
        } else if (this.currentTable == this.kDTable3) {
            this.pnlRequestRefreshed = false;
        }
    }

    @Override
    public void setIcon() {
    }

    public void setSaleOrdersSaved(List saleOrdersSaved) {
        this.saleOrdersSaved = saleOrdersSaved;
    }

    public void setTrackNumberInfo(TrackNumberInfo trackNumberInfo) {
        this.trackNumberInfo = trackNumberInfo;
        if (this.isQueryByTrackNumber) {
            this.trackNumberInfo.setString("queryMode", "byTrackNumber");
        } else {
            this.trackNumberInfo.setString("queryMode", "byTrackNumberWithSaleOrder");
            StringBuffer saleOrder = new StringBuffer("(");
            for (int i = 0; i < this.saleOrdersSaved.size() - 1; ++i) {
                saleOrder.append("'").append(((SaleOrderInfo)this.saleOrdersSaved.get(i)).getNumber()).append("'").append(",");
            }
            saleOrder.append("'");
            saleOrder.append(((SaleOrderInfo)this.saleOrdersSaved.get(this.saleOrdersSaved.size() - 1)).getNumber());
            saleOrder.append("')");
            this.trackNumberInfo.setString("saleOrder", saleOrder.toString());
        }
    }

    protected IMTOOrderTraceFacade getTreeInterface() throws Exception {
        return MTOOrderTraceFacadeFactory.getRemoteInstanceWithObjectContext(this.getUserContext());
    }

    private String convertDate(String source) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if ("".equals(source) || source == null) {
                return "";
            }
            date = dateFormat.parse(source);
        }
        catch (ParseException e) {
            date = new Date();
        }
        return dateFormat.format(date);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        PlannerWorkPlatformFacade facade = new PlannerWorkPlatformFacade();
        IObjectPK pk = LogUtil.beginLog(null, (String)"onLoad", (BOSObjectType)facade.getType(), null, (String)EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource.LOG_INSTANCE"), (String)"mm_MTOBillTrace_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
        this.doPrint(false);
    }

    public void actoinPreview_actionPerformed(ActionEvent e) throws Exception {
        PlannerWorkPlatformFacade facade = new PlannerWorkPlatformFacade();
        IObjectPK pk = LogUtil.beginLog(null, (String)"onLoad", (BOSObjectType)facade.getType(), null, (String)EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource.LOG_INSTANCE"), (String)"mm_MTOBillTrace_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
        this.doPrint(true);
    }

    private void doPrint(boolean preview) {
        if (preview) {
            this.currentTable.getPrintManager().printPreview();
        } else {
            this.currentTable.getPrintManager().print();
        }
    }

    public int getRowCountFromDB() {
        return this.getTableForCommon().getRowCount();
    }

    public void initBillList() {
        this.saleBillTypes.clear();
        this.manufactureBillTypes.clear();
        this.productionBillTypes.clear();
        this.requestBillTypes.clear();
        this.saleBillTypes.add("saleOrderInSale");
        this.saleBillTypes.add("plannedOrderInSale");
        this.saleBillTypes.add("manufactureOrderInSale");
        this.saleBillTypes.add("productionOrderInSale");
        this.saleBillTypes.add("purRequestInSale");
        this.saleBillTypes.add("purOrderInSale");
        this.saleBillTypes.add("purReqInSale");
        this.saleBillTypes.add("stockTransferBillInSale");
        this.saleBillTypes.add("transferOrderBillInSale");
        this.saleBillTypes.add("saleIssueBillInSale");
        this.manufactureBillTypes.add("manufactureOrderInManu");
        this.manufactureBillTypes.add("materialReqBillInManu");
        this.manufactureBillTypes.add("wPTransferBillInManu");
        this.manufactureBillTypes.add("completionReportInManu");
        this.manufactureBillTypes.add("scrapOrderInManu");
        this.manufactureBillTypes.add("stockTransferBillInManu");
        this.manufactureBillTypes.add("transferOrderBillInManu");
        this.manufactureBillTypes.add("manufactureRecBillInManu");
        this.productionBillTypes.add("productionOrderInProd");
        this.productionBillTypes.add("taskDispBillInProd");
        this.productionBillTypes.add("pickingSlipBillInProd");
        this.productionBillTypes.add("materialReqBillInProd");
        this.productionBillTypes.add("finishedRptInProd");
        this.productionBillTypes.add("manufactureRecBillInProd");
        this.requestBillTypes.add("purRequestInReq");
        this.requestBillTypes.add("subContractOrderInReq");
        this.requestBillTypes.add("purInWarehsBillInReq");
        this.requestBillTypes.add("materialRequestBillInReq");
    }

    public void initTableHeader() {
        this.tableHeader.put("saleOrderInSale", this.initSaleOrderHeader());
        this.tableHeader.put("plannedOrderInSale", this.initPlannedOrderHeader());
        this.tableHeader.put("manufactureOrderInSale", this.initManufactureOrderHeader());
        this.tableHeader.put("productionOrderInSale", this.initProductionOrderHeader());
        this.tableHeader.put("purRequestInSale", this.initPurRequestHeader());
        this.tableHeader.put("purReqInSale", this.initPurReqHeader());
        this.tableHeader.put("purOrderInSale", this.initPurOrderHeader());
        this.tableHeader.put("subContractOrderInSale", this.initSubContractOrderHeader());
        this.tableHeader.put("stockTransferBillInSale", this.initStockTransferBillHeader());
        this.tableHeader.put("transferOrderBillInSale", this.initTransferOrderBillHeader());
        this.tableHeader.put("saleIssueBillInSale", this.initSaleIssueBillHeader());
        this.tableHeader.put("manufactureOrderInManu", this.initManufactureOrderHeader());
        this.tableHeader.put("materialReqBillInManu", this.initMaterialReqBillHeader());
        this.tableHeader.put("wPTransferBillInManu", this.initWPTransferBillHeader());
        this.tableHeader.put("completionReportInManu", this.initCompletionReportHeader());
        this.tableHeader.put("scrapOrderInManu", this.initScrapOrderHeader());
        this.tableHeader.put("stockTransferBillInManu", this.initStockTransferBillHeader());
        this.tableHeader.put("transferOrderBillInManu", this.initTransferOrderBillHeader());
        this.tableHeader.put("manufactureRecBillInManu", this.initManufactureRecBillHeader());
        this.tableHeader.put("productionOrderInProd", this.initProductionOrderHeader());
        this.tableHeader.put("taskDispBillInProd", this.initTaskDispBillHeader());
        this.tableHeader.put("pickingSlipBillInProd", this.initPickingSlipBillHeader());
        this.tableHeader.put("materialReqBillInProd", this.initMaterialReqBillHeader());
        this.tableHeader.put("finishedRptInProd", this.initFinishedRptHeader());
        this.tableHeader.put("stockTransferBillInProd", this.initStockTransferBillHeader());
        this.tableHeader.put("transferOrderBillInProd", this.initTransferOrderBillHeader());
        this.tableHeader.put("manufactureRecBillInProd", this.initManufactureRecBillHeader());
        this.tableHeader.put("purRequestInReq", this.initPurReqHeader());
        this.tableHeader.put("subContractOrderInReq", this.initSubContractOrderHeader());
        this.tableHeader.put("purInWarehsBillInReq", this.initPurInWarehsBillHeader());
        this.tableHeader.put("materialRequestBillInReq", this.initMaterialRequestBillHeader());
    }

    public List initMaterialRequestBillHeader() {
        ArrayList<TableHeaderInfo> materialRequestBillHeader = new ArrayList<TableHeaderInfo>();
        materialRequestBillHeader.add(new TableHeaderInfo("materialRequestBillInReq", "FNUMBER", "MATERIALREQUEST_BILL"));
        materialRequestBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        materialRequestBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        materialRequestBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        materialRequestBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        materialRequestBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        materialRequestBillHeader.add(new TableHeaderInfo("REQUESTQTY", "QTY", "QTY"));
        materialRequestBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        materialRequestBillHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        materialRequestBillHeader.add(new TableHeaderInfo("WAREHOUSE", "WAREHOUSE", "WAREHOUSE"));
        materialRequestBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        materialRequestBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        materialRequestBillHeader.add(new TableHeaderInfo("TRANSACTIONTYPE", "TRANSACTIONTYPE", "TRANSACTION_TYPE"));
        materialRequestBillHeader.add(new TableHeaderInfo("SUPPLIER", "SUPPLIER", "SUPPLIER"));
        materialRequestBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return materialRequestBillHeader;
    }

    public List initPurInWarehsBillHeader() {
        ArrayList<TableHeaderInfo> purInWarehsBillHeader = new ArrayList<TableHeaderInfo>();
        purInWarehsBillHeader.add(new TableHeaderInfo("purInWarehsBillInReq", "FNUMBER", "PURINWAREHS_BILL"));
        purInWarehsBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        purInWarehsBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        purInWarehsBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        purInWarehsBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        purInWarehsBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        purInWarehsBillHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        purInWarehsBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        purInWarehsBillHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "BIZDATE"));
        purInWarehsBillHeader.add(new TableHeaderInfo("WAREHOUSE", "WAREHOUSE", "WAREHOUSE"));
        purInWarehsBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        purInWarehsBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        purInWarehsBillHeader.add(new TableHeaderInfo("TRANSACTIONTYPE", "TRANSACTIONTYPE", "TRANSACTION_TYPE"));
        purInWarehsBillHeader.add(new TableHeaderInfo("SUPPLIER", "SUPPLIER", "SUPPLIER"));
        purInWarehsBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return purInWarehsBillHeader;
    }

    public List initFinishedRptHeader() {
        ArrayList<TableHeaderInfo> finishedRptHeader = new ArrayList<TableHeaderInfo>();
        finishedRptHeader.add(new TableHeaderInfo("finishedRptInProd", "FNUMBER", "FINISHEDRPT"));
        finishedRptHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        finishedRptHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        finishedRptHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        finishedRptHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        finishedRptHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        finishedRptHeader.add(new TableHeaderInfo("COMMITQTY", "COMMITQTY", "COMMITTOTALQTY"));
        finishedRptHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        finishedRptHeader.add(new TableHeaderInfo("FINISHDATE", "FINISHDATE", "ENDDATE"));
        finishedRptHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "BIZDATE"));
        finishedRptHeader.add(new TableHeaderInfo("WAREHOUSE", "WAREHOUSE", "IN_WAREHOUSE"));
        finishedRptHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        finishedRptHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        finishedRptHeader.add(new TableHeaderInfo("TASKDISPBILL", "TASKDISPBILL", "TASKDISP_BILL_NO"));
        finishedRptHeader.add(new TableHeaderInfo("OUTPUTTYPE", "OUTPUTTYPE", "OUTPUT_TYPE"));
        finishedRptHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return finishedRptHeader;
    }

    public List initPickingSlipBillHeader() {
        ArrayList<TableHeaderInfo> pickingSlipBillHeader = new ArrayList<TableHeaderInfo>();
        pickingSlipBillHeader.add(new TableHeaderInfo("pickingSlipBillInProd", "FNUMBER", "PICKINGSLIP_BILL"));
        pickingSlipBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        pickingSlipBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        pickingSlipBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        pickingSlipBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        pickingSlipBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        pickingSlipBillHeader.add(new TableHeaderInfo("QTY", "QTY", "REQUEST_QTY"));
        pickingSlipBillHeader.add(new TableHeaderInfo("REQUIREMENTDATE", "REQUIREMENTDATE", "REQUIREMENT_DATE"));
        pickingSlipBillHeader.add(new TableHeaderInfo("PICKINGDATE", "PICKINGDATE", "PICKING_DATE"));
        pickingSlipBillHeader.add(new TableHeaderInfo("PICKINGWAREHOUSE", "PICKINGWAREHOUSE", "PICKING_WAREHOUSE"));
        pickingSlipBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        pickingSlipBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        pickingSlipBillHeader.add(new TableHeaderInfo("WORKSHOP", "WORKSHOP", "WORKSHOP"));
        pickingSlipBillHeader.add(new TableHeaderInfo("PRODUCTLINE", "PRODUCTLINE", "PRODUCTLINE"));
        pickingSlipBillHeader.add(new TableHeaderInfo("PRODUCTLINEWP", "PRODUCTLINEWP", "PRODUCTLINE_WP"));
        pickingSlipBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return pickingSlipBillHeader;
    }

    public List initTaskDispBillHeader() {
        ArrayList<TableHeaderInfo> taskDispBillHeader = new ArrayList<TableHeaderInfo>();
        taskDispBillHeader.add(new TableHeaderInfo("taskDispBillInProd", "FNUMBER", "TASKDISP_BILL"));
        taskDispBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        taskDispBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        taskDispBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        taskDispBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        taskDispBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        taskDispBillHeader.add(new TableHeaderInfo("PRODUCTQTY", "PRODUCTQTY", "PRODUCTQTY"));
        taskDispBillHeader.add(new TableHeaderInfo("COMMITTOTALQTY", "COMMITTOTALQTY", "COMMITTOTALQTY"));
        taskDispBillHeader.add(new TableHeaderInfo("UNITNAME", "PRODUCTUNIT", "UNIT_NAME"));
        taskDispBillHeader.add(new TableHeaderInfo("STARTDATE", "STARTDATE", "STARTTIME"));
        taskDispBillHeader.add(new TableHeaderInfo("ENDDATE", "ENDDATE", "ENDDATE"));
        taskDispBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        taskDispBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        taskDispBillHeader.add(new TableHeaderInfo("PRODUCTLINE", "PRODUCTLINE", "PRODUCTLINE"));
        taskDispBillHeader.add(new TableHeaderInfo("SHIFT", "SHIFT", "SHIFT"));
        taskDispBillHeader.add(new TableHeaderInfo("CLASSGROUP", "CLASSGROUP", "CLASSGROUP"));
        return taskDispBillHeader;
    }

    public List initManufactureRecBillHeader() {
        ArrayList<TableHeaderInfo> manufactureRecBillHeader = new ArrayList<TableHeaderInfo>();
        manufactureRecBillHeader.add(new TableHeaderInfo("manufactureRecBillInManu", "FNUMBER", "MANUFACTOREREC_BILL"));
        manufactureRecBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        manufactureRecBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        manufactureRecBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        manufactureRecBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        manufactureRecBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        manufactureRecBillHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        manufactureRecBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        manufactureRecBillHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "BIZDATE"));
        manufactureRecBillHeader.add(new TableHeaderInfo("WAREHOUSE", "WAREHOUSE", "WAREHOUSE"));
        manufactureRecBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        manufactureRecBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        manufactureRecBillHeader.add(new TableHeaderInfo("TRANSACTIONTYPE", "TRANSACTIONTYPE", "TRANSACTION_TYPE"));
        manufactureRecBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return manufactureRecBillHeader;
    }

    public List initScrapOrderHeader() {
        ArrayList<TableHeaderInfo> scrapOrderHeader = new ArrayList<TableHeaderInfo>();
        scrapOrderHeader.add(new TableHeaderInfo("scrapOrderInManu", "FNUMBER", "SCRAPT_ORDER"));
        scrapOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        scrapOrderHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        scrapOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        scrapOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        scrapOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        scrapOrderHeader.add(new TableHeaderInfo("SCRAPQTY", "SCRAPQTY", "SCRAPQTY"));
        scrapOrderHeader.add(new TableHeaderInfo("SUPPLIEDQTY", "SUPPLIEDQTY", "SUPPLIERQTY"));
        scrapOrderHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        scrapOrderHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "BIZDATE"));
        scrapOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        scrapOrderHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        scrapOrderHeader.add(new TableHeaderInfo("REASONCODE", "REASONCODE", "REASONCODE"));
        scrapOrderHeader.add(new TableHeaderInfo("SCRAPTYPE", "SCRAPTYPE", "SCRAPTYPE"));
        scrapOrderHeader.add(new TableHeaderInfo("SOURCEBILLNUMBER", "SOURCEBILLNUMBER", "SOURCEBILL_ID"));
        scrapOrderHeader.add(new TableHeaderInfo("ADMINORUNIT", "ADMINORUNIT", "ADMINORG_UNIT"));
        scrapOrderHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return scrapOrderHeader;
    }

    public List initCompletionReportHeader() {
        ArrayList<TableHeaderInfo> completionReportHeader = new ArrayList<TableHeaderInfo>();
        completionReportHeader.add(new TableHeaderInfo("completionReportInManu", "FNUMBER", "COMPLETIONREPORT"));
        completionReportHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        completionReportHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        completionReportHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        completionReportHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        completionReportHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        completionReportHeader.add(new TableHeaderInfo("REPORTQTY", "REPORTQTY", "REPORTQTY"));
        completionReportHeader.add(new TableHeaderInfo("QUALIFIEDQTY", "QUALIFIEDQTY", "QUALIFIEDQTY"));
        completionReportHeader.add(new TableHeaderInfo("REPAIRQTY", "REPAIRQTY", "REPAIRQTY"));
        completionReportHeader.add(new TableHeaderInfo("SCRAPQTY", "SCRAPQTY", "SCRAPQTY"));
        completionReportHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        completionReportHeader.add(new TableHeaderInfo("REPORTDATE", "REPORTDATE", "REPORT_TIME"));
        completionReportHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        completionReportHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        completionReportHeader.add(new TableHeaderInfo("REPORTTYPE", "REPORTTYPE", "REPORT_TYPE"));
        completionReportHeader.add(new TableHeaderInfo("SOURCEBILLNUMBER", "SOURCEBILLNUMBER", "SOURCEBILL_ID"));
        completionReportHeader.add(new TableHeaderInfo("DEPARTMENT", "DEPARTMENT", "DEPARTMENT"));
        completionReportHeader.add(new TableHeaderInfo("OPNO", "OPNO", "OP_NO"));
        completionReportHeader.add(new TableHeaderInfo("PROCESS", "PROCESS", "PROCESS"));
        return completionReportHeader;
    }

    public List initWPTransferBillHeader() {
        ArrayList<TableHeaderInfo> wPTransferBillHeader = new ArrayList<TableHeaderInfo>();
        wPTransferBillHeader.add(new TableHeaderInfo("wPTransferBillInManu", "FNUMBER", "WPTTRANSFER_BILL"));
        wPTransferBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        wPTransferBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        wPTransferBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        wPTransferBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        wPTransferBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        wPTransferBillHeader.add(new TableHeaderInfo("TRANSFERQTY", "TRANSFERQTY", "TRANSFER_QTY"));
        wPTransferBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        wPTransferBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        wPTransferBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        wPTransferBillHeader.add(new TableHeaderInfo("TRANSFERTYPE", "TRANSFERTYPE", "TRANSFER_TYPE"));
        wPTransferBillHeader.add(new TableHeaderInfo("SRCOPERATIONNO", "SRCOPERATIONNO", "SRC_OPERATIONNO"));
        wPTransferBillHeader.add(new TableHeaderInfo("SRCOPERATION", "SRCOPERATION", "SRC_OPERATION"));
        wPTransferBillHeader.add(new TableHeaderInfo("TARGETOPERATIONNO", "TARGETOPERATIONNO", "TARGETOPERATIONNO"));
        wPTransferBillHeader.add(new TableHeaderInfo("TARGETOPERATIONNAME", "TARGETOPERATIONNAME", "TARGETOPERATIONNAME"));
        return wPTransferBillHeader;
    }

    public List initMaterialReqBillHeader() {
        ArrayList<TableHeaderInfo> materialReqBillHeader = new ArrayList<TableHeaderInfo>();
        materialReqBillHeader.add(new TableHeaderInfo("materialReqBillInManu", "FNUMBER", "MATERIALREQ_BILL"));
        materialReqBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        materialReqBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        materialReqBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        materialReqBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        materialReqBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        materialReqBillHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        materialReqBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        materialReqBillHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "BIZDATE"));
        materialReqBillHeader.add(new TableHeaderInfo("WAREHOUSE", "WAREHOUSE", "WAREHOUSE"));
        materialReqBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        materialReqBillHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        materialReqBillHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        materialReqBillHeader.add(new TableHeaderInfo("TRANSACTIONTYPE", "TRANSACTIONTYPE", "TRANSACTION_TYPE"));
        materialReqBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return materialReqBillHeader;
    }

    public List initSaleOrderHeader() {
        ArrayList<TableHeaderInfo> saleOrderHeader = new ArrayList<TableHeaderInfo>();
        saleOrderHeader.add(new TableHeaderInfo("saleOrderInSale", "FNUMBER", "SALE_ORDER"));
        saleOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        saleOrderHeader.add(new TableHeaderInfo("SALEORGUNITNAME", "SALEORGUNITNAME", "SALE_ORG_UNIT"));
        saleOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        saleOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        saleOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        saleOrderHeader.add(new TableHeaderInfo("ENTRIESQTY", "ENTRIESQTY", "QTY"));
        saleOrderHeader.add(new TableHeaderInfo("ENTRIESTOTALISSUEQTY", "ENTRIESTOTALISSUEQTY", "TOTAL_ISSUEQTY"));
        saleOrderHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        saleOrderHeader.add(new TableHeaderInfo("ENTRIESSENDDATE", "ENTRIESSENDDATE", "SENDDATE"));
        saleOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        saleOrderHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        saleOrderHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        saleOrderHeader.add(new TableHeaderInfo("ORDERCUSTOMERNUMBER", "ORDERCUSTOMERNUMBER", "ORDERCUSTOMER_NUMBER"));
        saleOrderHeader.add(new TableHeaderInfo("SALEORDERCREATETIME", "SALEORDERCREATETIME", "SALEORDER_CREATETIME"));
        saleOrderHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGEORGUNIT_NAME"));
        saleOrderHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return saleOrderHeader;
    }

    public List initPlannedOrderHeader() {
        ArrayList<TableHeaderInfo> plannedOrderHeader = new ArrayList<TableHeaderInfo>();
        plannedOrderHeader.add(new TableHeaderInfo("plannedOrderInSale", "FNUMBER", "PLANNED_ORDER"));
        plannedOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        plannedOrderHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        plannedOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        plannedOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        plannedOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        plannedOrderHeader.add(new TableHeaderInfo("QTY", "QTY", "PLANNEDORDER_QTY"));
        plannedOrderHeader.add(new TableHeaderInfo("TOTALRELEASEQTY", "TOTALRELEASEQTY", "TOTAL_RELEASE_QTY"));
        plannedOrderHeader.add(new TableHeaderInfo("PRODUCTUNIT", "PRODUCTUNIT", "UNIT_NAME"));
        plannedOrderHeader.add(new TableHeaderInfo("STARTDATE", "STARTDATE", "PLAN_STARTDATE"));
        plannedOrderHeader.add(new TableHeaderInfo("ENDDATE", "ENDDATE", "PLAN_ENDDATE"));
        plannedOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        plannedOrderHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        plannedOrderHeader.add(new TableHeaderInfo("ORDERTYPE", "ORDERTYPE", "ORDER_TYPE"));
        plannedOrderHeader.add(new TableHeaderInfo("MATERIALATTR", "MATERIALATTR", "MATERIAL_ATTR"));
        return plannedOrderHeader;
    }

    public List initManufactureOrderHeader() {
        ArrayList<TableHeaderInfo> manufactureOrderHeader = new ArrayList<TableHeaderInfo>();
        manufactureOrderHeader.add(new TableHeaderInfo("manufactureOrderInSale", "FNUMBER", "MANUFACTORE_ORDER"));
        manufactureOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        manufactureOrderHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        manufactureOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        manufactureOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        manufactureOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        manufactureOrderHeader.add(new TableHeaderInfo("QTY", "QTY", "PLANNEDORDER_QTY"));
        manufactureOrderHeader.add(new TableHeaderInfo("FINISHEDQTY", "FINISHEDQTY", "FINISHED_QTY"));
        manufactureOrderHeader.add(new TableHeaderInfo("TOSTOREQTY", "TOSTOREQTY", "TOSTORE_QTY"));
        manufactureOrderHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        manufactureOrderHeader.add(new TableHeaderInfo("PLANBEGINDATE", "PLANBEGINDATE", "PLAN_BEGIN_DATE"));
        manufactureOrderHeader.add(new TableHeaderInfo("PLANENDDATE", "PLANENDDATE", "PLAN_END_DATE"));
        manufactureOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        manufactureOrderHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        manufactureOrderHeader.add(new TableHeaderInfo("TRANSACTIONTYPE", "TRANSACTIONTYPE", "TRANSACTION_TYPE"));
        manufactureOrderHeader.add(new TableHeaderInfo("BOMNUM", "BOMNUM", "BOM_NUM"));
        manufactureOrderHeader.add(new TableHeaderInfo("ROOTING", "ROOTING", "ROOTING_NUMBER"));
        return manufactureOrderHeader;
    }

    public List initProductionOrderHeader() {
        ArrayList<TableHeaderInfo> productionOrderHeader = new ArrayList<TableHeaderInfo>();
        productionOrderHeader.add(new TableHeaderInfo("productionOrderInSale", "FNUMBER", "PRODUCTION_ORDER"));
        productionOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        productionOrderHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        productionOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        productionOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        productionOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        productionOrderHeader.add(new TableHeaderInfo("QTY", "QTY", "REQUEST_QTY"));
        productionOrderHeader.add(new TableHeaderInfo("COMMITTOTALQTY", "COMMITTOTALQTY", "COMMIT_TOTAL_QTY"));
        productionOrderHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        productionOrderHeader.add(new TableHeaderInfo("STARTDATE", "STARTDATE", "STARTDATE"));
        productionOrderHeader.add(new TableHeaderInfo("ENDDATE", "ENDDATE", "ENDDATE"));
        productionOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        productionOrderHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        productionOrderHeader.add(new TableHeaderInfo("FORMULA", "FORMULA", "FORMULA"));
        productionOrderHeader.add(new TableHeaderInfo("BOMNUM", "BOM", "BOM_NUM"));
        productionOrderHeader.add(new TableHeaderInfo("PRODUCTLINE", "PRODUCTLINE", "PRODUCT_LINE"));
        return productionOrderHeader;
    }

    public List initPurRequestHeader() {
        ArrayList<TableHeaderInfo> purRequestHeader = new ArrayList<TableHeaderInfo>();
        purRequestHeader.add(new TableHeaderInfo("purRequestInSale", "FNUMBER", "PURREQUEST"));
        purRequestHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        purRequestHeader.add(new TableHeaderInfo("PURCHASEORGUNITNAME", "PURCHASEORGUNITNAME", "PURCHASE_ORG_UNIT"));
        purRequestHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        purRequestHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        purRequestHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        purRequestHeader.add(new TableHeaderInfo("REQUESTQTY", "REQUESTQTY", "REQUESTQTY"));
        purRequestHeader.add(new TableHeaderInfo("QTY", "QTY", "APPROVE_QTY"));
        purRequestHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        purRequestHeader.add(new TableHeaderInfo("REQUIREMENTDATE", "REQUIREMENTDATE", "REQUIREMENT_DATE"));
        purRequestHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        purRequestHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        purRequestHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        purRequestHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return purRequestHeader;
    }

    public List initPurOrderHeader() {
        ArrayList<TableHeaderInfo> purOrderHeader = new ArrayList<TableHeaderInfo>();
        purOrderHeader.add(new TableHeaderInfo("purOrderInSale", "FNUMBER", "PURORDER"));
        purOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        purOrderHeader.add(new TableHeaderInfo("PURCHASEORGUNITNAME", "PURCHASEORGUNITNAME", "PURCHASE_ORG_UNIT"));
        purOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        purOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        purOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        purOrderHeader.add(new TableHeaderInfo("QTY", "QTY", "ORDER_ QTY"));
        purOrderHeader.add(new TableHeaderInfo("TOTALRECEIPTQTY", "TOTALRECEIPTQTY", "TOTAL_RECEIPT_QTY"));
        purOrderHeader.add(new TableHeaderInfo("TOTALRETURNEDQTY", "TOTALRETURNEDQTY", "TOTAL_RETURNED_QTY"));
        purOrderHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        purOrderHeader.add(new TableHeaderInfo("DELIEVERYDATE", "DELIEVERYDATE", "DELIEVERY_DATE"));
        purOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        purOrderHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        purOrderHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        purOrderHeader.add(new TableHeaderInfo("SUPPLIER", "SUPPLIER", "SUPPLIER"));
        purOrderHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "ORDERDATE"));
        purOrderHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "RECEIPT_ORG_UNIT"));
        purOrderHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return purOrderHeader;
    }

    public List initPurReqHeader() {
        ArrayList<TableHeaderInfo> purReqHeader = new ArrayList<TableHeaderInfo>();
        purReqHeader.add(new TableHeaderInfo("purReqInSale", "FNUMBER", "PURREQ_ORDER"));
        purReqHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        purReqHeader.add(new TableHeaderInfo("PURCHASEORGUNITNAME", "PURCHASEORGUNITNAME", "PURCHASE_ORG_UNIT"));
        purReqHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        purReqHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        purReqHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        purReqHeader.add(new TableHeaderInfo("REQUESTQTY", "REQUESTQTY", "REQUESTQTY"));
        purReqHeader.add(new TableHeaderInfo("QTY", "QTY", "APPROVE_QTY"));
        purReqHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        purReqHeader.add(new TableHeaderInfo("REQUIREMENTDATE", "REQUIREMENTDATE", "REQUIREMENT_DATE"));
        purReqHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        purReqHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        purReqHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        purReqHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return purReqHeader;
    }

    public List initSubContractOrderHeader() {
        ArrayList<TableHeaderInfo> subContractOrderHeader = new ArrayList<TableHeaderInfo>();
        subContractOrderHeader.add(new TableHeaderInfo("subContractOrderInSale", "FNUMBER", "SUBCONTRACT_ORDER"));
        subContractOrderHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        subContractOrderHeader.add(new TableHeaderInfo("PURCHASEORGUNITNAME", "PURCHASEORGUNITNAME", "PURCHASE_ORG_UNIT"));
        subContractOrderHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        subContractOrderHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        subContractOrderHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        subContractOrderHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        subContractOrderHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        subContractOrderHeader.add(new TableHeaderInfo("DELIEVERYDATE", "DELIEVERYDATE", "DELIEVERY_DATE"));
        subContractOrderHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        subContractOrderHeader.add(new TableHeaderInfo("BASESTATUS", "BASESTATUS", "BASESTATUS"));
        subContractOrderHeader.add(new TableHeaderInfo("DOSINGTYPE", "DOSINGTYPE", "DOSING_TYPE"));
        subContractOrderHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        subContractOrderHeader.add(new TableHeaderInfo("SUPPLIER", "SUPPLIER", "SUPPLIER"));
        subContractOrderHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return subContractOrderHeader;
    }

    public List initStockTransferBillHeader() {
        ArrayList<TableHeaderInfo> stockTransferBillHeader = new ArrayList<TableHeaderInfo>();
        stockTransferBillHeader.add(new TableHeaderInfo("stockTransferBillInSale", "FNUMBER", "STOCKTRANSFER_BILL"));
        stockTransferBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        stockTransferBillHeader.add(new TableHeaderInfo("ISSUESTORAGEORGUNIT", "ISSUESTORAGEORGUNIT", "ISSUE_STORAGEORGUNIT"));
        stockTransferBillHeader.add(new TableHeaderInfo("RECEIPTSTORAGEORGUNIT", "RECEIPTSTORAGEORGUNIT", "RECEIPT_STORAGEIRGUNIT"));
        stockTransferBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        stockTransferBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        stockTransferBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        stockTransferBillHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        stockTransferBillHeader.add(new TableHeaderInfo("ISSUEQTY", "ISSUEQTY", "ISSUEQTY"));
        stockTransferBillHeader.add(new TableHeaderInfo("RECEIPTQTY", "RECEIPTQTY", "RECEIPTQTY"));
        stockTransferBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        stockTransferBillHeader.add(new TableHeaderInfo("RECEIPTPLANDATE", "RECEIPTPLANDATE", "RECEIPTPLAN_DATE"));
        stockTransferBillHeader.add(new TableHeaderInfo("ISSUEPLANDATE", "ISSUEPLANDATE", "ISSUEPLAN_DATE"));
        stockTransferBillHeader.add(new TableHeaderInfo("ISSUEWAREHOUSE", "ISSUEWAREHOUSE", "ISSUE_WAREHOUSE"));
        stockTransferBillHeader.add(new TableHeaderInfo("ISSUELOCATION", "ISSUELOCATION", "ISSUE_LOCATION"));
        stockTransferBillHeader.add(new TableHeaderInfo("RECEIPTWAREHOUSE", "RECEIPTWAREHOUSE", "RECEIPT_WAREHOUSE"));
        stockTransferBillHeader.add(new TableHeaderInfo("RECEIPTLOCATION", "RECEIPTLOCATION", "RECEIPT_LOCATION"));
        stockTransferBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        stockTransferBillHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        stockTransferBillHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        stockTransferBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return stockTransferBillHeader;
    }

    public List initTransferOrderBillHeader() {
        ArrayList<TableHeaderInfo> transferOrderBillHeader = new ArrayList<TableHeaderInfo>();
        transferOrderBillHeader.add(new TableHeaderInfo("transferOrderBillInSale", "FNUMBER", "STOCKTRANSFER_ORDER"));
        transferOrderBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        transferOrderBillHeader.add(new TableHeaderInfo("ISSUESTORAGEORGUNIT", "ISSUESTORAGEORGUNIT", "ISSUE_STORAGEORGUNIT_O"));
        transferOrderBillHeader.add(new TableHeaderInfo("RECEIPTSTORAGEORGUNIT", "RECEIPTSTORAGEORGUNIT", "RECEIPT_STORAGEIRGUNIT_O"));
        transferOrderBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        transferOrderBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        transferOrderBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        transferOrderBillHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        transferOrderBillHeader.add(new TableHeaderInfo("ISSUEQTY", "ISSUEQTY", "ISSUEQTY"));
        transferOrderBillHeader.add(new TableHeaderInfo("RECEIPTQTY", "RECEIPTQTY", "RECEIPTQTY"));
        transferOrderBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        transferOrderBillHeader.add(new TableHeaderInfo("RECEIPTPLANDATE", "RECEIPTPLANDATE", "RECEIPTPLAN_DATE"));
        transferOrderBillHeader.add(new TableHeaderInfo("ISSUEPLANDATE", "ISSUEPLANDATE", "ISSUEPLAN_DATE"));
        transferOrderBillHeader.add(new TableHeaderInfo("ISSUEWAREHOUSE", "ISSUEWAREHOUSE", "ISSUE_WAREHOUSE_O"));
        transferOrderBillHeader.add(new TableHeaderInfo("ISSUELOCATION", "ISSUELOCATION", "ISSUE_LOCATION_O"));
        transferOrderBillHeader.add(new TableHeaderInfo("RECEIPTWAREHOUSE", "RECEIPTWAREHOUSE", "RECEIPT_WAREHOUSE_O"));
        transferOrderBillHeader.add(new TableHeaderInfo("RECEIPTLOCATION", "RECEIPTLOCATION", "RECEIPT_LOCATION_O"));
        transferOrderBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        transferOrderBillHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        transferOrderBillHeader.add(new TableHeaderInfo("BIZTYPE", "BIZTYPE", "BIZTYPE"));
        transferOrderBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return transferOrderBillHeader;
    }

    public List initSaleIssueBillHeader() {
        ArrayList<TableHeaderInfo> saleIssueBillHeader = new ArrayList<TableHeaderInfo>();
        saleIssueBillHeader.add(new TableHeaderInfo("saleIssueBillInSale", "FNUMBER", "SALEISSUE_BILL"));
        saleIssueBillHeader.add(new TableHeaderInfo("NUMBER", "FNUMBER", "BILL_NUMBER"));
        saleIssueBillHeader.add(new TableHeaderInfo("STORAGEORGUNITNAME", "STORAGEORGUNITNAME", "STORAGE_ORG_UNIT"));
        saleIssueBillHeader.add(new TableHeaderInfo("MATERIALNUMBER", "MATERIALNUMBER", "MATERIAL_NUMBER"));
        saleIssueBillHeader.add(new TableHeaderInfo("MATERIALNAME", "MATERIALNAME", "MATERIAL_NAME"));
        saleIssueBillHeader.add(new TableHeaderInfo("MATERIALMODEL", "MATERIALMODEL", "MATERIAL_MODEL"));
        saleIssueBillHeader.add(new TableHeaderInfo("QTY", "QTY", "QTY"));
        saleIssueBillHeader.add(new TableHeaderInfo("UNITNAME", "UNITNAME", "UNIT_NAME"));
        saleIssueBillHeader.add(new TableHeaderInfo("BIZDATE", "BIZDATE", "BIZDATE"));
        saleIssueBillHeader.add(new TableHeaderInfo("WAREHOUSE", "WAREHOUSE", "WAREHOUSE"));
        saleIssueBillHeader.add(new TableHeaderInfo("TRACKNUMBER", "TRACKNUMBER", "TRACK_NUMBER"));
        saleIssueBillHeader.add(new TableHeaderInfo("BASESTATUS", "ENTRYBASESTATUS", "ENTRYBASESTATUS"));
        saleIssueBillHeader.add(new TableHeaderInfo("TRANSACTIONTYPE", "TRANSACTIONTYPE", "TRANSACTION_TYPE"));
        saleIssueBillHeader.add(new TableHeaderInfo("CUSTOMER", "CUSTOMER", "CUSTOMER"));
        saleIssueBillHeader.add(new TableHeaderInfo("ENTRIESSEQ", "ENTRIESSEQ", "ENTRIES_SEQ"));
        return saleIssueBillHeader;
    }
}

