/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.util;

import com.kingdee.eas.mm.basedata.PlanningHorizonUnitEnum;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class PeriodDivideInfo {
    private Calendar startDate = null;
    private Calendar endDate = null;
    private boolean isEqualCycle = false;
    private PlanningHorizonUnitEnum displayUnit;
    private String displayName = null;
    private Calendar displayDate = null;

    public PeriodDivideInfo(Calendar startDate, Calendar endDate, boolean isEqualCycle, PlanningHorizonUnitEnum displayUnit) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.isEqualCycle = isEqualCycle;
        this.displayUnit = displayUnit;
        this.displayDate = endDate;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy-MM");
        String name = null;
        if (this.isEqualCycle) {
            if (PlanningHorizonUnitEnum.DAY.equals((Object)this.displayUnit)) {
                name = dayFormat.format(this.startDate.getTime()) + "~" + dayFormat.format(this.displayDate.getTime());
            }
            if (PlanningHorizonUnitEnum.WEEK.equals((Object)this.displayUnit)) {
                name = this.startDate.get(1) + ".W" + this.startDate.get(3) + "~" + this.displayDate.get(1) + ".W" + this.displayDate.get(3);
            }
            if (PlanningHorizonUnitEnum.MONTH.equals((Object)this.displayUnit)) {
                name = monthFormat.format(this.startDate.getTime()) + "~" + monthFormat.format(this.displayDate.getTime());
            }
        } else {
            if (PlanningHorizonUnitEnum.DAY.equals((Object)this.displayUnit)) {
                name = dayFormat.format(this.displayDate.getTime());
            }
            if (PlanningHorizonUnitEnum.WEEK.equals((Object)this.displayUnit)) {
                name = this.displayDate.get(1) + ".W" + this.displayDate.get(3);
            }
            if (PlanningHorizonUnitEnum.MONTH.equals((Object)this.displayUnit)) {
                name = monthFormat.format(this.displayDate.getTime());
            }
        }
        return name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }
}

