/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.KDTableUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.ActualHourEntryInfo;
import com.kingdee.eas.ncm.bill.ActualHourFactory;
import com.kingdee.eas.ncm.bill.ActualHourInfo;
import com.kingdee.eas.ncm.bill.DataInputModeEnum;
import com.kingdee.eas.ncm.bill.HourTypeEnum;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.bill.client.AbstractActualHourEditUI;
import com.kingdee.eas.ncm.common.NCMCostTypeEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ActualHourEditUI
extends AbstractActualHourEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualHourEditUI.class);
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.ActualHourResource";
    private String companyOrgID = null;
    public static final String TB_CONUMBER = "costObject.number";
    public static final String TB_CONAME = "costObject.name";
    public static final String TB_MODEL = "product.model";
    public static final String TB_HOUR = "hour";
    public static final String TB_HOURTYPE = "hourType";
    public static final String TB_COBATCH = "batch";
    public static final String TB_TIMEUNIT = "timeUnit";
    public static final String TB_INPUTMODE = "inputMode";
    private static final String Col_CostObjectName = "costObject.name";
    private static final String Col_CostObjectNumber = "costObject.number";
    protected static final String Col_OrderNumber = "order.number";
    protected static final String Col_ProjectNumber = "project.number";
    protected static final String Col_TrackNumber = "track.number";
    protected static final String Col_ProductNumber = "product.number";
    protected static final String Col_ProductName = "product.name";
    protected static final String Col_Batch = "batch";
    private KDBizPromptBox prmtCostObject = null;
    private KDBizPromptBox prmtOrder = null;
    private KDBizPromptBox prmtProduct = null;
    private Object oldValue = null;
    private boolean inDeal = false;
    private Map modelMap = new HashMap();

    public ActualHourEditUI() throws Exception {
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ActualHourEditUI.this.kdtEntries_editStarting(e);
                }
                catch (Exception exc) {
                    ActualHourEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.checkParsed();
        this.kdtEntries.getColumn("batch").getStyleAttributes().setLocked(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            this.companyOrgID = comOrg.getId().toString();
            try {
                BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)this.companyOrgID, (boolean)true, (boolean)true);
                this.setDataFormat();
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.formatEntryTable(this.companyOrgID);
        try {
            this.initOrderInfo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.companyOrgID);
        int curPeriodNumber = currentPeriod.getNumber();
        if (this.editData.getCalculatePeriod() == null) {
            return;
        }
        int editDataPeriodNumber = this.editData.getCalculatePeriod().getNumber();
        if (editDataPeriodNumber != curPeriodNumber) {
            this.btnUnaudit.setEnabled(false);
        }
    }

    private void initOrderInfo() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
            Object value = this.kdtEntries.getRow(rowIndex).getCell("costObject.number").getValue();
            if (!(value instanceof CostObjectInfo)) continue;
            CostObjectInfo costObject = (CostObjectInfo)value;
            if (CalculateModeEnum.BYORDER.equals((Object)costObject.getCalculateMode()) && costObject.getOrderID() != null) {
                ids.add(costObject.getOrderID());
            }
            if (!CalculateModeEnum.BYBATCH.equals((Object)costObject.getCalculateMode())) continue;
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
        if (ids.size() > 0) {
            Map orders = CostObjectFactory.getRemoteInstance().getOrderInfo(ids);
            for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
                CostObjectInfo costObject;
                Object value = this.kdtEntries.getRow(rowIndex).getCell("costObject.number").getValue();
                if (!(value instanceof CostObjectInfo) || !CalculateModeEnum.BYORDER.equals((Object)(costObject = (CostObjectInfo)value).getCalculateMode()) || costObject.getOrderID() == null) continue;
                String orderID = costObject.getOrderID();
                Map orderInfo = (Map)orders.get(orderID);
                String orderNumber = "";
                String projectNumber = "";
                String trackNumber = "";
                if (orderInfo != null) {
                    orderNumber = (String)orderInfo.get("orderNumber");
                    projectNumber = (String)orderInfo.get("projectNumber");
                    trackNumber = (String)orderInfo.get("trackNumber");
                }
                ManufactureOrderInfo order = new ManufactureOrderInfo();
                order.setId(BOSUuid.read((String)orderID));
                order.setNumber(orderNumber);
                this.kdtEntries.getRow(rowIndex).getCell(Col_OrderNumber).setValue((Object)order);
                this.kdtEntries.getRow(rowIndex).getCell(Col_ProjectNumber).setValue((Object)projectNumber);
                this.kdtEntries.getRow(rowIndex).getCell(Col_TrackNumber).setValue((Object)trackNumber);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setCostType(NCMCostTypeEnum.NORMAL);
    }

    private void formatEntryTable(String companyOrgID) {
        this.prmtCostObject = new KDBizPromptBox();
        ExtendParser parserCostObject = new ExtendParser(this.prmtCostObject);
        this.prmtCostObject.setCommitParser((IParser)parserCostObject);
        this.prmtCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObject, Boolean.FALSE, Boolean.TRUE);
        this.prmtCostObject.setSelector((KDPromptSelector)arg0);
        this.prmtCostObject.setEditable(true);
        this.prmtCostObject.setDisplayFormat("$number$");
        this.prmtCostObject.setEditFormat("$number$");
        this.prmtCostObject.setCommitFormat("$number$");
        ObjectValueRender avrCostObject = new ObjectValueRender();
        avrCostObject.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("costObject.number").setRenderer((IBasicRender)avrCostObject);
        this.prmtCostObject.setRequired(true);
        this.prmtCostObject.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ActualHourEditUI.this.filtExsitCostObject(e);
            }
        });
        this.prmtCostObject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ActualHourEditUI.this.fillCellAfterBillSelectedRelation(eventObj);
            }
        });
        this.kdtEntries.getColumn("costObject.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtCostObject));
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(2);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
        colTxtField.setMaximumValue((Comparable)NCMClientUtils.MAXVAL);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(false);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        this.kdtEntries.getColumn(TB_HOUR).setEditor((ICellEditor)col_CellEditor);
        this.kdtEntries.getColumn(TB_HOUR).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.kdtEntries.getColumn("costObject.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_MODEL).getStyleAttributes().setLocked(true);
        KDComboBox hourType = new KDComboBox();
        hourType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ncm.bill.HourTypeEnum").toArray());
        KDTDefaultCellEditor col_HourTypeEditor = new KDTDefaultCellEditor((JComboBox)hourType);
        this.kdtEntries.getColumn(TB_HOURTYPE).setEditor((ICellEditor)col_HourTypeEditor);
        KDComboBox timeUnit = new KDComboBox();
        timeUnit.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ncm.bill.TimeUnitEnum").toArray());
        KDTDefaultCellEditor col_TimeUnitEditor = new KDTDefaultCellEditor((JComboBox)timeUnit);
        this.kdtEntries.getColumn(TB_TIMEUNIT).setEditor((ICellEditor)col_TimeUnitEditor);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        this.prmtOrder = new KDBizPromptBox();
        this.prmtOrder.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrder.setVisible(true);
        this.prmtOrder.setEditable(true);
        this.prmtOrder.setDisplayFormat("$number$");
        this.prmtOrder.setEditFormat("$number$");
        this.prmtOrder.setCommitFormat("$number$");
        KDTDefaultCellEditor orderEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtOrder);
        ObjectValueRender orderRender = new ObjectValueRender();
        orderRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        try {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            HashSet<Integer> statuses = new HashSet<Integer>();
            statuses.add(5);
            statuses.add(7);
            statuses.add(8);
            statuses.add(11);
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("oldBaseStatus", statuses, CompareType.INCLUDE));
            Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)companyOrgID);
            if (storageOrgUnitIds.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
                filter.setMaskString("(#0 or #1 and #2) and #3");
            } else {
                filter.setMaskString("(#0 or #1 and #2)");
            }
            view.setFilter(filter);
            this.prmtOrder.getQueryAgent().resetRuntimeEntityView();
            this.prmtOrder.setEntityViewInfo(view);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.kdtEntries.getColumn(Col_OrderNumber).setEditor((ICellEditor)orderEditor);
        this.kdtEntries.getColumn(Col_OrderNumber).setRenderer((IBasicRender)orderRender);
        this.prmtProduct = new KDBizPromptBox();
        this.prmtProduct.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prmtProduct.setVisible(true);
        this.prmtProduct.setEditable(true);
        this.prmtProduct.setDisplayFormat("$number$");
        this.prmtProduct.setEditFormat("$number$");
        this.prmtProduct.setCommitFormat("$number$");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.company.id", (Object)companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.createCOByOrder", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)2));
        view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtProduct.setEntityViewInfo(view);
        try {
            this.prmtProduct = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtProduct, (FilterInfo)filter);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        KDTDefaultCellEditor productEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtProduct);
        ObjectValueRender materialRender = new ObjectValueRender();
        materialRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(Col_ProductNumber).setEditor((ICellEditor)productEditor);
        this.kdtEntries.getColumn(Col_ProductNumber).setRenderer((IBasicRender)materialRender);
    }

    private void fillDataAfterOrderSelect(int rowIndex) throws Exception {
        CostObjectInfo costObjectInfo;
        Object data = this.kdtEntries.getCell(rowIndex, Col_OrderNumber).getValue();
        this.kdtEntries.getCell(rowIndex, "costObject.number").setValue(null);
        this.kdtEntries.getCell(rowIndex, "costObject.name").setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue(null);
        this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue(null);
        this.kdtEntries.getCell(rowIndex, "batch").setValue(null);
        this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
        this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
        if (data == null) {
            return;
        }
        if (!(data instanceof ManufactureOrderInfo)) {
            this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue(null);
            return;
        }
        ManufactureOrderInfo orderInfo = (ManufactureOrderInfo)data;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderInfo.getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("baseStatus");
        selector.add("project.id");
        selector.add(Col_ProjectNumber);
        selector.add("trackNumber.id");
        selector.add("trackNumber.number");
        selector.add("material.id");
        selector.add("material.number");
        selector.add("material.name");
        selector.add("costObject.id");
        selector.add("costObject.number");
        selector.add("costObject.name");
        selector.add("costObject.calculateMode");
        selector.add("costObject.batchNumber");
        selector.add("costObject.company.id");
        selector.add("costObject.StdProductID.id");
        selector.add("costObject.StdProductID.number");
        selector.add("costObject.StdProductID.name");
        selector.add("costObject.StdProductID.model");
        view.setSelector(selector);
        ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
        if (orderColl.size() == 0) {
            return;
        }
        orderInfo = orderColl.get(0);
        if (orderInfo.getProject() != null) {
            this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue((Object)orderInfo.getProject().getNumber());
        }
        if (orderInfo.getTrackNumber() != null) {
            this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue((Object)orderInfo.getTrackNumber().getNumber());
        }
        if ((costObjectInfo = orderInfo.getCostObject()) != null) {
            if (costObjectInfo.getCompany() == null || !costObjectInfo.getCompany().getId().toString().equals(this.companyOrgID)) {
                MsgBox.showInfo((String)this.getResource("CostObjectNotExistOfOrder"));
                return;
            }
            if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                return;
            }
            this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
            this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
            this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObjectInfo.getBatchNumber());
            if (costObjectInfo.getStdProductID() != null) {
                MaterialInfo materialInfo = costObjectInfo.getStdProductID();
                this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getModel());
            }
            if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(false);
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(new Color(252, 251, 223));
            } else {
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
            }
            return;
        }
        if (orderInfo.getMaterial() == null) {
            return;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)orderInfo.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("createCOByOrder");
        view.setSelector(selector);
        MaterialCompanyInfoCollection mcColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(view);
        if (mcColl.size() == 0) {
            MsgBox.showInfo((String)this.getResource("MaterialNotAudited"));
            return;
        }
        MaterialCompanyInfoInfo mcInfo = mcColl.get(0);
        if (mcInfo.isCreateCOByOrder()) {
            if (BillBaseStatusEnum.RELEASED.equals((Object)orderInfo.getBaseStatus()) || BillBaseStatusEnum.CLOSED.equals((Object)orderInfo.getBaseStatus()) || BillBaseStatusEnum.COMPLETE.equals((Object)orderInfo.getBaseStatus()) || BillBaseStatusEnum.FINCLOSED.equals((Object)orderInfo.getBaseStatus())) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orderInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)7));
                filter.getFilterItems().add(new FilterItemInfo("orderID", (Object)orderInfo.getId().toString()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("batchNumber");
                selector.add("StdProductID.id");
                selector.add("StdProductID.number");
                selector.add("StdProductID.name");
                selector.add("StdProductID.model");
                view.setSelector(selector);
                CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
                if (coColl.size() == 0) {
                    MsgBox.showInfo((String)this.getResource("NoOrderCostObjectOfMaterial"));
                    return;
                }
                costObjectInfo = coColl.get(0);
                if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                    MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                    return;
                }
                this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
                this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
                this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObjectInfo.getBatchNumber());
                if (costObjectInfo.getStdProductID() != null) {
                    MaterialInfo materialInfo = costObjectInfo.getStdProductID();
                    this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                    this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getModel());
                }
                return;
            }
            MsgBox.showInfo((String)this.getResource("OrderNotReleased"));
            return;
        }
        MaterialInfo materialInfo = orderInfo.getMaterial();
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        HashSet<Integer> modes = new HashSet<Integer>();
        modes.add(1);
        modes.add(3);
        modes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", modes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)3));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select ");
        ksql.append("    FParentID ");
        ksql.append("from T_BD_CostObjectEntry ");
        ksql.append("where FRelatedID = '" + materialInfo.getId().toString() + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.INNER));
        filter.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        selector.add("calculateMode");
        selector.add("StdProductID.id");
        selector.add("StdProductID.number");
        selector.add("StdProductID.name");
        selector.add("StdProductID.model");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
        if (coColl.size() == 0) {
            MsgBox.showInfo((String)this.getResource("NoCostObjectOfMaterial"));
            return;
        }
        costObjectInfo = coColl.get(0);
        if (CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode())) {
            if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                return;
            }
            this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
            this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
            this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObjectInfo.getBatchNumber());
            if (costObjectInfo.getStdProductID() != null) {
                materialInfo = costObjectInfo.getStdProductID();
                this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
            }
        } else if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            if (coColl.size() == 1) {
                if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                    MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                    return;
                }
                this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
                this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
                this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObjectInfo.getBatchNumber());
                if (costObjectInfo.getStdProductID() != null) {
                    materialInfo = costObjectInfo.getStdProductID();
                    this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                    this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getName());
                }
            } else if (costObjectInfo.getStdProductID() != null) {
                materialInfo = costObjectInfo.getStdProductID();
                this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getName());
            }
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
    }

    private void fillDataAfterProductSelect(int rowIndex) throws Exception {
        Object data = this.kdtEntries.getCell(rowIndex, Col_ProductNumber).getValue();
        this.kdtEntries.getCell(rowIndex, "costObject.number").setValue(null);
        this.kdtEntries.getCell(rowIndex, "costObject.name").setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue(null);
        this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue(null);
        this.kdtEntries.getCell(rowIndex, "batch").setValue(null);
        this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
        this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
        if (data == null) {
            return;
        }
        if (!(data instanceof MaterialInfo)) {
            return;
        }
        MaterialInfo materialInfo = (MaterialInfo)data;
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
        this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getModel());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        HashSet<Integer> modes = new HashSet<Integer>();
        modes.add(1);
        modes.add(3);
        modes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", modes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)3));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select ");
        ksql.append("    FParentID ");
        ksql.append("from T_BD_CostObjectEntry ");
        ksql.append("where FRelatedID = '" + materialInfo.getId().toString() + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.INNER));
        filter.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        selector.add("calculateMode");
        selector.add("StdProductID.id");
        selector.add("StdProductID.number");
        selector.add("StdProductID.name");
        selector.add("StdProductID.model");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
        if (coColl.size() == 0) {
            MsgBox.showInfo((String)this.getResource("CostObjectNotExistOfMaterial"));
            return;
        }
        CostObjectInfo costObjectInfo = coColl.get(0);
        if (CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode())) {
            if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                return;
            }
            this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
            this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
            this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObjectInfo.getBatchNumber());
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
        } else if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            if (coColl.size() == 1) {
                if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                    MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                    return;
                }
                this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
                this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
                this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObjectInfo.getBatchNumber());
            }
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
    }

    private void fillDataAfterBatchSelect(int rowIndex) throws Exception {
        this.kdtEntries.getCell(rowIndex, "costObject.number").setValue(null);
        this.kdtEntries.getCell(rowIndex, "costObject.name").setValue(null);
        Object data = this.kdtEntries.getCell(rowIndex, "batch").getValue();
        String batch = data != null ? data.toString() : null;
        data = this.kdtEntries.getCell(rowIndex, Col_ProductNumber).getValue();
        MaterialInfo materialInfo = null;
        if (!(data instanceof MaterialInfo)) {
            return;
        }
        materialInfo = (MaterialInfo)data;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)4));
        filter.getFilterItems().add(new FilterItemInfo("batchNumber", (Object)batch));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
        if (coColl.size() == 0) {
            this.kdtEntries.getCell(rowIndex, "batch").setValue(null);
            MsgBox.showInfo((String)this.getResource("CostObjectNotExistOfMaterialAndBatch", new Object[]{materialInfo.getNumber(), batch == null ? "" : batch}));
            return;
        }
        CostObjectInfo costObjectInfo = coColl.get(0);
        if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
            MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
            return;
        }
        this.kdtEntries.getCell(rowIndex, "costObject.number").setValue((Object)costObjectInfo);
        this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObjectInfo.getName());
    }

    public boolean isCostObjectExists(String costObjectID) throws Exception {
        return false;
    }

    private void filtExsitCostObject(SelectorEvent e) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("costObjectGroup.longnumber", (Object)"PD%", CompareType.LIKE));
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filter);
        this.prmtCostObject.setEntityViewInfo(newEvi);
    }

    protected void fillCellAfterBillSelectedRelation(DataChangeEvent eventObj) {
        if (!this.inDeal) {
            this.inDeal = true;
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            if (eventObj.getNewValue() == null) {
                KDTableUtil.clearCells((KDTable)this.kdtEntries, (int)selectRowIndex, (String[])new String[]{"costObject.number", "costObject.name", TB_MODEL, TB_HOUR, Col_OrderNumber, Col_ProjectNumber, Col_TrackNumber, Col_ProductNumber, Col_ProductName, "batch"});
            } else if (eventObj.getNewValue() instanceof Object[]) {
                Object[] object = (Object[])eventObj.getNewValue();
                if (object != null && object.length > 0) {
                    KDTableUtil.clearCells((KDTable)this.kdtEntries, (int)selectRowIndex, (String[])new String[]{"costObject.number", "costObject.name", TB_MODEL, TB_HOUR});
                    try {
                        this.getCostObjectMatModel(object);
                        int curRowIndex = 0;
                        for (int i = 0; i < object.length; ++i) {
                            curRowIndex = selectRowIndex + i;
                            CostObjectInfo info = (CostObjectInfo)object[i];
                            IRow row = null;
                            row = curRowIndex == selectRowIndex ? this.kdtEntries.getRow(selectRowIndex) : (this.kdtEntries.getRow(curRowIndex) != null && this.kdtEntries.getRow(curRowIndex).getCell("costObject.number") != null && this.kdtEntries.getRow(curRowIndex).getCell("costObject.number").getValue() == null ? this.kdtEntries.getRow(curRowIndex) : this.kdtEntries.addRow(curRowIndex));
                            row.getCell("costObject.number").setValue((Object)info);
                            row.getCell("costObject.name").setValue((Object)info.getName());
                            row.getCell("batch").setValue((Object)info.getBatchNumber());
                            this.setCostObjectMatModel(row, info);
                            row.getCell(TB_HOUR).setValue((Object)SysConstant.BIGZERO);
                            row.getCell(TB_HOURTYPE).setValue((Object)HourTypeEnum.hour);
                            row.getCell(TB_TIMEUNIT).setValue((Object)TimeUnitEnum.HOUR);
                            row.getCell(TB_INPUTMODE).setValue((Object)DataInputModeEnum.MANUALINPUT);
                            this.fillDataAfterCostObjectSelect(curRowIndex);
                        }
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                }
            } else if (eventObj.getNewValue() instanceof CostObjectInfo) {
                try {
                    CostObjectInfo costObjectInfo = (CostObjectInfo)eventObj.getNewValue();
                    if (this.oldValue == null || !(this.oldValue instanceof CostObjectInfo) || !costObjectInfo.getNumber().equals(((CostObjectInfo)this.oldValue).getNumber())) {
                        Object[] object = new Object[]{costObjectInfo};
                        this.getCostObjectMatModel(object);
                        IRow row = this.kdtEntries.getRow(selectRowIndex);
                        row.getCell("costObject.number").setValue((Object)costObjectInfo);
                        row.getCell("costObject.name").setValue((Object)costObjectInfo.getName());
                        row.getCell("batch").setValue((Object)costObjectInfo.getBatchNumber());
                        this.setCostObjectMatModel(row, costObjectInfo);
                        row.getCell(TB_HOUR).setValue((Object)SysConstant.BIGZERO);
                        row.getCell(TB_HOURTYPE).setValue((Object)HourTypeEnum.hour);
                        row.getCell(TB_TIMEUNIT).setValue((Object)TimeUnitEnum.HOUR);
                        row.getCell(TB_INPUTMODE).setValue((Object)DataInputModeEnum.MANUALINPUT);
                        this.fillDataAfterCostObjectSelect(selectRowIndex);
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                this.prmtCostObject.setValue(this.oldValue);
                this.kdtEntries.getRow(selectRowIndex).getCell("costObject.number").setValue(this.oldValue);
            }
            this.inDeal = false;
        }
    }

    private void fillDataAfterCostObjectSelect(int rowIndex) throws Exception {
        Object data = this.kdtEntries.getCell(rowIndex, "costObject.number").getValue();
        this.kdtEntries.getCell(rowIndex, "costObject.name").setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue(null);
        this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue(null);
        this.kdtEntries.getCell(rowIndex, "batch").setValue(null);
        this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(true);
        this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(Color.WHITE);
        if (data instanceof CostObjectInfo) {
            SelectorItemCollection selector;
            FilterInfo filter;
            EntityViewInfo view;
            CostObjectInfo costObject = (CostObjectInfo)data;
            this.kdtEntries.getCell(rowIndex, "costObject.name").setValue((Object)costObject.getName());
            this.kdtEntries.getCell(rowIndex, "batch").setValue((Object)costObject.getBatchNumber());
            if (CalculateModeEnum.BYORDER.equals((Object)costObject.getCalculateMode()) && costObject.getOrderID() != null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObject.getOrderID()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("project.id");
                selector.add(Col_ProjectNumber);
                selector.add("trackNumber.id");
                selector.add("trackNumber.number");
                view.setSelector(selector);
                ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
                if (orderColl.size() > 0) {
                    ManufactureOrderInfo orderInfo = orderColl.get(0);
                    this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue((Object)orderInfo);
                    if (orderInfo.getProject() != null) {
                        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue((Object)orderInfo.getProject().getNumber());
                    }
                    if (orderInfo.getTrackNumber() != null) {
                        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue((Object)orderInfo.getTrackNumber().getNumber());
                    }
                }
            }
            if (costObject.getStdProductID() != null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObject.getStdProductID().getId().toString()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("model");
                view.setSelector(selector);
                MaterialCollection matColl = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                if (matColl.size() > 0) {
                    MaterialInfo materialInfo = matColl.get(0);
                    this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                    this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getModel());
                }
            }
            if (CalculateModeEnum.BYBATCH.equals((Object)costObject.getCalculateMode())) {
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setLocked(false);
                this.kdtEntries.getCell(rowIndex, "batch").getStyleAttributes().setBackground(new Color(252, 251, 223));
            }
        }
    }

    private void getCostObjectMatModel(Object[] object) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        CostObjectInfo info = null;
        for (int i = 0; i < object.length; ++i) {
            String fid;
            info = (CostObjectInfo)object[i];
            if (!CORelatedType.Product.equals((Object)info.getRelatedType()) || this.modelMap.containsKey(fid = info.getId().toString())) continue;
            map.put(fid, info.getStdProductID().getId().toString());
        }
        if (map.size() > 0) {
            Map modelOfStdPrd = CostObjectSuiteFactory.getRemoteInstance().getCostObjectMatModel(map);
            this.modelMap.putAll(modelOfStdPrd);
        }
    }

    private void setCostObjectMatModel(IRow row, CostObjectInfo info) throws EASBizException, BOSException {
        String model = (String)this.modelMap.get(info.getId().toString());
        row.getCell(TB_MODEL).setValue((Object)model);
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kdtEntries, new String[]{TB_HOUR});
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ActualHourFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ActualHourInfo objectValue = new ActualHourInfo();
        objectValue.setCostType(NCMCostTypeEnum.NORMAL);
        if (SysContext.getSysContext().getCurrentCostUnit() != null && SysContext.getSysContext().getCurrentCostUnit().isIsBizUnit()) {
            objectValue.setCostCenter(SysContext.getSysContext().getCurrentCostUnit());
        }
        super.applyBillDefaultValue((IObjectValue)objectValue);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ActualHourEntryInfo entry = new ActualHourEntryInfo();
        entry.setHour(SysConstant.BIGZERO);
        entry.setHourType(HourTypeEnum.hour);
        entry.setInputMode(DataInputModeEnum.MANUALINPUT);
        entry.setTimeUnit(TimeUnitEnum.HOUR);
        return entry;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void checkValidDataForSubmit() throws Exception {
        super.checkValidDataForSubmit();
        BDCMClientUtils.checkIsNull((JComponent)this.prmtCostCenter, (String)this.contCostCenter.getBoundLabelText());
        int rowCount = this.kdtEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object val;
            Object cobj = this.kdtEntries.getCell(i, "costObject.number").getValue();
            if (cobj == null) {
                this.kdtEntries.getEditManager().editCellAt(i, 0);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"0_ActualHourEditUI"));
                SysUtil.abort();
            }
            if (cobj instanceof String) {
                this.kdtEntries.getEditManager().editCellAt(i, 0);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"148_actualHourEditUI"));
                SysUtil.abort();
            }
            if (!((val = this.kdtEntries.getCell(i, TB_HOUR).getValue()) instanceof BigDecimal) || SysConstant.BIGZERO.compareTo((BigDecimal)val) < 0) continue;
            this.kdtEntries.getEditManager().editCellAt(i, 3);
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource((String)"HourMustGreaterThenZero"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.comboBillStatus.getSelectedItem() != null && this.comboBillStatus.getSelectedItem().toString().equals("\u5ba1\u6838")) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("ActualHour_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    private void setDataFormat() throws EASBizException, BOSException {
        ActualHourInfo actualHourInfo = null;
        TimeUnitEnum unit = null;
        Locale locale = SysContext.getSysContext().getLocale();
        BOSUuid bOSUuid = this.editData.getId();
        if (bOSUuid != null) {
            String sql = "select id, entries.id, entries.timeUnit where id = '" + bOSUuid.toString() + "'";
            actualHourInfo = ActualHourFactory.getRemoteInstance().getActualHourInfo(sql);
        }
        int rowCount = this.kdtEntries.getRowCount();
        BigDecimal factor = new BigDecimal(1);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            unit = (TimeUnitEnum)((Object)this.kdtEntries.getRow(rowIndex).getCell(TB_TIMEUNIT).getValue());
            if ("1".equals(unit.getValue())) {
                factor = new BigDecimal(3600);
            }
            if ("2".equals(unit.getValue())) {
                factor = new BigDecimal(60);
            }
            if ("3".equals(unit.getValue())) {
                factor = new BigDecimal(1);
            }
            ICell cell = this.kdtEntries.getRow(rowIndex).getCell(TB_HOUR);
            BigDecimal value = new BigDecimal(cell.getValue().toString());
            cell.setValue((Object)value.divide(factor, 10, 3));
            this.kdtEntries.getRow(rowIndex).getCell(TB_TIMEUNIT).setValue((Object)unit.getAlias(locale));
        }
    }

    public void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        this.oldValue = this.kdtEntries.getRow(rowIndex).getCell(colIndex).getValue();
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int editRow = e.getRowIndex();
        this.kdtEntries.getRow(editRow).getCell(TB_INPUTMODE).setValue((Object)DataInputModeEnum.MANUALINPUT.getAlias(this.getLocale()));
        int colOrderIndex = this.kdtEntries.getCell(e.getRowIndex(), Col_OrderNumber).getColumnIndex();
        if (e.getColIndex() == colOrderIndex && e.getValue() != this.oldValue) {
            this.fillDataAfterOrderSelect(e.getRowIndex());
        }
        int colProductIndex = this.kdtEntries.getCell(e.getRowIndex(), Col_ProductNumber).getColumnIndex();
        if (e.getColIndex() == colProductIndex && e.getValue() != this.oldValue) {
            if (e.getValue() instanceof MaterialInfo) {
                MaterialInfo materialInfo = (MaterialInfo)e.getValue();
                this.kdtEntries.getCell(e.getRowIndex(), Col_ProductName).setValue((Object)materialInfo.getName());
                this.actionSave.setEnabled(true);
            } else if (e.getValue() == null) {
                this.kdtEntries.getCell(e.getRowIndex(), Col_ProductName).setValue((Object)"");
            }
            this.fillDataAfterProductSelect(e.getRowIndex());
        }
        int colBatchIndex = this.kdtEntries.getCell(e.getRowIndex(), "batch").getColumnIndex();
        if (!(e.getColIndex() != colBatchIndex || this.isValueEquals(e.getValue()) && this.kdtEntries.getCell(e.getRowIndex(), "costObject.number").getValue() != null)) {
            this.fillDataAfterBatchSelect(e.getRowIndex());
        }
    }

    private boolean isValueEquals(Object newValue) {
        if (this.oldValue == null && newValue == null) {
            return true;
        }
        if (this.oldValue == null || newValue == null) {
            return false;
        }
        if (newValue instanceof String) {
            return ((String)newValue).trim().equals(this.oldValue.toString().trim());
        }
        return false;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    protected String getResource(String resName) {
        return this.getResource(resName, null);
    }

    protected String getResource(String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(EASResource.getString((String)RES_CLASSNAME, (String)resName), params);
        }
        return EASResource.getString((String)RES_CLASSNAME, (String)resName);
    }
}

