/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.ActualHourFilterParam;
import com.kingdee.eas.ncm.bill.ActualHourInfo;
import com.kingdee.eas.ncm.bill.client.AbstractActualHourFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.util.Date;
import java.util.List;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class ActualHourFilterUI
extends AbstractActualHourFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualHourFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = null;
    private static final int PERIOD_MAX_MONTH = 12;
    private String ActualHourInfoFrom = "actualHourInfoFrom";
    private String ActualHourInfoTo = "actualHourInfoTo";
    private String BizDateFrom = "bizDateFrom";
    private String BizDateTo = "bizDateTo";
    private String PeriodFrom = "periodFrom";
    private String PeriodTo = "periodTo";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";
    private String BillSate = "billSate";
    private List periodList = null;
    protected boolean isCostNormal = true;
    private PeriodInfo periodStart;
    private PeriodInfo periodCur;

    public ActualHourFilterUI() throws Exception {
        this.prtBillNumTo.setQueryInfo("com.kingdee.eas.ncm.bill.app.ActualHourFilterQuery");
        this.prtBillNumFrom.setQueryInfo("com.kingdee.eas.ncm.bill.app.ActualHourFilterQuery");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.companyOrg.getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.companyOrg.getId().toString());
        this.formatUI();
    }

    private void formatUI() throws Exception {
        this.filterBillNumByOrg(this.prtBillNumFrom);
        this.filterBillNumByOrg(this.prtBillNumTo);
        this.initCompany(this.companyOrg);
        this.initBizDate(this.dpBizDateFrom);
        this.initBizDate(this.dpBizDateTo);
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.filterCostCenter(this.prtCostcenterFrom);
        this.filterCostCenter(this.prtCostcenterTo);
        this.filterCostObjectByOrg(this.prtCostObjectFrom);
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prtCostObjectFrom, Boolean.TRUE);
        this.prtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.filterCostObjectByOrg(this.prtCostObjectTo);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prtCostObjectTo, Boolean.TRUE);
        this.prtCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    public ActualHourFilterParam getFilterParam() {
        ActualHourFilterParam filterParam = (ActualHourFilterParam)this.createNewFilterParam();
        this.storeFilterParam(filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new ActualHourFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof ActualHourFilterParam)) {
            return;
        }
        ActualHourFilterParam fp = (ActualHourFilterParam)filterParam;
        ActualHourInfo bnFrom = null;
        ActualHourInfo bnTo = null;
        String actualHourFromData = customerParams.getCustomerParam(this.ActualHourInfoFrom);
        String actualHourToData = customerParams.getCustomerParam(this.ActualHourInfoTo);
        if (actualHourFromData != null && actualHourFromData.length() > 0) {
            bnFrom = new ActualHourInfo();
            bnFrom.setId(BOSUuid.read((String)actualHourFromData));
        }
        if (actualHourToData != null && actualHourToData.length() > 0) {
            bnTo = new ActualHourInfo();
            bnTo.setId(BOSUuid.read((String)actualHourToData));
        }
        fp.setActualHourInfoFrom(bnFrom);
        fp.setActualHourInfoTo(bnTo);
        String bizDateFromData = customerParams.getCustomerParam(this.BizDateFrom);
        String bizDateToData = customerParams.getCustomerParam(this.BizDateTo);
        if (bizDateFromData == null) {
            fp.setBizDateFrom(Long.parseLong("0"));
        } else {
            fp.setBizDateFrom(Long.parseLong(bizDateFromData));
        }
        if (bizDateToData == null) {
            fp.setBizDateTo(Long.parseLong("0"));
        } else {
            fp.setBizDateTo(Long.parseLong(bizDateToData));
        }
        String periodFromData = customerParams.getCustomerParam(this.PeriodFrom);
        String periodToData = customerParams.getCustomerParam(this.PeriodTo);
        try {
            if (this.companyOrg == null) {
                this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
            }
            PeriodInfo periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.companyOrg.getId().toString());
            if (periodFromData == null) {
                fp.setPeriodFrom(String.valueOf(periodCur.getNumber()));
            } else {
                fp.setPeriodFrom(periodFromData);
            }
            if (periodToData == null) {
                fp.setPeriodTo(String.valueOf(periodCur.getNumber()));
            } else {
                fp.setPeriodTo(periodToData);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
        String schemeState = customerParams.getCustomerParam(this.BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        int temp;
        int minPeriod;
        if (!(filterParam instanceof ActualHourFilterParam)) {
            return;
        }
        ActualHourFilterParam fp = (ActualHourFilterParam)filterParam;
        this.prtBillNumFrom.setData((Object)fp.getActualHourInfoFrom());
        this.prtBillNumTo.setData((Object)fp.getActualHourInfoTo());
        if (fp.getBizDateFrom() == 0L) {
            this.dpBizDateFrom.setValue(null);
        } else {
            this.dpBizDateFrom.setValue((Object)new Date(fp.getBizDateFrom()));
        }
        if (fp.getBizDateTo() == 0L) {
            this.dpBizDateTo.setValue(null);
        } else {
            this.dpBizDateTo.setValue((Object)new Date(fp.getBizDateTo()));
        }
        int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        if (fp.getPeriodFrom() != null && (temp = Integer.parseInt(fp.getPeriodFrom())) >= minPeriod) {
            initFromPeriod = temp;
        }
        if (fp.getPeriodTo() != null && (temp = Integer.parseInt(fp.getPeriodTo())) >= initFromPeriod) {
            initToPeriod = temp;
        }
        if (initToPeriod < initFromPeriod) {
            initToPeriod = initFromPeriod;
        }
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.prtCostcenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prtCostcenterTo.setData((Object)fp.getCostCenterTo());
        this.prtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.comBillSate.setSelectedIndex(Integer.parseInt(fp.getBillSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof ActualHourFilterParam)) {
            return;
        }
        ActualHourFilterParam fp = (ActualHourFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getActualHourInfoFrom(), this.ActualHourInfoFrom);
        super.putIdByKey(customerParams, (Object)fp.getActualHourInfoTo(), this.ActualHourInfoTo);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateFrom()).toString(), this.BizDateFrom);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateTo()).toString(), this.BizDateTo);
        super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), this.PeriodFrom);
        super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), this.PeriodTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
        super.putIdByKey(customerParams, (Object)fp.getBillSate(), this.BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof ActualHourFilterParam)) {
            return;
        }
        ActualHourFilterParam fp = (ActualHourFilterParam)filterParam;
        Object temp = null;
        ActualHourInfo actualHourInfoFrom = null;
        ActualHourInfo actualHourInfoTo = null;
        temp = this.prtBillNumFrom.getData();
        if (temp != null && temp instanceof ActualHourInfo) {
            actualHourInfoFrom = (ActualHourInfo)temp;
        }
        if ((temp = this.prtBillNumTo.getData()) != null && temp instanceof ActualHourInfo) {
            actualHourInfoTo = (ActualHourInfo)temp;
        }
        fp.setActualHourInfoFrom(actualHourInfoFrom);
        fp.setActualHourInfoTo(actualHourInfoTo);
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.dpBizDateFrom.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.dpBizDateTo.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        fp.setBizDateFrom(bizDateFrom);
        fp.setBizDateTo(bizDateTo);
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prtCostcenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prtCostcenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        int selectIndex = this.comBillSate.getSelectedIndex();
        fp.setBillSate(String.valueOf(selectIndex));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Date bizDateFrom = (Date)this.dpBizDateFrom.getValue();
        Date bizDateTo = (Date)this.dpBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && bizDateFrom.equals(bizDateTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            bizDateTo.setHours(23);
            bizDateTo.setMinutes(59);
            bizDateTo.setSeconds(59);
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
        } else {
            if (bizDateFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            }
            if (bizDateTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
            }
        }
        int selectIndex = this.comBillSate.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        if (this.isCostNormal) {
            String periodFrom = null;
            String periodTo = null;
            Object temp = this.spPeriodFrom.getValue();
            if (temp != null && temp instanceof Integer) {
                periodFrom = temp.toString();
            }
            if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
                periodTo = temp.toString();
            }
            if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
            } else {
                if (periodFrom != null) {
                    filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
                }
                if (periodTo != null) {
                    filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
                }
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
        this.prtCompany.setEnabled(false);
    }

    private void filterCostCenter(KDBizPromptBox prmt) {
        try {
            BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)prmt, (String)this.companyOrg.getId().toString());
            FilterInfo filterCostCenterType = new FilterInfo();
            filterCostCenterType.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)"0", CompareType.EQUALS));
            filterCostCenterType.mergeFilter(filterCostCenterType, "AND");
            filterCostCenterType.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
            prmt.getEntityViewInfo().setFilter(filterCostCenterType);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void filterCostObjectByOrg(KDBizPromptBox prmt) throws Exception {
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)prmt, (String)this.companyOrg.getId().toString());
        FilterInfo filterIsForbiden = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)"0", CompareType.EQUALS));
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("costObjectGroup.longnumber", (Object)"PD%", CompareType.LIKE));
        filterIsForbiden.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
        prmt.getEntityViewInfo().setFilter(filterIsForbiden);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void filterBillNumByOrg(KDBizPromptBox prmt) throws Exception {
        FilterInfo filterIsForbiden = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.companyOrg.getId().toString(), CompareType.EQUALS));
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("costType", (Object)"1", CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterIsForbiden);
        prmt.setEntityViewInfo(view);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void initBizDate(KDDatePicker kdDate) {
        kdDate.setValue(null);
    }

    private void clearFilterData() {
        this.prtBillNumFrom.setValue(null);
        this.prtBillNumTo.setValue(null);
        this.prtCostcenterFrom.setValue(null);
        this.prtCostcenterTo.setValue(null);
        this.prtCostObjectFrom.setValue(null);
        this.prtCostObjectTo.setValue(null);
        this.comBillSate.setSelectedIndex(0);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }
}

