/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.ActualHourFactory;
import com.kingdee.eas.ncm.bill.ActualHourInfo;
import com.kingdee.eas.ncm.bill.TimeUnitEnum;
import com.kingdee.eas.ncm.bill.client.AbstractActualHourListUI;
import com.kingdee.eas.ncm.bill.client.ActualHourEditUI;
import com.kingdee.eas.ncm.bill.client.ActualHourFilterUI;
import com.kingdee.eas.ncm.bill.client.HourImportDisplayRepeateRowUI;
import com.kingdee.eas.ncm.bill.client.HourImportUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActualHourListUI
extends AbstractActualHourListUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualHourListUI.class);
    public static final String TB_HOUR = "entries.hour";
    protected boolean isCostNormal = true;
    private CommonQueryDialog dialog = null;
    private ActualHourFilterUI filterUI = null;

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn(TB_HOUR).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuItemImport.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.actionImportHour.setEnabled(true);
        this.actionImportHour.setVisible(true);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.refreshListForOrder();
    }

    public void refreshListForOrder() throws Exception {
        super.refreshListForOrder();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            while (rowSet.next()) {
                int precision = 8;
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.hourSecond", (IRowSet)rowSet);
                BigDecimal factor = new BigDecimal(1);
                if (rowSet.getString("entries.timeUnit") != null) {
                    if (TimeUnitEnum.HOUR.getAlias(this.getLocale()).equals(rowSet.getString("entries.timeUnit"))) {
                        factor = new BigDecimal(3600);
                    }
                    if (TimeUnitEnum.MINUTES.getAlias(this.getLocale()).equals(rowSet.getString("entries.timeUnit"))) {
                        factor = new BigDecimal(60);
                    }
                    if (TimeUnitEnum.SCEOND.getAlias(this.getLocale()).equals(rowSet.getString("entries.timeUnit"))) {
                        factor = new BigDecimal(1);
                    }
                }
                if (rowSet.getBigDecimal("entries.hourSecond") == null) continue;
                BigDecimal value = rowSet.getBigDecimal("entries.hourSecond");
                rowSet.updateBigDecimal("entries.hourSecond", value.divide(factor, 1));
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        qe.option().isIgnoreOrder = false;
        qe.option().isAutoIgnoreZero = false;
        return qe;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "companyOrg.name", "calculatePeriod.number", "costCenter.number", "costCenter.name", "creator.name", "createTime", "auditor.name", "auditTime", "lastUpdateUser.name", "lastUpdateTime"};
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
            if (this.getFilterUI() != null) {
                this.dialog.addUserPanel((KDPanel)this.getFilterUI());
            }
        }
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        dialog.setProcessor((IProcessor)cmcq);
        dialog.setShowSorter(false);
        return dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new ActualHourFilterUI();
                this.filterUI.isCostNormal = this.isCostNormal;
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        if (this.filterUI != null) {
            this.filterUI.spPeriodFrom.setEditable(false);
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected String getEditUIName() {
        return ActualHourEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ActualHourFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ActualHourInfo objectValue = new ActualHourInfo();
        return objectValue;
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "actualHour";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"2_ActualHourListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "actualHour";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"2_ActualHourListUI");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionImportHour_actionPerformed(ActionEvent e) throws Exception {
        String companyID = this.getCompanyOrgInfoWithDefault().getId().toString();
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=ACTUALHOUR_IMPORT" + companyID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
        try {
            Map repeateRow;
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HourImportUI.class.getName(), (Map)uiContext, null);
            uiWindow.show();
            Boolean result = Boolean.valueOf(uiWindow.getUIObject().getUIContext().get("result").toString());
            this.refresh(e);
            if (result.booleanValue() && this.showRepeateUI(repeateRow = this.getRepeateRow())) {
                MsgBox.showInfo((String)"\u5bfc\u5165\u6210\u529f\uff01");
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=ACTUALHOUR_IMPORT" + companyID);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            if (this.isCostNormal) {
                filter.getFilterItems().add(new FilterItemInfo("costType", (Object)1));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("costType", (Object)2));
            }
            ev.getFilter().mergeFilter(filter, "and");
            if (this.filterUI != null) {
                ev.getFilter().mergeFilter(this.filterUI.getFilterInfo(), "AND");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.beforeExcutQuery(ev);
    }

    private boolean hasHistoryPeriod() throws Exception {
        PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod(null, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (periodInfo != null) {
            try {
                int size = this.tblMain.getSelectManager().size();
                IRow row = null;
                String period = null;
                KDTSelectBlock selectBlock = null;
                for (int j = 0; j < size; ++j) {
                    selectBlock = this.tblMain.getSelectManager().get(j);
                    if (selectBlock == null) continue;
                    int num = selectBlock.getEndRow();
                    for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                        row = this.tblMain.getRow(i);
                        period = row.getCell("calculatePeriod.number").getValue().toString();
                        if (period == null || period.length() <= 0 || Integer.parseInt(period) >= periodInfo.getNumber()) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return false;
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("ActualHour_audit");
        }
        if (this.hasHistoryPeriod()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"3_ActualHourListUI"));
            SysUtil.abort();
        }
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasHistoryPeriod()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"4_ActualHourListUI"));
            SysUtil.abort();
        }
        super.unauditAction_actionPerformed(e);
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    private Map getRepeateRow() throws UIException {
        HashMap<String, String> repeateRow = new HashMap<String, String>();
        int rowCount = this.tblMain.getRowCount();
        boolean flag = false;
        for (int row = 0; row < rowCount; ++row) {
            ICell costCenterCell = this.tblMain.getRow(row).getCell("costCenter.number");
            Object costCenterNumber = costCenterCell.getValue();
            ICell costObjectCell = this.tblMain.getRow(row).getCell("costObject.number");
            Object costObjectNumber = costObjectCell.getValue();
            ICell hourTypeCell = this.tblMain.getRow(row).getCell("hourType");
            String hourType = hourTypeCell.getValue().toString();
            ICell timeUnitCell = this.tblMain.getRow(row).getCell("timeUint");
            String timeUnit = timeUnitCell.getValue().toString();
            String ccNumber_coNUmber = costCenterNumber + "," + costObjectNumber + "," + hourType + "," + timeUnit;
            if (!repeateRow.containsKey(ccNumber_coNUmber)) {
                repeateRow.put(ccNumber_coNUmber, String.valueOf(row + 1));
                continue;
            }
            String value = repeateRow.get(ccNumber_coNUmber).toString();
            value = value + "," + String.valueOf(row + 1);
            repeateRow.put(ccNumber_coNUmber, value);
        }
        return repeateRow;
    }

    private boolean showRepeateUI(Map repeateRow) throws UIException {
        StringBuffer message = new StringBuffer();
        Set keySet = repeateRow.keySet();
        Iterator iterKey = keySet.iterator();
        int seq = 1;
        while (iterKey.hasNext()) {
            String temp = repeateRow.get(iterKey.next()).toString();
            if (temp.indexOf(",") <= 0) continue;
            message.append("\n").append(seq++).append(".\u7b2c").append(temp).append("\u884c\u91cd\u590d\u3002");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"CheckResult", (Object)message.toString());
        IUIWindow uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HourImportDisplayRepeateRowUI.class.getName(), (Map)uiContext, null);
        if (!message.toString().equals("")) {
            uiWindow1.show();
        }
        return message.toString().equals("");
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        row.getCell("timeUint").setValue((Object)TimeUnitEnum.SCEOND.getAlias(this.getLocale()));
        row.getCell("timeUint").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"left"));
        return row;
    }
}

