/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client.AllocBuilder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeEntryCollection;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.AllocDirector;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Allocator;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AutoAuxAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AutoCCOAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AutoCostAdjustAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AutoMatAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AutoOtherAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.AutoOtherInWHAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.CalWizAuxAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.CalWizCCOAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.CalWizCostAdjustAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.CalWizMatAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.CalWizOtherAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.CalWizOtherInwarehsAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.ManuCCOAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.ManuCostAdjustAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.ManuMatAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.ManuOtherAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.ManuOtherInWarehsAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.WizMatAllocatorBuilder;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Builder.WizOtherAllocatorBuilder;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllocClientDispatch {
    private static Logger logger = Logger.getLogger((String)AllocClientDispatch.class.getName());

    public Allocator DoMatAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoMatProgressHintListener listener = new AutoMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            ManuMatAllocatorBuilder builder = new ManuMatAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizMatProgressHintListener listener = new WizMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoOtherInWHAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.OtherInWarehsBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoOtherInWHProgressHintListener listener = new AutoOtherInWHProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            ManuOtherInWarehsAllocatorBuilder builder = new ManuOtherInWarehsAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizMatProgressHintListener listener = new WizMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoCostAdjustAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.CostAjustBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoCostAdjustProgressHintListener listener = new AutoCostAdjustProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            ManuCostAdjustAllocatorBuilder builder = new ManuCostAdjustAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizMatProgressHintListener listener = new WizMatProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoOtherAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.OtherFeeBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoOtherProgressHintListener listener = new AutoOtherProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            ManuOtherAllocatorBuilder builder = new ManuOtherAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizOtherProgressHintListener listener = new WizOtherProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoAuxFeeAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.InnerOverheadBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoOtherProgressHintListener listener = new AutoOtherProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    public Allocator DoAuxFeeAllocateFromCalWizard(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        Allocator allocator = null;
        param.put("allocSourceBill", AllocSourceBillEnum.InnerOverheadBill);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        Assert.that((company != null ? 1 : 0) != 0);
        Assert.that((period != null ? 1 : 0) != 0);
        FilterInfo filter = this.getFilterForAuxFeeAlloc(param);
        param.put("bFilter_all", String.valueOf(false));
        param.put("filterInfo", filter);
        param.put("companyId", company.getId().toString());
        param.put("periodId", period.getId().toString());
        param.put("companyName", company.getName().toString());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            CalWizAuxAllocatorBuilder builder = new CalWizAuxAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        }
        return allocator;
    }

    private FilterInfo getFilterForAuxFeeAlloc(Map param) throws BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("AuxFIinfo.companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("FeeCO.company.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    public Allocator DoMatAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Map matParam = this.makeMatAllocParamFromCalWizard(parentUI, param);
        CalWizMatAllocatorBuilder builder = new CalWizMatAllocatorBuilder(matParam, parentUI);
        return this.getAllocorFromCalWizard(builder);
    }

    public Allocator DoOIAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Map matParam = this.makeOIAllocParamFromCalWizard(parentUI, param);
        CalWizOtherInwarehsAllocatorBuilder builder = new CalWizOtherInwarehsAllocatorBuilder(matParam, parentUI);
        return this.getAllocorFromCalWizard(builder);
    }

    public Allocator DoCAAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Map matParam = this.makeCAAllocParamFromCalWizard(parentUI, param);
        CalWizCostAdjustAllocatorBuilder builder = new CalWizCostAdjustAllocatorBuilder(matParam, parentUI);
        return this.getAllocorFromCalWizard(builder);
    }

    private Map makeMatAllocParamFromCalWizard(CoreUIObject parentUI, Map param) throws BOSException {
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForMatAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            matParam.put("isOnlyUnAlloced", String.valueOf(true));
        } else {
            matParam.put("bFilter_all", String.valueOf(true));
        }
        return matParam;
    }

    private Map makeOIAllocParamFromCalWizard(CoreUIObject parentUI, Map param) throws BOSException {
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForOIAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.OtherInWarehsBill);
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            matParam.put("isOnlyUnAlloced", String.valueOf(true));
        } else {
            matParam.put("bFilter_all", String.valueOf(true));
        }
        return matParam;
    }

    private Map makeCAAllocParamFromCalWizard(CoreUIObject parentUI, Map param) throws BOSException {
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForCAAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.CostAjustBill);
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            matParam.put("isOnlyUnAlloced", String.valueOf(true));
        } else {
            matParam.put("bFilter_all", String.valueOf(true));
        }
        return matParam;
    }

    private Allocator getAllocorFromCalWizard(AllocatorBuilder builder) {
        Allocator allocator = null;
        try {
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return allocator;
    }

    public Allocator DoOtherAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Allocator allocator = null;
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForOtherAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("allocSourceBill", AllocSourceBillEnum.OtherFeeBill);
        try {
            CalWizOtherAllocatorBuilder builder = new CalWizOtherAllocatorBuilder(matParam, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return allocator;
    }

    public Allocator DoCCOAllocateFromCalWizard(CoreUIObject parentUI, Map param) throws Exception {
        Allocator allocator = null;
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForCCOAlloc(param);
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("companyName", company.getName().toString());
        matParam.put("periodNumber", String.valueOf(period.getNumber()));
        matParam.put("isForAllocate", "true");
        matParam.put("allocSourceBill", AllocSourceBillEnum.CCOFeeBill);
        try {
            CalWizCCOAllocatorBuilder builder = new CalWizCCOAllocatorBuilder(matParam, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        }
        catch (Exception e) {
            logger.fatal((Object)"", (Throwable)e);
        }
        return allocator;
    }

    public Allocator DoMatAllocateFromMatAllocWizard(CoreUIObject parentUI, Map param, MatAllocWizardSchemeEntryCollection entrys) throws Exception {
        Allocator allocator = null;
        Assert.that((parentUI != null ? 1 : 0) != 0);
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        Assert.that((boolean)param.containsKey("billType"));
        Assert.that((boolean)param.containsKey("parentUi"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = this.getFilterForMatAlloc(param);
        CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
        HashMap<String, Object> matParam = new HashMap<String, Object>();
        matParam.put("filterInfo", filter);
        matParam.put("companyId", company.getId().toString());
        matParam.put("periodId", period.getId().toString());
        matParam.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        matParam.put("billType", param.get("billType"));
        matParam.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        try {
            WizMatAllocatorBuilder builder = new WizMatAllocatorBuilder(matParam, parentUi, entrys);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
            param.put("allocator", allocator);
            if (allocator != null && String.valueOf(false).equals(allocator.getResultInfo().get("HasError"))) {
                ((ListUI)parentUi).refreshList();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return allocator;
    }

    public Allocator DoCCOAllocate(CoreUIObject parentUI, AllocTypeEnum allocType, Map param) throws Exception {
        param.put("allocSourceBill", AllocSourceBillEnum.CCOFeeBill);
        Allocator allocator = null;
        if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
            AutoCCOProgressHintListener listener = new AutoCCOProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        } else if (allocType.equals((Object)AllocTypeEnum.MANU)) {
            ManuCCOAllocatorBuilder builder = new ManuCCOAllocatorBuilder(param, parentUI);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            allocator = builder.getAllocator();
        } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
            WizOtherProgressHintListener listener = new WizOtherProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)parentUI, (ProgressHintListener)listener, (Map)param);
            if (param.containsKey("allocator")) {
                allocator = (Allocator)param.get("allocator");
            }
        }
        return allocator;
    }

    private FilterInfo getFilterForMatAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        return filter;
    }

    private FilterInfo getFilterForOIAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getFilterForCAAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("calculateKind", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("issueType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)0));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getFilterForOtherAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = this.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", (Object)String.valueOf(CostCenterType.DirectProdDept.getValue())));
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            String tblResult = NCMCommonFacadeFactory.getRemoteInstance().getPhysicalTblName(company.getId().toString(), "T_NCM_OtherAllocResult");
            filter.getFilterItems().add(new FilterItemInfo("entries.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.NOTINNER, false));
        }
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private FilterInfo getFilterForCCOAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("entries.isAlloced", (Object)Boolean.FALSE));
            filter1.getFilterItems().add(new FilterItemInfo("entries.isAlloced", null));
            filter1.setMaskString("#0 or #1");
            filter.mergeFilter(filter1, "and");
        }
        return filter;
    }

    private FilterInfo getDefaultCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    static final class WizOtherProgressHintListener
    implements ProgressHintListener {
        WizOtherProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            WizOtherAllocatorBuilder builder = new WizOtherAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            String hasError = (String)alloc.getResultInfo().get("HasError");
            if (hasError == null || hasError.equals(String.valueOf(false))) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoOtherProgressHintListener
    implements ProgressHintListener {
        AutoOtherProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            AutoOtherAllocatorBuilder builder = null;
            builder = param.get("allocSourceBill") != null && AllocSourceBillEnum.InnerOverheadBill.equals(param.get("allocSourceBill")) ? new AutoAuxAllocatorBuilder(param, parentUi) : new AutoOtherAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            String hasError = (String)alloc.getResultInfo().get("HasError");
            if (hasError == null || hasError.equals(String.valueOf(false))) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class WizMatProgressHintListener
    implements ProgressHintListener {
        WizMatProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            WizMatAllocatorBuilder builder = new WizMatAllocatorBuilder(param, parentUi, null);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            String hasError = (String)alloc.getResultInfo().get("HasError");
            if (hasError == null || hasError.equals(String.valueOf(false))) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoMatProgressHintListener
    implements ProgressHintListener {
        AutoMatProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            AutoMatAllocatorBuilder builder = new AutoMatAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            String hasError = (String)alloc.getResultInfo().get("HasError");
            if (hasError == null || hasError.equals(String.valueOf(false))) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoCCOProgressHintListener
    implements ProgressHintListener {
        AutoCCOProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            AutoCCOAllocatorBuilder builder = new AutoCCOAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
        }
    }

    static final class AutoCostAdjustProgressHintListener
    implements ProgressHintListener {
        AutoCostAdjustProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            AutoCostAdjustAllocatorBuilder builder = new AutoCostAdjustAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            String hasError = (String)alloc.getResultInfo().get("HasError");
            if (hasError == null || hasError.equals(String.valueOf(false))) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }

    static final class AutoOtherInWHProgressHintListener
    implements ProgressHintListener {
        AutoOtherInWHProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("parentUi"));
            CoreUIObject parentUi = (CoreUIObject)param.get("parentUi");
            param.remove("parentUi");
            AutoOtherInWHAllocatorBuilder builder = new AutoOtherInWHAllocatorBuilder(param, parentUi);
            AllocDirector director = new AllocDirector();
            director.CreateAllocator(builder);
            Allocator alloc = builder.getAllocator();
            param.put("allocator", alloc);
            String hasError = (String)alloc.getResultInfo().get("HasError");
            if (hasError == null || hasError.equals(String.valueOf(false))) {
                ((ListUI)parentUi).refreshList();
            }
        }
    }
}

