/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.AssignStandardDataFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractAssignStandardDataFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AssignStandardDataFilterUI
extends AbstractAssignStandardDataFilterUI {
    private static final long serialVersionUID = 5836637402442751222L;
    private static final Logger logger = CoreUIObject.getLogger(AssignStandardDataFilterUI.class);
    private static final int PERIOD_MAX_MONTH = 12;
    private static final String PERIOD_FROM = "PeriodFrom";
    private static final String PERIOD_TO = "PeriodTo";
    private static final String ALLOC_STD = "AllocStd";
    private static final String COST_CENTER_FROM = "CostCenterFrom";
    private static final String COST_CENTER_TO = "CostCenterTo";
    private static final String HISTORY = "History";
    protected FilterUIEnum filterUI = null;
    private PeriodInfo periodStart = null;
    private PeriodInfo periodCur = null;

    public AssignStandardDataFilterUI(FilterUIEnum filterUI) throws Exception {
        this.filterUI = filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.initCompany(companyOrg);
        this.periodStart = this.getStartPeriod(null, companyOrg.getId().toString());
        this.periodCur = this.getCurrentPeriod(null, companyOrg.getId().toString());
        if (this.isNormal) {
            this.initPeriod(companyOrg, false, this.periodStart, this.periodCur, -1, -1, -1, -1);
        }
        this.initAllocStd();
        if (this.isNormal) {
            this.initCostCenter(companyOrg);
        }
        this.initCBHistory();
    }

    public void clear() {
        super.clear();
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.kdbpbAllocStd.setValue(null);
        this.kDCBHistory.setSelected(false);
        this.initPeriod(SysContext.getSysContext().getCurrentFIUnit(), false, this.periodStart, this.periodCur, -1, -1, -1, -1);
    }

    private PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo periodCur = NCMUtils.GetCurrentPeriod((Context)ctx, (String)companyId);
        return periodCur;
    }

    private PeriodInfo getStartPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo periodStart = NCMUtils.GetStartPeriod((Context)ctx, (String)companyId);
        return periodStart;
    }

    public AssignStandardDataFilterParam getFilterParam() {
        AssignStandardDataFilterParam filterParam = (AssignStandardDataFilterParam)this.createNewFilterParam();
        this.storeFilterParam(filterParam);
        return filterParam;
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.kDBizPromptCompany.setValue((Object)companyOrg);
        this.kDBizPromptCompany.setEnabled(false);
    }

    private void initPeriod(CompanyOrgUnitInfo companyOrg, boolean history, PeriodInfo periodStart, PeriodInfo periodCur, int initYearFrom, int initMonthFrom, int initYearTo, int initMonthTo) {
        try {
            int maxMonth;
            int minMonth;
            int maxYear;
            int minYear;
            String periodMax;
            String periodMin;
            if (companyOrg == null) {
                companyOrg = SysContext.getSysContext().getCurrentFIUnit();
            }
            if (periodStart == null) {
                periodStart = this.getStartPeriod(null, companyOrg.getId().toString());
            }
            if (periodCur == null) {
                periodCur = this.getCurrentPeriod(null, companyOrg.getId().toString());
            }
            if ((periodMin = AssignStandardDataFilterUI.getNumberOfPeriod(periodStart.getPeriodYear(), periodStart.getPeriodNumber())).compareTo(periodMax = AssignStandardDataFilterUI.getNumberOfPeriod(periodCur.getPeriodYear(), periodCur.getPeriodNumber())) > 0) {
                throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"16_AssignStandardDataFilterUI") + periodMin + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"17_AssignStandardDataFilterUI") + periodMax + "]\u3002");
            }
            if (periodMin.compareTo(periodMax) == 0) {
                history = false;
            }
            this.kDCBHistory.setSelected(history);
            this.spYearFrom.setEnabled(history);
            this.spPeriodFrom.setEnabled(history);
            this.spYearTo.setEnabled(history);
            this.spPeriodTo.setEnabled(history);
            if (history) {
                minYear = periodStart.getPeriodYear();
                maxYear = periodCur.getPeriodYear();
                minMonth = periodStart.getPeriodNumber();
                maxMonth = periodCur.getPeriodNumber();
                if (maxMonth - 1 <= 0) {
                    --maxYear;
                    maxMonth = 12;
                } else {
                    --maxMonth;
                }
                periodMin = AssignStandardDataFilterUI.getNumberOfPeriod(minYear, minMonth);
                periodMax = AssignStandardDataFilterUI.getNumberOfPeriod(maxYear, maxMonth);
                String periodFrom = AssignStandardDataFilterUI.getNumberOfPeriod(initYearFrom, initMonthFrom);
                String periodTo = AssignStandardDataFilterUI.getNumberOfPeriod(initYearTo, initMonthTo);
                if (periodFrom.compareTo(periodMin) < 0 || periodFrom.compareTo(periodMax) > 0 || periodTo.compareTo(periodMin) < 0 || periodTo.compareTo(periodMax) > 0) {
                    initYearFrom = minYear;
                    initMonthFrom = minMonth;
                    initYearTo = maxYear;
                    initMonthTo = maxMonth;
                }
            } else {
                minYear = maxYear = periodCur.getPeriodYear();
                initYearTo = maxYear;
                initYearFrom = maxYear;
                minMonth = maxMonth = periodCur.getPeriodNumber();
                initMonthTo = maxMonth;
                initMonthFrom = maxMonth;
            }
            AssignStandardDataFilterUI.initPeriod(minYear, minMonth, maxYear, maxMonth, this.spYearFrom, this.spPeriodFrom, initYearFrom, initMonthFrom, this.spYearTo, this.spPeriodTo, initYearTo, initMonthTo);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
    }

    public static void initPeriod(int minYear, int minMonth, int maxYear, int maxMonth, KDSpinner spYearFrom, KDSpinner spMonthFrom, int initYearFrom, int initMonthFrom, KDSpinner spYearTo, KDSpinner spMonthTo, int initYearTo, int initMonthTo) {
        AssignStandardDataFilterUI.initPeriod(minYear, minMonth, maxYear, maxMonth, spYearFrom, spMonthFrom, initYearFrom, initMonthFrom);
        AssignStandardDataFilterUI.initPeriod(minYear, minMonth, maxYear, maxMonth, spYearTo, spMonthTo, initYearTo, initMonthTo);
    }

    public static void initPeriod(final int minYear, final int minMonth, final int maxYear, final int maxMonth, final KDSpinner spYear, final KDSpinner spMonth, int initYear, int initMonth) {
        SpinnerNumberModel spYearSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minYear);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(maxYear);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curYear == maxYear) {
                    return null;
                }
                if (curYear + 1 == maxYear && curMonth > maxMonth) {
                    spMonth.setValue((Object)maxMonth);
                }
                return curYear + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curYear == minYear) {
                    return null;
                }
                if (curYear - 1 == minYear && curMonth < minMonth) {
                    spMonth.setValue((Object)minMonth);
                }
                return curYear - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }
        };
        spYear.setModel((SpinnerModel)spYearSNM);
        spYear.setValue((Object)initYear);
        SpinnerNumberModel spMonthSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                if ((Integer)spYear.getValue() == minYear) {
                    return Integer.valueOf(minMonth);
                }
                return Integer.valueOf(1);
            }

            public Comparable getMaximum() {
                if ((Integer)spYear.getValue() == maxYear) {
                    return Integer.valueOf(maxMonth);
                }
                return Integer.valueOf(12);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curMonth == 12 && curYear < maxYear) {
                    spYear.setValue((Object)(curYear + 1));
                    return 1;
                }
                if (curMonth == (Integer)this.getMaximum()) {
                    return null;
                }
                return curMonth + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYear.getValue();
                int curMonth = (Integer)spMonth.getValue();
                if (curMonth == 1 && curYear > minYear) {
                    spYear.setValue((Object)(curYear - 1));
                    return 12;
                }
                if (curMonth == (Integer)this.getMinimum()) {
                    return null;
                }
                return curMonth - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }
        };
        spMonth.setModel((SpinnerModel)spMonthSNM);
        spMonth.setValue((Object)initMonth);
    }

    private void initAllocStd() throws EASBizException, BOSException {
        if (this.filterUI == FilterUIEnum.UserDefinedData) {
            BDCMClientUtils.filterDataBaseDF7((String)"9DD41AE3", (KDBizPromptBox)this.kdbpbAllocStd);
            FilterInfo fiAllocStdUnit = new FilterInfo();
            fiAllocStdUnit.getFilterItems().add(new FilterItemInfo("isSys", (Object)String.valueOf(false), CompareType.EQUALS));
            fiAllocStdUnit.getFilterItems().add(new FilterItemInfo("isByCU", (Object)String.valueOf(true), CompareType.NOTEQUALS));
            FilterInfo prmtFilter = this.kdbpbAllocStd.getEntityViewInfo().getFilter();
            prmtFilter.mergeFilter(fiAllocStdUnit, "and");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(prmtFilter);
            this.kdbpbAllocStd.setEntityViewInfo(evi);
        }
    }

    protected void initCostCenter(CompanyOrgUnitInfo companyOrg) throws EASBizException, BOSException {
        if (this.filterUI == FilterUIEnum.EquivalentCoef || this.filterUI == FilterUIEnum.EquiCoefIntegrated) {
            BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)companyOrg.getId().toString());
            BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)companyOrg.getId().toString());
        } else if (this.filterUI == FilterUIEnum.ClassPonderance || this.filterUI == FilterUIEnum.UserDefinedData || this.filterUI == FilterUIEnum.UnitStandardHour) {
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)"isBizUnit", (Object)Boolean.TRUE, (String)companyOrg.getId().toString());
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)"isBizUnit", (Object)Boolean.TRUE, (String)companyOrg.getId().toString());
        }
    }

    private void initCBHistory() {
        this.kDCBHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AssignStandardDataFilterUI.this.initPeriod(null, AssignStandardDataFilterUI.this.kDCBHistory.isSelected(), AssignStandardDataFilterUI.this.periodStart, AssignStandardDataFilterUI.this.periodCur, -1, -1, -1, -1);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new AssignStandardDataFilterParam();
    }

    public boolean verify() {
        String to;
        Integer yearFrom = this.spYearFrom.getIntegerVlaue();
        Integer periodFrom = this.spPeriodFrom.getIntegerVlaue();
        Integer yearTo = this.spYearTo.getIntegerVlaue();
        Integer periodTo = this.spPeriodTo.getIntegerVlaue();
        String from = AssignStandardDataFilterUI.getNumberOfPeriod(yearFrom, periodFrom);
        if (from.compareTo(to = AssignStandardDataFilterUI.getNumberOfPeriod(yearTo, periodTo)) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"18_AssignStandardDataFilterUI"));
            return false;
        }
        if (this.filterUI == FilterUIEnum.EquivalentCoef || this.filterUI == FilterUIEnum.EquiCoefIntegrated || this.filterUI == FilterUIEnum.ClassPonderance || this.filterUI == FilterUIEnum.UserDefinedData || this.filterUI == FilterUIEnum.UnitStandardHour) {
            String ccTo;
            String ccFrom;
            Object tempFrom = this.prmtCostCenterFrom.getData();
            Object tempTo = this.prmtCostCenterTo.getData();
            if (tempFrom != null && tempFrom instanceof CostCenterOrgUnitInfo && tempTo != null && tempTo instanceof CostCenterOrgUnitInfo && (ccFrom = ((CostCenterOrgUnitInfo)tempFrom).getNumber()).compareTo(ccTo = ((CostCenterOrgUnitInfo)tempTo).getNumber()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"19_AssignStandardDataFilterUI"));
                return false;
            }
        }
        return super.verify();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        String allocStdData;
        if (customerParams == null || filterParam == null || !(filterParam instanceof AssignStandardDataFilterParam)) {
            return;
        }
        AssignStandardDataFilterParam fp = (AssignStandardDataFilterParam)filterParam;
        String historyData = customerParams.getCustomerParam(HISTORY);
        if ("true".equals(historyData)) {
            fp.setHistory("true");
        } else {
            fp.setHistory("false");
        }
        if (fp.isHistory()) {
            String periodFrom = customerParams.getCustomerParam(PERIOD_FROM);
            String periodTo = customerParams.getCustomerParam(PERIOD_TO);
            if (periodFrom != null && periodFrom.length() == 6 && periodTo != null && periodTo.length() == 6) {
                fp.setPeriodFrom(periodFrom);
                fp.setPeriodTo(periodTo);
            } else {
                fp.setPeriodFrom(null);
                fp.setPeriodTo(null);
            }
        } else {
            fp.setPeriodFrom(null);
            fp.setPeriodTo(null);
        }
        AllocStdUnitInfo[] allocStds = null;
        if (this.filterUI == FilterUIEnum.UserDefinedData && (allocStdData = customerParams.getCustomerParam(ALLOC_STD)) != null && allocStdData.length() > 0) {
            List allocStdIds = (List)this.getObject(this.decode(allocStdData));
            allocStds = new AllocStdUnitInfo[allocStdIds.size()];
            int in = allocStdIds.size();
            for (int i = 0; i < in; ++i) {
                String id = (String)allocStdIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                allocStds[i] = new AllocStdUnitInfo();
                allocStds[i].setId(BOSUuid.read((String)id));
            }
            fp.setAllocStds(allocStds);
        }
        fp.setAllocStds(allocStds);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        if (this.filterUI == FilterUIEnum.EquivalentCoef || this.filterUI == FilterUIEnum.EquiCoefIntegrated || this.filterUI == FilterUIEnum.ClassPonderance || this.filterUI == FilterUIEnum.UserDefinedData || this.filterUI == FilterUIEnum.UnitStandardHour) {
            String costCenterFromData = customerParams.getCustomerParam(COST_CENTER_FROM);
            String costCenterToData = customerParams.getCustomerParam(COST_CENTER_TO);
            if (costCenterFromData != null && costCenterFromData.length() > 0) {
                ccFrom = new CostCenterOrgUnitInfo();
                ccFrom.setId(BOSUuid.read((String)costCenterFromData));
            }
            if (costCenterToData != null && costCenterToData.length() > 0) {
                ccTo = new CostCenterOrgUnitInfo();
                ccTo.setId(BOSUuid.read((String)costCenterToData));
            }
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof AssignStandardDataFilterParam)) {
            return;
        }
        AssignStandardDataFilterParam fp = (AssignStandardDataFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getHistory(), HISTORY);
        if (fp.isHistory()) {
            super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), PERIOD_FROM);
            super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), PERIOD_TO);
        }
        if (this.filterUI == FilterUIEnum.UserDefinedData) {
            super.putIdByKey(customerParams, (Object)fp.getAllocStds(), ALLOC_STD);
        }
        if (this.filterUI == FilterUIEnum.EquivalentCoef || this.filterUI == FilterUIEnum.EquiCoefIntegrated || this.filterUI == FilterUIEnum.ClassPonderance || this.filterUI == FilterUIEnum.UserDefinedData || this.filterUI == FilterUIEnum.UnitStandardHour) {
            super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), COST_CENTER_FROM);
            super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), COST_CENTER_TO);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof AssignStandardDataFilterParam)) {
            return;
        }
        AssignStandardDataFilterParam fp = (AssignStandardDataFilterParam)filterParam;
        int initYearFrom = -1;
        int initYearTo = -1;
        int initPeriodFrom = -1;
        int initPeriodTo = -1;
        if (fp.getPeriodFrom() != null && fp.getPeriodFrom().length() == 6 && fp.getPeriodTo() != null && fp.getPeriodTo().length() == 6) {
            initYearFrom = Integer.parseInt(fp.getPeriodFrom().substring(0, 4));
            initPeriodFrom = Integer.parseInt(fp.getPeriodFrom().substring(4));
            if (initPeriodFrom > 12) {
                initPeriodFrom = 12;
            }
            initYearTo = Integer.parseInt(fp.getPeriodTo().substring(0, 4));
            initPeriodTo = Integer.parseInt(fp.getPeriodTo().substring(4));
            if (initPeriodTo > 12) {
                initPeriodTo = 12;
            }
        }
        this.initPeriod(null, "true".equals(fp.getHistory()), this.periodStart, this.periodCur, initYearFrom, initPeriodFrom, initYearTo, initPeriodTo);
        if (this.filterUI == FilterUIEnum.UserDefinedData) {
            this.kdbpbAllocStd.setValue((Object)fp.getAllocStds());
        }
        if (this.filterUI == FilterUIEnum.EquivalentCoef || this.filterUI == FilterUIEnum.EquiCoefIntegrated || this.filterUI == FilterUIEnum.ClassPonderance || this.filterUI == FilterUIEnum.UserDefinedData || this.filterUI == FilterUIEnum.UnitStandardHour) {
            this.prmtCostCenterFrom.setData((Object)fp.getCostCenterFrom());
            this.prmtCostCenterTo.setData((Object)fp.getCostCenterTo());
        }
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof AssignStandardDataFilterParam)) {
            return;
        }
        AssignStandardDataFilterParam fp = (AssignStandardDataFilterParam)filterParam;
        Object temp = null;
        if (this.kDCBHistory.isSelected()) {
            fp.setHistory("true");
        } else {
            fp.setHistory("false");
        }
        String from = null;
        String to = null;
        if (fp.isHistory()) {
            Integer yearFrom = this.spYearFrom.getIntegerVlaue();
            Integer periodFrom = this.spPeriodFrom.getIntegerVlaue();
            Integer yearTo = this.spYearTo.getIntegerVlaue();
            Integer periodTo = this.spPeriodTo.getIntegerVlaue();
            from = AssignStandardDataFilterUI.getNumberOfPeriod(yearFrom, periodFrom);
            to = AssignStandardDataFilterUI.getNumberOfPeriod(yearTo, periodTo);
        }
        fp.setPeriodFrom(from);
        fp.setPeriodTo(to);
        AllocStdUnitInfo[] allocStds = null;
        if (this.filterUI == FilterUIEnum.UserDefinedData && (temp = this.kdbpbAllocStd.getData()) != null) {
            if (temp instanceof AllocStdUnitInfo) {
                allocStds = new AllocStdUnitInfo[]{(AllocStdUnitInfo)temp};
            } else if (temp instanceof Object[]) {
                Object[] objs = (Object[])temp;
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < objs.length; ++i) {
                    if (objs[i] == null) continue;
                    list.add(objs[i]);
                }
                if (list.size() > 0) {
                    allocStds = list.toArray(new AllocStdUnitInfo[list.size()]);
                }
            }
        }
        fp.setAllocStds(allocStds);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        if (this.filterUI == FilterUIEnum.EquivalentCoef || this.filterUI == FilterUIEnum.EquiCoefIntegrated || this.filterUI == FilterUIEnum.ClassPonderance || this.filterUI == FilterUIEnum.UserDefinedData || this.filterUI == FilterUIEnum.UnitStandardHour) {
            temp = this.prmtCostCenterFrom.getData();
            if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
                ccFrom = (CostCenterOrgUnitInfo)temp;
            }
            if ((temp = this.prmtCostCenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
                ccTo = (CostCenterOrgUnitInfo)temp;
            }
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
    }

    public static String getNumberOfPeriod(int periodYear, int periodNumber) {
        String year = "0000";
        if (periodYear >= 0 && periodYear <= 9999) {
            year = String.valueOf(periodYear);
            year = "0000".substring(year.length()) + year;
        }
        String period = "00";
        if (periodNumber >= 0 && periodNumber <= 12) {
            period = String.valueOf(periodNumber);
            period = "00".substring(period.length()) + period;
        }
        return year + period;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Integer yearFrom = this.spYearFrom.getIntegerVlaue();
        Integer periodFrom = this.spPeriodFrom.getIntegerVlaue();
        Integer yearTo = this.spYearTo.getIntegerVlaue();
        Integer periodTo = this.spPeriodTo.getIntegerVlaue();
        String from = AssignStandardDataFilterUI.getNumberOfPeriod(yearFrom, periodFrom);
        String to = AssignStandardDataFilterUI.getNumberOfPeriod(yearTo, periodTo);
        if (from != null && to != null && from.equals(to)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)from, CompareType.EQUALS));
        } else {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)from, CompareType.GREATER_EQUALS));
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)to, CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public static class FilterUIEnum
    extends IntEnum {
        private static final long serialVersionUID = -2518157617486461416L;
        public static final int EquivalentCoef_VALUE = 1;
        public static final int EquiCoefIntegrated_VALUE = 2;
        public static final int ClassPonderance_VALUE = 3;
        public static final int UserDefinedData_VALUE = 4;
        public static final int ByProductUnitCost_VALUE = 5;
        public static final int UnitStandardHour_VALUE = 6;
        public static final FilterUIEnum EquivalentCoef = new FilterUIEnum("EquivalentCoef", 1);
        public static final FilterUIEnum EquiCoefIntegrated = new FilterUIEnum("EquiCoefIntegrated", 2);
        public static final FilterUIEnum ClassPonderance = new FilterUIEnum("ClassPonderance", 3);
        public static final FilterUIEnum UserDefinedData = new FilterUIEnum("UserDefinedData", 4);
        public static final FilterUIEnum ByProductUnitCost = new FilterUIEnum("ByProductUnitCost", 5);
        public static final FilterUIEnum UnitStandardHour = new FilterUIEnum("UnitStandardHour", 6);

        protected FilterUIEnum(String name, int value) {
            super(name, value);
        }
    }
}

