/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostEntryInfo;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostFactory;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostInfo;
import com.kingdee.eas.ncm.bill.client.AbstractBoPInvSFPCostEditUI;
import com.kingdee.eas.ncm.bill.client.BoPInvSFPCostMatDetailUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.EventListener;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BoPInvSFPCostEditUI
extends AbstractBoPInvSFPCostEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BoPInvSFPCostEditUI.class);
    private CompanyOrgUnitInfo comanyOrg = null;
    private int amountPresision = 0;
    private static final String ELLIPSIS = "...";

    public void onShow() throws Exception {
        super.onShow();
        this.menuBiz.setVisible(true);
        this.menuTable1.setVisible(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtLot.setEnabled(false);
        this.prmtCostObject.setEnabled(false);
        this.kdbDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuItemMatD.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    @Override
    public void loadFields() {
        EventListener[] prmtCompanyListners = this.prmtProduct.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.prmtProduct);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.prmtProduct, (EventListener[])prmtCompanyListners);
        this.comanyOrg = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        CurrencyInfo currency = null;
        try {
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.comanyOrg.getBaseCurrency().getId()));
            this.amountPresision = currency.getPrecision();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtProduct.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtProduct, (String)"FIInfo.calculateType", (IntEnum)CalculateTypeEnum.SELFMANUFACTURE);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtProduct, (String)"orgUnit.id", (Object)this.comanyOrg.getId().toString());
        this.txtAmount.setPrecision(this.amountPresision);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtQty.setPrecision(2);
        this.txtQty.setRemoveingZeroInDispaly(false);
        String companyOrgID = this.comanyOrg.getId().toString();
        this.formatEntryTable(companyOrgID, currency);
        this.txtLot.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    BoPInvSFPCostEditUI.this.txtLot_dataChanged(e);
                }
                catch (Exception e1) {
                    BoPInvSFPCostEditUI.this.handUIException(e1);
                }
            }
        });
    }

    private void formatEntryTable(String companyOrgID, CurrencyInfo currency) {
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        prmtCostItem.setEnabledMultiSelection(false);
        KDTDefaultCellEditor itemEditor3 = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kdtEntrys.getColumn("costItem.number").setEditor((ICellEditor)itemEditor3);
        ObjectValueRender avr3 = new ObjectValueRender();
        avr3.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn("costItem.number").setRenderer((IBasicRender)avr3);
        NCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currency, (KDTable)this.kdtEntries, (String[])new String[]{"amount"});
        this.kdtEntrys.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("costItem.unit").getStyleAttributes().setLocked(true);
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            CostItemInfo ci = (CostItemInfo)row.getCell("costItem.number").getValue();
            if (ci == null) continue;
            this.setQtyPriceColumnPrecision(ci, i);
            boolean isStuff = ci.getItemType().equals((Object)CostItemEnum.STUFF);
            row.getCell("detail").setValue((Object)(isStuff ? ELLIPSIS : null));
            row.getCell("amount").getStyleAttributes().setLocked(isStuff);
            row.getCell("qty").getStyleAttributes().setLocked(isStuff);
            row.getCell("price").getStyleAttributes().setLocked(isStuff);
        }
    }

    private void setQtyPriceColumnPrecision(CostItemInfo ci, int row) {
        int qtyPrecision = 2;
        int pricePrecision = ci.getPricePrecision();
        if (ci.getUnit() != null) {
            MeasureUnitInfo ciUnit = (MeasureUnitInfo)BDCMUtils.getObjectValue(null, (String)ci.getUnit().getId().toString());
            this.kdtEntrys.getCell(row, "costItem.unit").setValue((Object)ciUnit.getName());
            qtyPrecision = ciUnit.getQtyPrecision();
        }
        NCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.kdtEntrys, (String[])new String[]{"qty"}, (int)row);
        NCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.kdtEntrys, (String[])new String[]{"price"}, (int)row);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BDCMClientUtils.filterCompanyOrgForPeriod((KDBizPromptBox)this.prmtCalculatePeriod, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompany.getData()));
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.prmtCalculatePeriod.setData((Object)NCMUtils.GetCurrentPeriod(null, (String)this.comanyOrg.getId().toString()));
        }
    }

    protected void actionSetup() {
        super.actionSetup();
        if ("VIEW".equals(this.getOprtState())) {
            this.actionDetail.setVisible(false);
        }
    }

    protected void setOprtStateForAUDIT(int billStatus) {
        super.setOprtStateForAUDIT(billStatus);
        if (4 == billStatus) {
            this.auditAction.setEnabled(false);
        } else {
            this.kdbDetail.setEnabled(true);
        }
    }

    @Override
    protected void prmtProduct_dataChanged(DataChangeEvent e) throws Exception {
        MaterialInfo material = (MaterialInfo)e.getNewValue();
        if (material != null) {
            MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(material.getBaseUnit().getId()));
            this.txtName.setText(material.getName());
            this.txtmodel.setText(material.getModel());
            this.txtUnit.setText(unit.getName());
            this.txtQty.setPrecision(unit.getQtyPrecision());
            CostObjectInfo co = CostObjectFactory.getRemoteInstance().getCostObjectByMaterial(material.getId().toString(), this.comanyOrg.getId().toString());
            if (co != null) {
                this.prmtCostObject.setData((Object)co);
                this.txtCostObjectName.setText(co.getName());
            }
            IMaterialCompanyInfo im = MaterialCompanyInfoFactory.getRemoteInstance();
            MaterialCompanyInfoInfo mcInfo = im.getMaterialCompanyInfoInfo("SELECT accountType, mateial.id, company.id WHERE mateial.id = '" + material.getId().toString() + "' AND company.id = '" + this.comanyOrg.getId().toString() + "'");
            this.txtLot.setEnabled(AccountType.SPECIAL_ACCT.equals((Object)mcInfo.getAccountType()));
            if (!AccountType.SPECIAL_ACCT.equals((Object)mcInfo.getAccountType())) {
                this.txtLot.setText(null);
            } else {
                this.prmtCostObject.setData(null);
                this.txtCostObjectName.setText(null);
            }
        } else {
            this.txtName.setText(null);
            this.txtmodel.setText(null);
            this.txtUnit.setText(null);
            this.txtQty.setPrecision(0);
            this.prmtCostObject.setData(null);
            this.txtCostObjectName.setText(null);
            this.txtLot.setText(null);
        }
    }

    protected void txtLot_dataChanged(FocusEvent e) throws Exception {
        MaterialInfo material;
        String value = this.txtLot.getText();
        CostObjectInfo co = null;
        if (value != null && (material = (MaterialInfo)this.prmtProduct.getValue()) != null) {
            String sql = "select id, number, name where StdProductID.id = '" + material.getId().toString() + "' and calculateMode = " + 4 + " and isForbiden = 0 and company.id = '" + this.comanyOrg.getId().toString() + "' and batchnumber = '" + value + "'";
            CostObjectCollection cotObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(sql);
            if (cotObjectColl != null && cotObjectColl.size() > 0) {
                co = cotObjectColl.get(0);
                this.prmtCostObject.setData((Object)co);
                this.txtCostObjectName.setText(co.getName());
            } else {
                this.prmtCostObject.setData(null);
                this.txtCostObjectName.setText(null);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BillResource", (String)"BoPInvSFPCostEditUI_001"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionDetail_actionPerformed(ActionEvent e) throws Exception {
        this.showMatDetaiUI();
    }

    public void showMatDetaiUI() throws Exception {
        IRow row;
        if ("ADDNEW".equals(this.getOprtState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"20_BoPInvSFPCostEditUI"));
            SysUtil.abort();
        }
        if ((row = this.kdtEntrys.getRow(this.getSelectedRow(this.kdtEntrys))) != null && row.getCell("detail").getValue() == null || row != null && !row.getCell("detail").getValue().toString().equals(ELLIPSIS)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"21_BoPInvSFPCostEditUI"));
            SysUtil.abort();
        }
        if (row != null && row.getCell("id").getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"20_BoPInvSFPCostEditUI"));
            SysUtil.abort();
        }
        if (row != null) {
            CostItemInfo ci = (CostItemInfo)row.getCell("costItem.number").getValue();
            this.getUIContext().put("entry.id", row.getCell("id").getValue());
            BoPInvSFPCostMatDetailUI.showMatDetaiUI((CoreUIObject)this, (CoreBaseInfo)this.editData, row.getCell("id").getValue().toString(), ci, this.getOprtState(), this.btnAddLine.isEnabled());
            StringBuffer sql = new StringBuffer();
            sql.append("select isnull(sum(Famount),0) as Famount, ").append(" isnull(sum(Fqty),0)  as Fqty,").append(" case when isnull(sum(Fqty),0) <> 0 then isnull(sum(Famount),0) / sum(Fqty) else 0 end as Fprice ").append(" from t_ncm_BoPInvSFPCostMatDetail where fparentid='").append(row.getCell("id").getValue().toString()).append("'");
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            while (rs.next()) {
                row.getCell("amount").setValue((Object)rs.getBigDecimal("Famount"));
                row.getCell("qty").setValue(ci.isIsAllocateQty() ? rs.getBigDecimal("Fqty") : null);
                row.getCell("price").setValue(ci.isIsAllocateQty() ? rs.getBigDecimal("Fprice") : null);
            }
        }
    }

    public int getSelectedRow(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (this.editData == null || this.editData.getId() == null || selectBlock == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return selectBlock.getTop();
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        if (e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kdtEntrys.getCell(row, "costItem.name").setValue((Object)ci.getName());
            this.setQtyPriceColumnPrecision(ci, row);
            if (!ci.isIsAllocateQty()) {
                this.kdtEntrys.getCell(row, "qty").setValue(null);
                this.kdtEntrys.getCell(row, "price").setValue(null);
            }
            boolean isStuff = ci.getItemType().equals((Object)CostItemEnum.STUFF);
            this.kdtEntrys.getCell(row, "detail").setValue((Object)(isStuff ? ELLIPSIS : null));
            this.kdtEntries.getCell(row, "amount").getStyleAttributes().setLocked(isStuff);
            this.kdtEntries.getCell(row, "qty").getStyleAttributes().setLocked(isStuff);
            this.kdtEntries.getCell(row, "price").getStyleAttributes().setLocked(isStuff);
        } else if (e.getOldValue() instanceof CostItemInfo) {
            this.kdtEntrys.getCell(row, "costItem.name").setValue(null);
            this.kdtEntrys.getCell(row, "costItem.unit").setValue(null);
            this.kdtEntrys.getCell(row, "detail").setValue(null);
        }
        String column = this.kdtEntrys.getColumnKey(e.getColIndex());
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal price = SysConstant.BIGZERO;
        BigDecimal amount = SysConstant.BIGZERO;
        if ("qty".equals(column) || "price".equals(column)) {
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntrys, (int)row, (String)"qty");
            price = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntrys, (int)row, (String)"price");
            amount = qty.multiply(price);
            amount = amount.setScale(this.amountPresision, 2);
            this.kdtEntrys.getCell(row, "amount").setValue((Object)amount);
        } else if ("amount".equals(column)) {
            amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntrys, (int)row, (String)"amount");
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntrys, (int)row, (String)"qty");
            if (qty.compareTo(SysConstant.BIGZERO) != 0) {
                price = amount.divide(qty, 4);
            }
            this.kdtEntrys.getCell(row, "price").setValue((Object)price);
        }
    }

    @Override
    protected void kdtEntrys_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.kdtEntrys.getSelectManager().getActiveColumnIndex() == this.kdtEntrys.getColumnIndex("detail")) {
            this.showMatDetaiUI();
        }
    }

    protected IObjectValue createNewData() {
        BoPInvSFPCostInfo objectValue = new BoPInvSFPCostInfo();
        super.applyBillDefaultValue((IObjectValue)objectValue);
        objectValue.setDescription("");
        objectValue.setQty(SysConstant.BIGZERO);
        objectValue.setAmount(SysConstant.BIGZERO);
        PeriodInfo curPeriod = null;
        try {
            curPeriod = NCMUtils.GetCurrentPeriod(null, (String)objectValue.getCompanyOrg().getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (curPeriod != null) {
            Timestamp date = curPeriod.getEndDate();
            objectValue.setBizDate(date);
            objectValue.setCalculatePeriod(curPeriod);
        }
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BoPInvSFPCostEntryInfo objectValueEntry = new BoPInvSFPCostEntryInfo();
        objectValueEntry.setQty(SysConstant.BIGZERO);
        objectValueEntry.setPrice(SysConstant.BIGZERO);
        objectValueEntry.setAmount(SysConstant.BIGZERO);
        return objectValueEntry;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BoPInvSFPCostFactory.getRemoteInstance();
    }

    protected void checkValidDataForSubmit() throws Exception {
        super.checkValidDataForSubmit();
        BDCMClientUtils.checkIsNull((JComponent)this.prmtCostObject, (String)this.contcostObject.getBoundLabelText());
        BDCMClientUtils.checkIsNull((JComponent)this.txtQty, (String)this.contQty.getBoundLabelText());
        BDCMClientUtils.checkIsNull((JComponent)this.txtAmount, (String)this.contAmount.getBoundLabelText());
        BDCMClientUtils.checkValue((JComponent)this.txtQty, (String)NCMClientUtils.getNcmBillResource((String)"ProductQtyNeedGreaterZero"), (BigDecimal)SysConstant.BIGZERO, (CompareType)CompareType.GREATER_EQUALS);
        BDCMClientUtils.checkValue((JComponent)this.txtAmount, (String)NCMClientUtils.getNcmBillResource((String)"ProductAmountNeedGreaterZero"), (BigDecimal)SysConstant.BIGZERO, (CompareType)CompareType.GREATER_EQUALS);
        int rowCount = this.kdtEntries.getRowCount();
        BigDecimal sumAmount = SysConstant.BIGZERO;
        while (rowCount-- > 0) {
            BigDecimal amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntrys, (int)rowCount, (String)"amount");
            if (SysConstant.BIGZERO.compareTo(amount) >= 0) {
                MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"UseAmountNeedGreaterZero"));
                SysUtil.abort();
            }
            sumAmount = sumAmount.add(amount);
        }
        if (sumAmount.compareTo(this.txtAmount.getBigDecimalValue()) != 0) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"CostItemAmtNotEqualsProductAmt"));
            SysUtil.abort();
        }
    }

    protected String[] getValidateColumns() {
        return new String[]{"costItem.number", "amount"};
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kdtEntries, new String[]{"amount", "qty"});
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.billstatus.getSelectedItem() != null && this.billstatus.getSelectedItem().toString().equals("\u5ba1\u6838")) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("BoPInvSFPCost_Audit");
        }
        super.auditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }
}

