/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractBoPInvSFPCostFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BoPInvSFPCostFilterUI
extends AbstractBoPInvSFPCostFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BoPInvSFPCostFilterUI.class);
    private static final int PERIOD_MAX_MONTH = 12;
    private static final String PeriodFrom = "periodFrom";
    private static final String PeriodTo = "periodTo";
    private static final String ProductFrom = "productFrom";
    private static final String ProductTo = "productTo";
    private static final String BillSate = "billSate";
    private PeriodInfo periodStart;
    private PeriodInfo periodCur;

    public void onLoad() throws Exception {
        super.onLoad();
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.formatUI();
    }

    private void formatUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        this.prtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prtCompany.setValue((Object)companyOrg);
        this.prtCompany.setEditable(false);
        this.initPeriod(companyOrg);
        this.prtProductFrom.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prtProductFrom.setDisplayFormat("$name$");
        this.prtProductFrom.setEditFormat("$number$");
        this.prtProductFrom.setCommitFormat("$number$");
        this.prtProductTo.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prtProductTo.setDisplayFormat("$name$");
        this.prtProductTo.setEditFormat("$number$");
        this.prtProductTo.setCommitFormat("$number$");
    }

    private void initPeriod(CompanyOrgUnitInfo companyOrg) throws EASBizException, BOSException {
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)companyOrg.getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)companyOrg.getId().toString());
        if (this.periodStart == null || this.periodCur == null) {
            return;
        }
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new BoPInvSFPCostFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof BoPInvSFPCostFilterParam)) {
            return;
        }
        BoPInvSFPCostFilterParam fp = (BoPInvSFPCostFilterParam)filterParam;
        String periodFromData = customerParams.getCustomerParam(PeriodFrom);
        String periodToData = customerParams.getCustomerParam(PeriodTo);
        fp.setPeriodFrom(periodFromData);
        fp.setPeriodTo(periodToData);
        MaterialInfo productFrom = null;
        String materialIDFrom = customerParams.getCustomerParam(ProductFrom);
        if (materialIDFrom != null && materialIDFrom.length() > 0) {
            productFrom = new MaterialInfo();
            productFrom.setId(BOSUuid.read((String)materialIDFrom));
        }
        MaterialInfo productTo = null;
        String materialIDTo = customerParams.getCustomerParam(ProductTo);
        if (materialIDTo != null && materialIDTo.length() > 0) {
            productTo = new MaterialInfo();
            productTo.setId(BOSUuid.read((String)materialIDTo));
        }
        fp.setProductFrom(productFrom);
        fp.setProductTo(productTo);
        String schemeState = customerParams.getCustomerParam(BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        int minPeriod;
        if (!(filterParam instanceof BoPInvSFPCostFilterParam)) {
            return;
        }
        BoPInvSFPCostFilterParam fp = (BoPInvSFPCostFilterParam)filterParam;
        int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        if (fp.getPeriodFrom() != null) {
            initFromPeriod = Integer.parseInt(fp.getPeriodFrom());
        }
        if (fp.getPeriodTo() != null) {
            initToPeriod = Integer.parseInt(fp.getPeriodTo());
        }
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.prtProductFrom.setData((Object)fp.getProductFrom());
        this.prtProductTo.setData((Object)fp.getProductTo());
        this.combBillState.setSelectedIndex(Integer.parseInt(fp.getBillSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof BoPInvSFPCostFilterParam)) {
            return;
        }
        BoPInvSFPCostFilterParam fp = (BoPInvSFPCostFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), PeriodFrom);
        super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), PeriodTo);
        super.putIdByKey(customerParams, (Object)fp.getProductFrom(), ProductFrom);
        super.putIdByKey(customerParams, (Object)fp.getProductTo(), ProductTo);
        super.putIdByKey(customerParams, (Object)fp.getBillSate(), BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof BoPInvSFPCostFilterParam)) {
            return;
        }
        BoPInvSFPCostFilterParam fp = (BoPInvSFPCostFilterParam)filterParam;
        Object temp = null;
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        MaterialInfo productFrom = null;
        MaterialInfo productTo = null;
        temp = this.prtProductFrom.getData();
        if (temp != null && temp instanceof MaterialInfo) {
            productFrom = (MaterialInfo)temp;
        }
        if ((temp = this.prtProductTo.getData()) != null && temp instanceof MaterialInfo) {
            productTo = (MaterialInfo)temp;
        }
        fp.setProductFrom(productFrom);
        fp.setProductTo(productTo);
        int selectIndex = this.combBillState.getSelectedIndex();
        fp.setBillSate(String.valueOf(selectIndex));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        int selectIndex = this.combBillState.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        String periodFrom = null;
        String periodTo = null;
        Object temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = temp.toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = temp.toString();
        }
        if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
        } else {
            if (periodFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
            }
            if (periodTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
            }
        }
        MaterialInfo productFrom = null;
        MaterialInfo productTo = null;
        Object value = this.prtProductFrom.getValue();
        if (value != null && value instanceof MaterialInfo) {
            productFrom = (MaterialInfo)value;
        }
        if ((value = this.prtProductTo.getValue()) != null && value instanceof MaterialInfo) {
            productTo = (MaterialInfo)value;
        }
        if (productFrom != null && productTo != null && productFrom.getNumber().equals(productTo.getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("product.number", (Object)productFrom.getNumber(), CompareType.EQUALS));
        } else {
            if (productFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("product.number", (Object)productFrom.getNumber(), CompareType.GREATER_EQUALS));
            }
            if (productTo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("product.number", (Object)productTo.getNumber(), CompareType.LESS_EQUALS));
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void clearFilterData() {
        this.prtProductFrom.setValue(null);
        this.prtProductTo.setValue(null);
        this.combBillState.setSelectedIndex(0);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return false;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerMaterialF7(this.prtProductFrom);
        this.prtProductFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prtProductFrom, (FilterInfo)this.getDefaultProductFilter(this.prtProductFrom));
        this.f7ContextManager.registerMaterialF7(this.prtProductTo);
        this.prtProductTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prtProductTo, (FilterInfo)this.getDefaultProductFilter(this.prtProductTo));
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prtProductFrom.setData(null);
                this.prtProductTo.setData(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
                this.prtProductFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prtProductFrom, (FilterInfo)this.getDefaultProductFilter(this.prtProductFrom));
                this.prtProductTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prtProductTo, (FilterInfo)this.getDefaultProductFilter(this.prtProductTo));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private FilterInfo getDefaultProductFilter(KDBizPromptBox prtProduct) {
        FilterInfo ret = new FilterInfo();
        ret.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)String.valueOf(2), CompareType.EQUALS));
        ret.getFilterItems().add(new FilterItemInfo("FIInfo.company.id", (Object)String.valueOf(this.getCompanyOrgInfoWithDefault().getId().toString()), CompareType.EQUALS));
        try {
            if (prtProduct.getEntityViewInfo() != null && prtProduct.getEntityViewInfo().getFilter() != null) {
                ret.mergeFilter(prtProduct.getEntityViewInfo().getFilter(), "AND");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return ret;
    }
}

